
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  148 ( 2357),  selected  148 , name 2b5x_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2b5x_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      E       1           -
LGA    K     2_A      N       2           -
LGA    L     3_A      L       3           -
LGA    R     4_A      Y       4           -
LGA    -       -      F       5           -
LGA    -       -      Q       6           -
LGA    -       -      S       7           -
LGA    -       -      M       8           -
LGA    -       -      I       9           -
LGA    Q     5_A      N      10          4.682
LGA    P     6_A      S      11          1.853
LGA    M     7_A      F      12          0.748
LGA    -       -      Y      13           -
LGA    P     8_A      A      14          5.214
LGA    E     9_A      F      15          3.323
LGA    L    10_A      E      16          4.790
LGA    T    11_A      V      17          0.816
LGA    G    12_A      K      18          2.676
LGA    E    13_A      -       -           -
LGA    K    14_A      -       -           -
LGA    A    15_A      D      19           #
LGA    W    16_A      A      20          0.920
LGA    L    17_A      K      21           #
LGA    N    18_A      G      22           -
LGA    G    19_A      R      23           -
LGA    E    20_A      T      24           #
LGA    V    21_A      V      25          4.196
LGA    T    22_A      S      26          2.161
LGA    R    23_A      L      27          2.231
LGA    E    24_A      E      28          1.270
LGA    Q    25_A      K      29          1.092
LGA    L    26_A      Y      30          0.996
LGA    I    27_A      K      31          0.546
LGA    G    28_A      G      32          3.257
LGA    E    29_A      -       -           -
LGA    K    30_A      K      33          2.607
LGA    P    31_A      V      34          2.035
LGA    T    32_A      S      35          2.002
LGA    L    33_A      L      36          1.954
LGA    I    34_A      V      37          1.631
LGA    H    35_A      V      38          1.642
LGA    F    36_A      N      39          1.552
LGA    W    37_A      V      40          1.361
LGA    S    38_A      A      41          1.408
LGA    I    39_A      S      42          1.628
LGA    S    40_A      D      43          2.829
LGA    C    41_A      C      44          2.568
LGA    H    42_A      Q      45          1.958
LGA    L    43_A      L      46          2.363
LGA    C    44_A      T      47          3.197
LGA    K    45_A      D      48          2.142
LGA    E    46_A      R      49          0.607
LGA    A    47_A      N      50          1.082
LGA    M    48_A      Y      51          0.398
LGA    P    49_A      L      52          0.963
LGA    Q    50_A      G      53          1.399
LGA    V    51_A      L      54          1.379
LGA    N    52_A      K      55          1.466
LGA    E    53_A      E      56          1.830
LGA    F    54_A      L      57          1.495
LGA    R    55_A      H      58          1.394
LGA    D    56_A      K      59          1.233
LGA    K    57_A      E      60          0.934
LGA    Y    58_A      F      61          1.110
LGA    Q    59_A      G      62          1.105
LGA    -       -      P      63           -
LGA    D    60_A      S      64          3.439
LGA    Q    61_A      H      65          2.854
LGA    L    62_A      F      66          1.321
LGA    N    63_A      S      67          2.628
LGA    V    64_A      V      68          2.677
LGA    V    65_A      L      69          1.674
LGA    A    66_A      A      70          1.199
LGA    V    67_A      F      71          0.807
LGA    H    68_A      P      72          0.856
LGA    M    69_A      C      73          1.364
LGA    P    70_A      N      74          1.721
LGA    R    71_A      Q      75          2.189
LGA    -       -      F      76           -
LGA    S    72_A      G      77          4.126
LGA    E    73_A      E      78          4.015
LGA    D    74_A      S      79          4.485
LGA    D    75_A      E      80          1.151
LGA    L    76_A      P      81          2.095
LGA    D    77_A      R      82          1.689
LGA    P    78_A      P      83          1.951
LGA    -       -      S      84           -
LGA    G    79_A      K      85          5.229
LGA    K    80_A      E      86          4.618
LGA    I    81_A      V      87          1.571
LGA    K    82_A      E      88          3.091
LGA    E    83_A      S      89          3.941
LGA    T    84_A      F      90          2.386
LGA    A    85_A      A      91          0.690
LGA    A    86_A      R      92          1.985
LGA    E    87_A      K      93          3.175
LGA    -       -      N      94           -
LGA    H    88_A      Y      95          1.546
LGA    D    89_A      G      96          1.488
LGA    I    90_A      V      97          1.711
LGA    T    91_A      T      98          1.411
LGA    Q    92_A      F      99          1.132
LGA    P    93_A      P     100          1.393
LGA    I    94_A      I     101          1.545
LGA    F    95_A      F     102          1.024
LGA    V    96_A      H     103          2.189
LGA    D    97_A      K     104          3.769
LGA    S    98_A      I     105          4.522
LGA    D    99_A      K     106           #
LGA    -       -      I     107           -
LGA    -       -      L     108           -
LGA    -       -      G     109           -
LGA    -       -      S     110           -
LGA    -       -      E     111           -
LGA    H   100_A      G     112          3.664
LGA    A   101_A      E     113          1.494
LGA    L   102_A      P     114          3.632
LGA    T   103_A      A     115           #
LGA    -       -      F     116           -
LGA    D   104_A      R     117          4.089
LGA    A   105_A      F     118          3.302
LGA    F   106_A      L     119          3.594
LGA    E   107_A      V     120          4.427
LGA    N   108_A      D     121           -
LGA    -       -      S     122           -
LGA    -       -      S     123           -
LGA    -       -      K     124           -
LGA    -       -      K     125           -
LGA    E   109_A      E     126          4.349
LGA    Y   110_A      P     127          1.906
LGA    -       -      R     128           -
LGA    -       -      W     129           -
LGA    V   111_A      N     130          2.424
LGA    P   112_A      F     131          0.870
LGA    A   113_A      W     132          1.604
LGA    Y   114_A      K     133          1.546
LGA    Y   115_A      Y     134          1.478
LGA    V   116_A      L     135          1.535
LGA    F   117_A      V     136          1.912
LGA    D   118_A      N     137          1.986
LGA    K   119_A      P     138          1.585
LGA    T   120_A      E     139          1.923
LGA    G   121_A      G     140          1.453
LGA    Q   122_A      Q     141          1.784
LGA    L   123_A      V     142          1.761
LGA    R   124_A      V     143          2.068
LGA    H   125_A      K     144          1.528
LGA    F   126_A      F     145          1.446
LGA    Q   127_A      W     146          1.243
LGA    A   128_A      R     147          1.716
LGA    G   129_A      P     148          1.268
LGA    G   130_A      E     149          3.340
LGA    S   131_A      E     150          4.448
LGA    G   132_A      P     151          4.731
LGA    M   133_A      I     152          2.927
LGA    K   134_A      E     153          3.142
LGA    M   135_A      V     154          1.790
LGA    L   136_A      I     155          1.250
LGA    E   137_A      R     156          1.255
LGA    K   138_A      P     157          1.376
LGA    R   139_A      D     158          1.253
LGA    V   140_A      I     159          0.233
LGA    N   141_A      A     160          0.843
LGA    R   142_A      A     161          1.885
LGA    V   143_A      L     162          1.354
LGA    L   144_A      V     163          2.031
LGA    A   145_A      R     164          3.658
LGA    E   146_A      Q     165          3.830
LGA    T   147_A      V     166          3.065
LGA    E   148_A      I     167          4.089
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  148  174    5.0    133    2.47    16.54     51.552     5.180

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.611624 * X  +  -0.395255 * Y  +  -0.685339 * Z  +  30.834475
  Y_new =   0.397373 * X  +   0.902538 * Y  +  -0.165888 * Z  +  95.746323
  Z_new =   0.684113 * X  +  -0.170874 * Y  +   0.709078 * Z  +   3.716631 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.236472    2.905120  [ DEG:   -13.5489    166.4511 ]
  Theta =  -0.753387   -2.388205  [ DEG:   -43.1659   -136.8341 ]
  Phi   =   0.576166   -2.565427  [ DEG:    33.0119   -146.9881 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2b5x_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2b5x_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  148  174   5.0  133   2.47   16.54  51.552
REMARK  ---------------------------------------------------------- 
MOLECULE 2b5x_A
HEADER    OXIDOREDUCTASE                          29-SEP-05   2B5X              
TITLE     SOLUTION STRUCTURE OF A THIOREDOXIN-LIKE PROTEIN IN THE               
TITLE    2 REDUCED FORM                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: YKUV PROTEIN;                                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 1-148;                                            
COMPND   5 SYNONYM: TRXY;                                                       
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET21A                                    
KEYWDS    THIOREDOXIN-LIKE                                                      
EXPDTA    NMR, 11 STRUCTURES                                                    
AUTHOR    X.ZHANG,B.XIA,C.JIN                                                   
REVDAT   2   28-MAR-06 2B5X    1       JRNL                                     
REVDAT   1   17-JAN-06 2B5X    0                                                
JRNL        AUTH   X.ZHANG,Y.HU,X.GUO,E.LESCOP,Y.LI,B.XIA,C.JIN                 
JRNL        TITL   THE BACILLUS SUBTILIS YKUV IS A THIOL-DISULFIDE              
JRNL        TITL 2 OXIDOREDUCTASE REVEALED BY ITS REDOX STRUCTURES              
JRNL        TITL 3 AND ACTIVITY                                                 
JRNL        REF    J.BIOL.CHEM.                  V. 281  8296 2006              
JRNL        REFN   ASTM JBCHA3  US ISSN 1083-351X                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2B5X A    1   148  GB     2632243  CAA10885         1    148             
SEQRES   1 A  148  MET LYS LEU ARG GLN PRO MET PRO GLU LEU THR GLY GLU          
SEQRES   2 A  148  LYS ALA TRP LEU ASN GLY GLU VAL THR ARG GLU GLN LEU          
SEQRES   3 A  148  ILE GLY GLU LYS PRO THR LEU ILE HIS PHE TRP SER ILE          
SEQRES   4 A  148  SER CYS HIS LEU CYS LYS GLU ALA MET PRO GLN VAL ASN          
SEQRES   5 A  148  GLU PHE ARG ASP LYS TYR GLN ASP GLN LEU ASN VAL VAL          
SEQRES   6 A  148  ALA VAL HIS MET PRO ARG SER GLU ASP ASP LEU ASP PRO          
SEQRES   7 A  148  GLY LYS ILE LYS GLU THR ALA ALA GLU HIS ASP ILE THR          
SEQRES   8 A  148  GLN PRO ILE PHE VAL ASP SER ASP HIS ALA LEU THR ASP          
SEQRES   9 A  148  ALA PHE GLU ASN GLU TYR VAL PRO ALA TYR TYR VAL PHE          
SEQRES  10 A  148  ASP LYS THR GLY GLN LEU ARG HIS PHE GLN ALA GLY GLY          
SEQRES  11 A  148  SER GLY MET LYS MET LEU GLU LYS ARG VAL ASN ARG VAL          
SEQRES  12 A  148  LEU ALA GLU THR GLU                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      34.281  95.113   5.196  0.00  0.00           N  
ATOM      2  CA  MET A   1      35.243  96.188   4.823  0.00  0.00           C  
ATOM      3  C   MET A   1      36.614  95.942   5.461  0.00  0.00           C  
ATOM      4  O   MET A   1      36.699  95.628   6.651  0.00  0.00           O  
ATOM      5  CB  MET A   1      34.772  97.596   5.253  0.00  0.00           C  
ATOM      6  CG  MET A   1      33.669  98.188   4.372  0.00  0.00           C  
ATOM      7  SD  MET A   1      33.426  99.959   4.657  0.00  0.00           S  
ATOM      8  CE  MET A   1      34.725 100.690   3.620  0.00  0.00           C  
ATOM      9  H2  MET A   1      34.162  95.082   6.197  0.00  0.00           H  
ATOM     10  HA  MET A   1      35.361  96.176   3.736  0.00  0.00           H  
ATOM     11  HB2 MET A   1      34.430  97.579   6.291  0.00  0.00           H  
ATOM     12  HB3 MET A   1      35.625  98.275   5.202  0.00  0.00           H  
ATOM     13  HG2 MET A   1      33.911  98.040   3.319  0.00  0.00           H  
ATOM     14  HG3 MET A   1      32.730  97.676   4.585  0.00  0.00           H  
ATOM     15  HE1 MET A   1      34.644 101.777   3.650  0.00  0.00           H  
ATOM     16  HE2 MET A   1      35.706 100.401   3.994  0.00  0.00           H  
ATOM     17  HE3 MET A   1      34.606 100.354   2.589  0.00  0.00           H  
ATOM     18  H1  MET A   1      34.631  94.216   4.894  0.00  0.00           H  
ATOM     19  H3  MET A   1      33.382  95.265   4.762  0.00  0.00           H  
ATOM     20  N   LYS A   2      37.699  96.154   4.701  0.00  0.00           N  
ATOM     21  CA  LYS A   2      39.029  96.320   5.295  0.00  0.00           C  
ATOM     22  C   LYS A   2      39.129  97.721   5.886  0.00  0.00           C  
ATOM     23  O   LYS A   2      38.526  98.655   5.346  0.00  0.00           O  
ATOM     24  CB  LYS A   2      40.144  96.127   4.253  0.00  0.00           C  
ATOM     25  CG  LYS A   2      39.978  94.848   3.416  0.00  0.00           C  
ATOM     26  CD  LYS A   2      41.306  94.115   3.214  0.00  0.00           C  
ATOM     27  CE  LYS A   2      41.084  92.929   2.268  0.00  0.00           C  
ATOM     28  NZ  LYS A   2      42.304  92.103   2.108  0.00  0.00           N  
ATOM     29  H   LYS A   2      37.599  96.396   3.723  0.00  0.00           H  
ATOM     30  HA  LYS A   2      39.163  95.579   6.089  0.00  0.00           H  
ATOM     31  HB2 LYS A   2      40.175  96.982   3.576  0.00  0.00           H  
ATOM     32  HB3 LYS A   2      41.096  96.097   4.786  0.00  0.00           H  
ATOM     33  HG2 LYS A   2      39.286  94.165   3.908  0.00  0.00           H  
ATOM     34  HG3 LYS A   2      39.560  95.120   2.446  0.00  0.00           H  
ATOM     35  HD2 LYS A   2      42.044  94.798   2.791  0.00  0.00           H  
ATOM     36  HD3 LYS A   2      41.659  93.757   4.183  0.00  0.00           H  
ATOM     37  HE2 LYS A   2      40.274  92.311   2.664  0.00  0.00           H  
ATOM     38  HE3 LYS A   2      40.771  93.315   1.294  0.00  0.00           H  
ATOM     39  HZ1 LYS A   2      43.071  92.647   1.738  0.00  0.00           H  
ATOM     40  HZ2 LYS A   2      42.593  91.702   2.990  0.00  0.00           H  
ATOM     41  HZ3 LYS A   2      42.133  91.339   1.469  0.00  0.00           H  
ATOM     42  N   LEU A   3      39.932  97.876   6.938  0.00  0.00           N  
ATOM     43  CA  LEU A   3      40.366  99.187   7.415  0.00  0.00           C  
ATOM     44  C   LEU A   3      41.283  99.828   6.358  0.00  0.00           C  
ATOM     45  O   LEU A   3      41.711  99.180   5.401  0.00  0.00           O  
ATOM     46  CB  LEU A   3      41.070  99.057   8.787  0.00  0.00           C  
ATOM     47  CG  LEU A   3      40.229  98.396   9.904  0.00  0.00           C  
ATOM     48  CD1 LEU A   3      41.026  98.354  11.213  0.00  0.00           C  
ATOM     49  CD2 LEU A   3      38.895  99.113  10.149  0.00  0.00           C  
ATOM     50  H   LEU A   3      40.415  97.064   7.296  0.00  0.00           H  
ATOM     51  HA  LEU A   3      39.490  99.826   7.533  0.00  0.00           H  
ATOM     52  HB2 LEU A   3      41.987  98.478   8.653  0.00  0.00           H  
ATOM     53  HB3 LEU A   3      41.362 100.054   9.124  0.00  0.00           H  
ATOM     54  HG  LEU A   3      40.013  97.367   9.619  0.00  0.00           H  
ATOM     55 HD11 LEU A   3      41.961  97.811  11.061  0.00  0.00           H  
ATOM     56 HD12 LEU A   3      41.254  99.364  11.554  0.00  0.00           H  
ATOM     57 HD13 LEU A   3      40.451  97.838  11.983  0.00  0.00           H  
ATOM     58 HD21 LEU A   3      39.067 100.169  10.355  0.00  0.00           H  
ATOM     59 HD22 LEU A   3      38.250  99.011   9.276  0.00  0.00           H  
ATOM     60 HD23 LEU A   3      38.379  98.656  10.995  0.00  0.00           H  
ATOM     61  N   ARG A   4      41.597 101.112   6.547  0.00  0.00           N  
ATOM     62  CA  ARG A   4      42.461 101.966   5.720  0.00  0.00           C  
ATOM     63  C   ARG A   4      41.947 102.236   4.298  0.00  0.00           C  
ATOM     64  O   ARG A   4      42.610 102.969   3.560  0.00  0.00           O  
ATOM     65  CB  ARG A   4      43.920 101.461   5.729  0.00  0.00           C  
ATOM     66  CG  ARG A   4      44.524 101.382   7.143  0.00  0.00           C  
ATOM     67  CD  ARG A   4      45.952 100.821   7.133  0.00  0.00           C  
ATOM     68  NE  ARG A   4      46.887 101.664   6.361  0.00  0.00           N  
ATOM     69  CZ  ARG A   4      48.179 101.388   6.132  0.00  0.00           C  
ATOM     70  NH1 ARG A   4      48.750 100.310   6.672  0.00  0.00           N  
ATOM     71  NH2 ARG A   4      48.899 102.195   5.357  0.00  0.00           N  
ATOM     72  H   ARG A   4      41.209 101.565   7.372  0.00  0.00           H  
ATOM     73  HA  ARG A   4      42.466 102.940   6.212  0.00  0.00           H  
ATOM     74  HB2 ARG A   4      43.973 100.482   5.255  0.00  0.00           H  
ATOM     75  HB3 ARG A   4      44.524 102.148   5.135  0.00  0.00           H  
ATOM     76  HG2 ARG A   4      44.526 102.374   7.595  0.00  0.00           H  
ATOM     77  HG3 ARG A   4      43.914 100.724   7.763  0.00  0.00           H  
ATOM     78  HD2 ARG A   4      46.302 100.750   8.164  0.00  0.00           H  
ATOM     79  HD3 ARG A   4      45.930  99.818   6.703  0.00  0.00           H  
ATOM     80  HE  ARG A   4      46.497 102.512   5.966  0.00  0.00           H  
ATOM     81 HH11 ARG A   4      48.218  99.691   7.271  0.00  0.00           H  
ATOM     82 HH12 ARG A   4      49.725 100.080   6.518  0.00  0.00           H  
ATOM     83 HH21 ARG A   4      48.487 103.014   4.923  0.00  0.00           H  
ATOM     84 HH22 ARG A   4      49.878 102.018   5.157  0.00  0.00           H  
ATOM     85  N   GLN A   5      40.781 101.719   3.901  0.00  0.00           N  
ATOM     86  CA  GLN A   5      40.166 102.093   2.625  0.00  0.00           C  
ATOM     87  C   GLN A   5      39.694 103.552   2.694  0.00  0.00           C  
ATOM     88  O   GLN A   5      39.245 103.978   3.764  0.00  0.00           O  
ATOM     89  CB  GLN A   5      38.969 101.185   2.317  0.00  0.00           C  
ATOM     90  CG  GLN A   5      39.384  99.735   2.036  0.00  0.00           C  
ATOM     91  CD  GLN A   5      38.161  98.906   1.651  0.00  0.00           C  
ATOM     92  OE1 GLN A   5      37.942  98.583   0.485  0.00  0.00           O  
ATOM     93  NE2 GLN A   5      37.313  98.579   2.617  0.00  0.00           N  
ATOM     94  H   GLN A   5      40.255 101.138   4.534  0.00  0.00           H  
ATOM     95  HA  GLN A   5      40.912 101.978   1.837  0.00  0.00           H  
ATOM     96  HB2 GLN A   5      38.266 101.213   3.151  0.00  0.00           H  
ATOM     97  HB3 GLN A   5      38.458 101.570   1.433  0.00  0.00           H  
ATOM     98  HG2 GLN A   5      40.105  99.716   1.218  0.00  0.00           H  
ATOM     99  HG3 GLN A   5      39.853  99.305   2.920  0.00  0.00           H  
ATOM    100 HE21 GLN A   5      37.528  98.853   3.577  0.00  0.00           H  
ATOM    101 HE22 GLN A   5      36.423  98.175   2.361  0.00  0.00           H  
ATOM    102  N   PRO A   6      39.743 104.313   1.585  0.00  0.00           N  
ATOM    103  CA  PRO A   6      39.154 105.643   1.517  0.00  0.00           C  
ATOM    104  C   PRO A   6      37.620 105.550   1.519  0.00  0.00           C  
ATOM    105  O   PRO A   6      37.044 104.602   0.975  0.00  0.00           O  
ATOM    106  CB  PRO A   6      39.679 106.257   0.217  0.00  0.00           C  
ATOM    107  CG  PRO A   6      39.918 105.045  -0.683  0.00  0.00           C  
ATOM    108  CD  PRO A   6      40.333 103.952   0.302  0.00  0.00           C  
ATOM    109  HA  PRO A   6      39.498 106.241   2.357  0.00  0.00           H  
ATOM    110  HB2 PRO A   6      38.970 106.956  -0.228  0.00  0.00           H  
ATOM    111  HB3 PRO A   6      40.630 106.756   0.411  0.00  0.00           H  
ATOM    112  HG2 PRO A   6      38.986 104.761  -1.173  0.00  0.00           H  
ATOM    113  HG3 PRO A   6      40.694 105.237  -1.423  0.00  0.00           H  
ATOM    114  HD2 PRO A   6      39.975 102.982  -0.045  0.00  0.00           H  
ATOM    115  HD3 PRO A   6      41.419 103.940   0.399  0.00  0.00           H  
ATOM    116  N   MET A   7      36.955 106.558   2.090  0.00  0.00           N  
ATOM    117  CA  MET A   7      35.503 106.724   2.000  0.00  0.00           C  
ATOM    118  C   MET A   7      35.056 106.807   0.518  0.00  0.00           C  
ATOM    119  O   MET A   7      35.584 107.645  -0.216  0.00  0.00           O  
ATOM    120  CB  MET A   7      35.024 107.925   2.837  0.00  0.00           C  
ATOM    121  CG  MET A   7      35.859 109.208   2.710  0.00  0.00           C  
ATOM    122  SD  MET A   7      35.241 110.627   3.664  0.00  0.00           S  
ATOM    123  CE  MET A   7      35.326 109.983   5.358  0.00  0.00           C  
ATOM    124  H   MET A   7      37.486 107.254   2.601  0.00  0.00           H  
ATOM    125  HA  MET A   7      35.067 105.849   2.472  0.00  0.00           H  
ATOM    126  HB2 MET A   7      33.994 108.145   2.559  0.00  0.00           H  
ATOM    127  HB3 MET A   7      35.026 107.621   3.883  0.00  0.00           H  
ATOM    128  HG2 MET A   7      36.874 109.006   3.043  0.00  0.00           H  
ATOM    129  HG3 MET A   7      35.904 109.497   1.661  0.00  0.00           H  
ATOM    130  HE1 MET A   7      34.567 109.216   5.505  0.00  0.00           H  
ATOM    131  HE2 MET A   7      36.308 109.553   5.545  0.00  0.00           H  
ATOM    132  HE3 MET A   7      35.152 110.797   6.059  0.00  0.00           H  
ATOM    133  N   PRO A   8      34.126 105.946   0.050  0.00  0.00           N  
ATOM    134  CA  PRO A   8      33.788 105.779  -1.359  0.00  0.00           C  
ATOM    135  C   PRO A   8      32.611 106.685  -1.774  0.00  0.00           C  
ATOM    136  O   PRO A   8      32.810 107.880  -1.992  0.00  0.00           O  
ATOM    137  CB  PRO A   8      33.525 104.273  -1.503  0.00  0.00           C  
ATOM    138  CG  PRO A   8      32.859 103.914  -0.176  0.00  0.00           C  
ATOM    139  CD  PRO A   8      33.558 104.848   0.810  0.00  0.00           C  
ATOM    140  HA  PRO A   8      34.648 106.028  -1.984  0.00  0.00           H  
ATOM    141  HB2 PRO A   8      32.908 104.018  -2.364  0.00  0.00           H  
ATOM    142  HB3 PRO A   8      34.479 103.749  -1.574  0.00  0.00           H  
ATOM    143  HG2 PRO A   8      31.790 104.129  -0.198  0.00  0.00           H  
ATOM    144  HG3 PRO A   8      33.026 102.869   0.083  0.00  0.00           H  
ATOM    145  HD2 PRO A   8      32.850 105.227   1.549  0.00  0.00           H  
ATOM    146  HD3 PRO A   8      34.358 104.289   1.296  0.00  0.00           H  
ATOM    147  N   GLU A   9      31.397 106.138  -1.906  0.00  0.00           N  
ATOM    148  CA  GLU A   9      30.264 106.731  -2.613  0.00  0.00           C  
ATOM    149  C   GLU A   9      29.353 107.442  -1.606  0.00  0.00           C  
ATOM    150  O   GLU A   9      28.209 107.036  -1.400  0.00  0.00           O  
ATOM    151  CB  GLU A   9      29.505 105.631  -3.395  0.00  0.00           C  
ATOM    152  CG  GLU A   9      30.328 104.807  -4.398  0.00  0.00           C  
ATOM    153  CD  GLU A   9      30.755 105.601  -5.648  0.00  0.00           C  
ATOM    154  OE1 GLU A   9      31.599 106.524  -5.541  0.00  0.00           O  
ATOM    155  OE2 GLU A   9      30.274 105.281  -6.764  0.00  0.00           O  
ATOM    156  H   GLU A   9      31.273 105.175  -1.629  0.00  0.00           H  
ATOM    157  HA  GLU A   9      30.631 107.474  -3.323  0.00  0.00           H  
ATOM    158  HB2 GLU A   9      29.082 104.927  -2.675  0.00  0.00           H  
ATOM    159  HB3 GLU A   9      28.678 106.094  -3.934  0.00  0.00           H  
ATOM    160  HG2 GLU A   9      31.208 104.390  -3.907  0.00  0.00           H  
ATOM    161  HG3 GLU A   9      29.712 103.958  -4.708  0.00  0.00           H  
ATOM    162  N   LEU A  10      29.874 108.454  -0.903  0.00  0.00           N  
ATOM    163  CA  LEU A  10      29.112 109.198   0.105  0.00  0.00           C  
ATOM    164  C   LEU A  10      28.080 110.104  -0.585  0.00  0.00           C  
ATOM    165  O   LEU A  10      28.333 111.292  -0.804  0.00  0.00           O  
ATOM    166  CB  LEU A  10      30.026 109.996   1.058  0.00  0.00           C  
ATOM    167  CG  LEU A  10      31.099 109.198   1.825  0.00  0.00           C  
ATOM    168  CD1 LEU A  10      31.605 110.059   2.991  0.00  0.00           C  
ATOM    169  CD2 LEU A  10      30.618 107.842   2.359  0.00  0.00           C  
ATOM    170  H   LEU A  10      30.822 108.744  -1.109  0.00  0.00           H  
ATOM    171  HA  LEU A  10      28.559 108.478   0.711  0.00  0.00           H  
ATOM    172  HB2 LEU A  10      30.531 110.782   0.496  0.00  0.00           H  
ATOM    173  HB3 LEU A  10      29.371 110.483   1.784  0.00  0.00           H  
ATOM    174  HG  LEU A  10      31.935 109.010   1.150  0.00  0.00           H  
ATOM    175 HD11 LEU A  10      31.977 111.013   2.617  0.00  0.00           H  
ATOM    176 HD12 LEU A  10      30.800 110.246   3.702  0.00  0.00           H  
ATOM    177 HD13 LEU A  10      32.417 109.553   3.510  0.00  0.00           H  
ATOM    178 HD21 LEU A  10      29.744 107.975   2.996  0.00  0.00           H  
ATOM    179 HD22 LEU A  10      30.364 107.178   1.531  0.00  0.00           H  
ATOM    180 HD23 LEU A  10      31.414 107.364   2.930  0.00  0.00           H  
ATOM    181  N   THR A  11      26.940 109.535  -0.976  0.00  0.00           N  
ATOM    182  CA  THR A  11      25.864 110.221  -1.678  0.00  0.00           C  
ATOM    183  C   THR A  11      24.528 109.511  -1.388  0.00  0.00           C  
ATOM    184  O   THR A  11      24.503 108.354  -0.949  0.00  0.00           O  
ATOM    185  CB  THR A  11      26.220 110.289  -3.184  0.00  0.00           C  
ATOM    186  OG1 THR A  11      25.363 111.192  -3.862  0.00  0.00           O  
ATOM    187  CG2 THR A  11      26.191 108.928  -3.897  0.00  0.00           C  
ATOM    188  H   THR A  11      26.818 108.538  -0.841  0.00  0.00           H  
ATOM    189  HA  THR A  11      25.800 111.240  -1.292  0.00  0.00           H  
ATOM    190  HB  THR A  11      27.234 110.683  -3.268  0.00  0.00           H  
ATOM    191  HG1 THR A  11      25.775 111.432  -4.716  0.00  0.00           H  
ATOM    192 HG21 THR A  11      26.867 108.230  -3.404  0.00  0.00           H  
ATOM    193 HG22 THR A  11      25.183 108.509  -3.887  0.00  0.00           H  
ATOM    194 HG23 THR A  11      26.519 109.044  -4.931  0.00  0.00           H  
ATOM    195  N   GLY A  12      23.415 110.197  -1.656  0.00  0.00           N  
ATOM    196  CA  GLY A  12      22.056 109.690  -1.531  0.00  0.00           C  
ATOM    197  C   GLY A  12      21.100 110.579  -2.326  0.00  0.00           C  
ATOM    198  O   GLY A  12      21.529 111.574  -2.921  0.00  0.00           O  
ATOM    199  H   GLY A  12      23.499 111.108  -2.091  0.00  0.00           H  
ATOM    200  HA2 GLY A  12      22.016 108.683  -1.944  0.00  0.00           H  
ATOM    201  HA3 GLY A  12      21.758 109.660  -0.484  0.00  0.00           H  
ATOM    202  N   GLU A  13      19.817 110.207  -2.380  0.00  0.00           N  
ATOM    203  CA  GLU A  13      18.868 110.802  -3.330  0.00  0.00           C  
ATOM    204  C   GLU A  13      17.395 110.651  -2.920  0.00  0.00           C  
ATOM    205  O   GLU A  13      16.583 111.501  -3.291  0.00  0.00           O  
ATOM    206  CB  GLU A  13      19.067 110.165  -4.727  0.00  0.00           C  
ATOM    207  CG  GLU A  13      19.517 111.201  -5.766  0.00  0.00           C  
ATOM    208  CD  GLU A  13      19.598 110.593  -7.178  0.00  0.00           C  
ATOM    209  OE1 GLU A  13      20.584 109.881  -7.488  0.00  0.00           O  
ATOM    210  OE2 GLU A  13      18.684 110.844  -8.004  0.00  0.00           O  
ATOM    211  H   GLU A  13      19.493 109.483  -1.752  0.00  0.00           H  
ATOM    212  HA  GLU A  13      19.075 111.872  -3.393  0.00  0.00           H  
ATOM    213  HB2 GLU A  13      19.810 109.365  -4.679  0.00  0.00           H  
ATOM    214  HB3 GLU A  13      18.132 109.717  -5.068  0.00  0.00           H  
ATOM    215  HG2 GLU A  13      18.808 112.033  -5.766  0.00  0.00           H  
ATOM    216  HG3 GLU A  13      20.495 111.595  -5.484  0.00  0.00           H  
ATOM    217  N   LYS A  14      17.027 109.595  -2.179  0.00  0.00           N  
ATOM    218  CA  LYS A  14      15.630 109.349  -1.806  0.00  0.00           C  
ATOM    219  C   LYS A  14      15.115 110.486  -0.924  0.00  0.00           C  
ATOM    220  O   LYS A  14      14.001 110.974  -1.129  0.00  0.00           O  
ATOM    221  CB  LYS A  14      15.503 107.970  -1.134  0.00  0.00           C  
ATOM    222  CG  LYS A  14      14.086 107.702  -0.599  0.00  0.00           C  
ATOM    223  CD  LYS A  14      13.843 106.203  -0.385  0.00  0.00           C  
ATOM    224  CE  LYS A  14      12.485 105.991   0.296  0.00  0.00           C  
ATOM    225  NZ  LYS A  14      12.030 104.579   0.215  0.00  0.00           N  
ATOM    226  H   LYS A  14      17.732 108.964  -1.826  0.00  0.00           H  
ATOM    227  HA  LYS A  14      15.030 109.340  -2.719  0.00  0.00           H  
ATOM    228  HB2 LYS A  14      15.754 107.211  -1.874  0.00  0.00           H  
ATOM    229  HB3 LYS A  14      16.208 107.890  -0.307  0.00  0.00           H  
ATOM    230  HG2 LYS A  14      13.956 108.233   0.346  0.00  0.00           H  
ATOM    231  HG3 LYS A  14      13.351 108.071  -1.315  0.00  0.00           H  
ATOM    232  HD2 LYS A  14      13.849 105.708  -1.357  0.00  0.00           H  
ATOM    233  HD3 LYS A  14      14.635 105.781   0.238  0.00  0.00           H  
ATOM    234  HE2 LYS A  14      12.571 106.288   1.346  0.00  0.00           H  
ATOM    235  HE3 LYS A  14      11.739 106.634  -0.178  0.00  0.00           H  
ATOM    236  HZ1 LYS A  14      11.760 104.331  -0.729  0.00  0.00           H  
ATOM    237  HZ2 LYS A  14      12.749 103.938   0.524  0.00  0.00           H  
ATOM    238  HZ3 LYS A  14      11.223 104.444   0.823  0.00  0.00           H  
ATOM    239  N   ALA A  15      15.941 110.922   0.026  0.00  0.00           N  
ATOM    240  CA  ALA A  15      15.761 112.126   0.819  0.00  0.00           C  
ATOM    241  C   ALA A  15      17.120 112.480   1.420  0.00  0.00           C  
ATOM    242  O   ALA A  15      18.036 111.653   1.435  0.00  0.00           O  
ATOM    243  CB  ALA A  15      14.733 111.881   1.935  0.00  0.00           C  
ATOM    244  H   ALA A  15      16.850 110.479   0.118  0.00  0.00           H  
ATOM    245  HA  ALA A  15      15.421 112.941   0.178  0.00  0.00           H  
ATOM    246  HB1 ALA A  15      13.762 111.662   1.493  0.00  0.00           H  
ATOM    247  HB2 ALA A  15      15.046 111.046   2.562  0.00  0.00           H  
ATOM    248  HB3 ALA A  15      14.632 112.773   2.555  0.00  0.00           H  
ATOM    249  N   TRP A  16      17.233 113.679   1.979  0.00  0.00           N  
ATOM    250  CA  TRP A  16      18.333 114.055   2.850  0.00  0.00           C  
ATOM    251  C   TRP A  16      17.827 115.080   3.863  0.00  0.00           C  
ATOM    252  O   TRP A  16      16.777 115.703   3.667  0.00  0.00           O  
ATOM    253  CB  TRP A  16      19.544 114.528   2.034  0.00  0.00           C  
ATOM    254  CG  TRP A  16      19.296 115.514   0.935  0.00  0.00           C  
ATOM    255  CD1 TRP A  16      19.067 115.206  -0.362  0.00  0.00           C  
ATOM    256  CD2 TRP A  16      19.316 116.972   0.998  0.00  0.00           C  
ATOM    257  NE1 TRP A  16      18.954 116.363  -1.104  0.00  0.00           N  
ATOM    258  CE2 TRP A  16      19.130 117.485  -0.322  0.00  0.00           C  
ATOM    259  CE3 TRP A  16      19.502 117.912   2.035  0.00  0.00           C  
ATOM    260  CZ2 TRP A  16      19.157 118.860  -0.600  0.00  0.00           C  
ATOM    261  CZ3 TRP A  16      19.519 119.295   1.767  0.00  0.00           C  
ATOM    262  CH2 TRP A  16      19.359 119.769   0.452  0.00  0.00           C  
ATOM    263  H   TRP A  16      16.452 114.324   1.951  0.00  0.00           H  
ATOM    264  HA  TRP A  16      18.631 113.177   3.421  0.00  0.00           H  
ATOM    265  HB2 TRP A  16      20.276 114.958   2.716  0.00  0.00           H  
ATOM    266  HB3 TRP A  16      20.011 113.649   1.588  0.00  0.00           H  
ATOM    267  HD1 TRP A  16      19.011 114.200  -0.763  0.00  0.00           H  
ATOM    268  HE1 TRP A  16      18.794 116.359  -2.107  0.00  0.00           H  
ATOM    269  HE3 TRP A  16      19.636 117.559   3.046  0.00  0.00           H  
ATOM    270  HZ2 TRP A  16      19.028 119.216  -1.613  0.00  0.00           H  
ATOM    271  HZ3 TRP A  16      19.660 120.000   2.576  0.00  0.00           H  
ATOM    272  HH2 TRP A  16      19.386 120.833   0.252  0.00  0.00           H  
ATOM    273  N   LEU A  17      18.541 115.193   4.980  0.00  0.00           N  
ATOM    274  CA  LEU A  17      18.024 115.698   6.246  0.00  0.00           C  
ATOM    275  C   LEU A  17      19.113 116.569   6.852  0.00  0.00           C  
ATOM    276  O   LEU A  17      20.255 116.124   6.972  0.00  0.00           O  
ATOM    277  CB  LEU A  17      17.684 114.503   7.175  0.00  0.00           C  
ATOM    278  CG  LEU A  17      16.224 114.391   7.646  0.00  0.00           C  
ATOM    279  CD1 LEU A  17      15.833 115.571   8.543  0.00  0.00           C  
ATOM    280  CD2 LEU A  17      15.259 114.243   6.464  0.00  0.00           C  
ATOM    281  H   LEU A  17      19.452 114.739   5.019  0.00  0.00           H  
ATOM    282  HA  LEU A  17      17.135 116.301   6.064  0.00  0.00           H  
ATOM    283  HB2 LEU A  17      17.933 113.566   6.672  0.00  0.00           H  
ATOM    284  HB3 LEU A  17      18.312 114.551   8.066  0.00  0.00           H  
ATOM    285  HG  LEU A  17      16.147 113.484   8.245  0.00  0.00           H  
ATOM    286 HD11 LEU A  17      16.530 115.642   9.381  0.00  0.00           H  
ATOM    287 HD12 LEU A  17      15.844 116.507   7.987  0.00  0.00           H  
ATOM    288 HD13 LEU A  17      14.833 115.411   8.947  0.00  0.00           H  
ATOM    289 HD21 LEU A  17      15.163 115.182   5.918  0.00  0.00           H  
ATOM    290 HD22 LEU A  17      15.621 113.472   5.783  0.00  0.00           H  
ATOM    291 HD23 LEU A  17      14.277 113.941   6.822  0.00  0.00           H  
ATOM    292  N   ASN A  18      18.763 117.808   7.208  0.00  0.00           N  
ATOM    293  CA  ASN A  18      19.630 118.876   7.732  0.00  0.00           C  
ATOM    294  C   ASN A  18      20.615 119.420   6.690  0.00  0.00           C  
ATOM    295  O   ASN A  18      20.921 120.614   6.704  0.00  0.00           O  
ATOM    296  CB  ASN A  18      20.394 118.450   8.997  0.00  0.00           C  
ATOM    297  CG  ASN A  18      19.504 117.809  10.052  0.00  0.00           C  
ATOM    298  OD1 ASN A  18      18.526 118.402  10.500  0.00  0.00           O  
ATOM    299  ND2 ASN A  18      19.819 116.596  10.479  0.00  0.00           N  
ATOM    300  H   ASN A  18      17.803 118.080   7.042  0.00  0.00           H  
ATOM    301  HA  ASN A  18      18.974 119.699   8.020  0.00  0.00           H  
ATOM    302  HB2 ASN A  18      21.196 117.769   8.714  0.00  0.00           H  
ATOM    303  HB3 ASN A  18      20.867 119.332   9.431  0.00  0.00           H  
ATOM    304 HD21 ASN A  18      20.666 116.146  10.129  0.00  0.00           H  
ATOM    305 HD22 ASN A  18      19.312 116.199  11.262  0.00  0.00           H  
ATOM    306  N   GLY A  19      21.094 118.577   5.778  0.00  0.00           N  
ATOM    307  CA  GLY A  19      21.988 118.914   4.686  0.00  0.00           C  
ATOM    308  C   GLY A  19      22.448 117.629   4.008  0.00  0.00           C  
ATOM    309  O   GLY A  19      22.157 116.527   4.480  0.00  0.00           O  
ATOM    310  H   GLY A  19      20.878 117.588   5.871  0.00  0.00           H  
ATOM    311  HA2 GLY A  19      21.472 119.551   3.968  0.00  0.00           H  
ATOM    312  HA3 GLY A  19      22.857 119.449   5.073  0.00  0.00           H  
ATOM    313  N   GLU A  20      23.209 117.767   2.928  0.00  0.00           N  
ATOM    314  CA  GLU A  20      23.995 116.693   2.342  0.00  0.00           C  
ATOM    315  C   GLU A  20      25.324 117.286   1.880  0.00  0.00           C  
ATOM    316  O   GLU A  20      25.468 118.507   1.749  0.00  0.00           O  
ATOM    317  CB  GLU A  20      23.214 115.933   1.253  0.00  0.00           C  
ATOM    318  CG  GLU A  20      22.653 116.748   0.076  0.00  0.00           C  
ATOM    319  CD  GLU A  20      23.701 117.125  -0.992  0.00  0.00           C  
ATOM    320  OE1 GLU A  20      24.035 116.262  -1.842  0.00  0.00           O  
ATOM    321  OE2 GLU A  20      24.149 118.297  -1.031  0.00  0.00           O  
ATOM    322  H   GLU A  20      23.440 118.693   2.594  0.00  0.00           H  
ATOM    323  HA  GLU A  20      24.223 115.969   3.128  0.00  0.00           H  
ATOM    324  HB2 GLU A  20      23.831 115.125   0.863  0.00  0.00           H  
ATOM    325  HB3 GLU A  20      22.368 115.452   1.743  0.00  0.00           H  
ATOM    326  HG2 GLU A  20      21.885 116.142  -0.408  0.00  0.00           H  
ATOM    327  HG3 GLU A  20      22.157 117.642   0.454  0.00  0.00           H  
ATOM    328  N   VAL A  21      26.328 116.425   1.751  0.00  0.00           N  
ATOM    329  CA  VAL A  21      27.730 116.805   1.690  0.00  0.00           C  
ATOM    330  C   VAL A  21      28.483 115.603   1.107  0.00  0.00           C  
ATOM    331  O   VAL A  21      28.042 114.459   1.268  0.00  0.00           O  
ATOM    332  CB  VAL A  21      28.177 117.213   3.119  0.00  0.00           C  
ATOM    333  CG1 VAL A  21      28.047 116.077   4.149  0.00  0.00           C  
ATOM    334  CG2 VAL A  21      29.588 117.807   3.160  0.00  0.00           C  
ATOM    335  H   VAL A  21      26.156 115.431   1.834  0.00  0.00           H  
ATOM    336  HA  VAL A  21      27.840 117.662   1.021  0.00  0.00           H  
ATOM    337  HB  VAL A  21      27.515 118.011   3.456  0.00  0.00           H  
ATOM    338 HG11 VAL A  21      27.016 115.732   4.209  0.00  0.00           H  
ATOM    339 HG12 VAL A  21      28.681 115.235   3.872  0.00  0.00           H  
ATOM    340 HG13 VAL A  21      28.342 116.439   5.134  0.00  0.00           H  
ATOM    341 HG21 VAL A  21      30.335 117.042   2.944  0.00  0.00           H  
ATOM    342 HG22 VAL A  21      29.664 118.618   2.436  0.00  0.00           H  
ATOM    343 HG23 VAL A  21      29.779 118.221   4.151  0.00  0.00           H  
ATOM    344  N   THR A  22      29.601 115.846   0.428  0.00  0.00           N  
ATOM    345  CA  THR A  22      30.406 114.808  -0.206  0.00  0.00           C  
ATOM    346  C   THR A  22      31.687 114.594   0.601  0.00  0.00           C  
ATOM    347  O   THR A  22      32.054 115.433   1.433  0.00  0.00           O  
ATOM    348  CB  THR A  22      30.688 115.209  -1.668  0.00  0.00           C  
ATOM    349  OG1 THR A  22      31.080 116.572  -1.753  0.00  0.00           O  
ATOM    350  CG2 THR A  22      29.442 115.024  -2.538  0.00  0.00           C  
ATOM    351  H   THR A  22      29.941 116.791   0.323  0.00  0.00           H  
ATOM    352  HA  THR A  22      29.860 113.863  -0.213  0.00  0.00           H  
ATOM    353  HB  THR A  22      31.485 114.580  -2.066  0.00  0.00           H  
ATOM    354  HG1 THR A  22      31.499 116.710  -2.626  0.00  0.00           H  
ATOM    355 HG21 THR A  22      29.123 113.981  -2.503  0.00  0.00           H  
ATOM    356 HG22 THR A  22      28.630 115.660  -2.182  0.00  0.00           H  
ATOM    357 HG23 THR A  22      29.675 115.281  -3.572  0.00  0.00           H  
ATOM    358  N   ARG A  23      32.397 113.487   0.335  0.00  0.00           N  
ATOM    359  CA  ARG A  23      33.684 113.196   0.973  0.00  0.00           C  
ATOM    360  C   ARG A  23      34.616 114.400   0.872  0.00  0.00           C  
ATOM    361  O   ARG A  23      35.109 114.880   1.884  0.00  0.00           O  
ATOM    362  CB  ARG A  23      34.298 111.893   0.407  0.00  0.00           C  
ATOM    363  CG  ARG A  23      34.705 111.930  -1.080  0.00  0.00           C  
ATOM    364  CD  ARG A  23      35.110 110.543  -1.583  0.00  0.00           C  
ATOM    365  NE  ARG A  23      35.699 110.612  -2.935  0.00  0.00           N  
ATOM    366  CZ  ARG A  23      35.767 109.612  -3.826  0.00  0.00           C  
ATOM    367  NH1 ARG A  23      35.135 108.461  -3.608  0.00  0.00           N  
ATOM    368  NH2 ARG A  23      36.478 109.770  -4.941  0.00  0.00           N  
ATOM    369  H   ARG A  23      32.029 112.817  -0.328  0.00  0.00           H  
ATOM    370  HA  ARG A  23      33.495 113.032   2.038  0.00  0.00           H  
ATOM    371  HB2 ARG A  23      35.191 111.662   0.986  0.00  0.00           H  
ATOM    372  HB3 ARG A  23      33.583 111.082   0.559  0.00  0.00           H  
ATOM    373  HG2 ARG A  23      33.875 112.291  -1.689  0.00  0.00           H  
ATOM    374  HG3 ARG A  23      35.557 112.598  -1.198  0.00  0.00           H  
ATOM    375  HD2 ARG A  23      35.854 110.121  -0.907  0.00  0.00           H  
ATOM    376  HD3 ARG A  23      34.229 109.904  -1.584  0.00  0.00           H  
ATOM    377  HE  ARG A  23      36.161 111.486  -3.164  0.00  0.00           H  
ATOM    378 HH11 ARG A  23      34.512 108.364  -2.808  0.00  0.00           H  
ATOM    379 HH12 ARG A  23      35.171 107.694  -4.269  0.00  0.00           H  
ATOM    380 HH21 ARG A  23      36.970 110.636  -5.133  0.00  0.00           H  
ATOM    381 HH22 ARG A  23      36.563 109.036  -5.635  0.00  0.00           H  
ATOM    382  N   GLU A  24      34.759 114.971  -0.324  0.00  0.00           N  
ATOM    383  CA  GLU A  24      35.708 116.045  -0.606  0.00  0.00           C  
ATOM    384  C   GLU A  24      35.369 117.368   0.106  0.00  0.00           C  
ATOM    385  O   GLU A  24      36.197 118.283   0.110  0.00  0.00           O  
ATOM    386  CB  GLU A  24      35.844 116.215  -2.130  0.00  0.00           C  
ATOM    387  CG  GLU A  24      34.546 116.648  -2.830  0.00  0.00           C  
ATOM    388  CD  GLU A  24      34.732 116.716  -4.356  0.00  0.00           C  
ATOM    389  OE1 GLU A  24      35.108 117.793  -4.882  0.00  0.00           O  
ATOM    390  OE2 GLU A  24      34.491 115.695  -5.048  0.00  0.00           O  
ATOM    391  H   GLU A  24      34.252 114.586  -1.109  0.00  0.00           H  
ATOM    392  HA  GLU A  24      36.681 115.724  -0.228  0.00  0.00           H  
ATOM    393  HB2 GLU A  24      36.621 116.951  -2.338  0.00  0.00           H  
ATOM    394  HB3 GLU A  24      36.168 115.262  -2.551  0.00  0.00           H  
ATOM    395  HG2 GLU A  24      33.753 115.933  -2.600  0.00  0.00           H  
ATOM    396  HG3 GLU A  24      34.237 117.624  -2.452  0.00  0.00           H  
ATOM    397  N   GLN A  25      34.185 117.477   0.723  0.00  0.00           N  
ATOM    398  CA  GLN A  25      33.781 118.623   1.534  0.00  0.00           C  
ATOM    399  C   GLN A  25      33.881 118.315   3.039  0.00  0.00           C  
ATOM    400  O   GLN A  25      33.821 119.244   3.851  0.00  0.00           O  
ATOM    401  CB  GLN A  25      32.349 119.030   1.158  0.00  0.00           C  
ATOM    402  CG  GLN A  25      32.238 119.585  -0.268  0.00  0.00           C  
ATOM    403  CD  GLN A  25      30.809 120.048  -0.567  0.00  0.00           C  
ATOM    404  OE1 GLN A  25      30.424 121.174  -0.252  0.00  0.00           O  
ATOM    405  NE2 GLN A  25      29.984 119.198  -1.162  0.00  0.00           N  
ATOM    406  H   GLN A  25      33.548 116.689   0.700  0.00  0.00           H  
ATOM    407  HA  GLN A  25      34.439 119.469   1.329  0.00  0.00           H  
ATOM    408  HB2 GLN A  25      31.695 118.165   1.251  0.00  0.00           H  
ATOM    409  HB3 GLN A  25      32.007 119.799   1.852  0.00  0.00           H  
ATOM    410  HG2 GLN A  25      32.916 120.433  -0.379  0.00  0.00           H  
ATOM    411  HG3 GLN A  25      32.533 118.821  -0.988  0.00  0.00           H  
ATOM    412 HE21 GLN A  25      30.325 118.278  -1.441  0.00  0.00           H  
ATOM    413 HE22 GLN A  25      29.043 119.482  -1.404  0.00  0.00           H  
ATOM    414  N   LEU A  26      34.038 117.044   3.430  0.00  0.00           N  
ATOM    415  CA  LEU A  26      34.141 116.621   4.822  0.00  0.00           C  
ATOM    416  C   LEU A  26      35.611 116.509   5.235  0.00  0.00           C  
ATOM    417  O   LEU A  26      36.032 117.120   6.221  0.00  0.00           O  
ATOM    418  CB  LEU A  26      33.445 115.254   5.017  0.00  0.00           C  
ATOM    419  CG  LEU A  26      32.439 115.290   6.177  0.00  0.00           C  
ATOM    420  CD1 LEU A  26      31.126 115.941   5.754  0.00  0.00           C  
ATOM    421  CD2 LEU A  26      32.160 113.875   6.677  0.00  0.00           C  
ATOM    422  H   LEU A  26      34.122 116.325   2.721  0.00  0.00           H  
ATOM    423  HA  LEU A  26      33.659 117.365   5.458  0.00  0.00           H  
ATOM    424  HB2 LEU A  26      32.936 114.939   4.104  0.00  0.00           H  
ATOM    425  HB3 LEU A  26      34.194 114.491   5.237  0.00  0.00           H  
ATOM    426  HG  LEU A  26      32.863 115.861   6.998  0.00  0.00           H  
ATOM    427 HD11 LEU A  26      31.300 116.981   5.484  0.00  0.00           H  
ATOM    428 HD12 LEU A  26      30.722 115.407   4.895  0.00  0.00           H  
ATOM    429 HD13 LEU A  26      30.405 115.905   6.573  0.00  0.00           H  
ATOM    430 HD21 LEU A  26      31.772 113.250   5.872  0.00  0.00           H  
ATOM    431 HD22 LEU A  26      33.098 113.456   7.032  0.00  0.00           H  
ATOM    432 HD23 LEU A  26      31.448 113.894   7.503  0.00  0.00           H  
ATOM    433  N   ILE A  27      36.384 115.716   4.489  0.00  0.00           N  
ATOM    434  CA  ILE A  27      37.776 115.410   4.805  0.00  0.00           C  
ATOM    435  C   ILE A  27      38.695 116.516   4.276  0.00  0.00           C  
ATOM    436  O   ILE A  27      38.306 117.324   3.427  0.00  0.00           O  
ATOM    437  CB  ILE A  27      38.162 114.002   4.294  0.00  0.00           C  
ATOM    438  CG1 ILE A  27      37.676 113.713   2.859  0.00  0.00           C  
ATOM    439  CG2 ILE A  27      37.584 112.974   5.282  0.00  0.00           C  
ATOM    440  CD1 ILE A  27      38.447 112.627   2.111  0.00  0.00           C  
ATOM    441  H   ILE A  27      35.995 115.314   3.644  0.00  0.00           H  
ATOM    442  HA  ILE A  27      37.886 115.407   5.892  0.00  0.00           H  
ATOM    443  HB  ILE A  27      39.247 113.908   4.304  0.00  0.00           H  
ATOM    444 HG12 ILE A  27      36.641 113.382   2.914  0.00  0.00           H  
ATOM    445 HG13 ILE A  27      37.741 114.625   2.265  0.00  0.00           H  
ATOM    446 HG21 ILE A  27      38.059 113.085   6.259  0.00  0.00           H  
ATOM    447 HG22 ILE A  27      36.506 113.107   5.387  0.00  0.00           H  
ATOM    448 HG23 ILE A  27      37.767 111.970   4.916  0.00  0.00           H  
ATOM    449 HD11 ILE A  27      39.505 112.886   2.069  0.00  0.00           H  
ATOM    450 HD12 ILE A  27      38.312 111.671   2.604  0.00  0.00           H  
ATOM    451 HD13 ILE A  27      38.059 112.548   1.095  0.00  0.00           H  
ATOM    452  N   GLY A  28      39.915 116.555   4.817  0.00  0.00           N  
ATOM    453  CA  GLY A  28      40.914 117.581   4.549  0.00  0.00           C  
ATOM    454  C   GLY A  28      41.354 118.283   5.832  0.00  0.00           C  
ATOM    455  O   GLY A  28      42.456 118.835   5.869  0.00  0.00           O  
ATOM    456  H   GLY A  28      40.198 115.801   5.438  0.00  0.00           H  
ATOM    457  HA2 GLY A  28      41.780 117.115   4.077  0.00  0.00           H  
ATOM    458  HA3 GLY A  28      40.513 118.332   3.870  0.00  0.00           H  
ATOM    459  N   GLU A  29      40.546 118.237   6.900  0.00  0.00           N  
ATOM    460  CA  GLU A  29      40.758 119.069   8.087  0.00  0.00           C  
ATOM    461  C   GLU A  29      40.521 118.309   9.398  0.00  0.00           C  
ATOM    462  O   GLU A  29      41.328 118.446  10.320  0.00  0.00           O  
ATOM    463  CB  GLU A  29      39.838 120.297   7.978  0.00  0.00           C  
ATOM    464  CG  GLU A  29      40.174 121.384   9.010  0.00  0.00           C  
ATOM    465  CD  GLU A  29      39.246 122.603   8.861  0.00  0.00           C  
ATOM    466  OE1 GLU A  29      38.123 122.590   9.422  0.00  0.00           O  
ATOM    467  OE2 GLU A  29      39.637 123.593   8.193  0.00  0.00           O  
ATOM    468  H   GLU A  29      39.654 117.770   6.804  0.00  0.00           H  
ATOM    469  HA  GLU A  29      41.789 119.426   8.098  0.00  0.00           H  
ATOM    470  HB2 GLU A  29      39.946 120.728   6.982  0.00  0.00           H  
ATOM    471  HB3 GLU A  29      38.801 119.982   8.103  0.00  0.00           H  
ATOM    472  HG2 GLU A  29      40.075 120.980  10.018  0.00  0.00           H  
ATOM    473  HG3 GLU A  29      41.213 121.692   8.874  0.00  0.00           H  
ATOM    474  N   LYS A  30      39.463 117.489   9.498  0.00  0.00           N  
ATOM    475  CA  LYS A  30      39.104 116.792  10.742  0.00  0.00           C  
ATOM    476  C   LYS A  30      38.766 115.332  10.435  0.00  0.00           C  
ATOM    477  O   LYS A  30      38.335 115.053   9.312  0.00  0.00           O  
ATOM    478  CB  LYS A  30      37.926 117.478  11.487  0.00  0.00           C  
ATOM    479  CG  LYS A  30      37.711 118.979  11.214  0.00  0.00           C  
ATOM    480  CD  LYS A  30      36.904 119.701  12.307  0.00  0.00           C  
ATOM    481  CE  LYS A  30      35.436 119.266  12.463  0.00  0.00           C  
ATOM    482  NZ  LYS A  30      34.534 119.865  11.442  0.00  0.00           N  
ATOM    483  H   LYS A  30      38.855 117.345   8.703  0.00  0.00           H  
ATOM    484  HA  LYS A  30      39.971 116.811  11.404  0.00  0.00           H  
ATOM    485  HB2 LYS A  30      36.997 116.953  11.262  0.00  0.00           H  
ATOM    486  HB3 LYS A  30      38.111 117.358  12.552  0.00  0.00           H  
ATOM    487  HG2 LYS A  30      38.682 119.466  11.169  0.00  0.00           H  
ATOM    488  HG3 LYS A  30      37.220 119.103  10.248  0.00  0.00           H  
ATOM    489  HD2 LYS A  30      37.410 119.536  13.260  0.00  0.00           H  
ATOM    490  HD3 LYS A  30      36.942 120.775  12.116  0.00  0.00           H  
ATOM    491  HE2 LYS A  30      35.367 118.176  12.434  0.00  0.00           H  
ATOM    492  HE3 LYS A  30      35.101 119.593  13.451  0.00  0.00           H  
ATOM    493  HZ1 LYS A  30      34.641 120.872  11.401  0.00  0.00           H  
ATOM    494  HZ2 LYS A  30      34.697 119.477  10.519  0.00  0.00           H  
ATOM    495  HZ3 LYS A  30      33.565 119.684  11.677  0.00  0.00           H  
ATOM    496  N   PRO A  31      38.939 114.406  11.397  0.00  0.00           N  
ATOM    497  CA  PRO A  31      38.424 113.047  11.278  0.00  0.00           C  
ATOM    498  C   PRO A  31      36.894 113.066  11.228  0.00  0.00           C  
ATOM    499  O   PRO A  31      36.262 114.105  11.419  0.00  0.00           O  
ATOM    500  CB  PRO A  31      38.975 112.291  12.492  0.00  0.00           C  
ATOM    501  CG  PRO A  31      39.199 113.377  13.535  0.00  0.00           C  
ATOM    502  CD  PRO A  31      39.553 114.606  12.704  0.00  0.00           C  
ATOM    503  HA  PRO A  31      38.795 112.584  10.363  0.00  0.00           H  
ATOM    504  HB2 PRO A  31      38.288 111.525  12.856  0.00  0.00           H  
ATOM    505  HB3 PRO A  31      39.933 111.841  12.232  0.00  0.00           H  
ATOM    506  HG2 PRO A  31      38.272 113.557  14.077  0.00  0.00           H  
ATOM    507  HG3 PRO A  31      40.002 113.107  14.221  0.00  0.00           H  
ATOM    508  HD2 PRO A  31      39.178 115.501  13.194  0.00  0.00           H  
ATOM    509  HD3 PRO A  31      40.634 114.677  12.588  0.00  0.00           H  
ATOM    510  N   THR A  32      36.285 111.909  10.999  0.00  0.00           N  
ATOM    511  CA  THR A  32      34.879 111.800  10.645  0.00  0.00           C  
ATOM    512  C   THR A  32      34.263 110.591  11.348  0.00  0.00           C  
ATOM    513  O   THR A  32      34.934 109.574  11.540  0.00  0.00           O  
ATOM    514  CB  THR A  32      34.814 111.677   9.114  0.00  0.00           C  
ATOM    515  OG1 THR A  32      35.221 112.904   8.528  0.00  0.00           O  
ATOM    516  CG2 THR A  32      33.437 111.284   8.571  0.00  0.00           C  
ATOM    517  H   THR A  32      36.847 111.068  10.914  0.00  0.00           H  
ATOM    518  HA  THR A  32      34.349 112.699  10.951  0.00  0.00           H  
ATOM    519  HB  THR A  32      35.519 110.909   8.807  0.00  0.00           H  
ATOM    520  HG1 THR A  32      35.793 112.708   7.761  0.00  0.00           H  
ATOM    521 HG21 THR A  32      33.194 110.267   8.875  0.00  0.00           H  
ATOM    522 HG22 THR A  32      32.672 111.967   8.943  0.00  0.00           H  
ATOM    523 HG23 THR A  32      33.446 111.298   7.483  0.00  0.00           H  
ATOM    524  N   LEU A  33      32.966 110.679  11.653  0.00  0.00           N  
ATOM    525  CA  LEU A  33      32.096 109.549  11.947  0.00  0.00           C  
ATOM    526  C   LEU A  33      31.049 109.492  10.836  0.00  0.00           C  
ATOM    527  O   LEU A  33      30.369 110.491  10.590  0.00  0.00           O  
ATOM    528  CB  LEU A  33      31.412 109.740  13.318  0.00  0.00           C  
ATOM    529  CG  LEU A  33      30.286 108.719  13.602  0.00  0.00           C  
ATOM    530  CD1 LEU A  33      30.802 107.278  13.598  0.00  0.00           C  
ATOM    531  CD2 LEU A  33      29.626 108.996  14.954  0.00  0.00           C  
ATOM    532  H   LEU A  33      32.499 111.572  11.514  0.00  0.00           H  
ATOM    533  HA  LEU A  33      32.678 108.626  11.960  0.00  0.00           H  
ATOM    534  HB2 LEU A  33      32.168 109.676  14.103  0.00  0.00           H  
ATOM    535  HB3 LEU A  33      30.973 110.739  13.350  0.00  0.00           H  
ATOM    536  HG  LEU A  33      29.510 108.809  12.842  0.00  0.00           H  
ATOM    537 HD11 LEU A  33      31.221 107.018  12.632  0.00  0.00           H  
ATOM    538 HD12 LEU A  33      31.571 107.150  14.358  0.00  0.00           H  
ATOM    539 HD13 LEU A  33      29.970 106.602  13.787  0.00  0.00           H  
ATOM    540 HD21 LEU A  33      30.360 108.927  15.758  0.00  0.00           H  
ATOM    541 HD22 LEU A  33      29.188 109.993  14.953  0.00  0.00           H  
ATOM    542 HD23 LEU A  33      28.828 108.276  15.136  0.00  0.00           H  
ATOM    543  N   ILE A  34      30.883 108.321  10.222  0.00  0.00           N  
ATOM    544  CA  ILE A  34      29.705 107.965   9.438  0.00  0.00           C  
ATOM    545  C   ILE A  34      28.990 106.903  10.280  0.00  0.00           C  
ATOM    546  O   ILE A  34      29.647 105.982  10.774  0.00  0.00           O  
ATOM    547  CB  ILE A  34      30.091 107.416   8.037  0.00  0.00           C  
ATOM    548  CG1 ILE A  34      31.168 108.273   7.328  0.00  0.00           C  
ATOM    549  CG2 ILE A  34      28.825 107.289   7.165  0.00  0.00           C  
ATOM    550  CD1 ILE A  34      31.518 107.789   5.917  0.00  0.00           C  
ATOM    551  H   ILE A  34      31.483 107.542  10.483  0.00  0.00           H  
ATOM    552  HA  ILE A  34      29.068 108.838   9.313  0.00  0.00           H  
ATOM    553  HB  ILE A  34      30.507 106.415   8.165  0.00  0.00           H  
ATOM    554 HG12 ILE A  34      30.842 109.309   7.267  0.00  0.00           H  
ATOM    555 HG13 ILE A  34      32.085 108.249   7.915  0.00  0.00           H  
ATOM    556 HG21 ILE A  34      28.064 106.702   7.677  0.00  0.00           H  
ATOM    557 HG22 ILE A  34      28.421 108.275   6.933  0.00  0.00           H  
ATOM    558 HG23 ILE A  34      29.056 106.771   6.234  0.00  0.00           H  
ATOM    559 HD11 ILE A  34      31.673 106.711   5.912  0.00  0.00           H  
ATOM    560 HD12 ILE A  34      30.711 108.042   5.232  0.00  0.00           H  
ATOM    561 HD13 ILE A  34      32.430 108.281   5.581  0.00  0.00           H  
ATOM    562  N   HIS A  35      27.669 106.992  10.442  0.00  0.00           N  
ATOM    563  CA  HIS A  35      26.905 105.946  11.115  0.00  0.00           C  
ATOM    564  C   HIS A  35      25.659 105.600  10.312  0.00  0.00           C  
ATOM    565  O   HIS A  35      25.083 106.449   9.625  0.00  0.00           O  
ATOM    566  CB  HIS A  35      26.589 106.325  12.568  0.00  0.00           C  
ATOM    567  CG  HIS A  35      25.580 107.428  12.754  0.00  0.00           C  
ATOM    568  ND1 HIS A  35      24.240 107.252  13.022  0.00  0.00           N  
ATOM    569  CD2 HIS A  35      25.823 108.776  12.766  0.00  0.00           C  
ATOM    570  CE1 HIS A  35      23.691 108.465  13.186  0.00  0.00           C  
ATOM    571  NE2 HIS A  35      24.617 109.433  13.046  0.00  0.00           N  
ATOM    572  H   HIS A  35      27.154 107.765  10.038  0.00  0.00           H  
ATOM    573  HA  HIS A  35      27.513 105.042  11.148  0.00  0.00           H  
ATOM    574  HB2 HIS A  35      26.191 105.437  13.057  0.00  0.00           H  
ATOM    575  HB3 HIS A  35      27.514 106.596  13.080  0.00  0.00           H  
ATOM    576  HD1 HIS A  35      23.755 106.368  13.120  0.00  0.00           H  
ATOM    577  HD2 HIS A  35      26.782 109.249  12.605  0.00  0.00           H  
ATOM    578  HE1 HIS A  35      22.646 108.636  13.406  0.00  0.00           H  
ATOM    579  N   PHE A  36      25.263 104.332  10.379  0.00  0.00           N  
ATOM    580  CA  PHE A  36      24.141 103.770   9.646  0.00  0.00           C  
ATOM    581  C   PHE A  36      23.073 103.445  10.683  0.00  0.00           C  
ATOM    582  O   PHE A  36      23.395 102.884  11.736  0.00  0.00           O  
ATOM    583  CB  PHE A  36      24.572 102.513   8.871  0.00  0.00           C  
ATOM    584  CG  PHE A  36      25.512 102.683   7.679  0.00  0.00           C  
ATOM    585  CD1 PHE A  36      26.060 103.927   7.296  0.00  0.00           C  
ATOM    586  CD2 PHE A  36      25.837 101.541   6.925  0.00  0.00           C  
ATOM    587  CE1 PHE A  36      26.906 104.025   6.179  0.00  0.00           C  
ATOM    588  CE2 PHE A  36      26.690 101.639   5.811  0.00  0.00           C  
ATOM    589  CZ  PHE A  36      27.211 102.882   5.431  0.00  0.00           C  
ATOM    590  H   PHE A  36      25.738 103.710  11.028  0.00  0.00           H  
ATOM    591  HA  PHE A  36      23.758 104.498   8.939  0.00  0.00           H  
ATOM    592  HB2 PHE A  36      25.034 101.814   9.571  0.00  0.00           H  
ATOM    593  HB3 PHE A  36      23.666 102.035   8.494  0.00  0.00           H  
ATOM    594  HD1 PHE A  36      25.823 104.829   7.827  0.00  0.00           H  
ATOM    595  HD2 PHE A  36      25.424 100.583   7.202  0.00  0.00           H  
ATOM    596  HE1 PHE A  36      27.317 104.982   5.892  0.00  0.00           H  
ATOM    597  HE2 PHE A  36      26.957 100.761   5.246  0.00  0.00           H  
ATOM    598  HZ  PHE A  36      27.852 102.958   4.565  0.00  0.00           H  
ATOM    599  N   TRP A  37      21.820 103.810  10.408  0.00  0.00           N  
ATOM    600  CA  TRP A  37      20.720 103.698  11.362  0.00  0.00           C  
ATOM    601  C   TRP A  37      19.394 103.429  10.637  0.00  0.00           C  
ATOM    602  O   TRP A  37      19.314 103.548   9.411  0.00  0.00           O  
ATOM    603  CB  TRP A  37      20.675 104.961  12.245  0.00  0.00           C  
ATOM    604  CG  TRP A  37      20.297 106.258  11.587  0.00  0.00           C  
ATOM    605  CD1 TRP A  37      21.003 106.912  10.636  0.00  0.00           C  
ATOM    606  CD2 TRP A  37      19.128 107.093  11.846  0.00  0.00           C  
ATOM    607  NE1 TRP A  37      20.345 108.070  10.275  0.00  0.00           N  
ATOM    608  CE2 TRP A  37      19.186 108.240  10.999  0.00  0.00           C  
ATOM    609  CE3 TRP A  37      18.022 106.998  12.718  0.00  0.00           C  
ATOM    610  CZ2 TRP A  37      18.174 109.213  10.979  0.00  0.00           C  
ATOM    611  CZ3 TRP A  37      17.024 107.990  12.736  0.00  0.00           C  
ATOM    612  CH2 TRP A  37      17.085 109.084  11.858  0.00  0.00           C  
ATOM    613  H   TRP A  37      21.603 104.229   9.510  0.00  0.00           H  
ATOM    614  HA  TRP A  37      20.915 102.850  12.020  0.00  0.00           H  
ATOM    615  HB2 TRP A  37      19.971 104.779  13.056  0.00  0.00           H  
ATOM    616  HB3 TRP A  37      21.652 105.093  12.711  0.00  0.00           H  
ATOM    617  HD1 TRP A  37      21.945 106.578  10.216  0.00  0.00           H  
ATOM    618  HE1 TRP A  37      20.701 108.710   9.575  0.00  0.00           H  
ATOM    619  HE3 TRP A  37      17.953 106.163  13.401  0.00  0.00           H  
ATOM    620  HZ2 TRP A  37      18.228 110.058  10.309  0.00  0.00           H  
ATOM    621  HZ3 TRP A  37      16.220 107.929  13.453  0.00  0.00           H  
ATOM    622  HH2 TRP A  37      16.307 109.834  11.875  0.00  0.00           H  
ATOM    623  N   SER A  38      18.364 103.070  11.406  0.00  0.00           N  
ATOM    624  CA  SER A  38      17.024 102.715  10.950  0.00  0.00           C  
ATOM    625  C   SER A  38      16.050 103.098  12.065  0.00  0.00           C  
ATOM    626  O   SER A  38      16.302 102.734  13.217  0.00  0.00           O  
ATOM    627  CB  SER A  38      16.942 101.201  10.709  0.00  0.00           C  
ATOM    628  OG  SER A  38      17.743 100.795   9.613  0.00  0.00           O  
ATOM    629  H   SER A  38      18.493 103.053  12.408  0.00  0.00           H  
ATOM    630  HA  SER A  38      16.782 103.231  10.026  0.00  0.00           H  
ATOM    631  HB2 SER A  38      17.284 100.683  11.602  0.00  0.00           H  
ATOM    632  HB3 SER A  38      15.904 100.915  10.533  0.00  0.00           H  
ATOM    633  HG  SER A  38      17.442 101.285   8.827  0.00  0.00           H  
ATOM    634  N   ILE A  39      14.934 103.776  11.767  0.00  0.00           N  
ATOM    635  CA  ILE A  39      13.923 104.082  12.789  0.00  0.00           C  
ATOM    636  C   ILE A  39      13.133 102.834  13.239  0.00  0.00           C  
ATOM    637  O   ILE A  39      12.291 102.948  14.129  0.00  0.00           O  
ATOM    638  CB  ILE A  39      13.004 105.271  12.399  0.00  0.00           C  
ATOM    639  CG1 ILE A  39      12.179 105.047  11.122  0.00  0.00           C  
ATOM    640  CG2 ILE A  39      13.819 106.566  12.281  0.00  0.00           C  
ATOM    641  CD1 ILE A  39      11.149 106.152  10.859  0.00  0.00           C  
ATOM    642  H   ILE A  39      14.771 104.082  10.812  0.00  0.00           H  
ATOM    643  HA  ILE A  39      14.473 104.402  13.676  0.00  0.00           H  
ATOM    644  HB  ILE A  39      12.304 105.417  13.224  0.00  0.00           H  
ATOM    645 HG12 ILE A  39      12.848 104.999  10.267  0.00  0.00           H  
ATOM    646 HG13 ILE A  39      11.642 104.103  11.212  0.00  0.00           H  
ATOM    647 HG21 ILE A  39      14.530 106.626  13.101  0.00  0.00           H  
ATOM    648 HG22 ILE A  39      14.330 106.609  11.325  0.00  0.00           H  
ATOM    649 HG23 ILE A  39      13.164 107.429  12.337  0.00  0.00           H  
ATOM    650 HD11 ILE A  39      10.434 106.200  11.681  0.00  0.00           H  
ATOM    651 HD12 ILE A  39      11.635 107.118  10.739  0.00  0.00           H  
ATOM    652 HD13 ILE A  39      10.622 105.931   9.934  0.00  0.00           H  
ATOM    653  N   SER A  40      13.403 101.645  12.686  0.00  0.00           N  
ATOM    654  CA  SER A  40      12.734 100.405  13.080  0.00  0.00           C  
ATOM    655  C   SER A  40      13.477  99.621  14.177  0.00  0.00           C  
ATOM    656  O   SER A  40      12.922  98.640  14.683  0.00  0.00           O  
ATOM    657  CB  SER A  40      12.556  99.515  11.844  0.00  0.00           C  
ATOM    658  OG  SER A  40      11.931 100.228  10.797  0.00  0.00           O  
ATOM    659  H   SER A  40      14.048 101.595  11.914  0.00  0.00           H  
ATOM    660  HA  SER A  40      11.741 100.643  13.460  0.00  0.00           H  
ATOM    661  HB2 SER A  40      13.532  99.160  11.505  0.00  0.00           H  
ATOM    662  HB3 SER A  40      11.942  98.652  12.107  0.00  0.00           H  
ATOM    663  HG  SER A  40      12.623 100.345  10.101  0.00  0.00           H  
ATOM    664  N   CYS A  41      14.709 100.000  14.550  0.00  0.00           N  
ATOM    665  CA  CYS A  41      15.569  99.169  15.399  0.00  0.00           C  
ATOM    666  C   CYS A  41      15.702  99.779  16.795  0.00  0.00           C  
ATOM    667  O   CYS A  41      15.995 100.967  16.931  0.00  0.00           O  
ATOM    668  CB  CYS A  41      16.953  99.024  14.754  0.00  0.00           C  
ATOM    669  SG  CYS A  41      16.837  98.321  13.082  0.00  0.00           S  
ATOM    670  H   CYS A  41      15.103 100.856  14.176  0.00  0.00           H  
ATOM    671  HA  CYS A  41      15.140  98.169  15.488  0.00  0.00           H  
ATOM    672  HB2 CYS A  41      17.419 100.003  14.698  0.00  0.00           H  
ATOM    673  HB3 CYS A  41      17.579  98.377  15.374  0.00  0.00           H  
ATOM    674  HG  CYS A  41      18.163  98.291  12.852  0.00  0.00           H  
ATOM    675  N   HIS A  42      15.556  98.950  17.832  0.00  0.00           N  
ATOM    676  CA  HIS A  42      15.606  99.368  19.231  0.00  0.00           C  
ATOM    677  C   HIS A  42      16.947 100.026  19.577  0.00  0.00           C  
ATOM    678  O   HIS A  42      16.969 101.080  20.211  0.00  0.00           O  
ATOM    679  CB  HIS A  42      15.338  98.140  20.117  0.00  0.00           C  
ATOM    680  CG  HIS A  42      15.359  98.423  21.600  0.00  0.00           C  
ATOM    681  ND1 HIS A  42      14.295  98.840  22.371  0.00  0.00           N  
ATOM    682  CD2 HIS A  42      16.431  98.270  22.441  0.00  0.00           C  
ATOM    683  CE1 HIS A  42      14.716  98.935  23.645  0.00  0.00           C  
ATOM    684  NE2 HIS A  42      16.018  98.598  23.741  0.00  0.00           N  
ATOM    685  H   HIS A  42      15.329  97.980  17.648  0.00  0.00           H  
ATOM    686  HA  HIS A  42      14.811 100.096  19.402  0.00  0.00           H  
ATOM    687  HB2 HIS A  42      14.361  97.728  19.860  0.00  0.00           H  
ATOM    688  HB3 HIS A  42      16.087  97.375  19.902  0.00  0.00           H  
ATOM    689  HD1 HIS A  42      13.348  99.024  22.051  0.00  0.00           H  
ATOM    690  HD2 HIS A  42      17.419  97.937  22.150  0.00  0.00           H  
ATOM    691  HE1 HIS A  42      14.088  99.232  24.477  0.00  0.00           H  
ATOM    692  N   LEU A  43      18.072  99.444  19.140  0.00  0.00           N  
ATOM    693  CA  LEU A  43      19.388 100.010  19.445  0.00  0.00           C  
ATOM    694  C   LEU A  43      19.613 101.327  18.704  0.00  0.00           C  
ATOM    695  O   LEU A  43      20.292 102.197  19.238  0.00  0.00           O  
ATOM    696  CB  LEU A  43      20.525  99.019  19.146  0.00  0.00           C  
ATOM    697  CG  LEU A  43      20.625  97.826  20.118  0.00  0.00           C  
ATOM    698  CD1 LEU A  43      21.789  96.929  19.684  0.00  0.00           C  
ATOM    699  CD2 LEU A  43      20.844  98.259  21.576  0.00  0.00           C  
ATOM    700  H   LEU A  43      18.014  98.578  18.619  0.00  0.00           H  
ATOM    701  HA  LEU A  43      19.413 100.257  20.507  0.00  0.00           H  
ATOM    702  HB2 LEU A  43      20.405  98.645  18.128  0.00  0.00           H  
ATOM    703  HB3 LEU A  43      21.471  99.564  19.191  0.00  0.00           H  
ATOM    704  HG  LEU A  43      19.705  97.245  20.065  0.00  0.00           H  
ATOM    705 HD11 LEU A  43      21.636  96.589  18.659  0.00  0.00           H  
ATOM    706 HD12 LEU A  43      22.727  97.480  19.742  0.00  0.00           H  
ATOM    707 HD13 LEU A  43      21.850  96.055  20.333  0.00  0.00           H  
ATOM    708 HD21 LEU A  43      21.701  98.931  21.646  0.00  0.00           H  
ATOM    709 HD22 LEU A  43      19.958  98.761  21.963  0.00  0.00           H  
ATOM    710 HD23 LEU A  43      21.028  97.385  22.201  0.00  0.00           H  
ATOM    711  N   CYS A  44      19.016 101.525  17.522  0.00  0.00           N  
ATOM    712  CA  CYS A  44      19.055 102.829  16.859  0.00  0.00           C  
ATOM    713  C   CYS A  44      18.330 103.878  17.708  0.00  0.00           C  
ATOM    714  O   CYS A  44      18.828 104.994  17.827  0.00  0.00           O  
ATOM    715  CB  CYS A  44      18.446 102.762  15.454  0.00  0.00           C  
ATOM    716  SG  CYS A  44      19.430 101.677  14.378  0.00  0.00           S  
ATOM    717  H   CYS A  44      18.448 100.793  17.118  0.00  0.00           H  
ATOM    718  HA  CYS A  44      20.099 103.135  16.765  0.00  0.00           H  
ATOM    719  HB2 CYS A  44      17.417 102.403  15.507  0.00  0.00           H  
ATOM    720  HB3 CYS A  44      18.425 103.766  15.023  0.00  0.00           H  
ATOM    721  HG  CYS A  44      18.452 101.429  13.489  0.00  0.00           H  
ATOM    722  N   LYS A  45      17.204 103.540  18.352  0.00  0.00           N  
ATOM    723  CA  LYS A  45      16.513 104.482  19.242  0.00  0.00           C  
ATOM    724  C   LYS A  45      17.360 104.855  20.463  0.00  0.00           C  
ATOM    725  O   LYS A  45      17.150 105.933  21.015  0.00  0.00           O  
ATOM    726  CB  LYS A  45      15.149 103.944  19.711  0.00  0.00           C  
ATOM    727  CG  LYS A  45      14.146 103.604  18.600  0.00  0.00           C  
ATOM    728  CD  LYS A  45      13.936 104.751  17.596  0.00  0.00           C  
ATOM    729  CE  LYS A  45      12.768 104.462  16.646  0.00  0.00           C  
ATOM    730  NZ  LYS A  45      11.433 104.664  17.270  0.00  0.00           N  
ATOM    731  H   LYS A  45      16.822 102.609  18.231  0.00  0.00           H  
ATOM    732  HA  LYS A  45      16.348 105.407  18.687  0.00  0.00           H  
ATOM    733  HB2 LYS A  45      15.301 103.057  20.327  0.00  0.00           H  
ATOM    734  HB3 LYS A  45      14.692 104.701  20.348  0.00  0.00           H  
ATOM    735  HG2 LYS A  45      14.484 102.720  18.062  0.00  0.00           H  
ATOM    736  HG3 LYS A  45      13.197 103.358  19.076  0.00  0.00           H  
ATOM    737  HD2 LYS A  45      13.766 105.692  18.123  0.00  0.00           H  
ATOM    738  HD3 LYS A  45      14.840 104.855  16.992  0.00  0.00           H  
ATOM    739  HE2 LYS A  45      12.856 105.120  15.778  0.00  0.00           H  
ATOM    740  HE3 LYS A  45      12.855 103.430  16.296  0.00  0.00           H  
ATOM    741  HZ1 LYS A  45      11.293 104.058  18.067  0.00  0.00           H  
ATOM    742  HZ2 LYS A  45      11.309 105.622  17.572  0.00  0.00           H  
ATOM    743  HZ3 LYS A  45      10.699 104.457  16.604  0.00  0.00           H  
ATOM    744  N   GLU A  46      18.307 104.011  20.880  0.00  0.00           N  
ATOM    745  CA  GLU A  46      19.234 104.331  21.964  0.00  0.00           C  
ATOM    746  C   GLU A  46      20.436 105.114  21.426  0.00  0.00           C  
ATOM    747  O   GLU A  46      20.925 106.028  22.094  0.00  0.00           O  
ATOM    748  CB  GLU A  46      19.701 103.045  22.664  0.00  0.00           C  
ATOM    749  CG  GLU A  46      18.576 102.317  23.416  0.00  0.00           C  
ATOM    750  CD  GLU A  46      18.024 103.145  24.592  0.00  0.00           C  
ATOM    751  OE1 GLU A  46      18.634 103.127  25.690  0.00  0.00           O  
ATOM    752  OE2 GLU A  46      16.972 103.813  24.439  0.00  0.00           O  
ATOM    753  H   GLU A  46      18.400 103.114  20.426  0.00  0.00           H  
ATOM    754  HA  GLU A  46      18.728 104.963  22.696  0.00  0.00           H  
ATOM    755  HB2 GLU A  46      20.128 102.366  21.925  0.00  0.00           H  
ATOM    756  HB3 GLU A  46      20.488 103.296  23.378  0.00  0.00           H  
ATOM    757  HG2 GLU A  46      17.770 102.071  22.723  0.00  0.00           H  
ATOM    758  HG3 GLU A  46      18.973 101.374  23.797  0.00  0.00           H  
ATOM    759  N   ALA A  47      20.899 104.803  20.210  0.00  0.00           N  
ATOM    760  CA  ALA A  47      21.961 105.550  19.551  0.00  0.00           C  
ATOM    761  C   ALA A  47      21.518 106.988  19.292  0.00  0.00           C  
ATOM    762  O   ALA A  47      22.301 107.897  19.509  0.00  0.00           O  
ATOM    763  CB  ALA A  47      22.376 104.862  18.244  0.00  0.00           C  
ATOM    764  H   ALA A  47      20.497 104.011  19.718  0.00  0.00           H  
ATOM    765  HA  ALA A  47      22.826 105.577  20.215  0.00  0.00           H  
ATOM    766  HB1 ALA A  47      22.680 103.832  18.438  0.00  0.00           H  
ATOM    767  HB2 ALA A  47      21.549 104.867  17.534  0.00  0.00           H  
ATOM    768  HB3 ALA A  47      23.216 105.399  17.803  0.00  0.00           H  
ATOM    769  N   MET A  48      20.279 107.214  18.863  0.00  0.00           N  
ATOM    770  CA  MET A  48      19.770 108.519  18.449  0.00  0.00           C  
ATOM    771  C   MET A  48      19.993 109.665  19.451  0.00  0.00           C  
ATOM    772  O   MET A  48      20.600 110.666  19.062  0.00  0.00           O  
ATOM    773  CB  MET A  48      18.297 108.372  18.061  0.00  0.00           C  
ATOM    774  CG  MET A  48      18.151 107.893  16.615  0.00  0.00           C  
ATOM    775  SD  MET A  48      18.591 109.159  15.402  0.00  0.00           S  
ATOM    776  CE  MET A  48      20.190 108.562  14.787  0.00  0.00           C  
ATOM    777  H   MET A  48      19.686 106.409  18.687  0.00  0.00           H  
ATOM    778  HA  MET A  48      20.328 108.806  17.561  0.00  0.00           H  
ATOM    779  HB2 MET A  48      17.796 107.672  18.728  0.00  0.00           H  
ATOM    780  HB3 MET A  48      17.809 109.338  18.155  0.00  0.00           H  
ATOM    781  HG2 MET A  48      18.763 107.009  16.446  0.00  0.00           H  
ATOM    782  HG3 MET A  48      17.111 107.615  16.451  0.00  0.00           H  
ATOM    783  HE1 MET A  48      20.965 108.718  15.536  0.00  0.00           H  
ATOM    784  HE2 MET A  48      20.124 107.501  14.547  0.00  0.00           H  
ATOM    785  HE3 MET A  48      20.448 109.116  13.884  0.00  0.00           H  
ATOM    786  N   PRO A  49      19.580 109.578  20.729  0.00  0.00           N  
ATOM    787  CA  PRO A  49      19.856 110.640  21.686  0.00  0.00           C  
ATOM    788  C   PRO A  49      21.359 110.765  21.952  0.00  0.00           C  
ATOM    789  O   PRO A  49      21.849 111.881  22.147  0.00  0.00           O  
ATOM    790  CB  PRO A  49      19.060 110.289  22.947  0.00  0.00           C  
ATOM    791  CG  PRO A  49      18.853 108.779  22.844  0.00  0.00           C  
ATOM    792  CD  PRO A  49      18.761 108.547  21.338  0.00  0.00           C  
ATOM    793  HA  PRO A  49      19.492 111.589  21.291  0.00  0.00           H  
ATOM    794  HB2 PRO A  49      19.590 110.562  23.861  0.00  0.00           H  
ATOM    795  HB3 PRO A  49      18.091 110.788  22.910  0.00  0.00           H  
ATOM    796  HG2 PRO A  49      19.726 108.262  23.242  0.00  0.00           H  
ATOM    797  HG3 PRO A  49      17.948 108.455  23.357  0.00  0.00           H  
ATOM    798  HD2 PRO A  49      19.117 107.552  21.093  0.00  0.00           H  
ATOM    799  HD3 PRO A  49      17.728 108.672  21.009  0.00  0.00           H  
ATOM    800  N   GLN A  50      22.102 109.652  21.919  0.00  0.00           N  
ATOM    801  CA  GLN A  50      23.547 109.667  22.105  0.00  0.00           C  
ATOM    802  C   GLN A  50      24.249 110.349  20.923  0.00  0.00           C  
ATOM    803  O   GLN A  50      25.210 111.077  21.142  0.00  0.00           O  
ATOM    804  CB  GLN A  50      24.072 108.249  22.386  0.00  0.00           C  
ATOM    805  CG  GLN A  50      23.604 107.778  23.776  0.00  0.00           C  
ATOM    806  CD  GLN A  50      24.120 106.388  24.149  0.00  0.00           C  
ATOM    807  OE1 GLN A  50      23.356 105.454  24.373  0.00  0.00           O  
ATOM    808  NE2 GLN A  50      25.432 106.207  24.227  0.00  0.00           N  
ATOM    809  H   GLN A  50      21.660 108.766  21.709  0.00  0.00           H  
ATOM    810  HA  GLN A  50      23.756 110.261  22.991  0.00  0.00           H  
ATOM    811  HB2 GLN A  50      23.728 107.551  21.623  0.00  0.00           H  
ATOM    812  HB3 GLN A  50      25.162 108.272  22.364  0.00  0.00           H  
ATOM    813  HG2 GLN A  50      23.957 108.487  24.527  0.00  0.00           H  
ATOM    814  HG3 GLN A  50      22.514 107.768  23.810  0.00  0.00           H  
ATOM    815 HE21 GLN A  50      26.063 106.991  24.103  0.00  0.00           H  
ATOM    816 HE22 GLN A  50      25.787 105.315  24.544  0.00  0.00           H  
ATOM    817  N   VAL A  51      23.752 110.198  19.692  0.00  0.00           N  
ATOM    818  CA  VAL A  51      24.216 110.917  18.506  0.00  0.00           C  
ATOM    819  C   VAL A  51      24.026 112.421  18.716  0.00  0.00           C  
ATOM    820  O   VAL A  51      24.913 113.184  18.346  0.00  0.00           O  
ATOM    821  CB  VAL A  51      23.493 110.381  17.245  0.00  0.00           C  
ATOM    822  CG1 VAL A  51      23.702 111.251  16.000  0.00  0.00           C  
ATOM    823  CG2 VAL A  51      23.961 108.965  16.872  0.00  0.00           C  
ATOM    824  H   VAL A  51      22.978 109.554  19.566  0.00  0.00           H  
ATOM    825  HA  VAL A  51      25.283 110.737  18.383  0.00  0.00           H  
ATOM    826  HB  VAL A  51      22.426 110.340  17.435  0.00  0.00           H  
ATOM    827 HG11 VAL A  51      23.280 112.245  16.150  0.00  0.00           H  
ATOM    828 HG12 VAL A  51      24.766 111.344  15.774  0.00  0.00           H  
ATOM    829 HG13 VAL A  51      23.197 110.783  15.157  0.00  0.00           H  
ATOM    830 HG21 VAL A  51      24.953 109.009  16.422  0.00  0.00           H  
ATOM    831 HG22 VAL A  51      24.004 108.320  17.747  0.00  0.00           H  
ATOM    832 HG23 VAL A  51      23.275 108.524  16.150  0.00  0.00           H  
ATOM    833  N   ASN A  52      22.926 112.865  19.338  0.00  0.00           N  
ATOM    834  CA  ASN A  52      22.699 114.287  19.616  0.00  0.00           C  
ATOM    835  C   ASN A  52      23.788 114.856  20.536  0.00  0.00           C  
ATOM    836  O   ASN A  52      24.385 115.885  20.211  0.00  0.00           O  
ATOM    837  CB  ASN A  52      21.270 114.516  20.156  0.00  0.00           C  
ATOM    838  CG  ASN A  52      21.204 115.302  21.467  0.00  0.00           C  
ATOM    839  OD1 ASN A  52      21.269 116.527  21.483  0.00  0.00           O  
ATOM    840  ND2 ASN A  52      21.092 114.617  22.595  0.00  0.00           N  
ATOM    841  H   ASN A  52      22.212 112.199  19.607  0.00  0.00           H  
ATOM    842  HA  ASN A  52      22.776 114.821  18.668  0.00  0.00           H  
ATOM    843  HB2 ASN A  52      20.715 115.076  19.402  0.00  0.00           H  
ATOM    844  HB3 ASN A  52      20.749 113.567  20.278  0.00  0.00           H  
ATOM    845 HD21 ASN A  52      21.129 113.599  22.576  0.00  0.00           H  
ATOM    846 HD22 ASN A  52      21.038 115.099  23.484  0.00  0.00           H  
ATOM    847  N   GLU A  53      24.088 114.201  21.661  0.00  0.00           N  
ATOM    848  CA  GLU A  53      25.089 114.734  22.588  0.00  0.00           C  
ATOM    849  C   GLU A  53      26.501 114.546  22.023  0.00  0.00           C  
ATOM    850  O   GLU A  53      27.354 115.411  22.204  0.00  0.00           O  
ATOM    851  CB  GLU A  53      24.926 114.162  24.009  0.00  0.00           C  
ATOM    852  CG  GLU A  53      25.084 112.639  24.111  0.00  0.00           C  
ATOM    853  CD  GLU A  53      25.066 112.151  25.575  0.00  0.00           C  
ATOM    854  OE1 GLU A  53      26.097 112.318  26.275  0.00  0.00           O  
ATOM    855  OE2 GLU A  53      24.051 111.560  26.016  0.00  0.00           O  
ATOM    856  H   GLU A  53      23.586 113.354  21.906  0.00  0.00           H  
ATOM    857  HA  GLU A  53      24.920 115.809  22.674  0.00  0.00           H  
ATOM    858  HB2 GLU A  53      25.663 114.638  24.658  0.00  0.00           H  
ATOM    859  HB3 GLU A  53      23.933 114.427  24.381  0.00  0.00           H  
ATOM    860  HG2 GLU A  53      24.266 112.179  23.559  0.00  0.00           H  
ATOM    861  HG3 GLU A  53      26.029 112.333  23.657  0.00  0.00           H  
ATOM    862  N   PHE A  54      26.748 113.457  21.289  0.00  0.00           N  
ATOM    863  CA  PHE A  54      28.010 113.205  20.604  0.00  0.00           C  
ATOM    864  C   PHE A  54      28.279 114.302  19.577  0.00  0.00           C  
ATOM    865  O   PHE A  54      29.363 114.886  19.574  0.00  0.00           O  
ATOM    866  CB  PHE A  54      27.960 111.822  19.942  0.00  0.00           C  
ATOM    867  CG  PHE A  54      29.162 111.516  19.079  0.00  0.00           C  
ATOM    868  CD1 PHE A  54      29.163 111.892  17.722  0.00  0.00           C  
ATOM    869  CD2 PHE A  54      30.293 110.897  19.642  0.00  0.00           C  
ATOM    870  CE1 PHE A  54      30.306 111.681  16.938  0.00  0.00           C  
ATOM    871  CE2 PHE A  54      31.431 110.674  18.851  0.00  0.00           C  
ATOM    872  CZ  PHE A  54      31.438 111.072  17.501  0.00  0.00           C  
ATOM    873  H   PHE A  54      26.017 112.759  21.188  0.00  0.00           H  
ATOM    874  HA  PHE A  54      28.820 113.211  21.332  0.00  0.00           H  
ATOM    875  HB2 PHE A  54      27.878 111.059  20.717  0.00  0.00           H  
ATOM    876  HB3 PHE A  54      27.072 111.757  19.316  0.00  0.00           H  
ATOM    877  HD1 PHE A  54      28.294 112.364  17.281  0.00  0.00           H  
ATOM    878  HD2 PHE A  54      30.298 110.608  20.684  0.00  0.00           H  
ATOM    879  HE1 PHE A  54      30.316 111.981  15.902  0.00  0.00           H  
ATOM    880  HE2 PHE A  54      32.302 110.211  19.289  0.00  0.00           H  
ATOM    881  HZ  PHE A  54      32.311 110.912  16.885  0.00  0.00           H  
ATOM    882  N   ARG A  55      27.289 114.624  18.737  0.00  0.00           N  
ATOM    883  CA  ARG A  55      27.393 115.697  17.758  0.00  0.00           C  
ATOM    884  C   ARG A  55      27.818 116.964  18.480  0.00  0.00           C  
ATOM    885  O   ARG A  55      28.805 117.557  18.070  0.00  0.00           O  
ATOM    886  CB  ARG A  55      26.068 115.834  16.976  0.00  0.00           C  
ATOM    887  CG  ARG A  55      25.924 117.131  16.145  0.00  0.00           C  
ATOM    888  CD  ARG A  55      24.607 117.889  16.394  0.00  0.00           C  
ATOM    889  NE  ARG A  55      24.330 118.130  17.827  0.00  0.00           N  
ATOM    890  CZ  ARG A  55      23.128 118.407  18.354  0.00  0.00           C  
ATOM    891  NH1 ARG A  55      22.123 118.839  17.614  0.00  0.00           N  
ATOM    892  NH2 ARG A  55      22.904 118.233  19.648  0.00  0.00           N  
ATOM    893  H   ARG A  55      26.418 114.104  18.781  0.00  0.00           H  
ATOM    894  HA  ARG A  55      28.189 115.445  17.056  0.00  0.00           H  
ATOM    895  HB2 ARG A  55      25.980 114.983  16.299  0.00  0.00           H  
ATOM    896  HB3 ARG A  55      25.238 115.752  17.676  0.00  0.00           H  
ATOM    897  HG2 ARG A  55      26.750 117.816  16.329  0.00  0.00           H  
ATOM    898  HG3 ARG A  55      25.972 116.872  15.085  0.00  0.00           H  
ATOM    899  HD2 ARG A  55      24.660 118.846  15.876  0.00  0.00           H  
ATOM    900  HD3 ARG A  55      23.790 117.305  15.970  0.00  0.00           H  
ATOM    901  HE  ARG A  55      25.096 117.950  18.461  0.00  0.00           H  
ATOM    902 HH11 ARG A  55      22.222 118.981  16.611  0.00  0.00           H  
ATOM    903 HH12 ARG A  55      21.184 118.859  18.023  0.00  0.00           H  
ATOM    904 HH21 ARG A  55      23.562 117.707  20.218  0.00  0.00           H  
ATOM    905 HH22 ARG A  55      21.960 118.348  20.017  0.00  0.00           H  
ATOM    906  N   ASP A  56      27.133 117.356  19.557  0.00  0.00           N  
ATOM    907  CA  ASP A  56      27.468 118.596  20.264  0.00  0.00           C  
ATOM    908  C   ASP A  56      28.906 118.569  20.795  0.00  0.00           C  
ATOM    909  O   ASP A  56      29.674 119.505  20.548  0.00  0.00           O  
ATOM    910  CB  ASP A  56      26.488 118.854  21.412  0.00  0.00           C  
ATOM    911  CG  ASP A  56      26.878 120.136  22.168  0.00  0.00           C  
ATOM    912  OD1 ASP A  56      26.657 121.246  21.628  0.00  0.00           O  
ATOM    913  OD2 ASP A  56      27.391 120.041  23.309  0.00  0.00           O  
ATOM    914  H   ASP A  56      26.404 116.758  19.931  0.00  0.00           H  
ATOM    915  HA  ASP A  56      27.383 119.427  19.563  0.00  0.00           H  
ATOM    916  HB2 ASP A  56      25.480 118.961  21.007  0.00  0.00           H  
ATOM    917  HB3 ASP A  56      26.490 118.004  22.096  0.00  0.00           H  
ATOM    918  N   LYS A  57      29.289 117.476  21.467  0.00  0.00           N  
ATOM    919  CA  LYS A  57      30.608 117.321  22.081  0.00  0.00           C  
ATOM    920  C   LYS A  57      31.742 117.352  21.053  0.00  0.00           C  
ATOM    921  O   LYS A  57      32.829 117.832  21.391  0.00  0.00           O  
ATOM    922  CB  LYS A  57      30.663 116.012  22.893  0.00  0.00           C  
ATOM    923  CG  LYS A  57      29.932 116.122  24.243  0.00  0.00           C  
ATOM    924  CD  LYS A  57      29.939 114.813  25.054  0.00  0.00           C  
ATOM    925  CE  LYS A  57      29.039 113.738  24.424  0.00  0.00           C  
ATOM    926  NZ  LYS A  57      28.904 112.524  25.271  0.00  0.00           N  
ATOM    927  H   LYS A  57      28.610 116.734  21.612  0.00  0.00           H  
ATOM    928  HA  LYS A  57      30.766 118.161  22.760  0.00  0.00           H  
ATOM    929  HB2 LYS A  57      30.241 115.203  22.297  0.00  0.00           H  
ATOM    930  HB3 LYS A  57      31.708 115.772  23.098  0.00  0.00           H  
ATOM    931  HG2 LYS A  57      30.427 116.891  24.837  0.00  0.00           H  
ATOM    932  HG3 LYS A  57      28.900 116.438  24.085  0.00  0.00           H  
ATOM    933  HD2 LYS A  57      30.961 114.441  25.141  0.00  0.00           H  
ATOM    934  HD3 LYS A  57      29.570 115.039  26.057  0.00  0.00           H  
ATOM    935  HE2 LYS A  57      28.048 114.178  24.276  0.00  0.00           H  
ATOM    936  HE3 LYS A  57      29.437 113.462  23.447  0.00  0.00           H  
ATOM    937  HZ1 LYS A  57      29.768 111.989  25.354  0.00  0.00           H  
ATOM    938  HZ2 LYS A  57      28.569 112.755  26.199  0.00  0.00           H  
ATOM    939  HZ3 LYS A  57      28.223 111.887  24.880  0.00  0.00           H  
ATOM    940  N   TYR A  58      31.522 116.867  19.825  0.00  0.00           N  
ATOM    941  CA  TYR A  58      32.616 116.565  18.904  0.00  0.00           C  
ATOM    942  C   TYR A  58      32.541 117.312  17.573  0.00  0.00           C  
ATOM    943  O   TYR A  58      33.526 117.245  16.843  0.00  0.00           O  
ATOM    944  CB  TYR A  58      32.755 115.040  18.728  0.00  0.00           C  
ATOM    945  CG  TYR A  58      33.138 114.332  20.019  0.00  0.00           C  
ATOM    946  CD1 TYR A  58      34.442 114.463  20.537  0.00  0.00           C  
ATOM    947  CD2 TYR A  58      32.176 113.605  20.743  0.00  0.00           C  
ATOM    948  CE1 TYR A  58      34.765 113.912  21.791  0.00  0.00           C  
ATOM    949  CE2 TYR A  58      32.483 113.068  22.004  0.00  0.00           C  
ATOM    950  CZ  TYR A  58      33.777 113.238  22.544  0.00  0.00           C  
ATOM    951  OH  TYR A  58      34.076 112.776  23.794  0.00  0.00           O  
ATOM    952  H   TYR A  58      30.617 116.456  19.623  0.00  0.00           H  
ATOM    953  HA  TYR A  58      33.550 116.897  19.353  0.00  0.00           H  
ATOM    954  HB2 TYR A  58      31.822 114.632  18.338  0.00  0.00           H  
ATOM    955  HB3 TYR A  58      33.533 114.836  17.990  0.00  0.00           H  
ATOM    956  HD1 TYR A  58      35.192 115.011  19.987  0.00  0.00           H  
ATOM    957  HD2 TYR A  58      31.185 113.477  20.339  0.00  0.00           H  
ATOM    958  HE1 TYR A  58      35.762 114.034  22.191  0.00  0.00           H  
ATOM    959  HE2 TYR A  58      31.720 112.539  22.558  0.00  0.00           H  
ATOM    960  HH  TYR A  58      33.309 112.420  24.278  0.00  0.00           H  
ATOM    961  N   GLN A  59      31.484 118.076  17.256  0.00  0.00           N  
ATOM    962  CA  GLN A  59      31.385 118.780  15.968  0.00  0.00           C  
ATOM    963  C   GLN A  59      32.574 119.713  15.674  0.00  0.00           C  
ATOM    964  O   GLN A  59      32.915 119.925  14.509  0.00  0.00           O  
ATOM    965  CB  GLN A  59      30.029 119.503  15.782  0.00  0.00           C  
ATOM    966  CG  GLN A  59      29.494 120.442  16.887  0.00  0.00           C  
ATOM    967  CD  GLN A  59      30.446 121.539  17.354  0.00  0.00           C  
ATOM    968  OE1 GLN A  59      30.854 122.404  16.580  0.00  0.00           O  
ATOM    969  NE2 GLN A  59      30.811 121.534  18.630  0.00  0.00           N  
ATOM    970  H   GLN A  59      30.658 118.054  17.848  0.00  0.00           H  
ATOM    971  HA  GLN A  59      31.420 118.006  15.199  0.00  0.00           H  
ATOM    972  HB2 GLN A  59      30.084 120.076  14.855  0.00  0.00           H  
ATOM    973  HB3 GLN A  59      29.271 118.736  15.620  0.00  0.00           H  
ATOM    974  HG2 GLN A  59      28.587 120.919  16.511  0.00  0.00           H  
ATOM    975  HG3 GLN A  59      29.194 119.862  17.752  0.00  0.00           H  
ATOM    976 HE21 GLN A  59      30.430 120.836  19.272  0.00  0.00           H  
ATOM    977 HE22 GLN A  59      31.411 122.264  18.992  0.00  0.00           H  
ATOM    978  N   ASP A  60      33.232 120.246  16.710  0.00  0.00           N  
ATOM    979  CA  ASP A  60      34.373 121.157  16.565  0.00  0.00           C  
ATOM    980  C   ASP A  60      35.682 120.403  16.273  0.00  0.00           C  
ATOM    981  O   ASP A  60      36.689 121.010  15.906  0.00  0.00           O  
ATOM    982  CB  ASP A  60      34.513 121.992  17.844  0.00  0.00           C  
ATOM    983  CG  ASP A  60      35.619 123.055  17.731  0.00  0.00           C  
ATOM    984  OD1 ASP A  60      35.497 123.976  16.885  0.00  0.00           O  
ATOM    985  OD2 ASP A  60      36.588 123.012  18.529  0.00  0.00           O  
ATOM    986  H   ASP A  60      32.899 120.057  17.646  0.00  0.00           H  
ATOM    987  HA  ASP A  60      34.175 121.839  15.737  0.00  0.00           H  
ATOM    988  HB2 ASP A  60      33.566 122.498  18.043  0.00  0.00           H  
ATOM    989  HB3 ASP A  60      34.719 121.327  18.685  0.00  0.00           H  
ATOM    990  N   GLN A  61      35.671 119.073  16.417  0.00  0.00           N  
ATOM    991  CA  GLN A  61      36.861 118.226  16.488  0.00  0.00           C  
ATOM    992  C   GLN A  61      36.803 117.088  15.461  0.00  0.00           C  
ATOM    993  O   GLN A  61      37.846 116.589  15.044  0.00  0.00           O  
ATOM    994  CB  GLN A  61      36.978 117.638  17.909  0.00  0.00           C  
ATOM    995  CG  GLN A  61      36.996 118.696  19.027  0.00  0.00           C  
ATOM    996  CD  GLN A  61      37.259 118.060  20.394  0.00  0.00           C  
ATOM    997  OE1 GLN A  61      38.402 117.772  20.751  0.00  0.00           O  
ATOM    998  NE2 GLN A  61      36.229 117.821  21.197  0.00  0.00           N  
ATOM    999  H   GLN A  61      34.788 118.628  16.640  0.00  0.00           H  
ATOM   1000  HA  GLN A  61      37.752 118.821  16.286  0.00  0.00           H  
ATOM   1001  HB2 GLN A  61      36.143 116.957  18.087  0.00  0.00           H  
ATOM   1002  HB3 GLN A  61      37.900 117.061  17.965  0.00  0.00           H  
ATOM   1003  HG2 GLN A  61      37.782 119.423  18.817  0.00  0.00           H  
ATOM   1004  HG3 GLN A  61      36.044 119.224  19.051  0.00  0.00           H  
ATOM   1005 HE21 GLN A  61      35.284 118.070  20.929  0.00  0.00           H  
ATOM   1006 HE22 GLN A  61      36.383 117.401  22.105  0.00  0.00           H  
ATOM   1007  N   LEU A  62      35.603 116.689  15.037  0.00  0.00           N  
ATOM   1008  CA  LEU A  62      35.332 115.573  14.144  0.00  0.00           C  
ATOM   1009  C   LEU A  62      34.031 115.893  13.404  0.00  0.00           C  
ATOM   1010  O   LEU A  62      33.116 116.499  13.961  0.00  0.00           O  
ATOM   1011  CB  LEU A  62      35.266 114.278  14.981  0.00  0.00           C  
ATOM   1012  CG  LEU A  62      34.477 113.113  14.345  0.00  0.00           C  
ATOM   1013  CD1 LEU A  62      35.121 111.758  14.647  0.00  0.00           C  
ATOM   1014  CD2 LEU A  62      33.043 113.095  14.889  0.00  0.00           C  
ATOM   1015  H   LEU A  62      34.774 117.118  15.438  0.00  0.00           H  
ATOM   1016  HA  LEU A  62      36.142 115.485  13.420  0.00  0.00           H  
ATOM   1017  HB2 LEU A  62      36.292 113.960  15.165  0.00  0.00           H  
ATOM   1018  HB3 LEU A  62      34.833 114.500  15.957  0.00  0.00           H  
ATOM   1019  HG  LEU A  62      34.467 113.217  13.265  0.00  0.00           H  
ATOM   1020 HD11 LEU A  62      36.134 111.729  14.245  0.00  0.00           H  
ATOM   1021 HD12 LEU A  62      35.152 111.599  15.719  0.00  0.00           H  
ATOM   1022 HD13 LEU A  62      34.542 110.956  14.188  0.00  0.00           H  
ATOM   1023 HD21 LEU A  62      33.047 112.954  15.969  0.00  0.00           H  
ATOM   1024 HD22 LEU A  62      32.547 114.038  14.671  0.00  0.00           H  
ATOM   1025 HD23 LEU A  62      32.480 112.294  14.417  0.00  0.00           H  
ATOM   1026  N   ASN A  63      33.964 115.524  12.127  0.00  0.00           N  
ATOM   1027  CA  ASN A  63      32.769 115.666  11.305  0.00  0.00           C  
ATOM   1028  C   ASN A  63      31.786 114.560  11.668  0.00  0.00           C  
ATOM   1029  O   ASN A  63      32.211 113.439  11.946  0.00  0.00           O  
ATOM   1030  CB  ASN A  63      33.118 115.496   9.823  0.00  0.00           C  
ATOM   1031  CG  ASN A  63      34.231 116.415   9.342  0.00  0.00           C  
ATOM   1032  OD1 ASN A  63      34.144 117.636   9.456  0.00  0.00           O  
ATOM   1033  ND2 ASN A  63      35.297 115.846   8.810  0.00  0.00           N  
ATOM   1034  H   ASN A  63      34.740 114.996  11.738  0.00  0.00           H  
ATOM   1035  HA  ASN A  63      32.323 116.649  11.470  0.00  0.00           H  
ATOM   1036  HB2 ASN A  63      33.396 114.458   9.641  0.00  0.00           H  
ATOM   1037  HB3 ASN A  63      32.223 115.697   9.233  0.00  0.00           H  
ATOM   1038 HD21 ASN A  63      35.384 114.829   8.793  0.00  0.00           H  
ATOM   1039 HD22 ASN A  63      36.003 116.409   8.355  0.00  0.00           H  
ATOM   1040  N   VAL A  64      30.486 114.808  11.540  0.00  0.00           N  
ATOM   1041  CA  VAL A  64      29.462 113.781  11.718  0.00  0.00           C  
ATOM   1042  C   VAL A  64      28.615 113.783  10.447  0.00  0.00           C  
ATOM   1043  O   VAL A  64      28.341 114.843   9.879  0.00  0.00           O  
ATOM   1044  CB  VAL A  64      28.632 114.039  12.998  0.00  0.00           C  
ATOM   1045  CG1 VAL A  64      27.834 112.786  13.396  0.00  0.00           C  
ATOM   1046  CG2 VAL A  64      29.488 114.438  14.210  0.00  0.00           C  
ATOM   1047  H   VAL A  64      30.170 115.718  11.229  0.00  0.00           H  
ATOM   1048  HA  VAL A  64      29.938 112.803  11.814  0.00  0.00           H  
ATOM   1049  HB  VAL A  64      27.934 114.853  12.805  0.00  0.00           H  
ATOM   1050 HG11 VAL A  64      27.208 112.448  12.572  0.00  0.00           H  
ATOM   1051 HG12 VAL A  64      28.513 111.978  13.669  0.00  0.00           H  
ATOM   1052 HG13 VAL A  64      27.187 113.009  14.247  0.00  0.00           H  
ATOM   1053 HG21 VAL A  64      30.268 113.696  14.368  0.00  0.00           H  
ATOM   1054 HG22 VAL A  64      29.946 115.415  14.052  0.00  0.00           H  
ATOM   1055 HG23 VAL A  64      28.867 114.498  15.104  0.00  0.00           H  
ATOM   1056  N   VAL A  65      28.200 112.603   9.999  0.00  0.00           N  
ATOM   1057  CA  VAL A  65      27.254 112.401   8.912  0.00  0.00           C  
ATOM   1058  C   VAL A  65      26.574 111.053   9.181  0.00  0.00           C  
ATOM   1059  O   VAL A  65      27.128 110.212   9.900  0.00  0.00           O  
ATOM   1060  CB  VAL A  65      27.986 112.507   7.548  0.00  0.00           C  
ATOM   1061  CG1 VAL A  65      29.211 111.585   7.438  0.00  0.00           C  
ATOM   1062  CG2 VAL A  65      27.076 112.254   6.338  0.00  0.00           C  
ATOM   1063  H   VAL A  65      28.519 111.751  10.452  0.00  0.00           H  
ATOM   1064  HA  VAL A  65      26.502 113.188   8.962  0.00  0.00           H  
ATOM   1065  HB  VAL A  65      28.350 113.530   7.453  0.00  0.00           H  
ATOM   1066 HG11 VAL A  65      29.958 111.853   8.186  0.00  0.00           H  
ATOM   1067 HG12 VAL A  65      28.908 110.551   7.590  0.00  0.00           H  
ATOM   1068 HG13 VAL A  65      29.669 111.686   6.454  0.00  0.00           H  
ATOM   1069 HG21 VAL A  65      26.773 111.207   6.292  0.00  0.00           H  
ATOM   1070 HG22 VAL A  65      26.190 112.886   6.397  0.00  0.00           H  
ATOM   1071 HG23 VAL A  65      27.610 112.500   5.419  0.00  0.00           H  
ATOM   1072  N   ALA A  66      25.381 110.830   8.631  0.00  0.00           N  
ATOM   1073  CA  ALA A  66      24.650 109.583   8.812  0.00  0.00           C  
ATOM   1074  C   ALA A  66      24.019 109.125   7.503  0.00  0.00           C  
ATOM   1075  O   ALA A  66      23.834 109.918   6.577  0.00  0.00           O  
ATOM   1076  CB  ALA A  66      23.581 109.761   9.893  0.00  0.00           C  
ATOM   1077  H   ALA A  66      24.956 111.541   8.045  0.00  0.00           H  
ATOM   1078  HA  ALA A  66      25.346 108.815   9.144  0.00  0.00           H  
ATOM   1079  HB1 ALA A  66      23.984 110.347  10.716  0.00  0.00           H  
ATOM   1080  HB2 ALA A  66      22.716 110.275   9.488  0.00  0.00           H  
ATOM   1081  HB3 ALA A  66      23.273 108.783  10.265  0.00  0.00           H  
ATOM   1082  N   VAL A  67      23.633 107.854   7.455  0.00  0.00           N  
ATOM   1083  CA  VAL A  67      23.012 107.230   6.299  0.00  0.00           C  
ATOM   1084  C   VAL A  67      21.863 106.398   6.850  0.00  0.00           C  
ATOM   1085  O   VAL A  67      22.078 105.538   7.708  0.00  0.00           O  
ATOM   1086  CB  VAL A  67      24.040 106.373   5.529  0.00  0.00           C  
ATOM   1087  CG1 VAL A  67      23.450 105.865   4.207  0.00  0.00           C  
ATOM   1088  CG2 VAL A  67      25.344 107.143   5.255  0.00  0.00           C  
ATOM   1089  H   VAL A  67      23.829 107.250   8.247  0.00  0.00           H  
ATOM   1090  HA  VAL A  67      22.626 107.998   5.630  0.00  0.00           H  
ATOM   1091  HB  VAL A  67      24.287 105.503   6.132  0.00  0.00           H  
ATOM   1092 HG11 VAL A  67      22.585 105.232   4.406  0.00  0.00           H  
ATOM   1093 HG12 VAL A  67      23.143 106.703   3.583  0.00  0.00           H  
ATOM   1094 HG13 VAL A  67      24.192 105.268   3.675  0.00  0.00           H  
ATOM   1095 HG21 VAL A  67      25.115 108.123   4.844  0.00  0.00           H  
ATOM   1096 HG22 VAL A  67      25.906 107.270   6.180  0.00  0.00           H  
ATOM   1097 HG23 VAL A  67      25.969 106.597   4.553  0.00  0.00           H  
ATOM   1098  N   HIS A  68      20.634 106.675   6.418  0.00  0.00           N  
ATOM   1099  CA  HIS A  68      19.513 105.840   6.813  0.00  0.00           C  
ATOM   1100  C   HIS A  68      19.509 104.600   5.922  0.00  0.00           C  
ATOM   1101  O   HIS A  68      19.622 104.722   4.698  0.00  0.00           O  
ATOM   1102  CB  HIS A  68      18.190 106.606   6.718  0.00  0.00           C  
ATOM   1103  CG  HIS A  68      17.255 106.189   7.816  0.00  0.00           C  
ATOM   1104  ND1 HIS A  68      17.357 106.599   9.119  0.00  0.00           N  
ATOM   1105  CD2 HIS A  68      16.215 105.296   7.752  0.00  0.00           C  
ATOM   1106  CE1 HIS A  68      16.412 105.976   9.827  0.00  0.00           C  
ATOM   1107  NE2 HIS A  68      15.668 105.180   9.038  0.00  0.00           N  
ATOM   1108  H   HIS A  68      20.497 107.367   5.687  0.00  0.00           H  
ATOM   1109  HA  HIS A  68      19.658 105.542   7.852  0.00  0.00           H  
ATOM   1110  HB2 HIS A  68      18.378 107.675   6.834  0.00  0.00           H  
ATOM   1111  HB3 HIS A  68      17.724 106.437   5.748  0.00  0.00           H  
ATOM   1112  HD1 HIS A  68      18.043 107.238   9.501  0.00  0.00           H  
ATOM   1113  HD2 HIS A  68      15.886 104.766   6.868  0.00  0.00           H  
ATOM   1114  HE1 HIS A  68      16.299 106.082  10.896  0.00  0.00           H  
ATOM   1115  N   MET A  69      19.359 103.420   6.521  0.00  0.00           N  
ATOM   1116  CA  MET A  69      19.128 102.180   5.796  0.00  0.00           C  
ATOM   1117  C   MET A  69      17.610 101.962   5.770  0.00  0.00           C  
ATOM   1118  O   MET A  69      17.039 101.689   6.833  0.00  0.00           O  
ATOM   1119  CB  MET A  69      19.859 101.011   6.485  0.00  0.00           C  
ATOM   1120  CG  MET A  69      19.620  99.693   5.738  0.00  0.00           C  
ATOM   1121  SD  MET A  69      20.349  98.227   6.518  0.00  0.00           S  
ATOM   1122  CE  MET A  69      19.886  96.992   5.271  0.00  0.00           C  
ATOM   1123  H   MET A  69      19.249 103.394   7.531  0.00  0.00           H  
ATOM   1124  HA  MET A  69      19.526 102.264   4.787  0.00  0.00           H  
ATOM   1125  HB2 MET A  69      20.930 101.218   6.503  0.00  0.00           H  
ATOM   1126  HB3 MET A  69      19.511 100.909   7.513  0.00  0.00           H  
ATOM   1127  HG2 MET A  69      18.548  99.519   5.655  0.00  0.00           H  
ATOM   1128  HG3 MET A  69      20.024  99.789   4.729  0.00  0.00           H  
ATOM   1129  HE1 MET A  69      18.800  96.937   5.191  0.00  0.00           H  
ATOM   1130  HE2 MET A  69      20.302  97.272   4.303  0.00  0.00           H  
ATOM   1131  HE3 MET A  69      20.276  96.015   5.557  0.00  0.00           H  
ATOM   1132  N   PRO A  70      16.932 102.073   4.611  0.00  0.00           N  
ATOM   1133  CA  PRO A  70      15.581 101.557   4.486  0.00  0.00           C  
ATOM   1134  C   PRO A  70      15.664 100.026   4.589  0.00  0.00           C  
ATOM   1135  O   PRO A  70      16.409  99.376   3.846  0.00  0.00           O  
ATOM   1136  CB  PRO A  70      15.060 102.061   3.139  0.00  0.00           C  
ATOM   1137  CG  PRO A  70      16.328 102.207   2.302  0.00  0.00           C  
ATOM   1138  CD  PRO A  70      17.418 102.548   3.322  0.00  0.00           C  
ATOM   1139  HA  PRO A  70      14.954 101.958   5.280  0.00  0.00           H  
ATOM   1140  HB2 PRO A  70      14.351 101.366   2.687  0.00  0.00           H  
ATOM   1141  HB3 PRO A  70      14.600 103.041   3.274  0.00  0.00           H  
ATOM   1142  HG2 PRO A  70      16.553 101.249   1.838  0.00  0.00           H  
ATOM   1143  HG3 PRO A  70      16.228 102.983   1.543  0.00  0.00           H  
ATOM   1144  HD2 PRO A  70      18.348 102.055   3.038  0.00  0.00           H  
ATOM   1145  HD3 PRO A  70      17.558 103.628   3.363  0.00  0.00           H  
ATOM   1146  N   ARG A  71      14.926  99.448   5.534  0.00  0.00           N  
ATOM   1147  CA  ARG A  71      15.019  98.052   5.940  0.00  0.00           C  
ATOM   1148  C   ARG A  71      13.627  97.461   6.175  0.00  0.00           C  
ATOM   1149  O   ARG A  71      13.431  96.282   5.862  0.00  0.00           O  
ATOM   1150  CB  ARG A  71      15.879  97.971   7.218  0.00  0.00           C  
ATOM   1151  CG  ARG A  71      16.135  96.528   7.678  0.00  0.00           C  
ATOM   1152  CD  ARG A  71      16.986  96.481   8.950  0.00  0.00           C  
ATOM   1153  NE  ARG A  71      17.191  95.084   9.382  0.00  0.00           N  
ATOM   1154  CZ  ARG A  71      17.056  94.581  10.618  0.00  0.00           C  
ATOM   1155  NH1 ARG A  71      16.764  95.363  11.656  0.00  0.00           N  
ATOM   1156  NH2 ARG A  71      17.212  93.274  10.816  0.00  0.00           N  
ATOM   1157  H   ARG A  71      14.344 100.057   6.106  0.00  0.00           H  
ATOM   1158  HA  ARG A  71      15.506  97.479   5.150  0.00  0.00           H  
ATOM   1159  HB2 ARG A  71      16.842  98.450   7.030  0.00  0.00           H  
ATOM   1160  HB3 ARG A  71      15.378  98.515   8.020  0.00  0.00           H  
ATOM   1161  HG2 ARG A  71      15.186  96.036   7.887  0.00  0.00           H  
ATOM   1162  HG3 ARG A  71      16.649  95.985   6.882  0.00  0.00           H  
ATOM   1163  HD2 ARG A  71      17.955  96.937   8.745  0.00  0.00           H  
ATOM   1164  HD3 ARG A  71      16.483  97.059   9.726  0.00  0.00           H  
ATOM   1165  HE  ARG A  71      17.441  94.444   8.636  0.00  0.00           H  
ATOM   1166 HH11 ARG A  71      16.652  96.362  11.538  0.00  0.00           H  
ATOM   1167 HH12 ARG A  71      16.658  94.996  12.594  0.00  0.00           H  
ATOM   1168 HH21 ARG A  71      17.423  92.646  10.047  0.00  0.00           H  
ATOM   1169 HH22 ARG A  71      17.114  92.852  11.732  0.00  0.00           H  
ATOM   1170  N   SER A  72      12.661  98.249   6.654  0.00  0.00           N  
ATOM   1171  CA  SER A  72      11.354  97.756   7.080  0.00  0.00           C  
ATOM   1172  C   SER A  72      10.274  98.797   6.777  0.00  0.00           C  
ATOM   1173  O   SER A  72      10.568  99.974   6.575  0.00  0.00           O  
ATOM   1174  CB  SER A  72      11.393  97.449   8.587  0.00  0.00           C  
ATOM   1175  OG  SER A  72      12.463  96.574   8.937  0.00  0.00           O  
ATOM   1176  H   SER A  72      12.851  99.233   6.834  0.00  0.00           H  
ATOM   1177  HA  SER A  72      11.110  96.841   6.539  0.00  0.00           H  
ATOM   1178  HB2 SER A  72      11.506  98.386   9.130  0.00  0.00           H  
ATOM   1179  HB3 SER A  72      10.445  96.996   8.882  0.00  0.00           H  
ATOM   1180  HG  SER A  72      12.420  96.403   9.899  0.00  0.00           H  
ATOM   1181  N   GLU A  73       9.004  98.386   6.773  0.00  0.00           N  
ATOM   1182  CA  GLU A  73       7.876  99.248   6.408  0.00  0.00           C  
ATOM   1183  C   GLU A  73       7.778 100.501   7.295  0.00  0.00           C  
ATOM   1184  O   GLU A  73       7.229 101.517   6.863  0.00  0.00           O  
ATOM   1185  CB  GLU A  73       6.566  98.448   6.478  0.00  0.00           C  
ATOM   1186  CG  GLU A  73       6.449  97.411   5.351  0.00  0.00           C  
ATOM   1187  CD  GLU A  73       5.154  96.588   5.480  0.00  0.00           C  
ATOM   1188  OE1 GLU A  73       4.064  97.094   5.110  0.00  0.00           O  
ATOM   1189  OE2 GLU A  73       5.212  95.421   5.941  0.00  0.00           O  
ATOM   1190  H   GLU A  73       8.803  97.411   6.956  0.00  0.00           H  
ATOM   1191  HA  GLU A  73       8.017  99.582   5.379  0.00  0.00           H  
ATOM   1192  HB2 GLU A  73       6.501  97.947   7.445  0.00  0.00           H  
ATOM   1193  HB3 GLU A  73       5.725  99.138   6.394  0.00  0.00           H  
ATOM   1194  HG2 GLU A  73       6.458  97.929   4.389  0.00  0.00           H  
ATOM   1195  HG3 GLU A  73       7.311  96.742   5.379  0.00  0.00           H  
ATOM   1196  N   ASP A  74       8.311 100.455   8.521  0.00  0.00           N  
ATOM   1197  CA  ASP A  74       8.245 101.581   9.455  0.00  0.00           C  
ATOM   1198  C   ASP A  74       9.345 102.628   9.214  0.00  0.00           C  
ATOM   1199  O   ASP A  74       9.270 103.722   9.770  0.00  0.00           O  
ATOM   1200  CB  ASP A  74       8.257 101.079  10.903  0.00  0.00           C  
ATOM   1201  CG  ASP A  74       7.818 102.184  11.884  0.00  0.00           C  
ATOM   1202  OD1 ASP A  74       6.723 102.768  11.688  0.00  0.00           O  
ATOM   1203  OD2 ASP A  74       8.519 102.418  12.897  0.00  0.00           O  
ATOM   1204  H   ASP A  74       8.757  99.604   8.831  0.00  0.00           H  
ATOM   1205  HA  ASP A  74       7.287 102.074   9.301  0.00  0.00           H  
ATOM   1206  HB2 ASP A  74       7.564 100.241  10.996  0.00  0.00           H  
ATOM   1207  HB3 ASP A  74       9.256 100.720  11.154  0.00  0.00           H  
ATOM   1208  N   ASP A  75      10.327 102.342   8.347  0.00  0.00           N  
ATOM   1209  CA  ASP A  75      11.438 103.237   7.980  0.00  0.00           C  
ATOM   1210  C   ASP A  75      11.565 103.420   6.458  0.00  0.00           C  
ATOM   1211  O   ASP A  75      12.355 104.238   5.982  0.00  0.00           O  
ATOM   1212  CB  ASP A  75      12.765 102.774   8.605  0.00  0.00           C  
ATOM   1213  CG  ASP A  75      13.283 101.419   8.106  0.00  0.00           C  
ATOM   1214  OD1 ASP A  75      13.271 101.150   6.888  0.00  0.00           O  
ATOM   1215  OD2 ASP A  75      13.700 100.605   8.963  0.00  0.00           O  
ATOM   1216  H   ASP A  75      10.321 101.429   7.907  0.00  0.00           H  
ATOM   1217  HA  ASP A  75      11.229 104.225   8.388  0.00  0.00           H  
ATOM   1218  HB2 ASP A  75      13.526 103.527   8.404  0.00  0.00           H  
ATOM   1219  HB3 ASP A  75      12.639 102.719   9.685  0.00  0.00           H  
ATOM   1220  N   LEU A  76      10.721 102.715   5.701  0.00  0.00           N  
ATOM   1221  CA  LEU A  76      10.547 102.763   4.256  0.00  0.00           C  
ATOM   1222  C   LEU A  76      10.231 104.167   3.719  0.00  0.00           C  
ATOM   1223  O   LEU A  76      10.455 104.415   2.533  0.00  0.00           O  
ATOM   1224  CB  LEU A  76       9.403 101.779   3.938  0.00  0.00           C  
ATOM   1225  CG  LEU A  76       8.879 101.726   2.491  0.00  0.00           C  
ATOM   1226  CD1 LEU A  76       9.944 101.242   1.501  0.00  0.00           C  
ATOM   1227  CD2 LEU A  76       7.671 100.780   2.441  0.00  0.00           C  
ATOM   1228  H   LEU A  76      10.206 101.986   6.177  0.00  0.00           H  
ATOM   1229  HA  LEU A  76      11.466 102.408   3.788  0.00  0.00           H  
ATOM   1230  HB2 LEU A  76       9.729 100.778   4.218  0.00  0.00           H  
ATOM   1231  HB3 LEU A  76       8.561 102.045   4.576  0.00  0.00           H  
ATOM   1232  HG  LEU A  76       8.532 102.712   2.192  0.00  0.00           H  
ATOM   1233 HD11 LEU A  76      10.815 101.895   1.533  0.00  0.00           H  
ATOM   1234 HD12 LEU A  76      10.256 100.226   1.744  0.00  0.00           H  
ATOM   1235 HD13 LEU A  76       9.537 101.260   0.489  0.00  0.00           H  
ATOM   1236 HD21 LEU A  76       7.964  99.769   2.725  0.00  0.00           H  
ATOM   1237 HD22 LEU A  76       6.899 101.132   3.127  0.00  0.00           H  
ATOM   1238 HD23 LEU A  76       7.253 100.766   1.433  0.00  0.00           H  
ATOM   1239  N   ASP A  77       9.712 105.079   4.543  0.00  0.00           N  
ATOM   1240  CA  ASP A  77       9.152 106.354   4.092  0.00  0.00           C  
ATOM   1241  C   ASP A  77       9.938 107.527   4.695  0.00  0.00           C  
ATOM   1242  O   ASP A  77      10.110 107.571   5.917  0.00  0.00           O  
ATOM   1243  CB  ASP A  77       7.675 106.434   4.487  0.00  0.00           C  
ATOM   1244  CG  ASP A  77       7.071 107.768   4.026  0.00  0.00           C  
ATOM   1245  OD1 ASP A  77       7.155 108.764   4.781  0.00  0.00           O  
ATOM   1246  OD2 ASP A  77       6.526 107.825   2.898  0.00  0.00           O  
ATOM   1247  H   ASP A  77       9.652 104.867   5.528  0.00  0.00           H  
ATOM   1248  HA  ASP A  77       9.188 106.400   3.006  0.00  0.00           H  
ATOM   1249  HB2 ASP A  77       7.136 105.604   4.025  0.00  0.00           H  
ATOM   1250  HB3 ASP A  77       7.579 106.334   5.569  0.00  0.00           H  
ATOM   1251  N   PRO A  78      10.430 108.483   3.883  0.00  0.00           N  
ATOM   1252  CA  PRO A  78      11.314 109.535   4.367  0.00  0.00           C  
ATOM   1253  C   PRO A  78      10.611 110.579   5.237  0.00  0.00           C  
ATOM   1254  O   PRO A  78      11.287 111.239   6.024  0.00  0.00           O  
ATOM   1255  CB  PRO A  78      11.934 110.163   3.118  0.00  0.00           C  
ATOM   1256  CG  PRO A  78      10.883 109.924   2.037  0.00  0.00           C  
ATOM   1257  CD  PRO A  78      10.282 108.578   2.437  0.00  0.00           C  
ATOM   1258  HA  PRO A  78      12.106 109.088   4.963  0.00  0.00           H  
ATOM   1259  HB2 PRO A  78      12.142 111.225   3.251  0.00  0.00           H  
ATOM   1260  HB3 PRO A  78      12.848 109.624   2.861  0.00  0.00           H  
ATOM   1261  HG2 PRO A  78      10.117 110.699   2.092  0.00  0.00           H  
ATOM   1262  HG3 PRO A  78      11.326 109.892   1.041  0.00  0.00           H  
ATOM   1263  HD2 PRO A  78       9.235 108.533   2.139  0.00  0.00           H  
ATOM   1264  HD3 PRO A  78      10.843 107.770   1.966  0.00  0.00           H  
ATOM   1265  N   GLY A  79       9.285 110.721   5.159  0.00  0.00           N  
ATOM   1266  CA  GLY A  79       8.540 111.596   6.055  0.00  0.00           C  
ATOM   1267  C   GLY A  79       8.644 111.089   7.493  0.00  0.00           C  
ATOM   1268  O   GLY A  79       8.863 111.879   8.414  0.00  0.00           O  
ATOM   1269  H   GLY A  79       8.745 110.100   4.566  0.00  0.00           H  
ATOM   1270  HA2 GLY A  79       8.935 112.610   5.993  0.00  0.00           H  
ATOM   1271  HA3 GLY A  79       7.492 111.602   5.756  0.00  0.00           H  
ATOM   1272  N   LYS A  80       8.575 109.765   7.689  0.00  0.00           N  
ATOM   1273  CA  LYS A  80       8.779 109.162   9.004  0.00  0.00           C  
ATOM   1274  C   LYS A  80      10.204 109.426   9.489  0.00  0.00           C  
ATOM   1275  O   LYS A  80      10.382 109.793  10.652  0.00  0.00           O  
ATOM   1276  CB  LYS A  80       8.493 107.652   8.982  0.00  0.00           C  
ATOM   1277  CG  LYS A  80       7.073 107.297   8.515  0.00  0.00           C  
ATOM   1278  CD  LYS A  80       6.812 105.795   8.688  0.00  0.00           C  
ATOM   1279  CE  LYS A  80       5.402 105.433   8.197  0.00  0.00           C  
ATOM   1280  NZ  LYS A  80       4.901 104.169   8.798  0.00  0.00           N  
ATOM   1281  H   LYS A  80       8.414 109.160   6.892  0.00  0.00           H  
ATOM   1282  HA  LYS A  80       8.091 109.634   9.708  0.00  0.00           H  
ATOM   1283  HB2 LYS A  80       9.216 107.149   8.339  0.00  0.00           H  
ATOM   1284  HB3 LYS A  80       8.622 107.278   9.997  0.00  0.00           H  
ATOM   1285  HG2 LYS A  80       6.350 107.855   9.113  0.00  0.00           H  
ATOM   1286  HG3 LYS A  80       6.949 107.570   7.469  0.00  0.00           H  
ATOM   1287  HD2 LYS A  80       7.549 105.223   8.120  0.00  0.00           H  
ATOM   1288  HD3 LYS A  80       6.909 105.546   9.747  0.00  0.00           H  
ATOM   1289  HE2 LYS A  80       4.719 106.245   8.459  0.00  0.00           H  
ATOM   1290  HE3 LYS A  80       5.417 105.345   7.108  0.00  0.00           H  
ATOM   1291  HZ1 LYS A  80       5.480 103.381   8.541  0.00  0.00           H  
ATOM   1292  HZ2 LYS A  80       4.874 104.232   9.809  0.00  0.00           H  
ATOM   1293  HZ3 LYS A  80       3.959 103.974   8.482  0.00  0.00           H  
ATOM   1294  N   ILE A  81      11.207 109.277   8.613  0.00  0.00           N  
ATOM   1295  CA  ILE A  81      12.602 109.554   8.961  0.00  0.00           C  
ATOM   1296  C   ILE A  81      12.714 111.015   9.416  0.00  0.00           C  
ATOM   1297  O   ILE A  81      13.263 111.269  10.486  0.00  0.00           O  
ATOM   1298  CB  ILE A  81      13.571 109.218   7.792  0.00  0.00           C  
ATOM   1299  CG1 ILE A  81      13.453 107.736   7.362  0.00  0.00           C  
ATOM   1300  CG2 ILE A  81      15.030 109.529   8.194  0.00  0.00           C  
ATOM   1301  CD1 ILE A  81      14.244 107.381   6.092  0.00  0.00           C  
ATOM   1302  H   ILE A  81      10.996 108.947   7.681  0.00  0.00           H  
ATOM   1303  HA  ILE A  81      12.867 108.919   9.808  0.00  0.00           H  
ATOM   1304  HB  ILE A  81      13.318 109.847   6.940  0.00  0.00           H  
ATOM   1305 HG12 ILE A  81      13.789 107.097   8.180  0.00  0.00           H  
ATOM   1306 HG13 ILE A  81      12.411 107.491   7.166  0.00  0.00           H  
ATOM   1307 HG21 ILE A  81      15.137 110.573   8.488  0.00  0.00           H  
ATOM   1308 HG22 ILE A  81      15.336 108.893   9.026  0.00  0.00           H  
ATOM   1309 HG23 ILE A  81      15.706 109.366   7.355  0.00  0.00           H  
ATOM   1310 HD11 ILE A  81      13.938 108.015   5.263  0.00  0.00           H  
ATOM   1311 HD12 ILE A  81      15.312 107.502   6.252  0.00  0.00           H  
ATOM   1312 HD13 ILE A  81      14.053 106.343   5.826  0.00  0.00           H  
ATOM   1313  N   LYS A  82      12.165 111.967   8.650  0.00  0.00           N  
ATOM   1314  CA  LYS A  82      12.226 113.400   8.943  0.00  0.00           C  
ATOM   1315  C   LYS A  82      11.646 113.676  10.327  0.00  0.00           C  
ATOM   1316  O   LYS A  82      12.299 114.309  11.156  0.00  0.00           O  
ATOM   1317  CB  LYS A  82      11.462 114.164   7.836  0.00  0.00           C  
ATOM   1318  CG  LYS A  82      11.768 115.661   7.652  0.00  0.00           C  
ATOM   1319  CD  LYS A  82      11.710 116.540   8.910  0.00  0.00           C  
ATOM   1320  CE  LYS A  82      11.640 118.021   8.499  0.00  0.00           C  
ATOM   1321  NZ  LYS A  82      12.204 118.935   9.526  0.00  0.00           N  
ATOM   1322  H   LYS A  82      11.728 111.688   7.776  0.00  0.00           H  
ATOM   1323  HA  LYS A  82      13.274 113.699   8.939  0.00  0.00           H  
ATOM   1324  HB2 LYS A  82      11.682 113.695   6.876  0.00  0.00           H  
ATOM   1325  HB3 LYS A  82      10.390 114.056   7.999  0.00  0.00           H  
ATOM   1326  HG2 LYS A  82      12.759 115.766   7.212  0.00  0.00           H  
ATOM   1327  HG3 LYS A  82      11.048 116.047   6.927  0.00  0.00           H  
ATOM   1328  HD2 LYS A  82      10.826 116.295   9.502  0.00  0.00           H  
ATOM   1329  HD3 LYS A  82      12.607 116.361   9.504  0.00  0.00           H  
ATOM   1330  HE2 LYS A  82      12.185 118.159   7.563  0.00  0.00           H  
ATOM   1331  HE3 LYS A  82      10.594 118.280   8.313  0.00  0.00           H  
ATOM   1332  HZ1 LYS A  82      11.751 118.816  10.423  0.00  0.00           H  
ATOM   1333  HZ2 LYS A  82      13.198 118.788   9.643  0.00  0.00           H  
ATOM   1334  HZ3 LYS A  82      12.076 119.901   9.247  0.00  0.00           H  
ATOM   1335  N   GLU A  83      10.426 113.207  10.580  0.00  0.00           N  
ATOM   1336  CA  GLU A  83       9.697 113.549  11.793  0.00  0.00           C  
ATOM   1337  C   GLU A  83      10.397 112.956  13.024  0.00  0.00           C  
ATOM   1338  O   GLU A  83      10.551 113.639  14.038  0.00  0.00           O  
ATOM   1339  CB  GLU A  83       8.244 113.076  11.640  0.00  0.00           C  
ATOM   1340  CG  GLU A  83       7.329 113.648  12.732  0.00  0.00           C  
ATOM   1341  CD  GLU A  83       5.844 113.386  12.417  0.00  0.00           C  
ATOM   1342  OE1 GLU A  83       5.383 112.225  12.545  0.00  0.00           O  
ATOM   1343  OE2 GLU A  83       5.118 114.345  12.055  0.00  0.00           O  
ATOM   1344  H   GLU A  83       9.936 112.683   9.862  0.00  0.00           H  
ATOM   1345  HA  GLU A  83       9.697 114.636  11.889  0.00  0.00           H  
ATOM   1346  HB2 GLU A  83       7.870 113.420  10.674  0.00  0.00           H  
ATOM   1347  HB3 GLU A  83       8.205 111.987  11.657  0.00  0.00           H  
ATOM   1348  HG2 GLU A  83       7.587 113.199  13.694  0.00  0.00           H  
ATOM   1349  HG3 GLU A  83       7.499 114.726  12.805  0.00  0.00           H  
ATOM   1350  N   THR A  84      10.885 111.716  12.926  0.00  0.00           N  
ATOM   1351  CA  THR A  84      11.615 111.068  14.008  0.00  0.00           C  
ATOM   1352  C   THR A  84      12.981 111.745  14.229  0.00  0.00           C  
ATOM   1353  O   THR A  84      13.366 111.984  15.377  0.00  0.00           O  
ATOM   1354  CB  THR A  84      11.713 109.566  13.687  0.00  0.00           C  
ATOM   1355  OG1 THR A  84      10.412 108.999  13.607  0.00  0.00           O  
ATOM   1356  CG2 THR A  84      12.485 108.778  14.744  0.00  0.00           C  
ATOM   1357  H   THR A  84      10.726 111.180  12.080  0.00  0.00           H  
ATOM   1358  HA  THR A  84      11.038 111.184  14.928  0.00  0.00           H  
ATOM   1359  HB  THR A  84      12.214 109.444  12.725  0.00  0.00           H  
ATOM   1360  HG1 THR A  84      10.256 108.715  12.687  0.00  0.00           H  
ATOM   1361 HG21 THR A  84      13.546 109.005  14.655  0.00  0.00           H  
ATOM   1362 HG22 THR A  84      12.140 109.045  15.743  0.00  0.00           H  
ATOM   1363 HG23 THR A  84      12.350 107.707  14.594  0.00  0.00           H  
ATOM   1364  N   ALA A  85      13.698 112.120  13.161  0.00  0.00           N  
ATOM   1365  CA  ALA A  85      14.980 112.808  13.256  0.00  0.00           C  
ATOM   1366  C   ALA A  85      14.833 114.131  14.011  0.00  0.00           C  
ATOM   1367  O   ALA A  85      15.659 114.444  14.871  0.00  0.00           O  
ATOM   1368  CB  ALA A  85      15.543 113.062  11.852  0.00  0.00           C  
ATOM   1369  H   ALA A  85      13.347 111.916  12.231  0.00  0.00           H  
ATOM   1370  HA  ALA A  85      15.676 112.171  13.805  0.00  0.00           H  
ATOM   1371  HB1 ALA A  85      15.743 112.114  11.351  0.00  0.00           H  
ATOM   1372  HB2 ALA A  85      14.836 113.639  11.256  0.00  0.00           H  
ATOM   1373  HB3 ALA A  85      16.470 113.629  11.925  0.00  0.00           H  
ATOM   1374  N   ALA A  86      13.774 114.892  13.711  0.00  0.00           N  
ATOM   1375  CA  ALA A  86      13.530 116.187  14.332  0.00  0.00           C  
ATOM   1376  C   ALA A  86      13.397 116.061  15.857  0.00  0.00           C  
ATOM   1377  O   ALA A  86      13.898 116.916  16.591  0.00  0.00           O  
ATOM   1378  CB  ALA A  86      12.272 116.817  13.724  0.00  0.00           C  
ATOM   1379  H   ALA A  86      13.144 114.586  12.978  0.00  0.00           H  
ATOM   1380  HA  ALA A  86      14.381 116.833  14.113  0.00  0.00           H  
ATOM   1381  HB1 ALA A  86      12.386 116.905  12.643  0.00  0.00           H  
ATOM   1382  HB2 ALA A  86      11.398 116.206  13.948  0.00  0.00           H  
ATOM   1383  HB3 ALA A  86      12.125 117.811  14.147  0.00  0.00           H  
ATOM   1384  N   GLU A  87      12.755 114.994  16.342  0.00  0.00           N  
ATOM   1385  CA  GLU A  87      12.553 114.766  17.772  0.00  0.00           C  
ATOM   1386  C   GLU A  87      13.855 114.346  18.471  0.00  0.00           C  
ATOM   1387  O   GLU A  87      14.044 114.652  19.651  0.00  0.00           O  
ATOM   1388  CB  GLU A  87      11.465 113.697  17.981  0.00  0.00           C  
ATOM   1389  CG  GLU A  87      10.053 114.191  17.630  0.00  0.00           C  
ATOM   1390  CD  GLU A  87       9.530 115.229  18.640  0.00  0.00           C  
ATOM   1391  OE1 GLU A  87       8.957 114.831  19.685  0.00  0.00           O  
ATOM   1392  OE2 GLU A  87       9.670 116.454  18.398  0.00  0.00           O  
ATOM   1393  H   GLU A  87      12.368 114.318  15.695  0.00  0.00           H  
ATOM   1394  HA  GLU A  87      12.223 115.700  18.229  0.00  0.00           H  
ATOM   1395  HB2 GLU A  87      11.698 112.825  17.369  0.00  0.00           H  
ATOM   1396  HB3 GLU A  87      11.469 113.379  19.024  0.00  0.00           H  
ATOM   1397  HG2 GLU A  87      10.048 114.615  16.624  0.00  0.00           H  
ATOM   1398  HG3 GLU A  87       9.380 113.330  17.623  0.00  0.00           H  
ATOM   1399  N   HIS A  88      14.764 113.670  17.759  0.00  0.00           N  
ATOM   1400  CA  HIS A  88      16.033 113.186  18.302  0.00  0.00           C  
ATOM   1401  C   HIS A  88      17.129 114.269  18.331  0.00  0.00           C  
ATOM   1402  O   HIS A  88      18.229 114.000  18.817  0.00  0.00           O  
ATOM   1403  CB  HIS A  88      16.485 111.951  17.506  0.00  0.00           C  
ATOM   1404  CG  HIS A  88      15.598 110.736  17.682  0.00  0.00           C  
ATOM   1405  ND1 HIS A  88      15.032 110.285  18.859  0.00  0.00           N  
ATOM   1406  CD2 HIS A  88      15.323 109.796  16.725  0.00  0.00           C  
ATOM   1407  CE1 HIS A  88      14.429 109.110  18.608  0.00  0.00           C  
ATOM   1408  NE2 HIS A  88      14.585 108.761  17.319  0.00  0.00           N  
ATOM   1409  H   HIS A  88      14.552 113.444  16.794  0.00  0.00           H  
ATOM   1410  HA  HIS A  88      15.870 112.880  19.335  0.00  0.00           H  
ATOM   1411  HB2 HIS A  88      16.544 112.205  16.446  0.00  0.00           H  
ATOM   1412  HB3 HIS A  88      17.486 111.671  17.833  0.00  0.00           H  
ATOM   1413  HD1 HIS A  88      15.060 110.744  19.763  0.00  0.00           H  
ATOM   1414  HD2 HIS A  88      15.663 109.828  15.698  0.00  0.00           H  
ATOM   1415  HE1 HIS A  88      13.900 108.522  19.350  0.00  0.00           H  
ATOM   1416  N   ASP A  89      16.842 115.483  17.844  0.00  0.00           N  
ATOM   1417  CA  ASP A  89      17.777 116.614  17.728  0.00  0.00           C  
ATOM   1418  C   ASP A  89      19.060 116.259  16.959  0.00  0.00           C  
ATOM   1419  O   ASP A  89      20.122 116.831  17.198  0.00  0.00           O  
ATOM   1420  CB  ASP A  89      18.063 117.264  19.098  0.00  0.00           C  
ATOM   1421  CG  ASP A  89      18.737 118.647  18.948  0.00  0.00           C  
ATOM   1422  OD1 ASP A  89      18.072 119.584  18.443  0.00  0.00           O  
ATOM   1423  OD2 ASP A  89      19.911 118.827  19.360  0.00  0.00           O  
ATOM   1424  H   ASP A  89      15.917 115.624  17.463  0.00  0.00           H  
ATOM   1425  HA  ASP A  89      17.263 117.367  17.129  0.00  0.00           H  
ATOM   1426  HB2 ASP A  89      17.122 117.394  19.635  0.00  0.00           H  
ATOM   1427  HB3 ASP A  89      18.696 116.602  19.693  0.00  0.00           H  
ATOM   1428  N   ILE A  90      19.005 115.299  16.034  0.00  0.00           N  
ATOM   1429  CA  ILE A  90      20.131 115.030  15.147  0.00  0.00           C  
ATOM   1430  C   ILE A  90      20.164 116.150  14.093  0.00  0.00           C  
ATOM   1431  O   ILE A  90      19.167 116.376  13.398  0.00  0.00           O  
ATOM   1432  CB  ILE A  90      20.052 113.593  14.584  0.00  0.00           C  
ATOM   1433  CG1 ILE A  90      18.852 113.362  13.641  0.00  0.00           C  
ATOM   1434  CG2 ILE A  90      20.103 112.591  15.756  0.00  0.00           C  
ATOM   1435  CD1 ILE A  90      18.640 111.907  13.229  0.00  0.00           C  
ATOM   1436  H   ILE A  90      18.119 114.856  15.833  0.00  0.00           H  
ATOM   1437  HA  ILE A  90      21.053 115.090  15.728  0.00  0.00           H  
ATOM   1438  HB  ILE A  90      20.945 113.429  13.990  0.00  0.00           H  
ATOM   1439 HG12 ILE A  90      17.941 113.715  14.114  0.00  0.00           H  
ATOM   1440 HG13 ILE A  90      19.009 113.939  12.731  0.00  0.00           H  
ATOM   1441 HG21 ILE A  90      20.900 112.861  16.449  0.00  0.00           H  
ATOM   1442 HG22 ILE A  90      19.158 112.587  16.296  0.00  0.00           H  
ATOM   1443 HG23 ILE A  90      20.304 111.585  15.388  0.00  0.00           H  
ATOM   1444 HD11 ILE A  90      19.596 111.410  13.062  0.00  0.00           H  
ATOM   1445 HD12 ILE A  90      18.079 111.399  14.007  0.00  0.00           H  
ATOM   1446 HD13 ILE A  90      18.061 111.869  12.309  0.00  0.00           H  
ATOM   1447  N   THR A  91      21.284 116.874  13.984  0.00  0.00           N  
ATOM   1448  CA  THR A  91      21.412 118.031  13.090  0.00  0.00           C  
ATOM   1449  C   THR A  91      22.628 117.917  12.156  0.00  0.00           C  
ATOM   1450  O   THR A  91      22.849 118.801  11.322  0.00  0.00           O  
ATOM   1451  CB  THR A  91      21.385 119.350  13.881  0.00  0.00           C  
ATOM   1452  OG1 THR A  91      22.414 119.375  14.848  0.00  0.00           O  
ATOM   1453  CG2 THR A  91      20.060 119.568  14.617  0.00  0.00           C  
ATOM   1454  H   THR A  91      22.050 116.697  14.617  0.00  0.00           H  
ATOM   1455  HA  THR A  91      20.543 118.065  12.443  0.00  0.00           H  
ATOM   1456  HB  THR A  91      21.524 120.179  13.187  0.00  0.00           H  
ATOM   1457  HG1 THR A  91      23.023 120.109  14.618  0.00  0.00           H  
ATOM   1458 HG21 THR A  91      19.232 119.511  13.909  0.00  0.00           H  
ATOM   1459 HG22 THR A  91      19.920 118.816  15.392  0.00  0.00           H  
ATOM   1460 HG23 THR A  91      20.058 120.557  15.078  0.00  0.00           H  
ATOM   1461  N   GLN A  92      23.403 116.828  12.247  0.00  0.00           N  
ATOM   1462  CA  GLN A  92      24.404 116.481  11.244  0.00  0.00           C  
ATOM   1463  C   GLN A  92      23.716 116.259   9.887  0.00  0.00           C  
ATOM   1464  O   GLN A  92      22.529 115.918   9.876  0.00  0.00           O  
ATOM   1465  CB  GLN A  92      25.210 115.240  11.689  0.00  0.00           C  
ATOM   1466  CG  GLN A  92      24.504 113.868  11.632  0.00  0.00           C  
ATOM   1467  CD  GLN A  92      23.597 113.548  12.821  0.00  0.00           C  
ATOM   1468  OE1 GLN A  92      23.262 114.399  13.643  0.00  0.00           O  
ATOM   1469  NE2 GLN A  92      23.175 112.302  12.949  0.00  0.00           N  
ATOM   1470  H   GLN A  92      23.161 116.108  12.917  0.00  0.00           H  
ATOM   1471  HA  GLN A  92      25.092 117.324  11.161  0.00  0.00           H  
ATOM   1472  HB2 GLN A  92      26.069 115.169  11.029  0.00  0.00           H  
ATOM   1473  HB3 GLN A  92      25.599 115.404  12.694  0.00  0.00           H  
ATOM   1474  HG2 GLN A  92      23.930 113.771  10.713  0.00  0.00           H  
ATOM   1475  HG3 GLN A  92      25.274 113.100  11.589  0.00  0.00           H  
ATOM   1476 HE21 GLN A  92      23.540 111.562  12.359  0.00  0.00           H  
ATOM   1477 HE22 GLN A  92      22.622 112.053  13.752  0.00  0.00           H  
ATOM   1478  N   PRO A  93      24.420 116.382   8.749  0.00  0.00           N  
ATOM   1479  CA  PRO A  93      23.891 115.951   7.463  0.00  0.00           C  
ATOM   1480  C   PRO A  93      23.547 114.457   7.494  0.00  0.00           C  
ATOM   1481  O   PRO A  93      24.292 113.650   8.057  0.00  0.00           O  
ATOM   1482  CB  PRO A  93      24.962 116.286   6.419  0.00  0.00           C  
ATOM   1483  CG  PRO A  93      26.227 116.625   7.210  0.00  0.00           C  
ATOM   1484  CD  PRO A  93      25.745 116.965   8.616  0.00  0.00           C  
ATOM   1485  HA  PRO A  93      22.988 116.522   7.241  0.00  0.00           H  
ATOM   1486  HB2 PRO A  93      25.141 115.449   5.744  0.00  0.00           H  
ATOM   1487  HB3 PRO A  93      24.652 117.161   5.848  0.00  0.00           H  
ATOM   1488  HG2 PRO A  93      26.883 115.754   7.250  0.00  0.00           H  
ATOM   1489  HG3 PRO A  93      26.755 117.471   6.765  0.00  0.00           H  
ATOM   1490  HD2 PRO A  93      26.442 116.566   9.349  0.00  0.00           H  
ATOM   1491  HD3 PRO A  93      25.672 118.047   8.729  0.00  0.00           H  
ATOM   1492  N   ILE A  94      22.435 114.081   6.868  0.00  0.00           N  
ATOM   1493  CA  ILE A  94      21.955 112.706   6.768  0.00  0.00           C  
ATOM   1494  C   ILE A  94      21.429 112.547   5.347  0.00  0.00           C  
ATOM   1495  O   ILE A  94      20.817 113.477   4.821  0.00  0.00           O  
ATOM   1496  CB  ILE A  94      20.836 112.420   7.805  0.00  0.00           C  
ATOM   1497  CG1 ILE A  94      21.268 112.825   9.232  0.00  0.00           C  
ATOM   1498  CG2 ILE A  94      20.345 110.957   7.716  0.00  0.00           C  
ATOM   1499  CD1 ILE A  94      20.319 112.436  10.365  0.00  0.00           C  
ATOM   1500  H   ILE A  94      21.861 114.786   6.414  0.00  0.00           H  
ATOM   1501  HA  ILE A  94      22.786 112.025   6.934  0.00  0.00           H  
ATOM   1502  HB  ILE A  94      19.988 113.049   7.550  0.00  0.00           H  
ATOM   1503 HG12 ILE A  94      22.256 112.428   9.450  0.00  0.00           H  
ATOM   1504 HG13 ILE A  94      21.329 113.908   9.252  0.00  0.00           H  
ATOM   1505 HG21 ILE A  94      19.897 110.767   6.740  0.00  0.00           H  
ATOM   1506 HG22 ILE A  94      21.171 110.264   7.860  0.00  0.00           H  
ATOM   1507 HG23 ILE A  94      19.564 110.766   8.448  0.00  0.00           H  
ATOM   1508 HD11 ILE A  94      19.304 112.759  10.132  0.00  0.00           H  
ATOM   1509 HD12 ILE A  94      20.343 111.359  10.525  0.00  0.00           H  
ATOM   1510 HD13 ILE A  94      20.652 112.927  11.278  0.00  0.00           H  
ATOM   1511  N   PHE A  95      21.589 111.370   4.747  0.00  0.00           N  
ATOM   1512  CA  PHE A  95      20.956 111.051   3.474  0.00  0.00           C  
ATOM   1513  C   PHE A  95      20.343 109.653   3.504  0.00  0.00           C  
ATOM   1514  O   PHE A  95      20.671 108.815   4.348  0.00  0.00           O  
ATOM   1515  CB  PHE A  95      21.933 111.284   2.308  0.00  0.00           C  
ATOM   1516  CG  PHE A  95      23.301 110.636   2.428  0.00  0.00           C  
ATOM   1517  CD1 PHE A  95      23.468 109.273   2.123  0.00  0.00           C  
ATOM   1518  CD2 PHE A  95      24.419 111.405   2.810  0.00  0.00           C  
ATOM   1519  CE1 PHE A  95      24.743 108.689   2.196  0.00  0.00           C  
ATOM   1520  CE2 PHE A  95      25.696 110.818   2.877  0.00  0.00           C  
ATOM   1521  CZ  PHE A  95      25.860 109.458   2.565  0.00  0.00           C  
ATOM   1522  H   PHE A  95      22.101 110.628   5.212  0.00  0.00           H  
ATOM   1523  HA  PHE A  95      20.125 111.732   3.318  0.00  0.00           H  
ATOM   1524  HB2 PHE A  95      21.462 110.948   1.385  0.00  0.00           H  
ATOM   1525  HB3 PHE A  95      22.076 112.361   2.205  0.00  0.00           H  
ATOM   1526  HD1 PHE A  95      22.621 108.669   1.824  0.00  0.00           H  
ATOM   1527  HD2 PHE A  95      24.301 112.453   3.048  0.00  0.00           H  
ATOM   1528  HE1 PHE A  95      24.860 107.642   1.966  0.00  0.00           H  
ATOM   1529  HE2 PHE A  95      26.551 111.414   3.169  0.00  0.00           H  
ATOM   1530  HZ  PHE A  95      26.839 109.000   2.624  0.00  0.00           H  
ATOM   1531  N   VAL A  96      19.426 109.426   2.569  0.00  0.00           N  
ATOM   1532  CA  VAL A  96      18.677 108.200   2.359  0.00  0.00           C  
ATOM   1533  C   VAL A  96      18.857 107.925   0.869  0.00  0.00           C  
ATOM   1534  O   VAL A  96      18.790 108.853   0.055  0.00  0.00           O  
ATOM   1535  CB  VAL A  96      17.186 108.402   2.734  0.00  0.00           C  
ATOM   1536  CG1 VAL A  96      16.453 107.054   2.802  0.00  0.00           C  
ATOM   1537  CG2 VAL A  96      16.973 109.153   4.061  0.00  0.00           C  
ATOM   1538  H   VAL A  96      19.199 110.175   1.919  0.00  0.00           H  
ATOM   1539  HA  VAL A  96      19.109 107.393   2.954  0.00  0.00           H  
ATOM   1540  HB  VAL A  96      16.711 108.998   1.956  0.00  0.00           H  
ATOM   1541 HG11 VAL A  96      16.536 106.529   1.850  0.00  0.00           H  
ATOM   1542 HG12 VAL A  96      16.878 106.426   3.585  0.00  0.00           H  
ATOM   1543 HG13 VAL A  96      15.393 107.214   3.011  0.00  0.00           H  
ATOM   1544 HG21 VAL A  96      17.505 108.656   4.868  0.00  0.00           H  
ATOM   1545 HG22 VAL A  96      17.332 110.180   3.977  0.00  0.00           H  
ATOM   1546 HG23 VAL A  96      15.910 109.195   4.300  0.00  0.00           H  
ATOM   1547  N   ASP A  97      19.101 106.677   0.483  0.00  0.00           N  
ATOM   1548  CA  ASP A  97      19.504 106.367  -0.881  0.00  0.00           C  
ATOM   1549  C   ASP A  97      18.777 105.130  -1.377  0.00  0.00           C  
ATOM   1550  O   ASP A  97      18.942 104.047  -0.818  0.00  0.00           O  
ATOM   1551  CB  ASP A  97      21.017 106.165  -0.949  0.00  0.00           C  
ATOM   1552  CG  ASP A  97      21.478 105.946  -2.399  0.00  0.00           C  
ATOM   1553  OD1 ASP A  97      20.731 106.281  -3.347  0.00  0.00           O  
ATOM   1554  OD2 ASP A  97      22.598 105.424  -2.576  0.00  0.00           O  
ATOM   1555  H   ASP A  97      19.120 105.922   1.156  0.00  0.00           H  
ATOM   1556  HA  ASP A  97      19.257 107.197  -1.540  0.00  0.00           H  
ATOM   1557  HB2 ASP A  97      21.516 107.041  -0.534  0.00  0.00           H  
ATOM   1558  HB3 ASP A  97      21.296 105.304  -0.338  0.00  0.00           H  
ATOM   1559  N   SER A  98      17.957 105.302  -2.413  0.00  0.00           N  
ATOM   1560  CA  SER A  98      17.211 104.241  -3.069  0.00  0.00           C  
ATOM   1561  C   SER A  98      18.111 103.381  -3.972  0.00  0.00           C  
ATOM   1562  O   SER A  98      17.779 102.221  -4.233  0.00  0.00           O  
ATOM   1563  CB  SER A  98      16.067 104.887  -3.871  0.00  0.00           C  
ATOM   1564  OG  SER A  98      16.450 106.144  -4.434  0.00  0.00           O  
ATOM   1565  H   SER A  98      17.890 106.205  -2.861  0.00  0.00           H  
ATOM   1566  HA  SER A  98      16.774 103.591  -2.308  0.00  0.00           H  
ATOM   1567  HB2 SER A  98      15.740 104.206  -4.658  0.00  0.00           H  
ATOM   1568  HB3 SER A  98      15.227 105.057  -3.197  0.00  0.00           H  
ATOM   1569  HG  SER A  98      15.698 106.492  -4.954  0.00  0.00           H  
ATOM   1570  N   ASP A  99      19.246 103.914  -4.445  0.00  0.00           N  
ATOM   1571  CA  ASP A  99      20.204 103.165  -5.268  0.00  0.00           C  
ATOM   1572  C   ASP A  99      21.137 102.308  -4.403  0.00  0.00           C  
ATOM   1573  O   ASP A  99      21.756 101.363  -4.900  0.00  0.00           O  
ATOM   1574  CB  ASP A  99      21.034 104.126  -6.129  0.00  0.00           C  
ATOM   1575  CG  ASP A  99      21.965 103.363  -7.089  0.00  0.00           C  
ATOM   1576  OD1 ASP A  99      21.456 102.668  -8.003  0.00  0.00           O  
ATOM   1577  OD2 ASP A  99      23.207 103.493  -6.972  0.00  0.00           O  
ATOM   1578  H   ASP A  99      19.505 104.859  -4.175  0.00  0.00           H  
ATOM   1579  HA  ASP A  99      19.653 102.505  -5.940  0.00  0.00           H  
ATOM   1580  HB2 ASP A  99      20.360 104.755  -6.714  0.00  0.00           H  
ATOM   1581  HB3 ASP A  99      21.625 104.772  -5.479  0.00  0.00           H  
ATOM   1582  N   HIS A 100      21.193 102.603  -3.099  0.00  0.00           N  
ATOM   1583  CA  HIS A 100      22.072 101.977  -2.121  0.00  0.00           C  
ATOM   1584  C   HIS A 100      23.538 101.952  -2.603  0.00  0.00           C  
ATOM   1585  O   HIS A 100      24.186 100.902  -2.613  0.00  0.00           O  
ATOM   1586  CB  HIS A 100      21.545 100.585  -1.731  0.00  0.00           C  
ATOM   1587  CG  HIS A 100      20.090 100.492  -1.346  0.00  0.00           C  
ATOM   1588  ND1 HIS A 100      19.149  99.674  -1.934  0.00  0.00           N  
ATOM   1589  CD2 HIS A 100      19.485 101.096  -0.276  0.00  0.00           C  
ATOM   1590  CE1 HIS A 100      18.003  99.793  -1.243  0.00  0.00           C  
ATOM   1591  NE2 HIS A 100      18.157 100.651  -0.218  0.00  0.00           N  
ATOM   1592  H   HIS A 100      20.631 103.377  -2.777  0.00  0.00           H  
ATOM   1593  HA  HIS A 100      22.041 102.601  -1.226  0.00  0.00           H  
ATOM   1594  HB2 HIS A 100      21.733  99.886  -2.546  0.00  0.00           H  
ATOM   1595  HB3 HIS A 100      22.116 100.253  -0.874  0.00  0.00           H  
ATOM   1596  HD1 HIS A 100      19.292  99.066  -2.733  0.00  0.00           H  
ATOM   1597  HD2 HIS A 100      19.962 101.776   0.420  0.00  0.00           H  
ATOM   1598  HE1 HIS A 100      17.089  99.254  -1.471  0.00  0.00           H  
ATOM   1599  N   ALA A 101      24.069 103.104  -3.025  0.00  0.00           N  
ATOM   1600  CA  ALA A 101      25.428 103.238  -3.534  0.00  0.00           C  
ATOM   1601  C   ALA A 101      26.469 102.762  -2.516  0.00  0.00           C  
ATOM   1602  O   ALA A 101      27.447 102.119  -2.900  0.00  0.00           O  
ATOM   1603  CB  ALA A 101      25.702 104.695  -3.925  0.00  0.00           C  
ATOM   1604  H   ALA A 101      23.500 103.949  -2.983  0.00  0.00           H  
ATOM   1605  HA  ALA A 101      25.515 102.620  -4.430  0.00  0.00           H  
ATOM   1606  HB1 ALA A 101      24.959 105.033  -4.647  0.00  0.00           H  
ATOM   1607  HB2 ALA A 101      25.669 105.335  -3.042  0.00  0.00           H  
ATOM   1608  HB3 ALA A 101      26.691 104.764  -4.378  0.00  0.00           H  
ATOM   1609  N   LEU A 102      26.266 103.032  -1.218  0.00  0.00           N  
ATOM   1610  CA  LEU A 102      27.197 102.563  -0.192  0.00  0.00           C  
ATOM   1611  C   LEU A 102      27.119 101.045  -0.066  0.00  0.00           C  
ATOM   1612  O   LEU A 102      28.142 100.417   0.173  0.00  0.00           O  
ATOM   1613  CB  LEU A 102      26.983 103.228   1.180  0.00  0.00           C  
ATOM   1614  CG  LEU A 102      27.416 104.709   1.231  0.00  0.00           C  
ATOM   1615  CD1 LEU A 102      26.313 105.643   0.723  0.00  0.00           C  
ATOM   1616  CD2 LEU A 102      27.768 105.109   2.666  0.00  0.00           C  
ATOM   1617  H   LEU A 102      25.454 103.568  -0.943  0.00  0.00           H  
ATOM   1618  HA  LEU A 102      28.211 102.803  -0.519  0.00  0.00           H  
ATOM   1619  HB2 LEU A 102      25.944 103.117   1.498  0.00  0.00           H  
ATOM   1620  HB3 LEU A 102      27.598 102.676   1.894  0.00  0.00           H  
ATOM   1621  HG  LEU A 102      28.308 104.847   0.620  0.00  0.00           H  
ATOM   1622 HD11 LEU A 102      26.143 105.489  -0.341  0.00  0.00           H  
ATOM   1623 HD12 LEU A 102      25.385 105.473   1.269  0.00  0.00           H  
ATOM   1624 HD13 LEU A 102      26.628 106.679   0.849  0.00  0.00           H  
ATOM   1625 HD21 LEU A 102      26.925 104.906   3.324  0.00  0.00           H  
ATOM   1626 HD22 LEU A 102      28.638 104.542   3.001  0.00  0.00           H  
ATOM   1627 HD23 LEU A 102      28.018 106.169   2.711  0.00  0.00           H  
ATOM   1628  N   THR A 103      25.961 100.423  -0.279  0.00  0.00           N  
ATOM   1629  CA  THR A 103      25.815  98.970  -0.243  0.00  0.00           C  
ATOM   1630  C   THR A 103      26.557  98.291  -1.410  0.00  0.00           C  
ATOM   1631  O   THR A 103      26.854  97.101  -1.324  0.00  0.00           O  
ATOM   1632  CB  THR A 103      24.317  98.610  -0.171  0.00  0.00           C  
ATOM   1633  OG1 THR A 103      23.716  99.417   0.834  0.00  0.00           O  
ATOM   1634  CG2 THR A 103      24.052  97.139   0.172  0.00  0.00           C  
ATOM   1635  H   THR A 103      25.125 100.957  -0.469  0.00  0.00           H  
ATOM   1636  HA  THR A 103      26.279  98.626   0.680  0.00  0.00           H  
ATOM   1637  HB  THR A 103      23.848  98.826  -1.130  0.00  0.00           H  
ATOM   1638  HG1 THR A 103      22.775  99.179   0.921  0.00  0.00           H  
ATOM   1639 HG21 THR A 103      24.343  96.506  -0.666  0.00  0.00           H  
ATOM   1640 HG22 THR A 103      24.621  96.848   1.053  0.00  0.00           H  
ATOM   1641 HG23 THR A 103      22.989  96.982   0.359  0.00  0.00           H  
ATOM   1642  N   ASP A 104      26.941  99.013  -2.469  0.00  0.00           N  
ATOM   1643  CA  ASP A 104      27.823  98.456  -3.501  0.00  0.00           C  
ATOM   1644  C   ASP A 104      29.279  98.362  -3.015  0.00  0.00           C  
ATOM   1645  O   ASP A 104      30.022  97.487  -3.466  0.00  0.00           O  
ATOM   1646  CB  ASP A 104      27.751  99.291  -4.785  0.00  0.00           C  
ATOM   1647  CG  ASP A 104      28.607  98.663  -5.898  0.00  0.00           C  
ATOM   1648  OD1 ASP A 104      28.212  97.602  -6.442  0.00  0.00           O  
ATOM   1649  OD2 ASP A 104      29.657  99.246  -6.266  0.00  0.00           O  
ATOM   1650  H   ASP A 104      26.681  99.989  -2.538  0.00  0.00           H  
ATOM   1651  HA  ASP A 104      27.480  97.450  -3.747  0.00  0.00           H  
ATOM   1652  HB2 ASP A 104      26.713  99.352  -5.115  0.00  0.00           H  
ATOM   1653  HB3 ASP A 104      28.105 100.301  -4.581  0.00  0.00           H  
ATOM   1654  N   ALA A 105      29.686  99.228  -2.074  0.00  0.00           N  
ATOM   1655  CA  ALA A 105      31.078  99.378  -1.646  0.00  0.00           C  
ATOM   1656  C   ALA A 105      31.323  98.762  -0.261  0.00  0.00           C  
ATOM   1657  O   ALA A 105      32.251  97.969  -0.089  0.00  0.00           O  
ATOM   1658  CB  ALA A 105      31.436 100.872  -1.650  0.00  0.00           C  
ATOM   1659  H   ALA A 105      29.010  99.881  -1.699  0.00  0.00           H  
ATOM   1660  HA  ALA A 105      31.734  98.884  -2.364  0.00  0.00           H  
ATOM   1661  HB1 ALA A 105      31.284 101.290  -2.647  0.00  0.00           H  
ATOM   1662  HB2 ALA A 105      30.818 101.418  -0.935  0.00  0.00           H  
ATOM   1663  HB3 ALA A 105      32.485 100.990  -1.378  0.00  0.00           H  
ATOM   1664  N   PHE A 106      30.493  99.114   0.725  0.00  0.00           N  
ATOM   1665  CA  PHE A 106      30.557  98.619   2.097  0.00  0.00           C  
ATOM   1666  C   PHE A 106      29.888  97.242   2.218  0.00  0.00           C  
ATOM   1667  O   PHE A 106      30.222  96.474   3.122  0.00  0.00           O  
ATOM   1668  CB  PHE A 106      29.814  99.581   3.043  0.00  0.00           C  
ATOM   1669  CG  PHE A 106      30.452 100.908   3.430  0.00  0.00           C  
ATOM   1670  CD1 PHE A 106      31.411 101.558   2.629  0.00  0.00           C  
ATOM   1671  CD2 PHE A 106      30.089 101.491   4.661  0.00  0.00           C  
ATOM   1672  CE1 PHE A 106      31.992 102.756   3.074  0.00  0.00           C  
ATOM   1673  CE2 PHE A 106      30.634 102.717   5.077  0.00  0.00           C  
ATOM   1674  CZ  PHE A 106      31.586 103.359   4.274  0.00  0.00           C  
ATOM   1675  H   PHE A 106      29.753  99.776   0.516  0.00  0.00           H  
ATOM   1676  HA  PHE A 106      31.598  98.538   2.410  0.00  0.00           H  
ATOM   1677  HB2 PHE A 106      28.816  99.775   2.650  0.00  0.00           H  
ATOM   1678  HB3 PHE A 106      29.681  99.036   3.973  0.00  0.00           H  
ATOM   1679  HD1 PHE A 106      31.754 101.125   1.703  0.00  0.00           H  
ATOM   1680  HD2 PHE A 106      29.381 100.994   5.304  0.00  0.00           H  
ATOM   1681  HE1 PHE A 106      32.787 103.196   2.510  0.00  0.00           H  
ATOM   1682  HE2 PHE A 106      30.334 103.154   6.020  0.00  0.00           H  
ATOM   1683  HZ  PHE A 106      32.023 104.295   4.589  0.00  0.00           H  
ATOM   1684  N   GLU A 107      28.940  96.932   1.323  0.00  0.00           N  
ATOM   1685  CA  GLU A 107      28.050  95.770   1.411  0.00  0.00           C  
ATOM   1686  C   GLU A 107      27.252  95.748   2.732  0.00  0.00           C  
ATOM   1687  O   GLU A 107      27.140  94.723   3.411  0.00  0.00           O  
ATOM   1688  CB  GLU A 107      28.805  94.482   1.029  0.00  0.00           C  
ATOM   1689  CG  GLU A 107      27.887  93.494   0.296  0.00  0.00           C  
ATOM   1690  CD  GLU A 107      28.654  92.236  -0.150  0.00  0.00           C  
ATOM   1691  OE1 GLU A 107      28.727  91.255   0.629  0.00  0.00           O  
ATOM   1692  OE2 GLU A 107      29.174  92.208  -1.294  0.00  0.00           O  
ATOM   1693  H   GLU A 107      28.772  97.579   0.567  0.00  0.00           H  
ATOM   1694  HA  GLU A 107      27.299  95.911   0.639  0.00  0.00           H  
ATOM   1695  HB2 GLU A 107      29.625  94.735   0.354  0.00  0.00           H  
ATOM   1696  HB3 GLU A 107      29.233  94.014   1.917  0.00  0.00           H  
ATOM   1697  HG2 GLU A 107      27.056  93.216   0.945  0.00  0.00           H  
ATOM   1698  HG3 GLU A 107      27.468  93.989  -0.585  0.00  0.00           H  
ATOM   1699  N   ASN A 108      26.701  96.920   3.086  0.00  0.00           N  
ATOM   1700  CA  ASN A 108      25.771  97.156   4.194  0.00  0.00           C  
ATOM   1701  C   ASN A 108      24.725  96.047   4.350  0.00  0.00           C  
ATOM   1702  O   ASN A 108      23.943  95.793   3.430  0.00  0.00           O  
ATOM   1703  CB  ASN A 108      25.072  98.511   3.997  0.00  0.00           C  
ATOM   1704  CG  ASN A 108      23.751  98.636   4.757  0.00  0.00           C  
ATOM   1705  OD1 ASN A 108      22.695  98.785   4.149  0.00  0.00           O  
ATOM   1706  ND2 ASN A 108      23.763  98.577   6.084  0.00  0.00           N  
ATOM   1707  H   ASN A 108      26.919  97.717   2.510  0.00  0.00           H  
ATOM   1708  HA  ASN A 108      26.347  97.214   5.111  0.00  0.00           H  
ATOM   1709  HB2 ASN A 108      25.740  99.314   4.292  0.00  0.00           H  
ATOM   1710  HB3 ASN A 108      24.853  98.640   2.939  0.00  0.00           H  
ATOM   1711 HD21 ASN A 108      24.625  98.517   6.605  0.00  0.00           H  
ATOM   1712 HD22 ASN A 108      22.885  98.664   6.585  0.00  0.00           H  
ATOM   1713  N   GLU A 109      24.678  95.437   5.538  0.00  0.00           N  
ATOM   1714  CA  GLU A 109      23.669  94.451   5.924  0.00  0.00           C  
ATOM   1715  C   GLU A 109      23.574  94.393   7.466  0.00  0.00           C  
ATOM   1716  O   GLU A 109      23.476  93.322   8.070  0.00  0.00           O  
ATOM   1717  CB  GLU A 109      24.014  93.096   5.267  0.00  0.00           C  
ATOM   1718  CG  GLU A 109      22.791  92.172   5.165  0.00  0.00           C  
ATOM   1719  CD  GLU A 109      23.072  90.973   4.243  0.00  0.00           C  
ATOM   1720  OE1 GLU A 109      23.783  90.026   4.662  0.00  0.00           O  
ATOM   1721  OE2 GLU A 109      22.565  90.953   3.093  0.00  0.00           O  
ATOM   1722  H   GLU A 109      25.388  95.649   6.227  0.00  0.00           H  
ATOM   1723  HA  GLU A 109      22.707  94.795   5.538  0.00  0.00           H  
ATOM   1724  HB2 GLU A 109      24.372  93.272   4.252  0.00  0.00           H  
ATOM   1725  HB3 GLU A 109      24.818  92.604   5.818  0.00  0.00           H  
ATOM   1726  HG2 GLU A 109      22.510  91.812   6.156  0.00  0.00           H  
ATOM   1727  HG3 GLU A 109      21.949  92.744   4.766  0.00  0.00           H  
ATOM   1728  N   TYR A 110      23.693  95.553   8.120  0.00  0.00           N  
ATOM   1729  CA  TYR A 110      23.862  95.697   9.566  0.00  0.00           C  
ATOM   1730  C   TYR A 110      23.313  97.062   9.990  0.00  0.00           C  
ATOM   1731  O   TYR A 110      23.405  98.026   9.225  0.00  0.00           O  
ATOM   1732  CB  TYR A 110      25.360  95.574   9.921  0.00  0.00           C  
ATOM   1733  CG  TYR A 110      26.307  96.280   8.960  0.00  0.00           C  
ATOM   1734  CD1 TYR A 110      26.425  97.680   8.987  0.00  0.00           C  
ATOM   1735  CD2 TYR A 110      27.019  95.540   7.994  0.00  0.00           C  
ATOM   1736  CE1 TYR A 110      27.231  98.350   8.055  0.00  0.00           C  
ATOM   1737  CE2 TYR A 110      27.822  96.201   7.049  0.00  0.00           C  
ATOM   1738  CZ  TYR A 110      27.922  97.610   7.073  0.00  0.00           C  
ATOM   1739  OH  TYR A 110      28.643  98.251   6.118  0.00  0.00           O  
ATOM   1740  H   TYR A 110      23.708  96.417   7.594  0.00  0.00           H  
ATOM   1741  HA  TYR A 110      23.308  94.915  10.085  0.00  0.00           H  
ATOM   1742  HB2 TYR A 110      25.525  95.959  10.929  0.00  0.00           H  
ATOM   1743  HB3 TYR A 110      25.617  94.514   9.943  0.00  0.00           H  
ATOM   1744  HD1 TYR A 110      25.868  98.254   9.710  0.00  0.00           H  
ATOM   1745  HD2 TYR A 110      26.940  94.462   7.965  0.00  0.00           H  
ATOM   1746  HE1 TYR A 110      27.304  99.429   8.084  0.00  0.00           H  
ATOM   1747  HE2 TYR A 110      28.355  95.635   6.296  0.00  0.00           H  
ATOM   1748  HH  TYR A 110      28.713  99.208   6.266  0.00  0.00           H  
ATOM   1749  N   VAL A 111      22.757  97.150  11.201  0.00  0.00           N  
ATOM   1750  CA  VAL A 111      22.300  98.391  11.831  0.00  0.00           C  
ATOM   1751  C   VAL A 111      22.084  98.141  13.339  0.00  0.00           C  
ATOM   1752  O   VAL A 111      21.662  97.035  13.698  0.00  0.00           O  
ATOM   1753  CB  VAL A 111      20.978  98.923  11.204  0.00  0.00           C  
ATOM   1754  CG1 VAL A 111      21.246 100.213  10.417  0.00  0.00           C  
ATOM   1755  CG2 VAL A 111      20.194  97.943  10.314  0.00  0.00           C  
ATOM   1756  H   VAL A 111      22.687  96.319  11.776  0.00  0.00           H  
ATOM   1757  HA  VAL A 111      23.085  99.132  11.691  0.00  0.00           H  
ATOM   1758  HB  VAL A 111      20.306  99.203  12.015  0.00  0.00           H  
ATOM   1759 HG11 VAL A 111      21.709 100.941  11.074  0.00  0.00           H  
ATOM   1760 HG12 VAL A 111      21.905 100.026   9.572  0.00  0.00           H  
ATOM   1761 HG13 VAL A 111      20.309 100.625  10.047  0.00  0.00           H  
ATOM   1762 HG21 VAL A 111      20.737  97.745   9.391  0.00  0.00           H  
ATOM   1763 HG22 VAL A 111      20.022  97.006  10.842  0.00  0.00           H  
ATOM   1764 HG23 VAL A 111      19.232  98.383  10.053  0.00  0.00           H  
ATOM   1765  N   PRO A 112      22.291  99.143  14.218  0.00  0.00           N  
ATOM   1766  CA  PRO A 112      23.104 100.330  13.972  0.00  0.00           C  
ATOM   1767  C   PRO A 112      24.574  99.934  13.789  0.00  0.00           C  
ATOM   1768  O   PRO A 112      25.019  98.913  14.325  0.00  0.00           O  
ATOM   1769  CB  PRO A 112      22.934 101.219  15.207  0.00  0.00           C  
ATOM   1770  CG  PRO A 112      22.610 100.229  16.323  0.00  0.00           C  
ATOM   1771  CD  PRO A 112      21.858  99.105  15.609  0.00  0.00           C  
ATOM   1772  HA  PRO A 112      22.744 100.864  13.096  0.00  0.00           H  
ATOM   1773  HB2 PRO A 112      23.832 101.795  15.424  0.00  0.00           H  
ATOM   1774  HB3 PRO A 112      22.097 101.900  15.061  0.00  0.00           H  
ATOM   1775  HG2 PRO A 112      23.533  99.831  16.743  0.00  0.00           H  
ATOM   1776  HG3 PRO A 112      22.005 100.694  17.101  0.00  0.00           H  
ATOM   1777  HD2 PRO A 112      22.088  98.145  16.072  0.00  0.00           H  
ATOM   1778  HD3 PRO A 112      20.786  99.293  15.653  0.00  0.00           H  
ATOM   1779  N   ALA A 113      25.338 100.747  13.058  0.00  0.00           N  
ATOM   1780  CA  ALA A 113      26.776 100.565  12.897  0.00  0.00           C  
ATOM   1781  C   ALA A 113      27.461 101.903  12.671  0.00  0.00           C  
ATOM   1782  O   ALA A 113      26.813 102.884  12.300  0.00  0.00           O  
ATOM   1783  CB  ALA A 113      27.068  99.624  11.727  0.00  0.00           C  
ATOM   1784  H   ALA A 113      24.941 101.602  12.680  0.00  0.00           H  
ATOM   1785  HA  ALA A 113      27.182 100.140  13.811  0.00  0.00           H  
ATOM   1786  HB1 ALA A 113      26.581  98.663  11.895  0.00  0.00           H  
ATOM   1787  HB2 ALA A 113      26.708 100.074  10.800  0.00  0.00           H  
ATOM   1788  HB3 ALA A 113      28.143  99.464  11.648  0.00  0.00           H  
ATOM   1789  N   TYR A 114      28.776 101.928  12.880  0.00  0.00           N  
ATOM   1790  CA  TYR A 114      29.555 103.142  13.035  0.00  0.00           C  
ATOM   1791  C   TYR A 114      30.920 102.900  12.395  0.00  0.00           C  
ATOM   1792  O   TYR A 114      31.518 101.841  12.600  0.00  0.00           O  
ATOM   1793  CB  TYR A 114      29.717 103.462  14.533  0.00  0.00           C  
ATOM   1794  CG  TYR A 114      28.576 103.026  15.443  0.00  0.00           C  
ATOM   1795  CD1 TYR A 114      27.346 103.707  15.421  0.00  0.00           C  
ATOM   1796  CD2 TYR A 114      28.731 101.900  16.274  0.00  0.00           C  
ATOM   1797  CE1 TYR A 114      26.261 103.241  16.182  0.00  0.00           C  
ATOM   1798  CE2 TYR A 114      27.661 101.443  17.063  0.00  0.00           C  
ATOM   1799  CZ  TYR A 114      26.411 102.105  17.006  0.00  0.00           C  
ATOM   1800  OH  TYR A 114      25.341 101.666  17.728  0.00  0.00           O  
ATOM   1801  H   TYR A 114      29.249 101.067  13.138  0.00  0.00           H  
ATOM   1802  HA  TYR A 114      29.048 103.972  12.541  0.00  0.00           H  
ATOM   1803  HB2 TYR A 114      30.630 102.988  14.889  0.00  0.00           H  
ATOM   1804  HB3 TYR A 114      29.859 104.534  14.634  0.00  0.00           H  
ATOM   1805  HD1 TYR A 114      27.224 104.582  14.803  0.00  0.00           H  
ATOM   1806  HD2 TYR A 114      29.673 101.374  16.298  0.00  0.00           H  
ATOM   1807  HE1 TYR A 114      25.312 103.758  16.142  0.00  0.00           H  
ATOM   1808  HE2 TYR A 114      27.804 100.582  17.698  0.00  0.00           H  
ATOM   1809  HH  TYR A 114      25.548 100.968  18.370  0.00  0.00           H  
ATOM   1810  N   TYR A 115      31.413 103.880  11.641  0.00  0.00           N  
ATOM   1811  CA  TYR A 115      32.634 103.804  10.852  0.00  0.00           C  
ATOM   1812  C   TYR A 115      33.376 105.121  11.073  0.00  0.00           C  
ATOM   1813  O   TYR A 115      32.817 106.194  10.825  0.00  0.00           O  
ATOM   1814  CB  TYR A 115      32.279 103.593   9.369  0.00  0.00           C  
ATOM   1815  CG  TYR A 115      31.865 102.181   8.984  0.00  0.00           C  
ATOM   1816  CD1 TYR A 115      30.591 101.676   9.312  0.00  0.00           C  
ATOM   1817  CD2 TYR A 115      32.772 101.358   8.292  0.00  0.00           C  
ATOM   1818  CE1 TYR A 115      30.254 100.344   9.006  0.00  0.00           C  
ATOM   1819  CE2 TYR A 115      32.448 100.027   7.994  0.00  0.00           C  
ATOM   1820  CZ  TYR A 115      31.191  99.505   8.357  0.00  0.00           C  
ATOM   1821  OH  TYR A 115      30.931  98.191   8.101  0.00  0.00           O  
ATOM   1822  H   TYR A 115      30.867 104.728  11.515  0.00  0.00           H  
ATOM   1823  HA  TYR A 115      33.255 102.973  11.190  0.00  0.00           H  
ATOM   1824  HB2 TYR A 115      31.489 104.286   9.082  0.00  0.00           H  
ATOM   1825  HB3 TYR A 115      33.159 103.851   8.781  0.00  0.00           H  
ATOM   1826  HD1 TYR A 115      29.875 102.302   9.820  0.00  0.00           H  
ATOM   1827  HD2 TYR A 115      33.733 101.737   7.995  0.00  0.00           H  
ATOM   1828  HE1 TYR A 115      29.291  99.960   9.301  0.00  0.00           H  
ATOM   1829  HE2 TYR A 115      33.170  99.396   7.502  0.00  0.00           H  
ATOM   1830  HH  TYR A 115      30.062  97.901   8.420  0.00  0.00           H  
ATOM   1831  N   VAL A 116      34.608 105.057  11.575  0.00  0.00           N  
ATOM   1832  CA  VAL A 116      35.362 106.225  12.035  0.00  0.00           C  
ATOM   1833  C   VAL A 116      36.561 106.376  11.099  0.00  0.00           C  
ATOM   1834  O   VAL A 116      37.245 105.389  10.830  0.00  0.00           O  
ATOM   1835  CB  VAL A 116      35.786 106.046  13.514  0.00  0.00           C  
ATOM   1836  CG1 VAL A 116      36.286 107.377  14.100  0.00  0.00           C  
ATOM   1837  CG2 VAL A 116      34.642 105.551  14.414  0.00  0.00           C  
ATOM   1838  H   VAL A 116      35.047 104.148  11.697  0.00  0.00           H  
ATOM   1839  HA  VAL A 116      34.732 107.112  11.962  0.00  0.00           H  
ATOM   1840  HB  VAL A 116      36.594 105.316  13.570  0.00  0.00           H  
ATOM   1841 HG11 VAL A 116      37.122 107.754  13.510  0.00  0.00           H  
ATOM   1842 HG12 VAL A 116      35.487 108.120  14.088  0.00  0.00           H  
ATOM   1843 HG13 VAL A 116      36.624 107.231  15.127  0.00  0.00           H  
ATOM   1844 HG21 VAL A 116      33.785 106.220  14.332  0.00  0.00           H  
ATOM   1845 HG22 VAL A 116      34.339 104.540  14.131  0.00  0.00           H  
ATOM   1846 HG23 VAL A 116      34.971 105.518  15.454  0.00  0.00           H  
ATOM   1847  N   PHE A 117      36.831 107.584  10.604  0.00  0.00           N  
ATOM   1848  CA  PHE A 117      37.826 107.834   9.562  0.00  0.00           C  
ATOM   1849  C   PHE A 117      38.770 108.944  10.020  0.00  0.00           C  
ATOM   1850  O   PHE A 117      38.342 109.889  10.682  0.00  0.00           O  
ATOM   1851  CB  PHE A 117      37.141 108.243   8.245  0.00  0.00           C  
ATOM   1852  CG  PHE A 117      36.187 107.233   7.631  0.00  0.00           C  
ATOM   1853  CD1 PHE A 117      34.880 107.082   8.128  0.00  0.00           C  
ATOM   1854  CD2 PHE A 117      36.582 106.470   6.519  0.00  0.00           C  
ATOM   1855  CE1 PHE A 117      34.002 106.160   7.540  0.00  0.00           C  
ATOM   1856  CE2 PHE A 117      35.703 105.558   5.917  0.00  0.00           C  
ATOM   1857  CZ  PHE A 117      34.413 105.395   6.439  0.00  0.00           C  
ATOM   1858  H   PHE A 117      36.287 108.381  10.921  0.00  0.00           H  
ATOM   1859  HA  PHE A 117      38.403 106.928   9.380  0.00  0.00           H  
ATOM   1860  HB2 PHE A 117      36.593 109.166   8.412  0.00  0.00           H  
ATOM   1861  HB3 PHE A 117      37.922 108.469   7.517  0.00  0.00           H  
ATOM   1862  HD1 PHE A 117      34.546 107.670   8.967  0.00  0.00           H  
ATOM   1863  HD2 PHE A 117      37.572 106.578   6.121  0.00  0.00           H  
ATOM   1864  HE1 PHE A 117      33.004 106.042   7.935  0.00  0.00           H  
ATOM   1865  HE2 PHE A 117      36.026 104.977   5.062  0.00  0.00           H  
ATOM   1866  HZ  PHE A 117      33.743 104.676   5.998  0.00  0.00           H  
ATOM   1867  N   ASP A 118      40.042 108.835   9.642  0.00  0.00           N  
ATOM   1868  CA  ASP A 118      41.073 109.867   9.816  0.00  0.00           C  
ATOM   1869  C   ASP A 118      40.819 111.028   8.838  0.00  0.00           C  
ATOM   1870  O   ASP A 118      40.023 110.887   7.907  0.00  0.00           O  
ATOM   1871  CB  ASP A 118      42.449 109.204   9.629  0.00  0.00           C  
ATOM   1872  CG  ASP A 118      43.528 110.145   9.077  0.00  0.00           C  
ATOM   1873  OD1 ASP A 118      44.205 110.830   9.874  0.00  0.00           O  
ATOM   1874  OD2 ASP A 118      43.660 110.209   7.836  0.00  0.00           O  
ATOM   1875  H   ASP A 118      40.283 108.055   9.037  0.00  0.00           H  
ATOM   1876  HA  ASP A 118      41.027 110.264  10.831  0.00  0.00           H  
ATOM   1877  HB2 ASP A 118      42.773 108.801  10.591  0.00  0.00           H  
ATOM   1878  HB3 ASP A 118      42.346 108.361   8.947  0.00  0.00           H  
ATOM   1879  N   LYS A 119      41.457 112.190   9.036  0.00  0.00           N  
ATOM   1880  CA  LYS A 119      41.187 113.392   8.242  0.00  0.00           C  
ATOM   1881  C   LYS A 119      41.490 113.281   6.745  0.00  0.00           C  
ATOM   1882  O   LYS A 119      41.063 114.180   6.023  0.00  0.00           O  
ATOM   1883  CB  LYS A 119      41.872 114.634   8.849  0.00  0.00           C  
ATOM   1884  CG  LYS A 119      43.413 114.589   8.837  0.00  0.00           C  
ATOM   1885  CD  LYS A 119      44.065 115.896   8.353  0.00  0.00           C  
ATOM   1886  CE  LYS A 119      44.093 115.965   6.817  0.00  0.00           C  
ATOM   1887  NZ  LYS A 119      44.790 117.182   6.320  0.00  0.00           N  
ATOM   1888  H   LYS A 119      42.153 112.249   9.769  0.00  0.00           H  
ATOM   1889  HA  LYS A 119      40.109 113.556   8.304  0.00  0.00           H  
ATOM   1890  HB2 LYS A 119      41.524 115.511   8.301  0.00  0.00           H  
ATOM   1891  HB3 LYS A 119      41.539 114.755   9.880  0.00  0.00           H  
ATOM   1892  HG2 LYS A 119      43.751 114.412   9.854  0.00  0.00           H  
ATOM   1893  HG3 LYS A 119      43.774 113.761   8.228  0.00  0.00           H  
ATOM   1894  HD2 LYS A 119      43.534 116.755   8.769  0.00  0.00           H  
ATOM   1895  HD3 LYS A 119      45.092 115.917   8.724  0.00  0.00           H  
ATOM   1896  HE2 LYS A 119      44.618 115.081   6.445  0.00  0.00           H  
ATOM   1897  HE3 LYS A 119      43.071 115.941   6.431  0.00  0.00           H  
ATOM   1898  HZ1 LYS A 119      44.250 118.022   6.510  0.00  0.00           H  
ATOM   1899  HZ2 LYS A 119      45.707 117.284   6.735  0.00  0.00           H  
ATOM   1900  HZ3 LYS A 119      44.916 117.140   5.317  0.00  0.00           H  
ATOM   1901  N   THR A 120      42.198 112.259   6.251  0.00  0.00           N  
ATOM   1902  CA  THR A 120      42.346 112.047   4.804  0.00  0.00           C  
ATOM   1903  C   THR A 120      41.228 111.138   4.262  0.00  0.00           C  
ATOM   1904  O   THR A 120      41.119 110.937   3.049  0.00  0.00           O  
ATOM   1905  CB  THR A 120      43.747 111.511   4.449  0.00  0.00           C  
ATOM   1906  OG1 THR A 120      43.896 110.158   4.841  0.00  0.00           O  
ATOM   1907  CG2 THR A 120      44.875 112.343   5.076  0.00  0.00           C  
ATOM   1908  H   THR A 120      42.611 111.561   6.867  0.00  0.00           H  
ATOM   1909  HA  THR A 120      42.243 113.008   4.298  0.00  0.00           H  
ATOM   1910  HB  THR A 120      43.855 111.564   3.365  0.00  0.00           H  
ATOM   1911  HG1 THR A 120      44.586 109.754   4.281  0.00  0.00           H  
ATOM   1912 HG21 THR A 120      44.755 113.392   4.803  0.00  0.00           H  
ATOM   1913 HG22 THR A 120      44.867 112.250   6.164  0.00  0.00           H  
ATOM   1914 HG23 THR A 120      45.840 111.998   4.702  0.00  0.00           H  
ATOM   1915  N   GLY A 121      40.388 110.588   5.146  0.00  0.00           N  
ATOM   1916  CA  GLY A 121      39.234 109.775   4.808  0.00  0.00           C  
ATOM   1917  C   GLY A 121      39.518 108.285   4.777  0.00  0.00           C  
ATOM   1918  O   GLY A 121      38.714 107.552   4.211  0.00  0.00           O  
ATOM   1919  H   GLY A 121      40.515 110.795   6.132  0.00  0.00           H  
ATOM   1920  HA2 GLY A 121      38.476 109.950   5.569  0.00  0.00           H  
ATOM   1921  HA3 GLY A 121      38.839 110.068   3.840  0.00  0.00           H  
ATOM   1922  N   GLN A 122      40.634 107.829   5.348  0.00  0.00           N  
ATOM   1923  CA  GLN A 122      40.929 106.408   5.490  0.00  0.00           C  
ATOM   1924  C   GLN A 122      40.217 105.866   6.736  0.00  0.00           C  
ATOM   1925  O   GLN A 122      40.284 106.476   7.806  0.00  0.00           O  
ATOM   1926  CB  GLN A 122      42.453 106.190   5.495  0.00  0.00           C  
ATOM   1927  CG  GLN A 122      43.181 106.833   6.684  0.00  0.00           C  
ATOM   1928  CD  GLN A 122      44.695 106.918   6.481  0.00  0.00           C  
ATOM   1929  OE1 GLN A 122      45.364 105.920   6.210  0.00  0.00           O  
ATOM   1930  NE2 GLN A 122      45.268 108.104   6.625  0.00  0.00           N  
ATOM   1931  H   GLN A 122      41.257 108.488   5.791  0.00  0.00           H  
ATOM   1932  HA  GLN A 122      40.537 105.895   4.614  0.00  0.00           H  
ATOM   1933  HB2 GLN A 122      42.661 105.122   5.488  0.00  0.00           H  
ATOM   1934  HB3 GLN A 122      42.856 106.611   4.572  0.00  0.00           H  
ATOM   1935  HG2 GLN A 122      42.795 107.840   6.825  0.00  0.00           H  
ATOM   1936  HG3 GLN A 122      42.979 106.258   7.587  0.00  0.00           H  
ATOM   1937 HE21 GLN A 122      44.683 108.926   6.830  0.00  0.00           H  
ATOM   1938 HE22 GLN A 122      46.259 108.223   6.468  0.00  0.00           H  
ATOM   1939  N   LEU A 123      39.510 104.743   6.591  0.00  0.00           N  
ATOM   1940  CA  LEU A 123      38.746 104.080   7.649  0.00  0.00           C  
ATOM   1941  C   LEU A 123      39.691 103.604   8.758  0.00  0.00           C  
ATOM   1942  O   LEU A 123      40.564 102.782   8.494  0.00  0.00           O  
ATOM   1943  CB  LEU A 123      37.982 102.911   6.991  0.00  0.00           C  
ATOM   1944  CG  LEU A 123      37.152 102.018   7.933  0.00  0.00           C  
ATOM   1945  CD1 LEU A 123      36.139 102.808   8.761  0.00  0.00           C  
ATOM   1946  CD2 LEU A 123      36.402 100.970   7.105  0.00  0.00           C  
ATOM   1947  H   LEU A 123      39.444 104.346   5.657  0.00  0.00           H  
ATOM   1948  HA  LEU A 123      38.028 104.788   8.066  0.00  0.00           H  
ATOM   1949  HB2 LEU A 123      37.316 103.326   6.235  0.00  0.00           H  
ATOM   1950  HB3 LEU A 123      38.702 102.277   6.471  0.00  0.00           H  
ATOM   1951  HG  LEU A 123      37.824 101.500   8.615  0.00  0.00           H  
ATOM   1952 HD11 LEU A 123      36.653 103.437   9.479  0.00  0.00           H  
ATOM   1953 HD12 LEU A 123      35.524 103.435   8.116  0.00  0.00           H  
ATOM   1954 HD13 LEU A 123      35.503 102.124   9.322  0.00  0.00           H  
ATOM   1955 HD21 LEU A 123      35.668 101.454   6.458  0.00  0.00           H  
ATOM   1956 HD22 LEU A 123      37.103 100.417   6.484  0.00  0.00           H  
ATOM   1957 HD23 LEU A 123      35.891 100.266   7.763  0.00  0.00           H  
ATOM   1958  N   ARG A 124      39.534 104.087   9.991  0.00  0.00           N  
ATOM   1959  CA  ARG A 124      40.400 103.718  11.117  0.00  0.00           C  
ATOM   1960  C   ARG A 124      39.783 102.614  11.972  0.00  0.00           C  
ATOM   1961  O   ARG A 124      40.534 101.792  12.498  0.00  0.00           O  
ATOM   1962  CB  ARG A 124      40.710 104.950  11.991  0.00  0.00           C  
ATOM   1963  CG  ARG A 124      41.453 106.079  11.255  0.00  0.00           C  
ATOM   1964  CD  ARG A 124      42.831 105.688  10.694  0.00  0.00           C  
ATOM   1965  NE  ARG A 124      43.822 105.438  11.755  0.00  0.00           N  
ATOM   1966  CZ  ARG A 124      45.067 104.976  11.581  0.00  0.00           C  
ATOM   1967  NH1 ARG A 124      45.524 104.632  10.375  0.00  0.00           N  
ATOM   1968  NH2 ARG A 124      45.853 104.870  12.643  0.00  0.00           N  
ATOM   1969  H   ARG A 124      38.774 104.735  10.170  0.00  0.00           H  
ATOM   1970  HA  ARG A 124      41.341 103.320  10.731  0.00  0.00           H  
ATOM   1971  HB2 ARG A 124      39.772 105.351  12.380  0.00  0.00           H  
ATOM   1972  HB3 ARG A 124      41.314 104.635  12.844  0.00  0.00           H  
ATOM   1973  HG2 ARG A 124      40.833 106.410  10.427  0.00  0.00           H  
ATOM   1974  HG3 ARG A 124      41.574 106.922  11.936  0.00  0.00           H  
ATOM   1975  HD2 ARG A 124      42.729 104.808  10.060  0.00  0.00           H  
ATOM   1976  HD3 ARG A 124      43.198 106.505  10.077  0.00  0.00           H  
ATOM   1977  HE  ARG A 124      43.555 105.693  12.706  0.00  0.00           H  
ATOM   1978 HH11 ARG A 124      44.941 104.714   9.554  0.00  0.00           H  
ATOM   1979 HH12 ARG A 124      46.470 104.293  10.239  0.00  0.00           H  
ATOM   1980 HH21 ARG A 124      45.471 105.168  13.549  0.00  0.00           H  
ATOM   1981 HH22 ARG A 124      46.809 104.538  12.600  0.00  0.00           H  
ATOM   1982  N   HIS A 125      38.454 102.562  12.113  0.00  0.00           N  
ATOM   1983  CA  HIS A 125      37.772 101.525  12.888  0.00  0.00           C  
ATOM   1984  C   HIS A 125      36.314 101.407  12.444  0.00  0.00           C  
ATOM   1985  O   HIS A 125      35.739 102.373  11.936  0.00  0.00           O  
ATOM   1986  CB  HIS A 125      37.834 101.869  14.387  0.00  0.00           C  
ATOM   1987  CG  HIS A 125      37.403 100.738  15.291  0.00  0.00           C  
ATOM   1988  ND1 HIS A 125      38.137  99.610  15.588  0.00  0.00           N  
ATOM   1989  CD2 HIS A 125      36.217 100.633  15.973  0.00  0.00           C  
ATOM   1990  CE1 HIS A 125      37.412  98.848  16.427  0.00  0.00           C  
ATOM   1991  NE2 HIS A 125      36.237  99.441  16.708  0.00  0.00           N  
ATOM   1992  H   HIS A 125      37.869 103.255  11.661  0.00  0.00           H  
ATOM   1993  HA  HIS A 125      38.274 100.570  12.722  0.00  0.00           H  
ATOM   1994  HB2 HIS A 125      38.859 102.127  14.654  0.00  0.00           H  
ATOM   1995  HB3 HIS A 125      37.211 102.745  14.577  0.00  0.00           H  
ATOM   1996  HD1 HIS A 125      39.063  99.378  15.235  0.00  0.00           H  
ATOM   1997  HD2 HIS A 125      35.406 101.351  15.946  0.00  0.00           H  
ATOM   1998  HE1 HIS A 125      37.737  97.892  16.822  0.00  0.00           H  
ATOM   1999  N   PHE A 126      35.704 100.251  12.711  0.00  0.00           N  
ATOM   2000  CA  PHE A 126      34.295  99.951  12.479  0.00  0.00           C  
ATOM   2001  C   PHE A 126      33.780  99.142  13.676  0.00  0.00           C  
ATOM   2002  O   PHE A 126      34.488  98.262  14.177  0.00  0.00           O  
ATOM   2003  CB  PHE A 126      34.141  99.169  11.158  0.00  0.00           C  
ATOM   2004  CG  PHE A 126      33.061  98.094  11.160  0.00  0.00           C  
ATOM   2005  CD1 PHE A 126      31.705  98.444  11.297  0.00  0.00           C  
ATOM   2006  CD2 PHE A 126      33.420  96.731  11.091  0.00  0.00           C  
ATOM   2007  CE1 PHE A 126      30.717  97.446  11.362  0.00  0.00           C  
ATOM   2008  CE2 PHE A 126      32.431  95.733  11.162  0.00  0.00           C  
ATOM   2009  CZ  PHE A 126      31.079  96.090  11.299  0.00  0.00           C  
ATOM   2010  H   PHE A 126      36.222  99.529  13.195  0.00  0.00           H  
ATOM   2011  HA  PHE A 126      33.734 100.881  12.408  0.00  0.00           H  
ATOM   2012  HB2 PHE A 126      33.929  99.885  10.365  0.00  0.00           H  
ATOM   2013  HB3 PHE A 126      35.091  98.694  10.909  0.00  0.00           H  
ATOM   2014  HD1 PHE A 126      31.418  99.485  11.361  0.00  0.00           H  
ATOM   2015  HD2 PHE A 126      34.459  96.446  10.999  0.00  0.00           H  
ATOM   2016  HE1 PHE A 126      29.679  97.724  11.458  0.00  0.00           H  
ATOM   2017  HE2 PHE A 126      32.713  94.690  11.115  0.00  0.00           H  
ATOM   2018  HZ  PHE A 126      30.317  95.323  11.354  0.00  0.00           H  
ATOM   2019  N   GLN A 127      32.545  99.415  14.106  0.00  0.00           N  
ATOM   2020  CA  GLN A 127      31.840  98.671  15.146  0.00  0.00           C  
ATOM   2021  C   GLN A 127      30.335  98.672  14.830  0.00  0.00           C  
ATOM   2022  O   GLN A 127      29.865  99.533  14.081  0.00  0.00           O  
ATOM   2023  CB  GLN A 127      32.167  99.326  16.506  0.00  0.00           C  
ATOM   2024  CG  GLN A 127      31.690  98.544  17.738  0.00  0.00           C  
ATOM   2025  CD  GLN A 127      32.200  97.099  17.760  0.00  0.00           C  
ATOM   2026  OE1 GLN A 127      31.416  96.153  17.722  0.00  0.00           O  
ATOM   2027  NE2 GLN A 127      33.508  96.884  17.784  0.00  0.00           N  
ATOM   2028  H   GLN A 127      31.999 100.122  13.617  0.00  0.00           H  
ATOM   2029  HA  GLN A 127      32.197  97.640  15.139  0.00  0.00           H  
ATOM   2030  HB2 GLN A 127      33.249  99.441  16.588  0.00  0.00           H  
ATOM   2031  HB3 GLN A 127      31.736 100.328  16.536  0.00  0.00           H  
ATOM   2032  HG2 GLN A 127      32.043  99.056  18.632  0.00  0.00           H  
ATOM   2033  HG3 GLN A 127      30.599  98.551  17.775  0.00  0.00           H  
ATOM   2034 HE21 GLN A 127      34.158  97.663  17.752  0.00  0.00           H  
ATOM   2035 HE22 GLN A 127      33.870  95.937  17.784  0.00  0.00           H  
ATOM   2036  N   ALA A 128      29.566  97.738  15.405  0.00  0.00           N  
ATOM   2037  CA  ALA A 128      28.118  97.641  15.224  0.00  0.00           C  
ATOM   2038  C   ALA A 128      27.434  97.111  16.487  0.00  0.00           C  
ATOM   2039  O   ALA A 128      28.061  96.435  17.306  0.00  0.00           O  
ATOM   2040  CB  ALA A 128      27.810  96.718  14.038  0.00  0.00           C  
ATOM   2041  H   ALA A 128      29.982  97.067  16.041  0.00  0.00           H  
ATOM   2042  HA  ALA A 128      27.719  98.630  15.022  0.00  0.00           H  
ATOM   2043  HB1 ALA A 128      28.261  97.115  13.131  0.00  0.00           H  
ATOM   2044  HB2 ALA A 128      28.204  95.718  14.228  0.00  0.00           H  
ATOM   2045  HB3 ALA A 128      26.731  96.651  13.890  0.00  0.00           H  
ATOM   2046  N   GLY A 129      26.133  97.392  16.612  0.00  0.00           N  
ATOM   2047  CA  GLY A 129      25.265  96.846  17.655  0.00  0.00           C  
ATOM   2048  C   GLY A 129      25.690  97.208  19.083  0.00  0.00           C  
ATOM   2049  O   GLY A 129      25.412  96.446  20.013  0.00  0.00           O  
ATOM   2050  H   GLY A 129      25.685  97.935  15.878  0.00  0.00           H  
ATOM   2051  HA2 GLY A 129      24.257  97.230  17.493  0.00  0.00           H  
ATOM   2052  HA3 GLY A 129      25.237  95.760  17.556  0.00  0.00           H  
ATOM   2053  N   GLY A 130      26.382  98.338  19.267  0.00  0.00           N  
ATOM   2054  CA  GLY A 130      26.758  98.844  20.585  0.00  0.00           C  
ATOM   2055  C   GLY A 130      25.535  99.290  21.397  0.00  0.00           C  
ATOM   2056  O   GLY A 130      24.432  99.444  20.858  0.00  0.00           O  
ATOM   2057  H   GLY A 130      26.599  98.904  18.463  0.00  0.00           H  
ATOM   2058  HA2 GLY A 130      27.286  98.062  21.132  0.00  0.00           H  
ATOM   2059  HA3 GLY A 130      27.432  99.694  20.471  0.00  0.00           H  
ATOM   2060  N   SER A 131      25.738  99.511  22.699  0.00  0.00           N  
ATOM   2061  CA  SER A 131      24.756 100.105  23.602  0.00  0.00           C  
ATOM   2062  C   SER A 131      24.662 101.600  23.280  0.00  0.00           C  
ATOM   2063  O   SER A 131      25.454 102.407  23.787  0.00  0.00           O  
ATOM   2064  CB  SER A 131      25.161  99.852  25.062  0.00  0.00           C  
ATOM   2065  OG  SER A 131      25.377  98.463  25.292  0.00  0.00           O  
ATOM   2066  H   SER A 131      26.653  99.332  23.087  0.00  0.00           H  
ATOM   2067  HA  SER A 131      23.783  99.641  23.430  0.00  0.00           H  
ATOM   2068  HB2 SER A 131      26.078 100.400  25.288  0.00  0.00           H  
ATOM   2069  HB3 SER A 131      24.367 100.216  25.718  0.00  0.00           H  
ATOM   2070  HG  SER A 131      25.622  98.344  26.234  0.00  0.00           H  
ATOM   2071  N   GLY A 132      23.764 101.958  22.356  0.00  0.00           N  
ATOM   2072  CA  GLY A 132      23.869 103.207  21.616  0.00  0.00           C  
ATOM   2073  C   GLY A 132      25.300 103.357  21.092  0.00  0.00           C  
ATOM   2074  O   GLY A 132      25.871 102.400  20.564  0.00  0.00           O  
ATOM   2075  H   GLY A 132      23.183 101.237  21.950  0.00  0.00           H  
ATOM   2076  HA2 GLY A 132      23.178 103.188  20.773  0.00  0.00           H  
ATOM   2077  HA3 GLY A 132      23.608 104.039  22.267  0.00  0.00           H  
ATOM   2078  N   MET A 133      25.910 104.526  21.297  0.00  0.00           N  
ATOM   2079  CA  MET A 133      27.270 104.815  20.837  0.00  0.00           C  
ATOM   2080  C   MET A 133      28.254 104.934  22.011  0.00  0.00           C  
ATOM   2081  O   MET A 133      29.268 105.623  21.897  0.00  0.00           O  
ATOM   2082  CB  MET A 133      27.260 106.079  19.960  0.00  0.00           C  
ATOM   2083  CG  MET A 133      26.302 105.994  18.765  0.00  0.00           C  
ATOM   2084  SD  MET A 133      26.786 106.992  17.325  0.00  0.00           S  
ATOM   2085  CE  MET A 133      27.245 108.566  18.109  0.00  0.00           C  
ATOM   2086  H   MET A 133      25.420 105.256  21.798  0.00  0.00           H  
ATOM   2087  HA  MET A 133      27.621 103.992  20.212  0.00  0.00           H  
ATOM   2088  HB2 MET A 133      26.998 106.949  20.566  0.00  0.00           H  
ATOM   2089  HB3 MET A 133      28.264 106.229  19.572  0.00  0.00           H  
ATOM   2090  HG2 MET A 133      26.237 104.955  18.438  0.00  0.00           H  
ATOM   2091  HG3 MET A 133      25.309 106.303  19.092  0.00  0.00           H  
ATOM   2092  HE1 MET A 133      26.448 108.889  18.779  0.00  0.00           H  
ATOM   2093  HE2 MET A 133      28.166 108.447  18.680  0.00  0.00           H  
ATOM   2094  HE3 MET A 133      27.406 109.322  17.340  0.00  0.00           H  
ATOM   2095  N   LYS A 134      27.966 104.332  23.176  0.00  0.00           N  
ATOM   2096  CA  LYS A 134      28.749 104.628  24.384  0.00  0.00           C  
ATOM   2097  C   LYS A 134      30.206 104.162  24.258  0.00  0.00           C  
ATOM   2098  O   LYS A 134      31.102 104.874  24.708  0.00  0.00           O  
ATOM   2099  CB  LYS A 134      28.056 104.056  25.638  0.00  0.00           C  
ATOM   2100  CG  LYS A 134      28.618 104.551  26.987  0.00  0.00           C  
ATOM   2101  CD  LYS A 134      28.333 106.019  27.375  0.00  0.00           C  
ATOM   2102  CE  LYS A 134      29.178 107.067  26.624  0.00  0.00           C  
ATOM   2103  NZ  LYS A 134      29.143 108.408  27.266  0.00  0.00           N  
ATOM   2104  H   LYS A 134      27.164 103.711  23.240  0.00  0.00           H  
ATOM   2105  HA  LYS A 134      28.770 105.712  24.454  0.00  0.00           H  
ATOM   2106  HB2 LYS A 134      26.993 104.293  25.610  0.00  0.00           H  
ATOM   2107  HB3 LYS A 134      28.142 102.967  25.612  0.00  0.00           H  
ATOM   2108  HG2 LYS A 134      28.164 103.930  27.761  0.00  0.00           H  
ATOM   2109  HG3 LYS A 134      29.691 104.369  27.033  0.00  0.00           H  
ATOM   2110  HD2 LYS A 134      27.271 106.231  27.232  0.00  0.00           H  
ATOM   2111  HD3 LYS A 134      28.547 106.112  28.442  0.00  0.00           H  
ATOM   2112  HE2 LYS A 134      30.214 106.720  26.576  0.00  0.00           H  
ATOM   2113  HE3 LYS A 134      28.803 107.169  25.605  0.00  0.00           H  
ATOM   2114  HZ1 LYS A 134      28.196 108.749  27.371  0.00  0.00           H  
ATOM   2115  HZ2 LYS A 134      29.578 108.389  28.179  0.00  0.00           H  
ATOM   2116  HZ3 LYS A 134      29.657 109.085  26.700  0.00  0.00           H  
ATOM   2117  N   MET A 135      30.452 103.016  23.616  0.00  0.00           N  
ATOM   2118  CA  MET A 135      31.816 102.545  23.345  0.00  0.00           C  
ATOM   2119  C   MET A 135      32.463 103.435  22.280  0.00  0.00           C  
ATOM   2120  O   MET A 135      33.619 103.832  22.414  0.00  0.00           O  
ATOM   2121  CB  MET A 135      31.776 101.067  22.906  0.00  0.00           C  
ATOM   2122  CG  MET A 135      33.105 100.313  23.092  0.00  0.00           C  
ATOM   2123  SD  MET A 135      34.562 100.818  22.122  0.00  0.00           S  
ATOM   2124  CE  MET A 135      33.933 100.666  20.423  0.00  0.00           C  
ATOM   2125  H   MET A 135      29.672 102.458  23.295  0.00  0.00           H  
ATOM   2126  HA  MET A 135      32.396 102.617  24.267  0.00  0.00           H  
ATOM   2127  HB2 MET A 135      31.037 100.548  23.519  0.00  0.00           H  
ATOM   2128  HB3 MET A 135      31.451 100.992  21.868  0.00  0.00           H  
ATOM   2129  HG2 MET A 135      33.378 100.372  24.144  0.00  0.00           H  
ATOM   2130  HG3 MET A 135      32.917  99.262  22.872  0.00  0.00           H  
ATOM   2131  HE1 MET A 135      33.415  99.712  20.308  0.00  0.00           H  
ATOM   2132  HE2 MET A 135      33.244 101.484  20.202  0.00  0.00           H  
ATOM   2133  HE3 MET A 135      34.767 100.708  19.718  0.00  0.00           H  
ATOM   2134  N   LEU A 136      31.708 103.789  21.232  0.00  0.00           N  
ATOM   2135  CA  LEU A 136      32.203 104.540  20.076  0.00  0.00           C  
ATOM   2136  C   LEU A 136      32.816 105.879  20.483  0.00  0.00           C  
ATOM   2137  O   LEU A 136      33.810 106.292  19.893  0.00  0.00           O  
ATOM   2138  CB  LEU A 136      31.038 104.781  19.111  0.00  0.00           C  
ATOM   2139  CG  LEU A 136      31.442 105.458  17.789  0.00  0.00           C  
ATOM   2140  CD1 LEU A 136      32.249 104.500  16.905  0.00  0.00           C  
ATOM   2141  CD2 LEU A 136      30.164 105.916  17.096  0.00  0.00           C  
ATOM   2142  H   LEU A 136      30.751 103.468  21.203  0.00  0.00           H  
ATOM   2143  HA  LEU A 136      32.966 103.939  19.581  0.00  0.00           H  
ATOM   2144  HB2 LEU A 136      30.543 103.833  18.891  0.00  0.00           H  
ATOM   2145  HB3 LEU A 136      30.324 105.427  19.615  0.00  0.00           H  
ATOM   2146  HG  LEU A 136      32.039 106.348  17.976  0.00  0.00           H  
ATOM   2147 HD11 LEU A 136      33.249 104.365  17.320  0.00  0.00           H  
ATOM   2148 HD12 LEU A 136      31.756 103.529  16.847  0.00  0.00           H  
ATOM   2149 HD13 LEU A 136      32.345 104.913  15.901  0.00  0.00           H  
ATOM   2150 HD21 LEU A 136      29.458 105.091  17.006  0.00  0.00           H  
ATOM   2151 HD22 LEU A 136      29.704 106.713  17.679  0.00  0.00           H  
ATOM   2152 HD23 LEU A 136      30.393 106.313  16.115  0.00  0.00           H  
ATOM   2153  N   GLU A 137      32.255 106.531  21.504  0.00  0.00           N  
ATOM   2154  CA  GLU A 137      32.790 107.764  22.078  0.00  0.00           C  
ATOM   2155  C   GLU A 137      34.279 107.601  22.429  0.00  0.00           C  
ATOM   2156  O   GLU A 137      35.088 108.492  22.153  0.00  0.00           O  
ATOM   2157  CB  GLU A 137      31.943 108.117  23.316  0.00  0.00           C  
ATOM   2158  CG  GLU A 137      32.288 109.474  23.946  0.00  0.00           C  
ATOM   2159  CD  GLU A 137      31.602 109.635  25.314  0.00  0.00           C  
ATOM   2160  OE1 GLU A 137      32.162 109.179  26.338  0.00  0.00           O  
ATOM   2161  OE2 GLU A 137      30.480 110.196  25.386  0.00  0.00           O  
ATOM   2162  H   GLU A 137      31.396 106.159  21.897  0.00  0.00           H  
ATOM   2163  HA  GLU A 137      32.689 108.563  21.341  0.00  0.00           H  
ATOM   2164  HB2 GLU A 137      30.890 108.131  23.032  0.00  0.00           H  
ATOM   2165  HB3 GLU A 137      32.082 107.337  24.063  0.00  0.00           H  
ATOM   2166  HG2 GLU A 137      33.367 109.556  24.081  0.00  0.00           H  
ATOM   2167  HG3 GLU A 137      31.968 110.269  23.270  0.00  0.00           H  
ATOM   2168  N   LYS A 138      34.671 106.448  22.988  0.00  0.00           N  
ATOM   2169  CA  LYS A 138      36.065 106.171  23.331  0.00  0.00           C  
ATOM   2170  C   LYS A 138      36.906 106.041  22.066  0.00  0.00           C  
ATOM   2171  O   LYS A 138      37.948 106.685  21.967  0.00  0.00           O  
ATOM   2172  CB  LYS A 138      36.202 104.892  24.184  0.00  0.00           C  
ATOM   2173  CG  LYS A 138      35.302 104.791  25.427  0.00  0.00           C  
ATOM   2174  CD  LYS A 138      35.314 106.039  26.321  0.00  0.00           C  
ATOM   2175  CE  LYS A 138      34.746 105.687  27.704  0.00  0.00           C  
ATOM   2176  NZ  LYS A 138      34.561 106.885  28.564  0.00  0.00           N  
ATOM   2177  H   LYS A 138      33.992 105.701  23.103  0.00  0.00           H  
ATOM   2178  HA  LYS A 138      36.451 107.017  23.905  0.00  0.00           H  
ATOM   2179  HB2 LYS A 138      36.010 104.017  23.563  0.00  0.00           H  
ATOM   2180  HB3 LYS A 138      37.239 104.825  24.515  0.00  0.00           H  
ATOM   2181  HG2 LYS A 138      34.275 104.590  25.118  0.00  0.00           H  
ATOM   2182  HG3 LYS A 138      35.645 103.933  26.009  0.00  0.00           H  
ATOM   2183  HD2 LYS A 138      36.338 106.402  26.435  0.00  0.00           H  
ATOM   2184  HD3 LYS A 138      34.706 106.818  25.858  0.00  0.00           H  
ATOM   2185  HE2 LYS A 138      33.787 105.178  27.579  0.00  0.00           H  
ATOM   2186  HE3 LYS A 138      35.433 104.993  28.194  0.00  0.00           H  
ATOM   2187  HZ1 LYS A 138      35.429 107.392  28.678  0.00  0.00           H  
ATOM   2188  HZ2 LYS A 138      33.871 107.515  28.174  0.00  0.00           H  
ATOM   2189  HZ3 LYS A 138      34.245 106.614  29.487  0.00  0.00           H  
ATOM   2190  N   ARG A 139      36.463 105.260  21.072  0.00  0.00           N  
ATOM   2191  CA  ARG A 139      37.222 105.092  19.826  0.00  0.00           C  
ATOM   2192  C   ARG A 139      37.375 106.425  19.100  0.00  0.00           C  
ATOM   2193  O   ARG A 139      38.440 106.677  18.546  0.00  0.00           O  
ATOM   2194  CB  ARG A 139      36.584 104.002  18.941  0.00  0.00           C  
ATOM   2195  CG  ARG A 139      37.205 103.877  17.533  0.00  0.00           C  
ATOM   2196  CD  ARG A 139      38.713 103.572  17.484  0.00  0.00           C  
ATOM   2197  NE  ARG A 139      39.045 102.188  17.874  0.00  0.00           N  
ATOM   2198  CZ  ARG A 139      40.285 101.684  17.981  0.00  0.00           C  
ATOM   2199  NH1 ARG A 139      41.355 102.469  17.858  0.00  0.00           N  
ATOM   2200  NH2 ARG A 139      40.458 100.384  18.207  0.00  0.00           N  
ATOM   2201  H   ARG A 139      35.587 104.766  21.191  0.00  0.00           H  
ATOM   2202  HA  ARG A 139      38.223 104.754  20.104  0.00  0.00           H  
ATOM   2203  HB2 ARG A 139      36.671 103.039  19.448  0.00  0.00           H  
ATOM   2204  HB3 ARG A 139      35.523 104.216  18.816  0.00  0.00           H  
ATOM   2205  HG2 ARG A 139      36.670 103.104  16.986  0.00  0.00           H  
ATOM   2206  HG3 ARG A 139      37.033 104.809  16.990  0.00  0.00           H  
ATOM   2207  HD2 ARG A 139      39.058 103.728  16.463  0.00  0.00           H  
ATOM   2208  HD3 ARG A 139      39.247 104.272  18.122  0.00  0.00           H  
ATOM   2209  HE  ARG A 139      38.257 101.561  18.000  0.00  0.00           H  
ATOM   2210 HH11 ARG A 139      41.260 103.454  17.653  0.00  0.00           H  
ATOM   2211 HH12 ARG A 139      42.298 102.105  17.936  0.00  0.00           H  
ATOM   2212 HH21 ARG A 139      39.670  99.753  18.295  0.00  0.00           H  
ATOM   2213 HH22 ARG A 139      41.381  99.969  18.274  0.00  0.00           H  
ATOM   2214  N   VAL A 140      36.372 107.296  19.118  0.00  0.00           N  
ATOM   2215  CA  VAL A 140      36.482 108.627  18.531  0.00  0.00           C  
ATOM   2216  C   VAL A 140      37.561 109.435  19.254  0.00  0.00           C  
ATOM   2217  O   VAL A 140      38.401 110.037  18.588  0.00  0.00           O  
ATOM   2218  CB  VAL A 140      35.091 109.292  18.519  0.00  0.00           C  
ATOM   2219  CG1 VAL A 140      35.167 110.825  18.432  0.00  0.00           C  
ATOM   2220  CG2 VAL A 140      34.298 108.705  17.339  0.00  0.00           C  
ATOM   2221  H   VAL A 140      35.488 107.028  19.542  0.00  0.00           H  
ATOM   2222  HA  VAL A 140      36.816 108.518  17.496  0.00  0.00           H  
ATOM   2223  HB  VAL A 140      34.566 109.043  19.442  0.00  0.00           H  
ATOM   2224 HG11 VAL A 140      35.466 111.236  19.398  0.00  0.00           H  
ATOM   2225 HG12 VAL A 140      35.904 111.125  17.688  0.00  0.00           H  
ATOM   2226 HG13 VAL A 140      34.199 111.250  18.176  0.00  0.00           H  
ATOM   2227 HG21 VAL A 140      34.693 109.077  16.392  0.00  0.00           H  
ATOM   2228 HG22 VAL A 140      34.354 107.616  17.343  0.00  0.00           H  
ATOM   2229 HG23 VAL A 140      33.248 108.973  17.421  0.00  0.00           H  
ATOM   2230  N   ASN A 141      37.604 109.409  20.591  0.00  0.00           N  
ATOM   2231  CA  ASN A 141      38.678 110.077  21.334  0.00  0.00           C  
ATOM   2232  C   ASN A 141      40.039 109.486  20.955  0.00  0.00           C  
ATOM   2233  O   ASN A 141      41.013 110.223  20.801  0.00  0.00           O  
ATOM   2234  CB  ASN A 141      38.453 109.994  22.852  0.00  0.00           C  
ATOM   2235  CG  ASN A 141      37.506 111.087  23.334  0.00  0.00           C  
ATOM   2236  OD1 ASN A 141      37.936 112.175  23.708  0.00  0.00           O  
ATOM   2237  ND2 ASN A 141      36.207 110.842  23.315  0.00  0.00           N  
ATOM   2238  H   ASN A 141      36.897 108.894  21.103  0.00  0.00           H  
ATOM   2239  HA  ASN A 141      38.689 111.130  21.052  0.00  0.00           H  
ATOM   2240  HB2 ASN A 141      38.085 109.009  23.139  0.00  0.00           H  
ATOM   2241  HB3 ASN A 141      39.410 110.141  23.358  0.00  0.00           H  
ATOM   2242 HD21 ASN A 141      35.844 109.956  22.965  0.00  0.00           H  
ATOM   2243 HD22 ASN A 141      35.552 111.570  23.588  0.00  0.00           H  
ATOM   2244  N   ARG A 142      40.109 108.168  20.743  0.00  0.00           N  
ATOM   2245  CA  ARG A 142      41.323 107.495  20.285  0.00  0.00           C  
ATOM   2246  C   ARG A 142      41.727 108.008  18.897  0.00  0.00           C  
ATOM   2247  O   ARG A 142      42.894 108.326  18.693  0.00  0.00           O  
ATOM   2248  CB  ARG A 142      41.109 105.966  20.319  0.00  0.00           C  
ATOM   2249  CG  ARG A 142      42.306 105.185  20.882  0.00  0.00           C  
ATOM   2250  CD  ARG A 142      43.541 105.231  19.978  0.00  0.00           C  
ATOM   2251  NE  ARG A 142      44.689 104.546  20.595  0.00  0.00           N  
ATOM   2252  CZ  ARG A 142      45.890 104.382  20.024  0.00  0.00           C  
ATOM   2253  NH1 ARG A 142      46.079 104.692  18.742  0.00  0.00           N  
ATOM   2254  NH2 ARG A 142      46.905 103.909  20.744  0.00  0.00           N  
ATOM   2255  H   ARG A 142      39.288 107.605  20.941  0.00  0.00           H  
ATOM   2256  HA  ARG A 142      42.119 107.760  20.986  0.00  0.00           H  
ATOM   2257  HB2 ARG A 142      40.262 105.737  20.966  0.00  0.00           H  
ATOM   2258  HB3 ARG A 142      40.867 105.599  19.322  0.00  0.00           H  
ATOM   2259  HG2 ARG A 142      42.557 105.584  21.866  0.00  0.00           H  
ATOM   2260  HG3 ARG A 142      42.008 104.142  21.004  0.00  0.00           H  
ATOM   2261  HD2 ARG A 142      43.294 104.750  19.034  0.00  0.00           H  
ATOM   2262  HD3 ARG A 142      43.823 106.267  19.795  0.00  0.00           H  
ATOM   2263  HE  ARG A 142      44.562 104.248  21.556  0.00  0.00           H  
ATOM   2264 HH11 ARG A 142      45.282 104.943  18.144  0.00  0.00           H  
ATOM   2265 HH12 ARG A 142      46.982 104.602  18.293  0.00  0.00           H  
ATOM   2266 HH21 ARG A 142      46.785 103.667  21.722  0.00  0.00           H  
ATOM   2267 HH22 ARG A 142      47.830 103.781  20.352  0.00  0.00           H  
ATOM   2268  N   VAL A 143      40.790 108.142  17.957  0.00  0.00           N  
ATOM   2269  CA  VAL A 143      41.078 108.686  16.631  0.00  0.00           C  
ATOM   2270  C   VAL A 143      41.515 110.150  16.736  0.00  0.00           C  
ATOM   2271  O   VAL A 143      42.448 110.535  16.034  0.00  0.00           O  
ATOM   2272  CB  VAL A 143      39.888 108.443  15.676  0.00  0.00           C  
ATOM   2273  CG1 VAL A 143      39.952 109.280  14.389  0.00  0.00           C  
ATOM   2274  CG2 VAL A 143      39.862 106.956  15.283  0.00  0.00           C  
ATOM   2275  H   VAL A 143      39.842 107.843  18.158  0.00  0.00           H  
ATOM   2276  HA  VAL A 143      41.936 108.143  16.231  0.00  0.00           H  
ATOM   2277  HB  VAL A 143      38.957 108.687  16.187  0.00  0.00           H  
ATOM   2278 HG11 VAL A 143      39.847 110.338  14.629  0.00  0.00           H  
ATOM   2279 HG12 VAL A 143      40.903 109.123  13.877  0.00  0.00           H  
ATOM   2280 HG13 VAL A 143      39.137 109.007  13.717  0.00  0.00           H  
ATOM   2281 HG21 VAL A 143      40.788 106.688  14.770  0.00  0.00           H  
ATOM   2282 HG22 VAL A 143      39.758 106.331  16.172  0.00  0.00           H  
ATOM   2283 HG23 VAL A 143      39.026 106.749  14.618  0.00  0.00           H  
ATOM   2284  N   LEU A 144      40.940 110.970  17.625  0.00  0.00           N  
ATOM   2285  CA  LEU A 144      41.440 112.333  17.825  0.00  0.00           C  
ATOM   2286  C   LEU A 144      42.909 112.285  18.246  0.00  0.00           C  
ATOM   2287  O   LEU A 144      43.718 113.028  17.695  0.00  0.00           O  
ATOM   2288  CB  LEU A 144      40.613 113.118  18.861  0.00  0.00           C  
ATOM   2289  CG  LEU A 144      39.181 113.481  18.426  0.00  0.00           C  
ATOM   2290  CD1 LEU A 144      38.438 114.155  19.584  0.00  0.00           C  
ATOM   2291  CD2 LEU A 144      39.150 114.421  17.217  0.00  0.00           C  
ATOM   2292  H   LEU A 144      40.151 110.643  18.174  0.00  0.00           H  
ATOM   2293  HA  LEU A 144      41.397 112.855  16.869  0.00  0.00           H  
ATOM   2294  HB2 LEU A 144      40.572 112.544  19.786  0.00  0.00           H  
ATOM   2295  HB3 LEU A 144      41.146 114.045  19.082  0.00  0.00           H  
ATOM   2296  HG  LEU A 144      38.643 112.572  18.163  0.00  0.00           H  
ATOM   2297 HD11 LEU A 144      38.409 113.489  20.447  0.00  0.00           H  
ATOM   2298 HD12 LEU A 144      38.943 115.080  19.869  0.00  0.00           H  
ATOM   2299 HD13 LEU A 144      37.415 114.381  19.286  0.00  0.00           H  
ATOM   2300 HD21 LEU A 144      39.704 115.336  17.428  0.00  0.00           H  
ATOM   2301 HD22 LEU A 144      39.588 113.933  16.350  0.00  0.00           H  
ATOM   2302 HD23 LEU A 144      38.118 114.672  16.972  0.00  0.00           H  
ATOM   2303  N   ALA A 145      43.275 111.369  19.149  0.00  0.00           N  
ATOM   2304  CA  ALA A 145      44.655 111.165  19.587  0.00  0.00           C  
ATOM   2305  C   ALA A 145      45.574 110.582  18.492  0.00  0.00           C  
ATOM   2306  O   ALA A 145      46.784 110.479  18.712  0.00  0.00           O  
ATOM   2307  CB  ALA A 145      44.666 110.287  20.845  0.00  0.00           C  
ATOM   2308  H   ALA A 145      42.560 110.785  19.565  0.00  0.00           H  
ATOM   2309  HA  ALA A 145      45.056 112.143  19.861  0.00  0.00           H  
ATOM   2310  HB1 ALA A 145      44.013 110.716  21.606  0.00  0.00           H  
ATOM   2311  HB2 ALA A 145      44.333 109.279  20.607  0.00  0.00           H  
ATOM   2312  HB3 ALA A 145      45.680 110.235  21.244  0.00  0.00           H  
ATOM   2313  N   GLU A 146      45.040 110.212  17.323  0.00  0.00           N  
ATOM   2314  CA  GLU A 146      45.797 109.769  16.146  0.00  0.00           C  
ATOM   2315  C   GLU A 146      45.847 110.870  15.072  0.00  0.00           C  
ATOM   2316  O   GLU A 146      46.552 110.719  14.069  0.00  0.00           O  
ATOM   2317  CB  GLU A 146      45.152 108.505  15.549  0.00  0.00           C  
ATOM   2318  CG  GLU A 146      45.338 107.256  16.420  0.00  0.00           C  
ATOM   2319  CD  GLU A 146      44.537 106.044  15.909  0.00  0.00           C  
ATOM   2320  OE1 GLU A 146      44.312 105.904  14.682  0.00  0.00           O  
ATOM   2321  OE2 GLU A 146      44.188 105.182  16.750  0.00  0.00           O  
ATOM   2322  H   GLU A 146      44.039 110.289  17.206  0.00  0.00           H  
ATOM   2323  HA  GLU A 146      46.823 109.531  16.432  0.00  0.00           H  
ATOM   2324  HB2 GLU A 146      44.089 108.681  15.391  0.00  0.00           H  
ATOM   2325  HB3 GLU A 146      45.606 108.302  14.579  0.00  0.00           H  
ATOM   2326  HG2 GLU A 146      46.399 106.997  16.438  0.00  0.00           H  
ATOM   2327  HG3 GLU A 146      45.036 107.477  17.442  0.00  0.00           H  
ATOM   2328  N   THR A 147      45.124 111.977  15.272  0.00  0.00           N  
ATOM   2329  CA  THR A 147      44.845 112.990  14.254  0.00  0.00           C  
ATOM   2330  C   THR A 147      45.113 114.403  14.822  0.00  0.00           C  
ATOM   2331  O   THR A 147      44.655 115.411  14.277  0.00  0.00           O  
ATOM   2332  CB  THR A 147      43.400 112.787  13.722  0.00  0.00           C  
ATOM   2333  OG1 THR A 147      43.052 111.417  13.588  0.00  0.00           O  
ATOM   2334  CG2 THR A 147      43.195 113.376  12.324  0.00  0.00           C  
ATOM   2335  H   THR A 147      44.610 112.070  16.140  0.00  0.00           H  
ATOM   2336  HA  THR A 147      45.536 112.846  13.423  0.00  0.00           H  
ATOM   2337  HB  THR A 147      42.695 113.251  14.414  0.00  0.00           H  
ATOM   2338  HG1 THR A 147      42.905 111.063  14.489  0.00  0.00           H  
ATOM   2339 HG21 THR A 147      43.251 114.462  12.356  0.00  0.00           H  
ATOM   2340 HG22 THR A 147      43.966 112.995  11.655  0.00  0.00           H  
ATOM   2341 HG23 THR A 147      42.215 113.091  11.940  0.00  0.00           H  
ATOM   2342  N   GLU A 148      45.867 114.495  15.922  0.00  0.00           N  
ATOM   2343  CA  GLU A 148      46.247 115.719  16.616  0.00  0.00           C  
ATOM   2344  C   GLU A 148      47.620 115.470  17.242  0.00  0.00           C  
ATOM   2345  O   GLU A 148      48.504 116.345  17.111  0.00  0.00           O  
ATOM   2346  CB  GLU A 148      45.185 116.069  17.678  0.00  0.00           C  
ATOM   2347  CG  GLU A 148      45.479 117.388  18.407  0.00  0.00           C  
ATOM   2348  CD  GLU A 148      44.337 117.771  19.374  0.00  0.00           C  
ATOM   2349  OE1 GLU A 148      44.263 117.212  20.498  0.00  0.00           O  
ATOM   2350  OE2 GLU A 148      43.511 118.655  19.030  0.00  0.00           O  
ATOM   2351  OXT GLU A 148      47.833 114.371  17.807  0.00  0.00           O  
ATOM   2352  H   GLU A 148      46.244 113.647  16.325  0.00  0.00           H  
ATOM   2353  HA  GLU A 148      46.317 116.538  15.898  0.00  0.00           H  
ATOM   2354  HB2 GLU A 148      44.213 116.157  17.189  0.00  0.00           H  
ATOM   2355  HB3 GLU A 148      45.129 115.266  18.415  0.00  0.00           H  
ATOM   2356  HG2 GLU A 148      46.410 117.291  18.971  0.00  0.00           H  
ATOM   2357  HG3 GLU A 148      45.615 118.181  17.666  0.00  0.00           H  
TER    2358      GLU A 148                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
