
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  134 ( 1025),  selected  134 , name 1zzo_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 1zzo_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T    45_A      E       1           -
LGA    V    46_A      N       2           -
LGA    -       -      L       3           -
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    -       -      Q       6           -
LGA    -       -      S       7           -
LGA    P    47_A      M       8           #
LGA    A    48_A      I       9          2.803
LGA    -       -      N      10           -
LGA    Q    49_A      S      11          4.570
LGA    L    50_A      F      12          1.150
LGA    -       -      Y      13           -
LGA    Q    51_A      A      14          3.511
LGA    F    52_A      F      15          2.346
LGA    S    53_A      E      16          1.635
LGA    A    54_A      V      17          1.228
LGA    K    55_A      K      18          1.581
LGA    T    56_A      D      19          1.680
LGA    L    57_A      A      20          1.717
LGA    D    58_A      K      21          4.316
LGA    G    59_A      G      22          4.741
LGA    H    60_A      R      23          4.293
LGA    D    61_A      T      24          2.958
LGA    F    62_A      V      25          2.307
LGA    H    63_A      S      26          1.912
LGA    G    64_A      L      27          2.728
LGA    E    65_A      E      28          3.158
LGA    S    66_A      K      29          2.954
LGA    L    67_A      Y      30          2.705
LGA    L    68_A      K      31          2.721
LGA    G    69_A      G      32          2.366
LGA    K    70_A      K      33          2.078
LGA    P    71_A      V      34          1.354
LGA    A    72_A      S      35          1.413
LGA    V    73_A      L      36          1.347
LGA    L    74_A      V      37          1.063
LGA    W    75_A      V      38          1.798
LGA    F    76_A      N      39          1.492
LGA    W    77_A      V      40          0.980
LGA    A    78_A      A      41          1.641
LGA    P    79_A      S      42          1.852
LGA    W    80_A      D      43          1.698
LGA    C    81_A      C      44          1.894
LGA    P    82_A      Q      45          1.786
LGA    T    83_A      L      46          0.867
LGA    C    84_A      T      47          2.770
LGA    Q    85_A      D      48          2.540
LGA    G    86_A      R      49          1.758
LGA    E    87_A      N      50          1.334
LGA    A    88_A      Y      51          0.538
LGA    P    89_A      L      52          0.932
LGA    V    90_A      G      53          1.146
LGA    V    91_A      L      54          0.572
LGA    G    92_A      K      55          0.450
LGA    Q    93_A      E      56          1.225
LGA    V    94_A      L      57          1.133
LGA    A    95_A      H      58          0.180
LGA    A    96_A      K      59          0.819
LGA    S    97_A      E      60          1.024
LGA    H    98_A      F      61          0.920
LGA    P    99_A      G      62          1.808
LGA    -       -      P      63           -
LGA    -       -      S      64           -
LGA    E   100_A      H      65          2.112
LGA    V   101_A      F      66          0.520
LGA    T   102_A      S      67          1.985
LGA    F   103_A      V      68          1.819
LGA    V   104_A      L      69          0.973
LGA    G   105_A      A      70          0.956
LGA    V   106_A      F      71          1.146
LGA    A   107_A      P      72          0.989
LGA    G   108_A      C      73          1.102
LGA    L   109_A      N      74          1.226
LGA    -       -      Q      75           -
LGA    -       -      F      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    -       -      S      79           -
LGA    -       -      E      80           -
LGA    D   110_A      P      81          3.815
LGA    Q   111_A      R      82          4.175
LGA    V   112_A      P      83          2.057
LGA    -       -      S      84           -
LGA    P   113_A      K      85          5.434
LGA    A   114_A      E      86          5.253
LGA    M   115_A      V      87          1.654
LGA    Q   116_A      E      88          3.433
LGA    E   117_A      S      89          5.339
LGA    F   118_A      F      90          3.341
LGA    V   119_A      A      91          0.971
LGA    -       -      R      92           -
LGA    N   120_A      K      93          2.570
LGA    K   121_A      N      94          2.021
LGA    Y   122_A      Y      95          2.514
LGA    P   123_A      G      96          3.177
LGA    V   124_A      V      97          2.187
LGA    K   125_A      -       -           -
LGA    T   126_A      T      98          0.434
LGA    F   127_A      F      99          0.936
LGA    T   128_A      P     100          0.895
LGA    Q   129_A      I     101          0.943
LGA    L   130_A      F     102          0.963
LGA    A   131_A      H     103          1.375
LGA    D   132_A      K     104          2.825
LGA    T   133_A      I     105          3.033
LGA    D   134_A      K     106          4.132
LGA    G   135_A      I     107          3.981
LGA    -       -      L     108           -
LGA    -       -      G     109           -
LGA    -       -      S     110           -
LGA    -       -      E     111           -
LGA    -       -      G     112           -
LGA    S   136_A      E     113          0.661
LGA    -       -      P     114           -
LGA    V   137_A      A     115          4.068
LGA    W   138_A      F     116          3.479
LGA    A   139_A      R     117          3.115
LGA    N   140_A      F     118          3.386
LGA    F   141_A      L     119          2.177
LGA    G   142_A      V     120          2.157
LGA    -       -      D     121           -
LGA    -       -      S     122           -
LGA    -       -      S     123           -
LGA    -       -      K     124           -
LGA    -       -      K     125           -
LGA    V   143_A      E     126          3.719
LGA    T   144_A      P     127          3.202
LGA    Q   145_A      R     128          3.051
LGA    Q   146_A      W     129          3.486
LGA    -       -      N     130           -
LGA    P   147_A      F     131          1.158
LGA    A   148_A      W     132          1.094
LGA    Y   149_A      K     133          1.077
LGA    A   150_A      Y     134          1.274
LGA    F   151_A      L     135          0.675
LGA    V   152_A      V     136          1.220
LGA    D   153_A      N     137          1.450
LGA    P   154_A      P     138          1.740
LGA    H   155_A      E     139          3.088
LGA    G   156_A      G     140          2.859
LGA    N   157_A      Q     141          2.521
LGA    V   158_A      V     142          0.685
LGA    D   159_A      V     143          2.919
LGA    -       -      K     144           -
LGA    V   160_A      F     145          2.553
LGA    V   161_A      W     146          2.228
LGA    R   162_A      R     147          2.503
LGA    G   163_A      P     148          2.096
LGA    R   164_A      E     149          3.084
LGA    M   165_A      E     150          3.330
LGA    S   166_A      P     151          2.033
LGA    Q   167_A      I     152          2.685
LGA    D   168_A      E     153          1.990
LGA    E   169_A      V     154          2.172
LGA    L   170_A      I     155          2.642
LGA    T   171_A      R     156          1.883
LGA    R   172_A      P     157          1.187
LGA    R   173_A      D     158          1.961
LGA    V   174_A      I     159          0.999
LGA    T   175_A      A     160          0.715
LGA    A   176_A      A     161          2.036
LGA    L   177_A      L     162          1.529
LGA    T   178_A      V     163          2.370
LGA    -       -      R     164           -
LGA    -       -      Q     165           -
LGA    -       -      V     166           -
LGA    -       -      I     167           -
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  134  174    5.0    130    2.40    15.38     52.002     5.208

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.267556 * X  +   0.963300 * Y  +   0.021585 * Z  + -55.615990
  Y_new =   0.021110 * X  +   0.016536 * Y  +  -0.999640 * Z  + 127.951164
  Z_new =  -0.963311 * X  +   0.267916 * Y  +  -0.015911 * Z  +  74.094101 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.630116   -1.511477  [ DEG:    93.3988    -86.6012 ]
  Theta =   1.299077    1.842515  [ DEG:    74.4316    105.5684 ]
  Phi   =   0.078737   -3.062855  [ DEG:     4.5113   -175.4887 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1zzo_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1zzo_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  134  174   5.0  130   2.40   15.38  52.002
REMARK  ---------------------------------------------------------- 
MOLECULE 1zzo_A
HEADER    ISOMERASE                               14-JUN-05   1ZZO              
TITLE     STRUCTURE OF MTB DSBF IN ITS OXIDIZED FORM.                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RV1677;                                                    
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 44-179;                                           
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: RV1677;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PETT7                                     
KEYWDS    THIOREDOXIN FOLD, STRUCTURAL GENOMICS, PSI, PROTEIN                   
KEYWDS   2 STRUCTURE INITIATIVE, TB STRUCTURAL GENOMICS CONSORTIUM,             
KEYWDS   3 TBSGC                                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.W.GOULDING,D.S.EISENBERG,T.LEKIN,B.SEGELKE,L.W.HUNG,M.YU,           
AUTHOR   2 S.IM,TB STRUCTURAL GENOMICS CONSORTIUM (TBSGC)                       
REVDAT   1   26-JUL-05 1ZZO    0                                                
JRNL        AUTH   C.W.GOULDING,D.S.EISENBERG,T.LEKIN,B.SEGELKE,                
JRNL        AUTH 2 L.W.HUNG,M.YU,S.IM                                           
JRNL        TITL   STRUCTURE OF MTB DSBF IN ITS OXIDIZED FORM.                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  1ZZO A   45   180  UNP    O53924   O53924_MYCTU    47    182             
SEQRES   1 A  136  THR VAL PRO ALA GLN LEU GLN PHE SER ALA LYS THR LEU          
SEQRES   2 A  136  ASP GLY HIS ASP PHE HIS GLY GLU SER LEU LEU GLY LYS          
SEQRES   3 A  136  PRO ALA VAL LEU TRP PHE TRP ALA PRO TRP CYS PRO THR          
SEQRES   4 A  136  CYS GLN GLY GLU ALA PRO VAL VAL GLY GLN VAL ALA ALA          
SEQRES   5 A  136  SER HIS PRO GLU VAL THR PHE VAL GLY VAL ALA GLY LEU          
SEQRES   6 A  136  ASP GLN VAL PRO ALA MET GLN GLU PHE VAL ASN LYS TYR          
SEQRES   7 A  136  PRO VAL LYS THR PHE THR GLN LEU ALA ASP THR ASP GLY          
SEQRES   8 A  136  SER VAL TRP ALA ASN PHE GLY VAL THR GLN GLN PRO ALA          
SEQRES   9 A  136  TYR ALA PHE VAL ASP PRO HIS GLY ASN VAL ASP VAL VAL          
SEQRES  10 A  136  ARG GLY ARG MET SER GLN ASP GLU LEU THR ARG ARG VAL          
SEQRES  11 A  136  THR ALA LEU THR SER ARG                                      
FORMUL   2  HOH   *108(H2 O)                                                    
CRYST1  100.167  100.167   30.093  90.00  90.00  90.00 P 42 21 2     8          
ATOM      1  N   THR A  45      46.031 109.457  -2.430  1.00 36.89           N  
ATOM      2  CA  THR A  45      44.723 109.282  -3.125  1.00 35.04           C  
ATOM      3  C   THR A  45      43.627 108.962  -2.115  1.00 33.37           C  
ATOM      4  O   THR A  45      43.906 108.505  -1.005  1.00 32.56           O  
ATOM      5  CB  THR A  45      44.792 108.154  -4.186  1.00 35.55           C  
ATOM      6  OG1 THR A  45      44.685 108.190  -5.614  1.00 20.00           O  
ATOM      7  CG2 THR A  45      44.998 106.714  -3.744  1.00 20.00           C  
ATOM      8  N   VAL A  46      42.377 109.204  -2.498  1.00 30.74           N  
ATOM      9  CA  VAL A  46      41.260 108.933  -1.604  1.00 29.96           C  
ATOM     10  C   VAL A  46      40.979 107.459  -1.432  1.00 27.78           C  
ATOM     11  O   VAL A  46      41.097 106.672  -2.372  1.00 25.89           O  
ATOM     12  CB  VAL A  46      39.943 109.566  -2.082  1.00 32.21           C  
ATOM     13  CG1 VAL A  46      39.923 111.029  -1.753  1.00 34.98           C  
ATOM     14  CG2 VAL A  46      39.762 109.336  -3.569  1.00 32.54           C  
ATOM     15  N   PRO A  47      40.599 107.065  -0.214  1.00 24.56           N  
ATOM     16  CA  PRO A  47      40.295 105.659   0.032  1.00 24.46           C  
ATOM     17  C   PRO A  47      39.015 105.324  -0.724  1.00 22.98           C  
ATOM     18  O   PRO A  47      38.079 106.131  -0.780  1.00 20.91           O  
ATOM     19  CB  PRO A  47      40.122 105.609   1.546  1.00 25.22           C  
ATOM     20  CG  PRO A  47      39.568 106.963   1.858  1.00 27.49           C  
ATOM     21  CD  PRO A  47      40.434 107.861   1.015  1.00 26.46           C  
ATOM     22  N   ALA A  48      38.982 104.140  -1.322  1.00 21.37           N  
ATOM     23  CA  ALA A  48      37.821 103.707  -2.084  1.00 21.01           C  
ATOM     24  C   ALA A  48      36.545 103.801  -1.260  1.00 21.41           C  
ATOM     25  O   ALA A  48      35.466 104.038  -1.796  1.00 19.87           O  
ATOM     26  CB  ALA A  48      38.029 102.276  -2.575  1.00 21.91           C  
ATOM     27  N   GLN A  49      36.675 103.624   0.051  1.00 23.15           N  
ATOM     28  CA  GLN A  49      35.526 103.680   0.944  1.00 22.72           C  
ATOM     29  C   GLN A  49      34.826 105.040   0.943  1.00 20.88           C  
ATOM     30  O   GLN A  49      33.641 105.132   1.241  1.00 18.81           O  
ATOM     31  CB  GLN A  49      35.948 103.338   2.378  1.00 26.87           C  
ATOM     32  CG  GLN A  49      36.471 101.918   2.589  1.00 27.70           C  
ATOM     33  CD  GLN A  49      37.978 101.801   2.467  1.00 30.28           C  
ATOM     34  OE1 GLN A  49      38.567 100.797   2.882  1.00 34.13           O  
ATOM     35  NE2 GLN A  49      38.613 102.815   1.895  1.00 27.19           N  
ATOM     36  N   LEU A  50      35.556 106.099   0.613  1.00 18.40           N  
ATOM     37  CA  LEU A  50      34.959 107.431   0.602  1.00 18.07           C  
ATOM     38  C   LEU A  50      34.475 107.856  -0.776  1.00 17.61           C  
ATOM     39  O   LEU A  50      33.948 108.951  -0.947  1.00 17.35           O  
ATOM     40  CB  LEU A  50      35.961 108.461   1.130  1.00 17.69           C  
ATOM     41  CG  LEU A  50      36.373 108.289   2.595  1.00 19.97           C  
ATOM     42  CD1 LEU A  50      37.292 109.430   3.001  1.00 19.00           C  
ATOM     43  CD2 LEU A  50      35.130 108.274   3.475  1.00 19.43           C  
ATOM     44  N   GLN A  51      34.648 106.987  -1.762  1.00 18.46           N  
ATOM     45  CA  GLN A  51      34.225 107.322  -3.109  1.00 20.13           C  
ATOM     46  C   GLN A  51      32.762 107.001  -3.346  1.00 20.47           C  
ATOM     47  O   GLN A  51      32.419 105.988  -3.955  1.00 23.22           O  
ATOM     48  CB  GLN A  51      35.113 106.607  -4.126  1.00 18.93           C  
ATOM     49  CG  GLN A  51      36.562 107.077  -4.063  1.00 20.51           C  
ATOM     50  CD  GLN A  51      37.437 106.451  -5.131  1.00 22.70           C  
ATOM     51  OE1 GLN A  51      37.769 105.266  -5.066  1.00 21.72           O  
ATOM     52  NE2 GLN A  51      37.813 107.248  -6.125  1.00 23.60           N  
ATOM     53  N   PHE A  52      31.905 107.883  -2.848  1.00 19.84           N  
ATOM     54  CA  PHE A  52      30.464 107.735  -2.991  1.00 20.78           C  
ATOM     55  C   PHE A  52      29.811 109.104  -2.870  1.00 22.07           C  
ATOM     56  O   PHE A  52      30.394 110.035  -2.317  1.00 20.78           O  
ATOM     57  CB  PHE A  52      29.919 106.782  -1.914  1.00 21.35           C  
ATOM     58  CG  PHE A  52      29.925 107.357  -0.517  1.00 21.12           C  
ATOM     59  CD1 PHE A  52      28.890 108.177  -0.080  1.00 20.99           C  
ATOM     60  CD2 PHE A  52      30.968 107.071   0.363  1.00 20.24           C  
ATOM     61  CE1 PHE A  52      28.891 108.708   1.212  1.00 22.15           C  
ATOM     62  CE2 PHE A  52      30.977 107.599   1.658  1.00 20.17           C  
ATOM     63  CZ  PHE A  52      29.934 108.416   2.081  1.00 19.48           C  
ATOM     64  N   SER A  53      28.608 109.230  -3.414  1.00 22.22           N  
ATOM     65  CA  SER A  53      27.872 110.480  -3.334  1.00 24.19           C  
ATOM     66  C   SER A  53      26.495 110.131  -2.787  1.00 22.23           C  
ATOM     67  O   SER A  53      26.108 108.965  -2.781  1.00 24.56           O  
ATOM     68  CB  SER A  53      27.754 111.128  -4.714  1.00 26.92           C  
ATOM     69  OG  SER A  53      27.164 110.236  -5.640  1.00 30.03           O  
ATOM     70  N   ALA A  54      25.767 111.136  -2.318  1.00 23.03           N  
ATOM     71  CA  ALA A  54      24.440 110.904  -1.767  1.00 21.83           C  
ATOM     72  C   ALA A  54      23.681 112.213  -1.626  1.00 21.89           C  
ATOM     73  O   ALA A  54      24.221 113.284  -1.888  1.00 22.06           O  
ATOM     74  CB  ALA A  54      24.556 110.213  -0.406  1.00 24.92           C  
ATOM     75  N   LYS A  55      22.418 112.118  -1.221  1.00 20.79           N  
ATOM     76  CA  LYS A  55      21.583 113.298  -1.019  1.00 23.65           C  
ATOM     77  C   LYS A  55      21.227 113.392   0.459  1.00 20.75           C  
ATOM     78  O   LYS A  55      20.906 112.382   1.082  1.00 24.33           O  
ATOM     79  CB  LYS A  55      20.292 113.195  -1.838  1.00 26.27           C  
ATOM     80  CG  LYS A  55      20.409 113.598  -3.305  1.00 29.49           C  
ATOM     81  CD  LYS A  55      20.480 115.112  -3.458  1.00 31.15           C  
ATOM     82  CE  LYS A  55      20.443 115.533  -4.922  1.00 32.77           C  
ATOM     83  NZ  LYS A  55      20.559 117.012  -5.071  1.00 33.50           N  
ATOM     84  N   THR A  56      21.289 114.592   1.023  1.00 22.49           N  
ATOM     85  CA  THR A  56      20.946 114.764   2.431  1.00 21.92           C  
ATOM     86  C   THR A  56      19.432 114.858   2.551  1.00 24.27           C  
ATOM     87  O   THR A  56      18.736 115.128   1.572  1.00 23.14           O  
ATOM     88  CB  THR A  56      21.562 116.041   3.029  1.00 22.13           C  
ATOM     89  OG1 THR A  56      20.935 117.201   2.462  1.00 19.96           O  
ATOM     90  CG2 THR A  56      23.053 116.086   2.748  1.00 19.85           C  
ATOM     91  N   LEU A  57      18.925 114.629   3.755  1.00 23.14           N  
ATOM     92  CA  LEU A  57      17.488 114.694   3.986  1.00 23.81           C  
ATOM     93  C   LEU A  57      16.914 116.061   3.644  1.00 25.36           C  
ATOM     94  O   LEU A  57      15.743 116.171   3.274  1.00 27.13           O  
ATOM     95  CB  LEU A  57      17.169 114.375   5.445  1.00 24.28           C  
ATOM     96  CG  LEU A  57      16.586 113.004   5.780  1.00 27.39           C  
ATOM     97  CD1 LEU A  57      16.168 113.011   7.243  1.00 25.10           C  
ATOM     98  CD2 LEU A  57      15.385 112.699   4.897  1.00 25.26           C  
ATOM     99  N   ASP A  58      17.729 117.104   3.774  1.00 26.89           N  
ATOM    100  CA  ASP A  58      17.265 118.453   3.479  1.00 28.57           C  
ATOM    101  C   ASP A  58      17.582 118.931   2.062  1.00 28.79           C  
ATOM    102  O   ASP A  58      17.664 120.131   1.803  1.00 29.41           O  
ATOM    103  CB  ASP A  58      17.792 119.442   4.532  1.00 32.12           C  
ATOM    104  CG  ASP A  58      19.301 119.404   4.684  1.00 34.15           C  
ATOM    105  OD1 ASP A  58      19.885 118.301   4.644  1.00 34.84           O  
ATOM    106  OD2 ASP A  58      19.900 120.485   4.867  1.00 38.41           O  
ATOM    107  N   GLY A  59      17.763 117.975   1.153  1.00 28.06           N  
ATOM    108  CA  GLY A  59      18.008 118.287  -0.248  1.00 29.18           C  
ATOM    109  C   GLY A  59      19.368 118.736  -0.757  1.00 29.44           C  
ATOM    110  O   GLY A  59      19.441 119.325  -1.835  1.00 29.12           O  
ATOM    111  N   HIS A  60      20.443 118.462  -0.026  1.00 28.27           N  
ATOM    112  CA  HIS A  60      21.772 118.875  -0.477  1.00 27.57           C  
ATOM    113  C   HIS A  60      22.594 117.706  -1.014  1.00 26.66           C  
ATOM    114  O   HIS A  60      22.352 116.552  -0.665  1.00 27.57           O  
ATOM    115  CB  HIS A  60      22.532 119.544   0.673  1.00 29.15           C  
ATOM    116  CG  HIS A  60      21.888 120.797   1.179  1.00 33.28           C  
ATOM    117  ND1 HIS A  60      21.799 121.946   0.424  1.00 35.32           N  
ATOM    118  CD2 HIS A  60      21.289 121.076   2.362  1.00 34.73           C  
ATOM    119  CE1 HIS A  60      21.174 122.880   1.119  1.00 35.77           C  
ATOM    120  NE2 HIS A  60      20.854 122.378   2.298  1.00 35.79           N  
ATOM    121  N   ASP A  61      23.561 118.003  -1.880  1.00 24.43           N  
ATOM    122  CA  ASP A  61      24.423 116.955  -2.420  1.00 23.01           C  
ATOM    123  C   ASP A  61      25.544 116.711  -1.418  1.00 20.36           C  
ATOM    124  O   ASP A  61      26.065 117.653  -0.824  1.00 22.80           O  
ATOM    125  CB  ASP A  61      25.031 117.382  -3.761  1.00 24.54           C  
ATOM    126  CG  ASP A  61      24.014 117.411  -4.884  1.00 27.35           C  
ATOM    127  OD1 ASP A  61      23.442 116.347  -5.202  1.00 30.19           O  
ATOM    128  OD2 ASP A  61      23.788 118.498  -5.450  1.00 28.76           O  
ATOM    129  N   PHE A  62      25.912 115.448  -1.231  1.00 18.91           N  
ATOM    130  CA  PHE A  62      26.977 115.092  -0.299  1.00 19.33           C  
ATOM    131  C   PHE A  62      28.013 114.207  -0.976  1.00 18.18           C  
ATOM    132  O   PHE A  62      27.673 113.262  -1.688  1.00 18.20           O  
ATOM    133  CB  PHE A  62      26.407 114.346   0.914  1.00 20.48           C  
ATOM    134  CG  PHE A  62      27.462 113.877   1.882  1.00 19.04           C  
ATOM    135  CD1 PHE A  62      27.939 114.726   2.877  1.00 20.56           C  
ATOM    136  CD2 PHE A  62      28.012 112.606   1.765  1.00 17.92           C  
ATOM    137  CE1 PHE A  62      28.955 114.308   3.746  1.00 20.12           C  
ATOM    138  CE2 PHE A  62      29.026 112.180   2.624  1.00 17.67           C  
ATOM    139  CZ  PHE A  62      29.497 113.037   3.617  1.00 19.03           C  
ATOM    140  N   HIS A  63      29.283 114.505  -0.730  1.00 17.91           N  
ATOM    141  CA  HIS A  63      30.367 113.735  -1.308  1.00 17.64           C  
ATOM    142  C   HIS A  63      31.194 113.082  -0.216  1.00 15.65           C  
ATOM    143  O   HIS A  63      31.689 113.761   0.683  1.00 17.43           O  
ATOM    144  CB  HIS A  63      31.253 114.649  -2.155  1.00 18.34           C  
ATOM    145  CG  HIS A  63      30.541 115.253  -3.321  1.00 17.99           C  
ATOM    146  ND1 HIS A  63      30.194 114.523  -4.439  1.00 20.53           N  
ATOM    147  CD2 HIS A  63      30.071 116.506  -3.528  1.00 20.22           C  
ATOM    148  CE1 HIS A  63      29.542 115.302  -5.284  1.00 20.18           C  
ATOM    149  NE2 HIS A  63      29.454 116.509  -4.755  1.00 19.18           N  
ATOM    150  N   GLY A  64      31.342 111.764  -0.292  1.00 15.61           N  
ATOM    151  CA  GLY A  64      32.128 111.070   0.709  1.00 14.05           C  
ATOM    152  C   GLY A  64      33.549 111.597   0.789  1.00 14.76           C  
ATOM    153  O   GLY A  64      34.170 111.599   1.854  1.00 12.70           O  
ATOM    154  N   GLU A  65      34.072 112.062  -0.339  1.00 14.50           N  
ATOM    155  CA  GLU A  65      35.439 112.568  -0.363  1.00 16.75           C  
ATOM    156  C   GLU A  65      35.627 113.809   0.514  1.00 16.71           C  
ATOM    157  O   GLU A  65      36.755 114.168   0.866  1.00 15.92           O  
ATOM    158  CB  GLU A  65      35.865 112.869  -1.804  1.00 17.52           C  
ATOM    159  CG  GLU A  65      35.908 111.649  -2.732  1.00 18.37           C  
ATOM    160  CD  GLU A  65      34.586 111.364  -3.434  1.00 19.38           C  
ATOM    161  OE1 GLU A  65      34.588 110.563  -4.396  1.00 19.94           O  
ATOM    162  OE2 GLU A  65      33.545 111.930  -3.035  1.00 18.52           O  
ATOM    163  N   SER A  66      34.524 114.461   0.873  1.00 17.02           N  
ATOM    164  CA  SER A  66      34.590 115.651   1.713  1.00 18.08           C  
ATOM    165  C   SER A  66      35.022 115.278   3.131  1.00 17.29           C  
ATOM    166  O   SER A  66      35.304 116.154   3.951  1.00 17.87           O  
ATOM    167  CB  SER A  66      33.228 116.355   1.756  1.00 19.94           C  
ATOM    168  OG  SER A  66      32.282 115.592   2.485  1.00 23.83           O  
ATOM    169  N   LEU A  67      35.073 113.979   3.417  1.00 15.98           N  
ATOM    170  CA  LEU A  67      35.481 113.512   4.739  1.00 15.54           C  
ATOM    171  C   LEU A  67      36.979 113.232   4.818  1.00 15.93           C  
ATOM    172  O   LEU A  67      37.515 113.029   5.905  1.00 19.99           O  
ATOM    173  CB  LEU A  67      34.718 112.236   5.120  1.00 14.11           C  
ATOM    174  CG  LEU A  67      33.193 112.308   5.142  1.00 16.07           C  
ATOM    175  CD1 LEU A  67      32.647 110.954   5.550  1.00 14.07           C  
ATOM    176  CD2 LEU A  67      32.715 113.388   6.103  1.00 15.62           C  
ATOM    177  N   LEU A  68      37.656 113.217   3.675  1.00 16.59           N  
ATOM    178  CA  LEU A  68      39.094 112.947   3.660  1.00 17.49           C  
ATOM    179  C   LEU A  68      39.906 114.039   4.355  1.00 18.93           C  
ATOM    180  O   LEU A  68      39.716 115.228   4.097  1.00 20.48           O  
ATOM    181  CB  LEU A  68      39.603 112.794   2.225  1.00 18.78           C  
ATOM    182  CG  LEU A  68      41.085 112.422   2.121  1.00 19.22           C  
ATOM    183  CD1 LEU A  68      41.297 111.039   2.721  1.00 21.25           C  
ATOM    184  CD2 LEU A  68      41.538 112.455   0.678  1.00 21.19           C  
ATOM    185  N   GLY A  69      40.810 113.621   5.238  1.00 19.93           N  
ATOM    186  CA  GLY A  69      41.659 114.567   5.942  1.00 21.72           C  
ATOM    187  C   GLY A  69      41.112 115.053   7.265  1.00 22.99           C  
ATOM    188  O   GLY A  69      41.719 115.892   7.927  1.00 25.32           O  
ATOM    189  N   LYS A  70      39.959 114.530   7.660  1.00 22.70           N  
ATOM    190  CA  LYS A  70      39.351 114.935   8.914  1.00 22.81           C  
ATOM    191  C   LYS A  70      38.705 113.734   9.588  1.00 20.91           C  
ATOM    192  O   LYS A  70      38.377 112.746   8.937  1.00 19.53           O  
ATOM    193  CB  LYS A  70      38.305 116.019   8.649  1.00 27.75           C  
ATOM    194  CG  LYS A  70      37.159 115.558   7.766  1.00 30.79           C  
ATOM    195  CD  LYS A  70      36.449 116.729   7.099  1.00 32.86           C  
ATOM    196  CE  LYS A  70      37.360 117.419   6.093  1.00 34.05           C  
ATOM    197  NZ  LYS A  70      36.630 118.424   5.272  1.00 35.54           N  
ATOM    198  N   PRO A  71      38.540 113.793  10.914  1.00 18.14           N  
ATOM    199  CA  PRO A  71      37.919 112.664  11.608  1.00 17.67           C  
ATOM    200  C   PRO A  71      36.424 112.667  11.319  1.00 16.56           C  
ATOM    201  O   PRO A  71      35.793 113.721  11.300  1.00 17.28           O  
ATOM    202  CB  PRO A  71      38.237 112.949  13.073  1.00 19.25           C  
ATOM    203  CG  PRO A  71      38.224 114.452  13.117  1.00 19.69           C  
ATOM    204  CD  PRO A  71      38.981 114.825  11.870  1.00 19.71           C  
ATOM    205  N   ALA A  72      35.858 111.494  11.066  1.00 14.58           N  
ATOM    206  CA  ALA A  72      34.433 111.424  10.787  1.00 12.60           C  
ATOM    207  C   ALA A  72      33.828 110.136  11.305  1.00 12.40           C  
ATOM    208  O   ALA A  72      34.518 109.135  11.494  1.00 13.90           O  
ATOM    209  CB  ALA A  72      34.185 111.552   9.278  1.00 13.96           C  
ATOM    210  N   VAL A  73      32.531 110.181  11.563  1.00 11.18           N  
ATOM    211  CA  VAL A  73      31.821 109.002  12.026  1.00 12.04           C  
ATOM    212  C   VAL A  73      30.538 108.887  11.229  1.00 12.43           C  
ATOM    213  O   VAL A  73      29.754 109.831  11.180  1.00 12.59           O  
ATOM    214  CB  VAL A  73      31.444 109.101  13.513  1.00 13.65           C  
ATOM    215  CG1 VAL A  73      30.623 107.880  13.919  1.00 15.15           C  
ATOM    216  CG2 VAL A  73      32.698 109.198  14.362  1.00 15.95           C  
ATOM    217  N   LEU A  74      30.338 107.743  10.587  1.00 11.42           N  
ATOM    218  CA  LEU A  74      29.109 107.515   9.845  1.00 12.87           C  
ATOM    219  C   LEU A  74      28.278 106.557  10.682  1.00 11.90           C  
ATOM    220  O   LEU A  74      28.740 105.486  11.079  1.00 14.23           O  
ATOM    221  CB  LEU A  74      29.396 106.919   8.462  1.00 13.03           C  
ATOM    222  CG  LEU A  74      30.077 107.911   7.511  1.00 14.83           C  
ATOM    223  CD1 LEU A  74      31.555 107.560   7.396  1.00 17.68           C  
ATOM    224  CD2 LEU A  74      29.415 107.877   6.143  1.00 16.37           C  
ATOM    225  N   TRP A  75      27.051 106.967  10.974  1.00 10.85           N  
ATOM    226  CA  TRP A  75      26.140 106.177  11.777  1.00 11.76           C  
ATOM    227  C   TRP A  75      25.013 105.668  10.885  1.00 12.60           C  
ATOM    228  O   TRP A  75      24.209 106.454  10.378  1.00 12.21           O  
ATOM    229  CB  TRP A  75      25.609 107.057  12.911  1.00 12.90           C  
ATOM    230  CG  TRP A  75      24.441 106.524  13.653  1.00 12.77           C  
ATOM    231  CD1 TRP A  75      24.303 105.275  14.184  1.00 14.51           C  
ATOM    232  CD2 TRP A  75      23.249 107.239  13.992  1.00 12.84           C  
ATOM    233  NE1 TRP A  75      23.101 105.169  14.833  1.00 15.37           N  
ATOM    234  CE2 TRP A  75      22.433 106.361  14.732  1.00 15.26           C  
ATOM    235  CE3 TRP A  75      22.795 108.542  13.747  1.00 14.64           C  
ATOM    236  CZ2 TRP A  75      21.177 106.739  15.229  1.00 15.11           C  
ATOM    237  CZ3 TRP A  75      21.543 108.919  14.243  1.00 16.61           C  
ATOM    238  CH2 TRP A  75      20.752 108.018  14.975  1.00 17.04           C  
ATOM    239  N   PHE A  76      24.964 104.352  10.702  1.00 11.67           N  
ATOM    240  CA  PHE A  76      23.953 103.737   9.848  1.00 12.93           C  
ATOM    241  C   PHE A  76      22.729 103.385  10.671  1.00 12.10           C  
ATOM    242  O   PHE A  76      22.814 102.626  11.641  1.00 14.15           O  
ATOM    243  CB  PHE A  76      24.537 102.493   9.177  1.00 13.92           C  
ATOM    244  CG  PHE A  76      25.782 102.774   8.382  1.00 14.35           C  
ATOM    245  CD1 PHE A  76      27.009 102.957   9.019  1.00 13.76           C  
ATOM    246  CD2 PHE A  76      25.719 102.902   6.997  1.00 14.26           C  
ATOM    247  CE1 PHE A  76      28.153 103.265   8.284  1.00 13.36           C  
ATOM    248  CE2 PHE A  76      26.859 103.210   6.258  1.00 16.87           C  
ATOM    249  CZ  PHE A  76      28.077 103.392   6.904  1.00 15.54           C  
ATOM    250  N   TRP A  77      21.589 103.951  10.288  1.00 11.84           N  
ATOM    251  CA  TRP A  77      20.345 103.721  11.015  1.00 11.93           C  
ATOM    252  C   TRP A  77      19.135 103.515  10.115  1.00 12.82           C  
ATOM    253  O   TRP A  77      19.173 103.820   8.924  1.00 13.48           O  
ATOM    254  CB  TRP A  77      20.060 104.892  11.979  1.00 12.45           C  
ATOM    255  CG  TRP A  77      19.931 106.269  11.347  1.00 12.33           C  
ATOM    256  CD1 TRP A  77      20.934 107.166  11.110  1.00 10.18           C  
ATOM    257  CD2 TRP A  77      18.718 106.907  10.925  1.00 11.52           C  
ATOM    258  NE1 TRP A  77      20.420 108.330  10.577  1.00 12.11           N  
ATOM    259  CE2 TRP A  77      19.061 108.200  10.459  1.00 11.21           C  
ATOM    260  CE3 TRP A  77      17.372 106.520  10.912  1.00 12.66           C  
ATOM    261  CZ2 TRP A  77      18.113 109.097   9.967  1.00 14.74           C  
ATOM    262  CZ3 TRP A  77      16.424 107.418  10.421  1.00 13.94           C  
ATOM    263  CH2 TRP A  77      16.800 108.693   9.964  1.00 14.31           C  
ATOM    264  N   ALA A  78      18.076 102.965  10.702  1.00 12.55           N  
ATOM    265  CA  ALA A  78      16.806 102.734  10.009  1.00 15.63           C  
ATOM    266  C   ALA A  78      15.778 103.349  10.956  1.00 15.16           C  
ATOM    267  O   ALA A  78      15.849 103.149  12.164  1.00 13.43           O  
ATOM    268  CB  ALA A  78      16.552 101.237   9.828  1.00 13.84           C  
ATOM    269  N   PRO A  79      14.804 104.097  10.419  1.00 15.93           N  
ATOM    270  CA  PRO A  79      13.771 104.752  11.230  1.00 15.70           C  
ATOM    271  C   PRO A  79      12.962 103.854  12.159  1.00 16.07           C  
ATOM    272  O   PRO A  79      12.581 104.270  13.256  1.00 16.95           O  
ATOM    273  CB  PRO A  79      12.873 105.421  10.183  1.00 18.11           C  
ATOM    274  CG  PRO A  79      13.745 105.551   8.981  1.00 20.32           C  
ATOM    275  CD  PRO A  79      14.531 104.280   8.985  1.00 15.80           C  
ATOM    276  N   TRP A  80      12.700 102.629  11.714  1.00 16.04           N  
ATOM    277  CA  TRP A  80      11.901 101.678  12.474  1.00 18.08           C  
ATOM    278  C   TRP A  80      12.699 100.849  13.466  1.00 19.48           C  
ATOM    279  O   TRP A  80      12.119 100.021  14.197  1.00 18.81           O  
ATOM    280  CB  TRP A  80      11.169 100.753  11.499  1.00 17.86           C  
ATOM    281  CG  TRP A  80      12.081 100.225  10.430  1.00 16.98           C  
ATOM    282  CD1 TRP A  80      12.199 100.683   9.151  1.00 16.13           C  
ATOM    283  CD2 TRP A  80      13.064  99.196  10.581  1.00 17.71           C  
ATOM    284  NE1 TRP A  80      13.196 100.006   8.493  1.00 16.50           N  
ATOM    285  CE2 TRP A  80      13.740  99.081   9.347  1.00 17.25           C  
ATOM    286  CE3 TRP A  80      13.435  98.350  11.637  1.00 17.71           C  
ATOM    287  CZ2 TRP A  80      14.779  98.167   9.142  1.00 19.52           C  
ATOM    288  CZ3 TRP A  80      14.468  97.443  11.435  1.00 19.72           C  
ATOM    289  CH2 TRP A  80      15.123  97.355  10.191  1.00 18.99           C  
ATOM    290  N   CYS A  81      13.989 101.028  13.532  1.00 18.04           N  
ATOM    291  CA  CYS A  81      14.797 100.243  14.422  1.00 19.58           C  
ATOM    292  C   CYS A  81      14.803 100.796  15.853  1.00 20.13           C  
ATOM    293  O   CYS A  81      15.311 101.911  16.105  1.00 19.10           O  
ATOM    294  CB  CYS A  81      16.229 100.312  13.747  1.00 19.82           C  
ATOM    295  SG  CYS A  81      17.335  99.152  14.724  1.00 25.85           S  
ATOM    296  N   PRO A  82      14.267 100.026  16.774  1.00 20.35           N  
ATOM    297  CA  PRO A  82      14.240 100.424  18.166  1.00 20.59           C  
ATOM    298  C   PRO A  82      15.580 100.695  18.783  1.00 20.64           C  
ATOM    299  O   PRO A  82      15.706 101.562  19.649  1.00 20.96           O  
ATOM    300  CB  PRO A  82      13.481  99.272  18.832  1.00 23.38           C  
ATOM    301  CG  PRO A  82      13.838  98.098  17.982  1.00 23.91           C  
ATOM    302  CD  PRO A  82      13.731  98.665  16.588  1.00 22.39           C  
ATOM    303  N   THR A  83      16.581  99.952  18.343  1.00 19.19           N  
ATOM    304  CA  THR A  83      17.928 100.147  18.858  1.00 20.24           C  
ATOM    305  C   THR A  83      18.447 101.499  18.372  1.00 19.48           C  
ATOM    306  O   THR A  83      19.072 102.237  19.135  1.00 19.25           O  
ATOM    307  CB  THR A  83      18.870  99.021  18.395  1.00 22.88           C  
ATOM    308  OG1 THR A  83      18.370  97.763  18.869  1.00 25.42           O  
ATOM    309  CG2 THR A  83      20.272  99.233  18.939  1.00 24.26           C  
ATOM    310  N   CYS A  84      18.189 101.831  17.109  1.00 17.36           N  
ATOM    311  CA  CYS A  84      18.625 103.123  16.584  1.00 16.44           C  
ATOM    312  C   CYS A  84      17.905 104.263  17.268  1.00 16.23           C  
ATOM    313  O   CYS A  84      18.485 105.319  17.507  1.00 16.34           O  
ATOM    314  CB  CYS A  84      18.372 103.211  15.088  1.00 16.14           C  
ATOM    315  SG  CYS A  84      19.451 102.121  14.118  1.00 19.49           S  
ATOM    316  N   GLN A  85      16.633 104.047  17.571  1.00 15.73           N  
ATOM    317  CA  GLN A  85      15.846 105.061  18.250  1.00 15.90           C  
ATOM    318  C   GLN A  85      16.466 105.301  19.621  1.00 17.13           C  
ATOM    319  O   GLN A  85      16.547 106.436  20.089  1.00 18.70           O  
ATOM    320  CB  GLN A  85      14.395 104.588  18.385  1.00 15.72           C  
ATOM    321  CG  GLN A  85      13.671 104.504  17.048  1.00 16.97           C  
ATOM    322  CD  GLN A  85      12.391 103.693  17.112  1.00 19.50           C  
ATOM    323  OE1 GLN A  85      11.895 103.371  18.192  1.00 21.19           O  
ATOM    324  NE2 GLN A  85      11.849 103.358  15.946  1.00 19.46           N  
ATOM    325  N   GLY A  86      16.930 104.225  20.247  1.00 17.93           N  
ATOM    326  CA  GLY A  86      17.545 104.348  21.556  1.00 19.33           C  
ATOM    327  C   GLY A  86      18.921 104.985  21.526  1.00 20.45           C  
ATOM    328  O   GLY A  86      19.298 105.706  22.449  1.00 22.43           O  
ATOM    329  N   GLU A  87      19.681 104.735  20.467  1.00 18.82           N  
ATOM    330  CA  GLU A  87      21.020 105.301  20.375  1.00 19.70           C  
ATOM    331  C   GLU A  87      21.062 106.720  19.818  1.00 17.35           C  
ATOM    332  O   GLU A  87      22.061 107.420  19.977  1.00 18.11           O  
ATOM    333  CB  GLU A  87      21.915 104.404  19.523  1.00 22.97           C  
ATOM    334  CG  GLU A  87      21.960 102.964  19.992  1.00 25.74           C  
ATOM    335  CD  GLU A  87      23.167 102.220  19.467  1.00 27.29           C  
ATOM    336  OE1 GLU A  87      23.510 102.394  18.279  1.00 29.41           O  
ATOM    337  OE2 GLU A  87      23.767 101.450  20.242  1.00 29.62           O  
ATOM    338  N   ALA A  88      19.984 107.141  19.170  1.00 17.20           N  
ATOM    339  CA  ALA A  88      19.931 108.474  18.577  1.00 17.01           C  
ATOM    340  C   ALA A  88      20.359 109.607  19.514  1.00 17.89           C  
ATOM    341  O   ALA A  88      21.215 110.411  19.157  1.00 16.44           O  
ATOM    342  CB  ALA A  88      18.536 108.744  18.023  1.00 17.49           C  
ATOM    343  N   PRO A  89      19.782 109.682  20.726  1.00 19.46           N  
ATOM    344  CA  PRO A  89      20.183 110.763  21.639  1.00 21.05           C  
ATOM    345  C   PRO A  89      21.655 110.688  22.038  1.00 21.11           C  
ATOM    346  O   PRO A  89      22.291 111.710  22.309  1.00 20.36           O  
ATOM    347  CB  PRO A  89      19.235 110.583  22.824  1.00 21.51           C  
ATOM    348  CG  PRO A  89      18.958 109.112  22.818  1.00 23.34           C  
ATOM    349  CD  PRO A  89      18.757 108.826  21.346  1.00 21.14           C  
ATOM    350  N   VAL A  90      22.194 109.475  22.064  1.00 18.67           N  
ATOM    351  CA  VAL A  90      23.594 109.271  22.410  1.00 19.03           C  
ATOM    352  C   VAL A  90      24.488 109.780  21.283  1.00 18.51           C  
ATOM    353  O   VAL A  90      25.478 110.473  21.522  1.00 17.09           O  
ATOM    354  CB  VAL A  90      23.891 107.782  22.639  1.00 20.93           C  
ATOM    355  CG1 VAL A  90      25.377 107.573  22.848  1.00 19.91           C  
ATOM    356  CG2 VAL A  90      23.106 107.282  23.840  1.00 21.35           C  
ATOM    357  N   VAL A  91      24.148 109.431  20.050  1.00 15.12           N  
ATOM    358  CA  VAL A  91      24.950 109.887  18.929  1.00 15.68           C  
ATOM    359  C   VAL A  91      24.870 111.409  18.858  1.00 14.50           C  
ATOM    360  O   VAL A  91      25.866 112.078  18.601  1.00 15.80           O  
ATOM    361  CB  VAL A  91      24.460 109.289  17.594  1.00 13.94           C  
ATOM    362  CG1 VAL A  91      25.332 109.797  16.454  1.00 16.20           C  
ATOM    363  CG2 VAL A  91      24.524 107.763  17.653  1.00 14.84           C  
ATOM    364  N   GLY A  92      23.682 111.954  19.097  1.00 15.54           N  
ATOM    365  CA  GLY A  92      23.525 113.397  19.053  1.00 17.09           C  
ATOM    366  C   GLY A  92      24.372 114.093  20.101  1.00 18.12           C  
ATOM    367  O   GLY A  92      24.985 115.127  19.836  1.00 18.58           O  
ATOM    368  N   GLN A  93      24.418 113.518  21.295  1.00 18.03           N  
ATOM    369  CA  GLN A  93      25.197 114.098  22.380  1.00 20.54           C  
ATOM    370  C   GLN A  93      26.687 114.080  22.056  1.00 19.08           C  
ATOM    371  O   GLN A  93      27.381 115.082  22.230  1.00 18.45           O  
ATOM    372  CB  GLN A  93      24.925 113.336  23.678  1.00 24.68           C  
ATOM    373  CG  GLN A  93      25.485 113.999  24.928  1.00 32.04           C  
ATOM    374  CD  GLN A  93      24.993 113.338  26.204  1.00 36.79           C  
ATOM    375  OE1 GLN A  93      25.348 113.753  27.309  1.00 39.66           O  
ATOM    376  NE2 GLN A  93      24.172 112.302  26.057  1.00 38.59           N  
ATOM    377  N   VAL A  94      27.187 112.943  21.581  1.00 15.89           N  
ATOM    378  CA  VAL A  94      28.603 112.844  21.249  1.00 15.79           C  
ATOM    379  C   VAL A  94      28.956 113.782  20.091  1.00 15.40           C  
ATOM    380  O   VAL A  94      30.021 114.400  20.087  1.00 15.73           O  
ATOM    381  CB  VAL A  94      29.000 111.380  20.905  1.00 15.58           C  
ATOM    382  CG1 VAL A  94      30.469 111.302  20.523  1.00 16.61           C  
ATOM    383  CG2 VAL A  94      28.747 110.486  22.116  1.00 17.51           C  
ATOM    384  N   ALA A  95      28.059 113.897  19.115  1.00 15.69           N  
ATOM    385  CA  ALA A  95      28.293 114.776  17.981  1.00 14.68           C  
ATOM    386  C   ALA A  95      28.433 116.215  18.468  1.00 16.15           C  
ATOM    387  O   ALA A  95      29.333 116.937  18.041  1.00 16.20           O  
ATOM    388  CB  ALA A  95      27.139 114.677  16.983  1.00 16.25           C  
ATOM    389  N   ALA A  96      27.541 116.615  19.367  1.00 16.26           N  
ATOM    390  CA  ALA A  96      27.556 117.973  19.908  1.00 18.37           C  
ATOM    391  C   ALA A  96      28.813 118.262  20.723  1.00 20.28           C  
ATOM    392  O   ALA A  96      29.328 119.385  20.714  1.00 22.61           O  
ATOM    393  CB  ALA A  96      26.325 118.188  20.770  1.00 17.36           C  
ATOM    394  N   SER A  97      29.305 117.246  21.425  1.00 18.39           N  
ATOM    395  CA  SER A  97      30.489 117.385  22.266  1.00 19.50           C  
ATOM    396  C   SER A  97      31.797 117.341  21.483  1.00 17.99           C  
ATOM    397  O   SER A  97      32.849 117.716  21.998  1.00 19.18           O  
ATOM    398  CB  SER A  97      30.500 116.282  23.322  1.00 21.05           C  
ATOM    399  OG  SER A  97      29.342 116.355  24.133  1.00 26.65           O  
ATOM    400  N   HIS A  98      31.737 116.891  20.234  1.00 17.09           N  
ATOM    401  CA  HIS A  98      32.942 116.807  19.425  1.00 17.49           C  
ATOM    402  C   HIS A  98      32.793 117.453  18.064  1.00 18.54           C  
ATOM    403  O   HIS A  98      32.744 116.771  17.040  1.00 18.71           O  
ATOM    404  CB  HIS A  98      33.355 115.344  19.266  1.00 16.92           C  
ATOM    405  CG  HIS A  98      33.715 114.694  20.559  1.00 19.44           C  
ATOM    406  ND1 HIS A  98      32.770 114.282  21.472  1.00 20.04           N  
ATOM    407  CD2 HIS A  98      34.919 114.452  21.127  1.00 19.65           C  
ATOM    408  CE1 HIS A  98      33.375 113.817  22.549  1.00 18.33           C  
ATOM    409  NE2 HIS A  98      34.679 113.910  22.365  1.00 19.09           N  
ATOM    410  N   PRO A  99      32.736 118.793  18.034  1.00 18.82           N  
ATOM    411  CA  PRO A  99      32.591 119.539  16.783  1.00 20.46           C  
ATOM    412  C   PRO A  99      33.750 119.353  15.807  1.00 20.64           C  
ATOM    413  O   PRO A  99      33.634 119.707  14.633  1.00 23.62           O  
ATOM    414  CB  PRO A  99      32.433 120.984  17.261  1.00 21.25           C  
ATOM    415  CG  PRO A  99      33.199 121.001  18.559  1.00 20.43           C  
ATOM    416  CD  PRO A  99      32.776 119.704  19.194  1.00 18.56           C  
ATOM    417  N   GLU A 100      34.862 118.792  16.275  1.00 20.29           N  
ATOM    418  CA  GLU A 100      36.006 118.572  15.396  1.00 21.39           C  
ATOM    419  C   GLU A 100      35.740 117.363  14.503  1.00 20.29           C  
ATOM    420  O   GLU A 100      36.377 117.194  13.465  1.00 22.37           O  
ATOM    421  CB  GLU A 100      37.296 118.339  16.205  1.00 22.84           C  
ATOM    422  CG  GLU A 100      37.446 116.947  16.827  1.00 24.25           C  
ATOM    423  CD  GLU A 100      36.651 116.767  18.107  1.00 25.80           C  
ATOM    424  OE1 GLU A 100      35.758 117.591  18.385  1.00 23.96           O  
ATOM    425  OE2 GLU A 100      36.919 115.784  18.836  1.00 29.21           O  
ATOM    426  N   VAL A 101      34.791 116.530  14.916  1.00 19.09           N  
ATOM    427  CA  VAL A 101      34.450 115.327  14.167  1.00 18.20           C  
ATOM    428  C   VAL A 101      33.195 115.523  13.328  1.00 15.53           C  
ATOM    429  O   VAL A 101      32.186 116.035  13.805  1.00 18.27           O  
ATOM    430  CB  VAL A 101      34.229 114.132  15.120  1.00 18.59           C  
ATOM    431  CG1 VAL A 101      33.898 112.873  14.320  1.00 19.44           C  
ATOM    432  CG2 VAL A 101      35.467 113.919  15.968  1.00 21.35           C  
ATOM    433  N   THR A 102      33.260 115.119  12.068  1.00 16.03           N  
ATOM    434  CA  THR A 102      32.108 115.254  11.204  1.00 14.92           C  
ATOM    435  C   THR A 102      31.251 114.006  11.352  1.00 14.17           C  
ATOM    436  O   THR A 102      31.689 112.907  11.009  1.00 15.07           O  
ATOM    437  CB  THR A 102      32.537 115.428   9.726  1.00 15.41           C  
ATOM    438  OG1 THR A 102      33.275 116.650   9.583  1.00 16.97           O  
ATOM    439  CG2 THR A 102      31.322 115.471   8.807  1.00 15.44           C  
ATOM    440  N   PHE A 103      30.056 114.169  11.907  1.00 13.45           N  
ATOM    441  CA  PHE A 103      29.143 113.039  12.055  1.00 12.95           C  
ATOM    442  C   PHE A 103      28.206 113.029  10.863  1.00 13.62           C  
ATOM    443  O   PHE A 103      27.728 114.082  10.427  1.00 13.56           O  
ATOM    444  CB  PHE A 103      28.327 113.139  13.344  1.00 14.76           C  
ATOM    445  CG  PHE A 103      29.020 112.573  14.541  1.00 16.96           C  
ATOM    446  CD1 PHE A 103      30.119 113.219  15.098  1.00 18.51           C  
ATOM    447  CD2 PHE A 103      28.584 111.378  15.107  1.00 18.60           C  
ATOM    448  CE1 PHE A 103      30.776 112.681  16.204  1.00 18.84           C  
ATOM    449  CE2 PHE A 103      29.234 110.837  16.211  1.00 19.44           C  
ATOM    450  CZ  PHE A 103      30.331 111.492  16.760  1.00 19.53           C  
ATOM    451  N   VAL A 104      27.958 111.840  10.324  1.00 11.26           N  
ATOM    452  CA  VAL A 104      27.067 111.697   9.186  1.00 12.81           C  
ATOM    453  C   VAL A 104      26.131 110.527   9.424  1.00 12.95           C  
ATOM    454  O   VAL A 104      26.574 109.382   9.549  1.00 14.21           O  
ATOM    455  CB  VAL A 104      27.847 111.428   7.877  1.00 13.51           C  
ATOM    456  CG1 VAL A 104      26.876 111.336   6.696  1.00 15.22           C  
ATOM    457  CG2 VAL A 104      28.865 112.522   7.638  1.00 14.24           C  
ATOM    458  N   GLY A 105      24.839 110.820   9.508  1.00 12.84           N  
ATOM    459  CA  GLY A 105      23.864 109.763   9.689  1.00 12.98           C  
ATOM    460  C   GLY A 105      23.576 109.214   8.307  1.00 11.91           C  
ATOM    461  O   GLY A 105      23.550 109.978   7.342  1.00 12.85           O  
ATOM    462  N   VAL A 106      23.403 107.902   8.196  1.00 10.57           N  
ATOM    463  CA  VAL A 106      23.116 107.276   6.908  1.00 12.95           C  
ATOM    464  C   VAL A 106      21.863 106.429   7.087  1.00 12.57           C  
ATOM    465  O   VAL A 106      21.935 105.279   7.505  1.00 11.57           O  
ATOM    466  CB  VAL A 106      24.288 106.376   6.444  1.00 13.92           C  
ATOM    467  CG1 VAL A 106      24.040 105.903   5.012  1.00 15.29           C  
ATOM    468  CG2 VAL A 106      25.611 107.147   6.537  1.00 14.18           C  
ATOM    469  N   ALA A 107      20.711 107.015   6.775  1.00 14.25           N  
ATOM    470  CA  ALA A 107      19.433 106.334   6.928  1.00 14.57           C  
ATOM    471  C   ALA A 107      19.131 105.417   5.759  1.00 15.81           C  
ATOM    472  O   ALA A 107      19.298 105.794   4.601  1.00 17.54           O  
ATOM    473  CB  ALA A 107      18.320 107.352   7.085  1.00 14.61           C  
ATOM    474  N   GLY A 108      18.678 104.211   6.072  1.00 15.12           N  
ATOM    475  CA  GLY A 108      18.348 103.263   5.031  1.00 17.56           C  
ATOM    476  C   GLY A 108      17.170 102.381   5.394  1.00 18.27           C  
ATOM    477  O   GLY A 108      16.599 102.494   6.482  1.00 16.52           O  
ATOM    478  N   LEU A 109      16.797 101.520   4.452  1.00 18.52           N  
ATOM    479  CA  LEU A 109      15.714 100.558   4.628  1.00 18.58           C  
ATOM    480  C   LEU A 109      14.338 101.162   4.881  1.00 18.38           C  
ATOM    481  O   LEU A 109      13.538 100.608   5.634  1.00 17.64           O  
ATOM    482  CB  LEU A 109      16.070  99.584   5.757  1.00 17.92           C  
ATOM    483  CG  LEU A 109      17.408  98.859   5.587  1.00 20.57           C  
ATOM    484  CD1 LEU A 109      17.570  97.815   6.681  1.00 20.28           C  
ATOM    485  CD2 LEU A 109      17.468  98.200   4.213  1.00 21.11           C  
ATOM    486  N   ASP A 110      14.068 102.295   4.250  1.00 18.25           N  
ATOM    487  CA  ASP A 110      12.780 102.957   4.396  1.00 19.14           C  
ATOM    488  C   ASP A 110      12.750 104.141   3.444  1.00 21.19           C  
ATOM    489  O   ASP A 110      13.696 104.345   2.683  1.00 21.50           O  
ATOM    490  CB  ASP A 110      12.580 103.413   5.843  1.00 20.25           C  
ATOM    491  CG  ASP A 110      11.118 103.431   6.251  1.00 21.59           C  
ATOM    492  OD1 ASP A 110      10.838 103.377   7.467  1.00 22.26           O  
ATOM    493  OD2 ASP A 110      10.250 103.506   5.356  1.00 22.82           O  
ATOM    494  N   GLN A 111      11.667 104.910   3.476  1.00 23.89           N  
ATOM    495  CA  GLN A 111      11.541 106.070   2.607  1.00 25.16           C  
ATOM    496  C   GLN A 111      11.722 107.361   3.399  1.00 23.33           C  
ATOM    497  O   GLN A 111      11.728 107.354   4.631  1.00 22.50           O  
ATOM    498  CB  GLN A 111      10.179 106.054   1.905  1.00 28.04           C  
ATOM    499  CG  GLN A 111       9.946 104.789   1.086  1.00 29.77           C  
ATOM    500  CD  GLN A 111      10.908 104.653  -0.086  1.00 32.25           C  
ATOM    501  OE1 GLN A 111      11.167 103.549  -0.565  1.00 33.72           O  
ATOM    502  NE2 GLN A 111      11.429 105.780  -0.562  1.00 32.02           N  
ATOM    503  N   VAL A 112      11.870 108.467   2.680  1.00 21.15           N  
ATOM    504  CA  VAL A 112      12.088 109.774   3.285  1.00 21.48           C  
ATOM    505  C   VAL A 112      11.150 110.176   4.427  1.00 21.51           C  
ATOM    506  O   VAL A 112      11.610 110.617   5.479  1.00 21.82           O  
ATOM    507  CB  VAL A 112      12.073 110.882   2.200  1.00 20.38           C  
ATOM    508  CG1 VAL A 112      12.144 112.259   2.848  1.00 21.52           C  
ATOM    509  CG2 VAL A 112      13.252 110.689   1.257  1.00 22.51           C  
ATOM    510  N   PRO A 113       9.828 110.041   4.238  1.00 21.34           N  
ATOM    511  CA  PRO A 113       8.897 110.419   5.307  1.00 21.71           C  
ATOM    512  C   PRO A 113       9.230 109.789   6.657  1.00 20.16           C  
ATOM    513  O   PRO A 113       9.193 110.457   7.687  1.00 20.51           O  
ATOM    514  CB  PRO A 113       7.546 109.951   4.768  1.00 23.09           C  
ATOM    515  CG  PRO A 113       7.705 110.137   3.290  1.00 21.94           C  
ATOM    516  CD  PRO A 113       9.093 109.586   3.042  1.00 22.77           C  
ATOM    517  N   ALA A 114       9.547 108.499   6.645  1.00 20.55           N  
ATOM    518  CA  ALA A 114       9.880 107.788   7.878  1.00 18.78           C  
ATOM    519  C   ALA A 114      11.182 108.334   8.452  1.00 18.08           C  
ATOM    520  O   ALA A 114      11.342 108.446   9.667  1.00 16.86           O  
ATOM    521  CB  ALA A 114      10.006 106.297   7.604  1.00 21.36           C  
ATOM    522  N   MET A 115      12.113 108.677   7.571  1.00 18.85           N  
ATOM    523  CA  MET A 115      13.389 109.228   8.005  1.00 17.37           C  
ATOM    524  C   MET A 115      13.180 110.586   8.671  1.00 17.65           C  
ATOM    525  O   MET A 115      13.779 110.877   9.701  1.00 15.02           O  
ATOM    526  CB  MET A 115      14.325 109.357   6.808  1.00 16.72           C  
ATOM    527  CG  MET A 115      14.590 108.031   6.134  1.00 16.60           C  
ATOM    528  SD  MET A 115      15.572 108.182   4.641  1.00 18.49           S  
ATOM    529  CE  MET A 115      15.864 106.521   4.287  1.00 16.76           C  
ATOM    530  N   GLN A 116      12.318 111.414   8.085  1.00 18.28           N  
ATOM    531  CA  GLN A 116      12.034 112.730   8.649  1.00 19.22           C  
ATOM    532  C   GLN A 116      11.386 112.611  10.028  1.00 17.78           C  
ATOM    533  O   GLN A 116      11.674 113.404  10.923  1.00 19.80           O  
ATOM    534  CB  GLN A 116      11.104 113.513   7.721  1.00 20.13           C  
ATOM    535  CG  GLN A 116      11.636 113.648   6.310  1.00 22.05           C  
ATOM    536  CD  GLN A 116      10.651 114.338   5.391  1.00 22.93           C  
ATOM    537  OE1 GLN A 116       9.459 114.032   5.407  1.00 23.81           O  
ATOM    538  NE2 GLN A 116      11.144 115.263   4.574  1.00 20.79           N  
ATOM    539  N   GLU A 117      10.506 111.626  10.192  1.00 19.33           N  
ATOM    540  CA  GLU A 117       9.832 111.415  11.470  1.00 22.04           C  
ATOM    541  C   GLU A 117      10.860 111.091  12.547  1.00 18.84           C  
ATOM    542  O   GLU A 117      10.777 111.585  13.669  1.00 18.34           O  
ATOM    543  CB  GLU A 117       8.827 110.266  11.362  1.00 25.40           C  
ATOM    544  CG  GLU A 117       7.594 110.577  10.540  1.00 32.25           C  
ATOM    545  CD  GLU A 117       6.700 109.364  10.364  1.00 36.36           C  
ATOM    546  OE1 GLU A 117       6.403 108.692  11.377  1.00 39.60           O  
ATOM    547  OE2 GLU A 117       6.289 109.086   9.216  1.00 39.27           O  
ATOM    548  N   PHE A 118      11.826 110.254  12.188  1.00 17.44           N  
ATOM    549  CA  PHE A 118      12.890 109.847  13.096  1.00 17.39           C  
ATOM    550  C   PHE A 118      13.737 111.055  13.516  1.00 17.44           C  
ATOM    551  O   PHE A 118      13.974 111.275  14.705  1.00 17.64           O  
ATOM    552  CB  PHE A 118      13.762 108.793  12.405  1.00 16.15           C  
ATOM    553  CG  PHE A 118      14.899 108.274  13.250  1.00 16.55           C  
ATOM    554  CD1 PHE A 118      14.772 107.083  13.958  1.00 15.85           C  
ATOM    555  CD2 PHE A 118      16.116 108.952  13.291  1.00 15.33           C  
ATOM    556  CE1 PHE A 118      15.846 106.569  14.691  1.00 14.58           C  
ATOM    557  CE2 PHE A 118      17.194 108.450  14.022  1.00 15.53           C  
ATOM    558  CZ  PHE A 118      17.058 107.253  14.721  1.00 17.21           C  
ATOM    559  N   VAL A 119      14.188 111.843  12.541  1.00 17.66           N  
ATOM    560  CA  VAL A 119      15.004 113.008  12.859  1.00 18.59           C  
ATOM    561  C   VAL A 119      14.217 114.048  13.657  1.00 19.81           C  
ATOM    562  O   VAL A 119      14.795 114.778  14.457  1.00 20.65           O  
ATOM    563  CB  VAL A 119      15.595 113.659  11.579  1.00 20.69           C  
ATOM    564  CG1 VAL A 119      16.485 112.658  10.853  1.00 20.75           C  
ATOM    565  CG2 VAL A 119      14.487 114.133  10.666  1.00 23.67           C  
ATOM    566  N   ASN A 120      12.902 114.110  13.453  1.00 21.56           N  
ATOM    567  CA  ASN A 120      12.071 115.059  14.193  1.00 24.56           C  
ATOM    568  C   ASN A 120      11.913 114.622  15.644  1.00 26.76           C  
ATOM    569  O   ASN A 120      11.921 115.446  16.560  1.00 26.49           O  
ATOM    570  CB  ASN A 120      10.668 115.180  13.577  1.00 25.33           C  
ATOM    571  CG  ASN A 120      10.642 116.012  12.306  1.00 27.43           C  
ATOM    572  OD1 ASN A 120      11.443 116.903  12.126  1.00 26.96           O  
ATOM    573  ND2 ASN A 120       9.694 115.728  11.429  1.00 27.57           N  
ATOM    574  N   LYS A 121      11.779 113.316  15.848  1.00 27.35           N  
ATOM    575  CA  LYS A 121      11.579 112.759  17.182  1.00 29.97           C  
ATOM    576  C   LYS A 121      12.856 112.714  18.021  1.00 29.30           C  
ATOM    577  O   LYS A 121      12.804 112.958  19.234  1.00 29.42           O  
ATOM    578  CB  LYS A 121      11.003 111.347  17.062  1.00 31.56           C  
ATOM    579  CG  LYS A 121      10.207 110.869  18.269  1.00 36.16           C  
ATOM    580  CD  LYS A 121      11.087 110.621  19.481  1.00 38.85           C  
ATOM    581  CE  LYS A 121      10.272 110.086  20.652  1.00 41.40           C  
ATOM    582  NZ  LYS A 121      11.120 109.826  21.852  1.00 41.91           N  
ATOM    583  N   TYR A 122      13.995 112.415  17.395  1.00 27.52           N  
ATOM    584  CA  TYR A 122      15.225 112.357  18.165  1.00 26.27           C  
ATOM    585  C   TYR A 122      16.200 113.457  17.779  1.00 26.90           C  
ATOM    586  O   TYR A 122      16.297 113.838  16.595  1.00 28.52           O  
ATOM    587  CB  TYR A 122      15.861 110.943  18.006  1.00 25.48           C  
ATOM    588  CG  TYR A 122      14.850 109.839  18.139  1.00 25.07           C  
ATOM    589  CD1 TYR A 122      14.286 109.272  17.003  1.00 24.41           C  
ATOM    590  CD2 TYR A 122      14.453 109.352  19.394  1.00 25.14           C  
ATOM    591  CE1 TYR A 122      13.358 108.242  17.096  1.00 26.27           C  
ATOM    592  CE2 TYR A 122      13.523 108.316  19.496  1.00 25.28           C  
ATOM    593  CZ  TYR A 122      12.981 107.773  18.349  1.00 25.66           C  
ATOM    594  OH  TYR A 122      12.056 106.768  18.454  1.00 28.54           O  
ATOM    595  N   PRO A 123      17.009 113.945  18.732  1.00 27.18           N  
ATOM    596  CA  PRO A 123      18.013 115.006  18.643  1.00 26.59           C  
ATOM    597  C   PRO A 123      19.247 114.716  17.792  1.00 25.01           C  
ATOM    598  O   PRO A 123      20.369 114.660  18.294  1.00 27.61           O  
ATOM    599  CB  PRO A 123      18.403 115.221  20.122  1.00 26.85           C  
ATOM    600  CG  PRO A 123      18.372 113.860  20.673  1.00 27.31           C  
ATOM    601  CD  PRO A 123      17.045 113.320  20.043  1.00 27.64           C  
ATOM    602  N   VAL A 124      19.011 114.589  16.502  1.00 24.83           N  
ATOM    603  CA  VAL A 124      20.081 114.316  15.560  1.00 22.71           C  
ATOM    604  C   VAL A 124      19.984 115.202  14.322  1.00 24.53           C  
ATOM    605  O   VAL A 124      20.513 114.863  13.265  1.00 23.69           O  
ATOM    606  CB  VAL A 124      20.059 112.836  15.111  1.00 21.74           C  
ATOM    607  CG1 VAL A 124      20.267 111.918  16.311  1.00 21.88           C  
ATOM    608  CG2 VAL A 124      18.735 112.526  14.433  1.00 20.11           C  
ATOM    609  N   LYS A 125      19.304 116.336  14.452  1.00 26.99           N  
ATOM    610  CA  LYS A 125      19.157 117.258  13.330  1.00 30.28           C  
ATOM    611  C   LYS A 125      20.358 118.185  13.181  1.00 30.18           C  
ATOM    612  O   LYS A 125      20.489 118.878  12.175  1.00 33.54           O  
ATOM    613  CB  LYS A 125      17.882 118.087  13.505  1.00 31.63           C  
ATOM    614  CG  LYS A 125      16.719 117.551  12.720  1.00 33.90           C  
ATOM    615  CD  LYS A 125      15.377 118.114  13.212  1.00 35.92           C  
ATOM    616  CE  LYS A 125      14.209 117.564  12.416  1.00 36.12           C  
ATOM    617  NZ  LYS A 125      12.931 118.084  12.944  1.00 37.65           N  
ATOM    618  N   THR A 126      21.236 118.169  14.180  1.00 29.97           N  
ATOM    619  CA  THR A 126      22.432 119.006  14.205  1.00 29.51           C  
ATOM    620  C   THR A 126      23.554 118.538  13.268  1.00 28.21           C  
ATOM    621  O   THR A 126      24.474 119.302  12.965  1.00 27.82           O  
ATOM    622  CB  THR A 126      22.994 119.102  15.643  1.00 31.64           C  
ATOM    623  OG1 THR A 126      21.966 119.582  16.519  1.00 36.90           O  
ATOM    624  CG2 THR A 126      24.174 120.057  15.702  1.00 34.28           C  
ATOM    625  N   PHE A 127      23.504 117.287  12.820  1.00 22.23           N  
ATOM    626  CA  PHE A 127      24.533 116.813  11.904  1.00 20.17           C  
ATOM    627  C   PHE A 127      23.917 116.245  10.632  1.00 18.11           C  
ATOM    628  O   PHE A 127      22.727 115.923  10.590  1.00 18.69           O  
ATOM    629  CB  PHE A 127      25.469 115.799  12.594  1.00 19.45           C  
ATOM    630  CG  PHE A 127      24.785 114.564  13.116  1.00 18.01           C  
ATOM    631  CD1 PHE A 127      24.659 113.429  12.317  1.00 16.42           C  
ATOM    632  CD2 PHE A 127      24.311 114.517  14.423  1.00 17.19           C  
ATOM    633  CE1 PHE A 127      24.079 112.270  12.816  1.00 18.22           C  
ATOM    634  CE2 PHE A 127      23.727 113.360  14.931  1.00 19.61           C  
ATOM    635  CZ  PHE A 127      23.610 112.232  14.126  1.00 19.29           C  
ATOM    636  N   THR A 128      24.729 116.155   9.587  1.00 17.84           N  
ATOM    637  CA  THR A 128      24.280 115.663   8.292  1.00 17.18           C  
ATOM    638  C   THR A 128      23.577 114.313   8.327  1.00 17.42           C  
ATOM    639  O   THR A 128      24.060 113.369   8.950  1.00 17.30           O  
ATOM    640  CB  THR A 128      25.463 115.550   7.306  1.00 18.98           C  
ATOM    641  OG1 THR A 128      26.130 116.815   7.209  1.00 22.73           O  
ATOM    642  CG2 THR A 128      24.972 115.134   5.925  1.00 20.67           C  
ATOM    643  N   GLN A 129      22.435 114.229   7.646  1.00 14.78           N  
ATOM    644  CA  GLN A 129      21.679 112.982   7.555  1.00 14.30           C  
ATOM    645  C   GLN A 129      21.507 112.628   6.073  1.00 15.47           C  
ATOM    646  O   GLN A 129      20.971 113.423   5.302  1.00 18.48           O  
ATOM    647  CB  GLN A 129      20.295 113.134   8.196  1.00 15.10           C  
ATOM    648  CG  GLN A 129      20.299 113.421   9.686  1.00 16.01           C  
ATOM    649  CD  GLN A 129      20.878 112.291  10.500  1.00 14.64           C  
ATOM    650  OE1 GLN A 129      20.986 111.154  10.026  1.00 14.49           O  
ATOM    651  NE2 GLN A 129      21.250 112.589  11.740  1.00 18.07           N  
ATOM    652  N   LEU A 130      21.966 111.444   5.675  1.00 14.24           N  
ATOM    653  CA  LEU A 130      21.835 111.009   4.285  1.00 16.06           C  
ATOM    654  C   LEU A 130      20.645 110.078   4.112  1.00 17.15           C  
ATOM    655  O   LEU A 130      20.435 109.162   4.910  1.00 16.61           O  
ATOM    656  CB  LEU A 130      23.093 110.270   3.822  1.00 16.65           C  
ATOM    657  CG  LEU A 130      24.421 110.993   4.031  1.00 15.48           C  
ATOM    658  CD1 LEU A 130      25.541 110.163   3.438  1.00 15.49           C  
ATOM    659  CD2 LEU A 130      24.366 112.364   3.392  1.00 17.06           C  
ATOM    660  N   ALA A 131      19.865 110.312   3.061  1.00 17.17           N  
ATOM    661  CA  ALA A 131      18.706 109.469   2.775  1.00 18.72           C  
ATOM    662  C   ALA A 131      19.154 108.422   1.757  1.00 19.19           C  
ATOM    663  O   ALA A 131      19.035 108.631   0.548  1.00 22.16           O  
ATOM    664  CB  ALA A 131      17.572 110.312   2.209  1.00 19.76           C  
ATOM    665  N   ASP A 132      19.666 107.300   2.255  1.00 17.61           N  
ATOM    666  CA  ASP A 132      20.183 106.224   1.409  1.00 18.14           C  
ATOM    667  C   ASP A 132      19.101 105.241   0.966  1.00 18.10           C  
ATOM    668  O   ASP A 132      19.189 104.041   1.226  1.00 19.62           O  
ATOM    669  CB  ASP A 132      21.306 105.489   2.164  1.00 19.50           C  
ATOM    670  CG  ASP A 132      22.065 104.510   1.287  1.00 19.71           C  
ATOM    671  OD1 ASP A 132      22.338 104.852   0.115  1.00 23.13           O  
ATOM    672  OD2 ASP A 132      22.402 103.410   1.772  1.00 19.56           O  
ATOM    673  N   THR A 133      18.090 105.762   0.277  1.00 21.42           N  
ATOM    674  CA  THR A 133      16.984 104.938  -0.191  1.00 22.33           C  
ATOM    675  C   THR A 133      17.388 103.884  -1.214  1.00 23.35           C  
ATOM    676  O   THR A 133      16.766 102.822  -1.287  1.00 25.08           O  
ATOM    677  CB  THR A 133      15.845 105.804  -0.774  1.00 23.68           C  
ATOM    678  OG1 THR A 133      16.360 106.658  -1.802  1.00 23.84           O  
ATOM    679  CG2 THR A 133      15.216 106.652   0.317  1.00 24.40           C  
ATOM    680  N   ASP A 134      18.419 104.157  -2.011  1.00 23.55           N  
ATOM    681  CA  ASP A 134      18.849 103.165  -2.992  1.00 25.20           C  
ATOM    682  C   ASP A 134      19.855 102.204  -2.370  1.00 24.20           C  
ATOM    683  O   ASP A 134      20.322 101.269  -3.016  1.00 25.78           O  
ATOM    684  CB  ASP A 134      19.429 103.836  -4.253  1.00 27.77           C  
ATOM    685  CG  ASP A 134      20.733 104.571  -4.001  1.00 30.45           C  
ATOM    686  OD1 ASP A 134      21.251 105.175  -4.966  1.00 31.43           O  
ATOM    687  OD2 ASP A 134      21.246 104.550  -2.864  1.00 30.77           O  
ATOM    688  N   GLY A 135      20.172 102.446  -1.101  1.00 22.75           N  
ATOM    689  CA  GLY A 135      21.092 101.592  -0.373  1.00 19.56           C  
ATOM    690  C   GLY A 135      22.536 101.565  -0.838  1.00 18.25           C  
ATOM    691  O   GLY A 135      23.298 100.697  -0.417  1.00 20.68           O  
ATOM    692  N   SER A 136      22.920 102.510  -1.688  1.00 19.47           N  
ATOM    693  CA  SER A 136      24.286 102.542  -2.194  1.00 21.11           C  
ATOM    694  C   SER A 136      25.332 102.894  -1.136  1.00 20.45           C  
ATOM    695  O   SER A 136      26.447 102.367  -1.166  1.00 21.74           O  
ATOM    696  CB  SER A 136      24.396 103.499  -3.389  1.00 20.60           C  
ATOM    697  OG  SER A 136      24.006 104.819  -3.065  1.00 23.72           O  
ATOM    698  N   VAL A 137      24.991 103.771  -0.197  1.00 18.41           N  
ATOM    699  CA  VAL A 137      25.963 104.134   0.827  1.00 16.32           C  
ATOM    700  C   VAL A 137      26.191 102.966   1.783  1.00 16.52           C  
ATOM    701  O   VAL A 137      27.328 102.664   2.136  1.00 15.80           O  
ATOM    702  CB  VAL A 137      25.525 105.397   1.614  1.00 15.95           C  
ATOM    703  CG1 VAL A 137      26.591 105.759   2.647  1.00 18.68           C  
ATOM    704  CG2 VAL A 137      25.319 106.561   0.650  1.00 16.65           C  
ATOM    705  N   TRP A 138      25.118 102.299   2.206  1.00 15.02           N  
ATOM    706  CA  TRP A 138      25.272 101.149   3.084  1.00 15.87           C  
ATOM    707  C   TRP A 138      26.121 100.092   2.384  1.00 17.59           C  
ATOM    708  O   TRP A 138      27.015  99.497   2.985  1.00 17.24           O  
ATOM    709  CB  TRP A 138      23.915 100.536   3.424  1.00 16.42           C  
ATOM    710  CG  TRP A 138      23.178 101.231   4.520  1.00 16.92           C  
ATOM    711  CD1 TRP A 138      23.115 102.575   4.746  1.00 16.59           C  
ATOM    712  CD2 TRP A 138      22.334 100.618   5.496  1.00 16.26           C  
ATOM    713  NE1 TRP A 138      22.275 102.841   5.804  1.00 15.64           N  
ATOM    714  CE2 TRP A 138      21.778 101.655   6.279  1.00 15.53           C  
ATOM    715  CE3 TRP A 138      21.983  99.292   5.780  1.00 17.21           C  
ATOM    716  CZ2 TRP A 138      20.892 101.406   7.333  1.00 15.82           C  
ATOM    717  CZ3 TRP A 138      21.101  99.043   6.829  1.00 17.64           C  
ATOM    718  CH2 TRP A 138      20.564 100.099   7.589  1.00 16.66           C  
ATOM    719  N   ALA A 139      25.831  99.865   1.105  1.00 19.62           N  
ATOM    720  CA  ALA A 139      26.558  98.867   0.328  1.00 22.65           C  
ATOM    721  C   ALA A 139      28.044  99.194   0.273  1.00 22.97           C  
ATOM    722  O   ALA A 139      28.895  98.311   0.387  1.00 22.78           O  
ATOM    723  CB  ALA A 139      25.985  98.794  -1.080  1.00 23.17           C  
ATOM    724  N   ASN A 140      28.344 100.476   0.109  1.00 22.38           N  
ATOM    725  CA  ASN A 140      29.721 100.937   0.032  1.00 21.73           C  
ATOM    726  C   ASN A 140      30.539 100.609   1.279  1.00 22.46           C  
ATOM    727  O   ASN A 140      31.761 100.471   1.206  1.00 22.55           O  
ATOM    728  CB  ASN A 140      29.750 102.443  -0.207  1.00 22.07           C  
ATOM    729  CG  ASN A 140      31.156 102.979  -0.316  1.00 25.10           C  
ATOM    730  OD1 ASN A 140      31.827 102.767  -1.308  1.00 24.94           O  
ATOM    731  ND2 ASN A 140      31.616 103.659   0.724  1.00 24.84           N  
ATOM    732  N   PHE A 141      29.872 100.482   2.419  1.00 18.75           N  
ATOM    733  CA  PHE A 141      30.561 100.183   3.668  1.00 18.80           C  
ATOM    734  C   PHE A 141      30.322  98.758   4.143  1.00 20.51           C  
ATOM    735  O   PHE A 141      30.701  98.389   5.255  1.00 20.68           O  
ATOM    736  CB  PHE A 141      30.123 101.173   4.751  1.00 17.67           C  
ATOM    737  CG  PHE A 141      30.708 102.547   4.588  1.00 16.37           C  
ATOM    738  CD1 PHE A 141      31.968 102.843   5.103  1.00 17.08           C  
ATOM    739  CD2 PHE A 141      30.008 103.541   3.915  1.00 16.98           C  
ATOM    740  CE1 PHE A 141      32.525 104.111   4.946  1.00 17.40           C  
ATOM    741  CE2 PHE A 141      30.555 104.818   3.751  1.00 16.98           C  
ATOM    742  CZ  PHE A 141      31.817 105.100   4.271  1.00 18.16           C  
ATOM    743  N   GLY A 142      29.687  97.957   3.293  1.00 22.61           N  
ATOM    744  CA  GLY A 142      29.405  96.579   3.646  1.00 21.07           C  
ATOM    745  C   GLY A 142      28.420  96.443   4.793  1.00 20.63           C  
ATOM    746  O   GLY A 142      28.452  95.461   5.536  1.00 22.08           O  
ATOM    747  N   VAL A 143      27.547  97.432   4.949  1.00 18.89           N  
ATOM    748  CA  VAL A 143      26.557  97.400   6.020  1.00 19.14           C  
ATOM    749  C   VAL A 143      25.244  96.839   5.491  1.00 20.24           C  
ATOM    750  O   VAL A 143      24.655  97.378   4.554  1.00 19.93           O  
ATOM    751  CB  VAL A 143      26.310  98.811   6.605  1.00 18.37           C  
ATOM    752  CG1 VAL A 143      25.196  98.758   7.646  1.00 18.50           C  
ATOM    753  CG2 VAL A 143      27.589  99.341   7.240  1.00 20.61           C  
ATOM    754  N   THR A 144      24.794  95.744   6.093  1.00 23.54           N  
ATOM    755  CA  THR A 144      23.552  95.113   5.678  1.00 25.95           C  
ATOM    756  C   THR A 144      22.504  95.226   6.772  1.00 27.86           C  
ATOM    757  O   THR A 144      21.305  95.113   6.509  1.00 31.65           O  
ATOM    758  CB  THR A 144      23.773  93.625   5.338  1.00 26.11           C  
ATOM    759  OG1 THR A 144      24.419  92.974   6.437  1.00 25.55           O  
ATOM    760  CG2 THR A 144      24.638  93.491   4.094  1.00 26.83           C  
ATOM    761  N   GLN A 145      22.957  95.466   7.997  1.00 29.63           N  
ATOM    762  CA  GLN A 145      22.051  95.589   9.131  1.00 31.18           C  
ATOM    763  C   GLN A 145      22.449  96.713  10.078  1.00 28.67           C  
ATOM    764  O   GLN A 145      23.630  96.950  10.321  1.00 27.59           O  
ATOM    765  CB  GLN A 145      22.006  94.277   9.914  1.00 33.72           C  
ATOM    766  CG  GLN A 145      21.562  93.079   9.101  1.00 38.53           C  
ATOM    767  CD  GLN A 145      21.669  91.786   9.886  1.00 39.70           C  
ATOM    768  OE1 GLN A 145      21.027  91.623  10.924  1.00 41.29           O  
ATOM    769  NE2 GLN A 145      22.485  90.860   9.394  1.00 41.88           N  
ATOM    770  N   GLN A 146      21.452  97.396  10.618  1.00 27.46           N  
ATOM    771  CA  GLN A 146      21.704  98.479  11.552  1.00 26.06           C  
ATOM    772  C   GLN A 146      21.503  97.945  12.965  1.00 25.92           C  
ATOM    773  O   GLN A 146      20.841  96.929  13.165  1.00 28.34           O  
ATOM    774  CB  GLN A 146      20.739  99.639  11.301  1.00 24.90           C  
ATOM    775  CG  GLN A 146      19.315  99.390  11.770  1.00 25.10           C  
ATOM    776  CD  GLN A 146      18.729  98.115  11.202  1.00 26.81           C  
ATOM    777  OE1 GLN A 146      18.899  97.816  10.020  1.00 27.10           O  
ATOM    778  NE2 GLN A 146      18.026  97.360  12.039  1.00 27.74           N  
ATOM    779  N   PRO A 147      22.090  98.620  13.959  1.00 24.80           N  
ATOM    780  CA  PRO A 147      22.895  99.817  13.726  1.00 23.21           C  
ATOM    781  C   PRO A 147      24.339  99.452  13.412  1.00 20.83           C  
ATOM    782  O   PRO A 147      24.779  98.328  13.665  1.00 18.59           O  
ATOM    783  CB  PRO A 147      22.766 100.570  15.043  1.00 25.73           C  
ATOM    784  CG  PRO A 147      22.763  99.453  16.036  1.00 25.87           C  
ATOM    785  CD  PRO A 147      21.841  98.426  15.400  1.00 26.68           C  
ATOM    786  N   ALA A 148      25.064 100.404  12.839  1.00 17.47           N  
ATOM    787  CA  ALA A 148      26.468 100.209  12.516  1.00 17.13           C  
ATOM    788  C   ALA A 148      27.136 101.571  12.545  1.00 16.40           C  
ATOM    789  O   ALA A 148      26.470 102.606  12.427  1.00 15.26           O  
ATOM    790  CB  ALA A 148      26.626  99.570  11.144  1.00 16.79           C  
ATOM    791  N   TYR A 149      28.453 101.562  12.713  1.00 14.30           N  
ATOM    792  CA  TYR A 149      29.232 102.790  12.770  1.00 13.87           C  
ATOM    793  C   TYR A 149      30.492 102.647  11.933  1.00 16.55           C  
ATOM    794  O   TYR A 149      31.147 101.606  11.968  1.00 18.74           O  
ATOM    795  CB  TYR A 149      29.640 103.081  14.219  1.00 14.31           C  
ATOM    796  CG  TYR A 149      28.489 103.381  15.139  1.00 14.63           C  
ATOM    797  CD1 TYR A 149      28.125 104.696  15.418  1.00 14.96           C  
ATOM    798  CD2 TYR A 149      27.735 102.352  15.703  1.00 16.17           C  
ATOM    799  CE1 TYR A 149      27.040 104.985  16.234  1.00 17.32           C  
ATOM    800  CE2 TYR A 149      26.642 102.630  16.520  1.00 16.17           C  
ATOM    801  CZ  TYR A 149      26.302 103.951  16.778  1.00 17.73           C  
ATOM    802  OH  TYR A 149      25.224 104.243  17.582  1.00 22.06           O  
ATOM    803  N   ALA A 150      30.826 103.678  11.165  1.00 12.28           N  
ATOM    804  CA  ALA A 150      32.053 103.643  10.383  1.00 13.31           C  
ATOM    805  C   ALA A 150      32.915 104.773  10.917  1.00 15.10           C  
ATOM    806  O   ALA A 150      32.504 105.934  10.902  1.00 15.63           O  
ATOM    807  CB  ALA A 150      31.764 103.844   8.906  1.00 15.60           C  
ATOM    808  N   PHE A 151      34.097 104.430  11.417  1.00 14.66           N  
ATOM    809  CA  PHE A 151      34.999 105.440  11.955  1.00 14.64           C  
ATOM    810  C   PHE A 151      36.080 105.742  10.935  1.00 16.28           C  
ATOM    811  O   PHE A 151      36.767 104.846  10.450  1.00 17.30           O  
ATOM    812  CB  PHE A 151      35.601 104.962  13.284  1.00 14.41           C  
ATOM    813  CG  PHE A 151      34.565 104.714  14.349  1.00 14.22           C  
ATOM    814  CD1 PHE A 151      33.931 103.478  14.452  1.00 16.44           C  
ATOM    815  CD2 PHE A 151      34.162 105.743  15.195  1.00 15.16           C  
ATOM    816  CE1 PHE A 151      32.911 103.273  15.382  1.00 15.58           C  
ATOM    817  CE2 PHE A 151      33.141 105.545  16.126  1.00 14.78           C  
ATOM    818  CZ  PHE A 151      32.514 104.307  16.217  1.00 15.74           C  
ATOM    819  N   VAL A 152      36.199 107.020  10.596  1.00 14.68           N  
ATOM    820  CA  VAL A 152      37.167 107.469   9.613  1.00 15.69           C  
ATOM    821  C   VAL A 152      38.198 108.374  10.263  1.00 16.02           C  
ATOM    822  O   VAL A 152      37.842 109.415  10.808  1.00 15.74           O  
ATOM    823  CB  VAL A 152      36.466 108.265   8.498  1.00 16.63           C  
ATOM    824  CG1 VAL A 152      37.460 108.615   7.407  1.00 16.63           C  
ATOM    825  CG2 VAL A 152      35.295 107.461   7.940  1.00 18.22           C  
ATOM    826  N   ASP A 153      39.472 107.991  10.224  1.00 16.78           N  
ATOM    827  CA  ASP A 153      40.483 108.850  10.822  1.00 19.65           C  
ATOM    828  C   ASP A 153      40.953 109.838   9.751  1.00 19.45           C  
ATOM    829  O   ASP A 153      40.635 109.675   8.569  1.00 19.67           O  
ATOM    830  CB  ASP A 153      41.640 108.015  11.422  1.00 19.69           C  
ATOM    831  CG  ASP A 153      42.553 107.398  10.380  1.00 22.83           C  
ATOM    832  OD1 ASP A 153      43.335 106.498  10.759  1.00 26.55           O  
ATOM    833  OD2 ASP A 153      42.520 107.799   9.202  1.00 23.63           O  
ATOM    834  N   PRO A 154      41.689 110.888  10.143  1.00 20.93           N  
ATOM    835  CA  PRO A 154      42.165 111.881   9.175  1.00 22.18           C  
ATOM    836  C   PRO A 154      43.004 111.353   8.016  1.00 25.06           C  
ATOM    837  O   PRO A 154      43.144 112.024   6.994  1.00 25.57           O  
ATOM    838  CB  PRO A 154      42.936 112.867  10.048  1.00 22.13           C  
ATOM    839  CG  PRO A 154      42.197 112.798  11.350  1.00 21.77           C  
ATOM    840  CD  PRO A 154      42.015 111.310  11.517  1.00 21.14           C  
ATOM    841  N   HIS A 155      43.566 110.161   8.170  1.00 26.35           N  
ATOM    842  CA  HIS A 155      44.381 109.581   7.109  1.00 31.04           C  
ATOM    843  C   HIS A 155      43.525 108.820   6.107  1.00 30.49           C  
ATOM    844  O   HIS A 155      44.025 108.340   5.091  1.00 32.97           O  
ATOM    845  CB  HIS A 155      45.439 108.646   7.696  1.00 34.66           C  
ATOM    846  CG  HIS A 155      46.447 109.342   8.557  1.00 38.64           C  
ATOM    847  ND1 HIS A 155      47.149 110.451   8.132  1.00 40.00           N  
ATOM    848  CD2 HIS A 155      46.883 109.080   9.812  1.00 39.92           C  
ATOM    849  CE1 HIS A 155      47.973 110.839   9.088  1.00 40.45           C  
ATOM    850  NE2 HIS A 155      47.832 110.025  10.119  1.00 41.99           N  
ATOM    851  N   GLY A 156      42.234 108.707   6.398  1.00 28.38           N  
ATOM    852  CA  GLY A 156      41.341 108.005   5.497  1.00 27.14           C  
ATOM    853  C   GLY A 156      41.096 106.560   5.885  1.00 25.75           C  
ATOM    854  O   GLY A 156      40.371 105.844   5.193  1.00 27.07           O  
ATOM    855  N   ASN A 157      41.703 106.124   6.983  1.00 23.17           N  
ATOM    856  CA  ASN A 157      41.520 104.757   7.458  1.00 23.97           C  
ATOM    857  C   ASN A 157      40.070 104.598   7.894  1.00 23.32           C  
ATOM    858  O   ASN A 157      39.522 105.469   8.567  1.00 23.42           O  
ATOM    859  CB  ASN A 157      42.451 104.482   8.639  1.00 25.81           C  
ATOM    860  CG  ASN A 157      43.912 104.515   8.244  1.00 29.10           C  
ATOM    861  OD1 ASN A 157      44.755 105.035   8.977  1.00 31.61           O  
ATOM    862  ND2 ASN A 157      44.222 103.951   7.080  1.00 31.39           N  
ATOM    863  N   VAL A 158      39.455 103.482   7.509  1.00 23.07           N  
ATOM    864  CA  VAL A 158      38.060 103.221   7.843  1.00 23.85           C  
ATOM    865  C   VAL A 158      37.860 101.930   8.624  1.00 25.06           C  
ATOM    866  O   VAL A 158      38.303 100.857   8.205  1.00 23.86           O  
ATOM    867  CB  VAL A 158      37.196 103.150   6.567  1.00 24.97           C  
ATOM    868  CG1 VAL A 158      35.750 102.834   6.932  1.00 24.13           C  
ATOM    869  CG2 VAL A 158      37.289 104.461   5.806  1.00 24.38           C  
ATOM    870  N   ASP A 159      37.181 102.042   9.759  1.00 23.86           N  
ATOM    871  CA  ASP A 159      36.898 100.888  10.602  1.00 25.39           C  
ATOM    872  C   ASP A 159      35.392 100.809  10.833  1.00 22.89           C  
ATOM    873  O   ASP A 159      34.792 101.737  11.375  1.00 22.46           O  
ATOM    874  CB  ASP A 159      37.638 101.019  11.936  1.00 30.57           C  
ATOM    875  CG  ASP A 159      37.389  99.845  12.861  1.00 35.52           C  
ATOM    876  OD1 ASP A 159      37.558  98.690  12.418  1.00 38.42           O  
ATOM    877  OD2 ASP A 159      37.032 100.079  14.035  1.00 39.71           O  
ATOM    878  N   VAL A 160      34.786  99.706  10.410  1.00 22.39           N  
ATOM    879  CA  VAL A 160      33.346  99.523  10.566  1.00 21.46           C  
ATOM    880  C   VAL A 160      33.021  98.625  11.748  1.00 22.04           C  
ATOM    881  O   VAL A 160      33.565  97.526  11.880  1.00 24.17           O  
ATOM    882  CB  VAL A 160      32.715  98.903   9.297  1.00 21.09           C  
ATOM    883  CG1 VAL A 160      31.215  98.707   9.497  1.00 21.90           C  
ATOM    884  CG2 VAL A 160      32.976  99.795   8.104  1.00 20.31           C  
ATOM    885  N   VAL A 161      32.137  99.109  12.610  1.00 19.98           N  
ATOM    886  CA  VAL A 161      31.711  98.365  13.784  1.00 21.46           C  
ATOM    887  C   VAL A 161      30.222  98.092  13.653  1.00 22.32           C  
ATOM    888  O   VAL A 161      29.415  99.011  13.552  1.00 20.16           O  
ATOM    889  CB  VAL A 161      31.964  99.161  15.080  1.00 22.39           C  
ATOM    890  CG1 VAL A 161      31.426  98.389  16.275  1.00 21.33           C  
ATOM    891  CG2 VAL A 161      33.458  99.429  15.243  1.00 22.26           C  
ATOM    892  N   ARG A 162      29.855  96.818  13.647  1.00 25.41           N  
ATOM    893  CA  ARG A 162      28.455  96.449  13.523  1.00 28.54           C  
ATOM    894  C   ARG A 162      27.876  96.119  14.884  1.00 29.24           C  
ATOM    895  O   ARG A 162      28.403  95.276  15.610  1.00 32.80           O  
ATOM    896  CB  ARG A 162      28.317  95.252  12.587  1.00 31.32           C  
ATOM    897  CG  ARG A 162      28.838  95.526  11.194  1.00 33.48           C  
ATOM    898  CD  ARG A 162      28.748  94.294  10.315  1.00 38.09           C  
ATOM    899  NE  ARG A 162      29.100  94.597   8.930  1.00 40.25           N  
ATOM    900  CZ  ARG A 162      30.306  94.980   8.526  1.00 42.20           C  
ATOM    901  NH1 ARG A 162      30.520  95.235   7.244  1.00 44.34           N  
ATOM    902  NH2 ARG A 162      31.302  95.102   9.395  1.00 43.55           N  
ATOM    903  N   GLY A 163      26.790  96.795  15.229  1.00 26.20           N  
ATOM    904  CA  GLY A 163      26.159  96.555  16.506  1.00 26.51           C  
ATOM    905  C   GLY A 163      25.917  97.854  17.240  1.00 26.27           C  
ATOM    906  O   GLY A 163      26.235  98.933  16.740  1.00 25.27           O  
ATOM    907  N   ARG A 164      25.357  97.746  18.436  1.00 27.75           N  
ATOM    908  CA  ARG A 164      25.064  98.915  19.243  1.00 27.93           C  
ATOM    909  C   ARG A 164      26.342  99.439  19.872  1.00 26.60           C  
ATOM    910  O   ARG A 164      27.355  98.740  19.928  1.00 24.77           O  
ATOM    911  CB  ARG A 164      24.045  98.562  20.328  1.00 32.42           C  
ATOM    912  CG  ARG A 164      24.441  97.380  21.192  1.00 36.60           C  
ATOM    913  CD  ARG A 164      23.313  96.980  22.135  1.00 39.82           C  
ATOM    914  NE  ARG A 164      22.080  96.689  21.409  1.00 42.68           N  
ATOM    915  CZ  ARG A 164      20.983  96.188  21.969  1.00 44.11           C  
ATOM    916  NH1 ARG A 164      19.906  95.957  21.228  1.00 44.37           N  
ATOM    917  NH2 ARG A 164      20.962  95.908  23.266  1.00 45.53           N  
ATOM    918  N   MET A 165      26.296 100.683  20.327  1.00 23.92           N  
ATOM    919  CA  MET A 165      27.451 101.277  20.962  1.00 22.39           C  
ATOM    920  C   MET A 165      27.029 102.209  22.080  1.00 20.98           C  
ATOM    921  O   MET A 165      26.128 103.034  21.918  1.00 19.53           O  
ATOM    922  CB  MET A 165      28.292 102.041  19.946  1.00 25.41           C  
ATOM    923  CG  MET A 165      29.685 102.322  20.455  1.00 22.50           C  
ATOM    924  SD  MET A 165      30.784 102.892  19.193  1.00 25.16           S  
ATOM    925  CE  MET A 165      30.899 101.444  18.109  1.00 23.91           C  
ATOM    926  N   SER A 166      27.689 102.067  23.221  1.00 17.60           N  
ATOM    927  CA  SER A 166      27.397 102.891  24.378  1.00 18.78           C  
ATOM    928  C   SER A 166      27.986 104.276  24.175  1.00 16.98           C  
ATOM    929  O   SER A 166      28.851 104.483  23.320  1.00 17.10           O  
ATOM    930  CB  SER A 166      28.010 102.274  25.630  1.00 19.25           C  
ATOM    931  OG  SER A 166      29.420 102.267  25.527  1.00 21.13           O  
ATOM    932  N   GLN A 167      27.527 105.224  24.983  1.00 18.17           N  
ATOM    933  CA  GLN A 167      28.030 106.584  24.893  1.00 16.65           C  
ATOM    934  C   GLN A 167      29.526 106.613  25.197  1.00 16.81           C  
ATOM    935  O   GLN A 167      30.287 107.328  24.549  1.00 15.89           O  
ATOM    936  CB  GLN A 167      27.274 107.495  25.863  1.00 18.59           C  
ATOM    937  CG  GLN A 167      27.634 108.960  25.705  1.00 24.53           C  
ATOM    938  CD  GLN A 167      26.737 109.878  26.508  1.00 27.36           C  
ATOM    939  OE1 GLN A 167      25.515 109.757  26.473  1.00 31.85           O  
ATOM    940  NE2 GLN A 167      27.344 110.815  27.228  1.00 31.15           N  
ATOM    941  N   ASP A 168      29.955 105.823  26.177  1.00 17.74           N  
ATOM    942  CA  ASP A 168      31.368 105.784  26.524  1.00 18.15           C  
ATOM    943  C   ASP A 168      32.222 105.224  25.397  1.00 15.74           C  
ATOM    944  O   ASP A 168      33.281 105.769  25.088  1.00 14.84           O  
ATOM    945  CB  ASP A 168      31.599 104.963  27.802  1.00 20.96           C  
ATOM    946  CG  ASP A 168      31.079 105.662  29.046  1.00 25.94           C  
ATOM    947  OD1 ASP A 168      31.177 106.904  29.107  1.00 26.78           O  
ATOM    948  OD2 ASP A 168      30.591 104.974  29.967  1.00 28.93           O  
ATOM    949  N   GLU A 169      31.779 104.135  24.772  1.00 13.68           N  
ATOM    950  CA  GLU A 169      32.571 103.584  23.691  1.00 13.89           C  
ATOM    951  C   GLU A 169      32.646 104.536  22.503  1.00 12.29           C  
ATOM    952  O   GLU A 169      33.709 104.705  21.911  1.00 12.27           O  
ATOM    953  CB  GLU A 169      32.030 102.228  23.213  1.00 13.94           C  
ATOM    954  CG  GLU A 169      32.974 101.609  22.189  1.00 16.14           C  
ATOM    955  CD  GLU A 169      32.544 100.245  21.678  1.00 18.68           C  
ATOM    956  OE1 GLU A 169      31.605  99.653  22.241  1.00 19.91           O  
ATOM    957  OE2 GLU A 169      33.167  99.772  20.708  1.00 22.38           O  
ATOM    958  N   LEU A 170      31.522 105.151  22.151  1.00 13.06           N  
ATOM    959  CA  LEU A 170      31.501 106.075  21.020  1.00 13.14           C  
ATOM    960  C   LEU A 170      32.440 107.240  21.319  1.00 12.15           C  
ATOM    961  O   LEU A 170      33.232 107.649  20.469  1.00 13.69           O  
ATOM    962  CB  LEU A 170      30.073 106.579  20.776  1.00 12.05           C  
ATOM    963  CG  LEU A 170      29.852 107.498  19.567  1.00 12.60           C  
ATOM    964  CD1 LEU A 170      30.376 106.845  18.292  1.00 14.84           C  
ATOM    965  CD2 LEU A 170      28.360 107.800  19.446  1.00 12.32           C  
ATOM    966  N   THR A 171      32.373 107.749  22.544  1.00 13.93           N  
ATOM    967  CA  THR A 171      33.231 108.859  22.954  1.00 13.86           C  
ATOM    968  C   THR A 171      34.699 108.462  22.825  1.00 14.30           C  
ATOM    969  O   THR A 171      35.510 109.201  22.266  1.00 14.40           O  
ATOM    970  CB  THR A 171      32.943 109.257  24.414  1.00 14.55           C  
ATOM    971  OG1 THR A 171      31.589 109.704  24.528  1.00 16.30           O  
ATOM    972  CG2 THR A 171      33.890 110.374  24.873  1.00 15.83           C  
ATOM    973  N   ARG A 172      35.044 107.285  23.342  1.00 12.85           N  
ATOM    974  CA  ARG A 172      36.423 106.815  23.261  1.00 14.14           C  
ATOM    975  C   ARG A 172      36.891 106.569  21.825  1.00 14.51           C  
ATOM    976  O   ARG A 172      38.034 106.869  21.482  1.00 16.10           O  
ATOM    977  CB  ARG A 172      36.583 105.551  24.108  1.00 15.16           C  
ATOM    978  CG  ARG A 172      36.491 105.827  25.602  1.00 16.41           C  
ATOM    979  CD  ARG A 172      36.237 104.556  26.393  1.00 18.47           C  
ATOM    980  NE  ARG A 172      36.008 104.851  27.804  1.00 21.04           N  
ATOM    981  CZ  ARG A 172      35.319 104.072  28.626  1.00 19.67           C  
ATOM    982  NH1 ARG A 172      35.165 104.421  29.899  1.00 21.10           N  
ATOM    983  NH2 ARG A 172      34.771 102.949  28.175  1.00 18.41           N  
ATOM    984  N   ARG A 173      36.020 106.027  20.976  1.00 14.66           N  
ATOM    985  CA  ARG A 173      36.408 105.789  19.590  1.00 14.35           C  
ATOM    986  C   ARG A 173      36.591 107.115  18.850  1.00 14.26           C  
ATOM    987  O   ARG A 173      37.533 107.285  18.075  1.00 16.71           O  
ATOM    988  CB  ARG A 173      35.366 104.923  18.882  1.00 15.41           C  
ATOM    989  CG  ARG A 173      35.468 103.450  19.243  1.00 20.48           C  
ATOM    990  CD  ARG A 173      34.508 102.629  18.409  1.00 23.00           C  
ATOM    991  NE  ARG A 173      34.539 101.213  18.757  1.00 24.03           N  
ATOM    992  CZ  ARG A 173      35.369 100.320  18.225  1.00 25.02           C  
ATOM    993  NH1 ARG A 173      35.310  99.055  18.614  1.00 25.70           N  
ATOM    994  NH2 ARG A 173      36.248 100.681  17.297  1.00 24.62           N  
ATOM    995  N   VAL A 174      35.699 108.060  19.116  1.00 15.58           N  
ATOM    996  CA  VAL A 174      35.791 109.366  18.486  1.00 17.73           C  
ATOM    997  C   VAL A 174      37.081 110.062  18.912  1.00 18.35           C  
ATOM    998  O   VAL A 174      37.763 110.672  18.087  1.00 19.50           O  
ATOM    999  CB  VAL A 174      34.567 110.232  18.848  1.00 18.06           C  
ATOM   1000  CG1 VAL A 174      34.805 111.683  18.461  1.00 21.84           C  
ATOM   1001  CG2 VAL A 174      33.337 109.696  18.120  1.00 19.07           C  
ATOM   1002  N   THR A 175      37.426 109.965  20.193  1.00 18.60           N  
ATOM   1003  CA  THR A 175      38.652 110.592  20.678  1.00 20.39           C  
ATOM   1004  C   THR A 175      39.872 109.971  20.004  1.00 20.45           C  
ATOM   1005  O   THR A 175      40.842 110.666  19.687  1.00 21.25           O  
ATOM   1006  CB  THR A 175      38.804 110.434  22.204  1.00 21.46           C  
ATOM   1007  OG1 THR A 175      38.923 109.046  22.536  1.00 30.32           O  
ATOM   1008  CG2 THR A 175      37.606 110.991  22.915  1.00 19.31           C  
ATOM   1009  N   ALA A 176      39.819 108.660  19.781  1.00 19.15           N  
ATOM   1010  CA  ALA A 176      40.925 107.950  19.153  1.00 21.30           C  
ATOM   1011  C   ALA A 176      41.197 108.430  17.730  1.00 20.86           C  
ATOM   1012  O   ALA A 176      42.326 108.355  17.256  1.00 22.70           O  
ATOM   1013  CB  ALA A 176      40.649 106.451  19.155  1.00 22.08           C  
ATOM   1014  N   LEU A 177      40.168 108.927  17.051  1.00 21.83           N  
ATOM   1015  CA  LEU A 177      40.333 109.407  15.683  1.00 22.63           C  
ATOM   1016  C   LEU A 177      41.248 110.625  15.617  1.00 25.78           C  
ATOM   1017  O   LEU A 177      41.918 110.849  14.611  1.00 26.96           O  
ATOM   1018  CB  LEU A 177      38.976 109.767  15.076  1.00 21.80           C  
ATOM   1019  CG  LEU A 177      37.942 108.645  14.999  1.00 22.21           C  
ATOM   1020  CD1 LEU A 177      36.650 109.204  14.430  1.00 22.84           C  
ATOM   1021  CD2 LEU A 177      38.466 107.511  14.134  1.00 22.89           C  
ATOM   1022  N   THR A 178      41.257 111.412  16.688  1.00 28.83           N  
ATOM   1023  CA  THR A 178      42.088 112.600  16.748  1.00 33.57           C  
ATOM   1024  C   THR A 178      43.396 112.343  17.472  1.00 35.77           C  
ATOM   1025  O   THR A 178      44.369 113.092  17.241  1.00 38.39           O  
TER    1026      THR A 178                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
