
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  134 ( 1018),  selected  134 , name 1lu4_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 1lu4_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E       1           -
LGA    -       -      N       2           -
LGA    -       -      L       3           -
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    -       -      Q       6           -
LGA    -       -      S       7           -
LGA    -       -      M       8           -
LGA    -       -      I       9           -
LGA    A  1001_A      N      10           #
LGA    D  1002_A      S      11          1.761
LGA    E  1003_A      -       -           -
LGA    R  1004_A      F      12          3.559
LGA    L  1005_A      Y      13          3.004
LGA    Q  1006_A      A      14          2.080
LGA    F  1007_A      F      15          1.635
LGA    T  1008_A      E      16          1.166
LGA    A  1009_A      V      17          1.505
LGA    T  1010_A      K      18          1.858
LGA    T  1011_A      D      19          1.654
LGA    L  1012_A      A      20          1.687
LGA    S  1013_A      K      21          3.992
LGA    G  1014_A      G      22          4.179
LGA    A  1015_A      R      23          4.180
LGA    P  1016_A      T      24          3.238
LGA    F  1017_A      V      25          1.848
LGA    D  1018_A      S      26          0.800
LGA    G  1019_A      L      27          1.543
LGA    A  1020_A      E      28          2.528
LGA    S  1021_A      K      29          2.485
LGA    L  1022_A      Y      30          2.421
LGA    Q  1023_A      K      31          2.762
LGA    G  1024_A      G      32          2.971
LGA    K  1025_A      K      33          2.461
LGA    P  1026_A      V      34          1.688
LGA    A  1027_A      S      35          1.721
LGA    V  1028_A      L      36          1.654
LGA    L  1029_A      V      37          1.069
LGA    W  1030_A      V      38          1.452
LGA    F  1031_A      N      39          1.462
LGA    W  1032_A      V      40          1.284
LGA    T  1033_A      A      41          1.760
LGA    P  1034_A      S      42          1.735
LGA    W  1035_A      D      43          1.798
LGA    C  1036_A      C      44          2.393
LGA    P  1037_A      Q      45          1.902
LGA    F  1038_A      L      46          2.046
LGA    C  1039_A      T      47          3.569
LGA    N  1040_A      D      48          2.879
LGA    A  1041_A      R      49          1.572
LGA    E  1042_A      N      50          1.336
LGA    A  1043_A      Y      51          1.005
LGA    P  1044_A      L      52          0.377
LGA    S  1045_A      G      53          0.955
LGA    L  1046_A      L      54          0.525
LGA    S  1047_A      K      55          0.636
LGA    Q  1048_A      E      56          1.386
LGA    V  1049_A      L      57          1.114
LGA    A  1050_A      H      58          0.132
LGA    A  1051_A      K      59          1.097
LGA    A  1052_A      E      60          1.284
LGA    N  1053_A      F      61          0.936
LGA    P  1054_A      G      62          1.737
LGA    -       -      P      63           -
LGA    -       -      S      64           -
LGA    A  1055_A      H      65          2.032
LGA    V  1056_A      F      66          0.712
LGA    T  1057_A      S      67          2.205
LGA    F  1058_A      V      68          2.071
LGA    V  1059_A      L      69          1.048
LGA    G  1060_A      A      70          0.804
LGA    I  1061_A      F      71          1.069
LGA    A  1062_A      P      72          1.070
LGA    T  1063_A      C      73          1.765
LGA    R  1064_A      N      74          1.517
LGA    -       -      Q      75           -
LGA    -       -      F      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    -       -      S      79           -
LGA    -       -      E      80           -
LGA    A  1065_A      P      81          3.353
LGA    -       -      R      82           -
LGA    D  1066_A      P      83          2.467
LGA    V  1067_A      S      84          1.791
LGA    G  1068_A      K      85          4.683
LGA    A  1069_A      E      86          4.584
LGA    M  1070_A      V      87          1.541
LGA    Q  1071_A      E      88          2.297
LGA    S  1072_A      S      89          4.301
LGA    F  1073_A      F      90          3.496
LGA    V  1074_A      A      91          1.237
LGA    S  1075_A      R      92          1.993
LGA    -       -      K      93           -
LGA    K  1076_A      N      94          1.266
LGA    Y  1077_A      Y      95          1.941
LGA    N  1078_A      G      96          2.071
LGA    L  1079_A      V      97          2.054
LGA    N  1080_A      T      98          0.809
LGA    F  1081_A      F      99          1.046
LGA    T  1082_A      P     100          1.099
LGA    N  1083_A      I     101          1.284
LGA    L  1084_A      F     102          0.892
LGA    N  1085_A      H     103          0.880
LGA    D  1086_A      K     104          3.308
LGA    A  1087_A      I     105          3.361
LGA    D  1088_A      -       -           -
LGA    G  1089_A      K     106          1.627
LGA    V  1090_A      I     107           #
LGA    -       -      L     108           -
LGA    -       -      G     109           -
LGA    -       -      S     110           -
LGA    -       -      E     111           -
LGA    -       -      G     112           -
LGA    -       -      E     113           -
LGA    -       -      P     114           -
LGA    I  1091_A      A     115          3.669
LGA    W  1092_A      F     116          3.368
LGA    A  1093_A      R     117          3.344
LGA    R  1094_A      F     118          3.711
LGA    Y  1095_A      L     119          2.820
LGA    N  1096_A      V     120          2.532
LGA    -       -      D     121           -
LGA    -       -      S     122           -
LGA    -       -      S     123           -
LGA    -       -      K     124           -
LGA    -       -      K     125           -
LGA    V  1097_A      E     126          3.380
LGA    P  1098_A      P     127          2.774
LGA    W  1099_A      R     128          3.389
LGA    Q  1100_A      W     129          3.745
LGA    -       -      N     130           -
LGA    P  1101_A      F     131          0.998
LGA    A  1102_A      W     132          1.501
LGA    F  1103_A      K     133          1.353
LGA    V  1104_A      Y     134          1.433
LGA    F  1105_A      L     135          1.105
LGA    Y  1106_A      V     136          1.928
LGA    R  1107_A      N     137          2.082
LGA    A  1108_A      P     138          1.758
LGA    D  1109_A      E     139          3.724
LGA    G  1110_A      G     140          3.842
LGA    T  1111_A      Q     141          3.602
LGA    S  1112_A      V     142          2.658
LGA    T  1113_A      V     143          2.717
LGA    F  1114_A      K     144          3.208
LGA    V  1115_A      F     145          2.505
LGA    N  1116_A      W     146          4.097
LGA    N  1117_A      R     147          1.733
LGA    P  1118_A      P     148          4.801
LGA    T  1119_A      -       -           -
LGA    A  1120_A      -       -           -
LGA    A  1121_A      E     149          3.690
LGA    M  1122_A      E     150          3.423
LGA    S  1123_A      P     151          2.526
LGA    Q  1124_A      I     152          3.079
LGA    D  1125_A      E     153          2.557
LGA    E  1126_A      V     154          2.668
LGA    L  1127_A      I     155          3.020
LGA    S  1128_A      R     156          2.389
LGA    G  1129_A      P     157          1.870
LGA    R  1130_A      D     158          2.497
LGA    V  1131_A      I     159          1.401
LGA    A  1132_A      A     160          0.321
LGA    A  1133_A      A     161          1.778
LGA    L  1134_A      L     162          1.163
LGA    -       -      V     163           -
LGA    -       -      R     164           -
LGA    -       -      Q     165           -
LGA    -       -      V     166           -
LGA    -       -      I     167           -
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  134  174    5.0    128    2.40    12.50     51.921     5.128

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.501173 * X  +   0.581474 * Y  +  -0.640869 * Z  +  33.791733
  Y_new =   0.211396 * X  +  -0.800422 * Y  +  -0.560924 * Z  + 122.646698
  Z_new =  -0.839129 * X  +   0.145643 * Y  +  -0.524072 * Z  +  36.777760 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.870527   -0.271066  [ DEG:   164.4691    -15.5309 ]
  Theta =   0.995679    2.145913  [ DEG:    57.0482    122.9518 ]
  Phi   =   0.399159   -2.742434  [ DEG:    22.8701   -157.1299 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1lu4_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1lu4_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  134  174   5.0  128   2.40   12.50  51.921
REMARK  ---------------------------------------------------------- 
MOLECULE 1lu4_A
HEADER    OXIDOREDUCTASE                          21-MAY-02   1LU4              
TITLE     1.1 ANGSTROM RESOLUTION CRYSTAL STRUCTURE OF A SECRETED               
TITLE    2 MYCOBACTERIUM TUBERCULOSIS DISULFIDE OXIDOREDUCTASE                  
TITLE    3 HOMOLOGOUS TO E. COLI DSBE: IMPLICATIONS FOR FUNCTIONS               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SOLUBLE SECRETED ANTIGEN MPT53;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: RV2878C;                                                       
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: XL-BLUE CELLS;                             
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PQE30                                     
KEYWDS    THIOREDOXIN-LIKE FOLD, STRUCTURAL GENOMICS, PSI, PROTEIN              
KEYWDS   2 STRUCTURE INITIATIVE, TB STRUCTURAL GENOMICS CONSORTIUM,             
KEYWDS   3 TBSGC                                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.W.GOULDING,M.I.APOSTOL,S.GLEITER,A.PARSEGHIAN,J.BARDWELL,           
AUTHOR   2 M.GENNARO,D.EISENBERG,TB STRUCTURAL GENOMICS CONSORTIUM              
AUTHOR   3 (TBSGC)                                                              
REVDAT   4   01-FEB-05 1LU4    1       AUTHOR KEYWDS REMARK                     
REVDAT   3   10-FEB-04 1LU4    1       AUTHOR                                   
REVDAT   2   03-FEB-04 1LU4    1       JRNL                                     
REVDAT   1   14-OCT-03 1LU4    0                                                
JRNL        AUTH   C.W.GOULDING,M.I.APOSTOL,S.GLEITER,A.PARSEGHIAN,             
JRNL        AUTH 2 J.BARDWELL,M.GENNARO,D.EISENBERG                             
JRNL        TITL   GRAM-POSITIVE DSBE PROTEINS FUNCTION DIFFERENTLY             
JRNL        TITL 2 FROM GRAM-NEGATIVE DSBE HOMOLOGS: A STRUCTURE TO             
JRNL        TITL 3 FUNCTION ANALYSIS OF DSBE FROM MYCOBACTERIUM                 
JRNL        TITL 4 TUBERCULOSIS.                                                
JRNL        REF    J.BIOL.CHEM.                  V. 279  3516 2004              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.12 ANGSTROMS.                                          
DBREF  1LU4 A 1001  1136  UNP    P0A618   MPT53_MYCTU     38    173             
SEQRES   1 A  136  ALA ASP GLU ARG LEU GLN PHE THR ALA THR THR LEU SER          
SEQRES   2 A  136  GLY ALA PRO PHE ASP GLY ALA SER LEU GLN GLY LYS PRO          
SEQRES   3 A  136  ALA VAL LEU TRP PHE TRP THR PRO TRP CYS PRO PHE CYS          
SEQRES   4 A  136  ASN ALA GLU ALA PRO SER LEU SER GLN VAL ALA ALA ALA          
SEQRES   5 A  136  ASN PRO ALA VAL THR PHE VAL GLY ILE ALA THR ARG ALA          
SEQRES   6 A  136  ASP VAL GLY ALA MET GLN SER PHE VAL SER LYS TYR ASN          
SEQRES   7 A  136  LEU ASN PHE THR ASN LEU ASN ASP ALA ASP GLY VAL ILE          
SEQRES   8 A  136  TRP ALA ARG TYR ASN VAL PRO TRP GLN PRO ALA PHE VAL          
SEQRES   9 A  136  PHE TYR ARG ALA ASP GLY THR SER THR PHE VAL ASN ASN          
SEQRES  10 A  136  PRO THR ALA ALA MET SER GLN ASP GLU LEU SER GLY ARG          
SEQRES  11 A  136  VAL ALA ALA LEU THR SER                                      
FORMUL   2  HOH   *321(H2 O)                                                    
CRYST1   60.640   60.640   79.775  90.00  90.00  90.00 P 43 21 2     8          
ATOM      1  N   ALA A1001      37.260 103.761   3.404  1.00 41.03           N  
ATOM      2  CA  ALA A1001      38.582 104.314   3.663  1.00 45.14           C  
ATOM      3  C   ALA A1001      38.891 104.850   2.256  1.00 48.49           C  
ATOM      4  O   ALA A1001      38.352 104.237   1.313  1.00 41.77           O  
ATOM      5  CB  ALA A1001      39.480 103.366   4.416  1.00 45.25           C  
ATOM      6  N   ASP A1002      39.621 105.932   2.376  1.00 32.83           N  
ATOM      7  CA  ASP A1002      40.108 106.693   1.238  1.00 32.20           C  
ATOM      8  C   ASP A1002      39.092 106.649   0.111  1.00 23.58           C  
ATOM      9  O   ASP A1002      38.068 107.364   0.187  1.00 34.46           O  
ATOM     10  CB  ASP A1002      41.515 106.158   0.921  1.00 42.73           C  
ATOM     11  CG  ASP A1002      42.552 107.172   1.362  1.00 48.42           C  
ATOM     12  OD1 ASP A1002      43.276 107.048   2.371  1.00 53.21           O  
ATOM     13  OD2 ASP A1002      42.636 108.183   0.623  1.00 69.05           O  
ATOM     14  N   GLU A1003      39.238 105.881  -0.968  1.00 26.97           N  
ATOM     15  CA  GLU A1003      38.379 106.039  -2.131  1.00 35.21           C  
ATOM     16  C   GLU A1003      36.933 105.609  -1.924  1.00 30.99           C  
ATOM     17  O   GLU A1003      36.022 105.978  -2.688  1.00 27.74           O  
ATOM     18  CB  GLU A1003      39.019 105.247  -3.301  1.00 39.10           C  
ATOM     19  CG  GLU A1003      38.551 105.823  -4.631  1.00 49.73           C  
ATOM     20  CD  GLU A1003      39.568 105.694  -5.744  1.00 54.45           C  
ATOM     21  OE1 GLU A1003      40.546 104.938  -5.567  1.00 68.13           O  
ATOM     22  OE2 GLU A1003      39.370 106.353  -6.786  1.00 71.19           O  
ATOM     23  N   ARG A1004      36.580 104.825  -0.901  1.00 24.47           N  
ATOM     24  CA  ARG A1004      35.154 104.636  -0.776  1.00 23.13           C  
ATOM     25  C   ARG A1004      34.345 105.885  -0.425  1.00 22.18           C  
ATOM     26  O   ARG A1004      33.144 105.930  -0.719  1.00 26.68           O  
ATOM     27  CB  ARG A1004      34.862 103.663   0.362  1.00 22.83           C  
ATOM     28  CG  ARG A1004      35.372 102.268   0.122  1.00 21.91           C  
ATOM     29  CD  ARG A1004      35.069 101.333   1.283  1.00 22.05           C  
ATOM     30  NE  ARG A1004      35.693 101.791   2.519  1.00 25.65           N  
ATOM     31  CZ  ARG A1004      35.545 101.308   3.747  1.00 26.64           C  
ATOM     32  NH1 ARG A1004      34.747 100.229   3.868  1.00 30.20           N  
ATOM     33  NH2 ARG A1004      36.126 101.788   4.837  1.00 29.37           N  
ATOM     34  N   LEU A1005      35.015 106.847   0.195  1.00 24.59           N  
ATOM     35  CA  LEU A1005      34.338 108.102   0.508  1.00 22.96           C  
ATOM     36  C   LEU A1005      33.978 108.868  -0.776  1.00 23.11           C  
ATOM     37  O   LEU A1005      33.293 109.868  -0.678  1.00 23.75           O  
ATOM     38  CB  LEU A1005      35.233 108.981   1.374  1.00 23.38           C  
ATOM     39  CG  LEU A1005      35.407 108.487   2.811  1.00 21.26           C  
ATOM     40  CD1 LEU A1005      36.534 109.253   3.488  1.00 21.96           C  
ATOM     41  CD2 LEU A1005      34.096 108.658   3.603  1.00 23.32           C  
ATOM     42  N   GLN A1006      34.415 108.450  -1.969  1.00 27.87           N  
ATOM     43  CA  GLN A1006      34.158 109.156  -3.213  1.00 28.63           C  
ATOM     44  C   GLN A1006      32.768 108.807  -3.709  1.00 26.06           C  
ATOM     45  O   GLN A1006      32.611 108.081  -4.684  1.00 28.54           O  
ATOM     46  CB  GLN A1006      35.240 108.807  -4.226  1.00 33.59           C  
ATOM     47  CG  GLN A1006      36.618 108.652  -3.610  1.00 45.12           C  
ATOM     48  CD  GLN A1006      37.593 109.479  -4.432  1.00 54.15           C  
ATOM     49  OE1 GLN A1006      38.757 109.132  -4.454  1.00 59.73           O  
ATOM     50  NE2 GLN A1006      37.015 110.505  -5.048  1.00 65.50           N  
ATOM     51  N   PHE A1007      31.765 109.292  -2.980  1.00 25.60           N  
ATOM     52  CA  PHE A1007      30.380 109.102  -3.400  1.00 24.02           C  
ATOM     53  C   PHE A1007      29.683 110.455  -3.368  1.00 18.51           C  
ATOM     54  O   PHE A1007      30.146 111.337  -2.642  1.00 18.90           O  
ATOM     55  CB  PHE A1007      29.621 108.112  -2.531  1.00 21.45           C  
ATOM     56  CG  PHE A1007      29.548 108.478  -1.049  1.00 18.24           C  
ATOM     57  CD1 PHE A1007      28.586 109.310  -0.509  1.00 19.95           C  
ATOM     58  CD2 PHE A1007      30.465 107.928  -0.160  1.00 20.62           C  
ATOM     59  CE1 PHE A1007      28.549 109.614   0.819  1.00 19.20           C  
ATOM     60  CE2 PHE A1007      30.420 108.251   1.202  1.00 18.86           C  
ATOM     61  CZ  PHE A1007      29.438 109.084   1.725  1.00 18.24           C  
ATOM     62  N   THR A1008      28.566 110.515  -4.060  1.00 19.23           N  
ATOM     63  CA  THR A1008      27.685 111.682  -3.877  1.00 19.16           C  
ATOM     64  C   THR A1008      26.340 111.169  -3.412  1.00 16.16           C  
ATOM     65  O   THR A1008      25.957 110.008  -3.587  1.00 22.79           O  
ATOM     66  CB  THR A1008      27.581 112.576  -5.120  1.00 25.01           C  
ATOM     67  OG1 THR A1008      27.027 111.843  -6.228  1.00 36.47           O  
ATOM     68  CG2 THR A1008      28.976 113.051  -5.516  1.00 33.09           C  
ATOM     69  N   ALA A1009      25.653 112.098  -2.759  1.00 15.15           N  
ATOM     70  CA  ALA A1009      24.419 111.735  -2.114  1.00 14.84           C  
ATOM     71  C   ALA A1009      23.451 112.896  -2.027  1.00 14.14           C  
ATOM     72  O   ALA A1009      23.826 114.008  -2.407  1.00 14.41           O  
ATOM     73  CB  ALA A1009      24.804 111.262  -0.704  1.00 13.79           C  
ATOM     74  N   THR A1010      22.281 112.646  -1.497  1.00 13.47           N  
ATOM     75  CA  THR A1010      21.287 113.702  -1.209  1.00 13.12           C  
ATOM     76  C   THR A1010      20.922 113.606   0.266  1.00 11.15           C  
ATOM     77  O   THR A1010      20.637 112.537   0.780  1.00 11.94           O  
ATOM     78  CB  THR A1010      20.025 113.542  -2.050  1.00 15.57           C  
ATOM     79  OG1 THR A1010      20.418 113.635  -3.422  1.00 21.69           O  
ATOM     80  CG2 THR A1010      19.004 114.643  -1.859  1.00 20.00           C  
ATOM     81  N   THR A1011      20.910 114.773   0.926  1.00 11.16           N  
ATOM     82  CA  THR A1011      20.556 114.802   2.335  1.00 10.40           C  
ATOM     83  C   THR A1011      19.078 114.696   2.553  1.00 10.93           C  
ATOM     84  O   THR A1011      18.303 114.804   1.569  1.00 13.62           O  
ATOM     85  CB  THR A1011      21.056 116.092   3.023  1.00 12.28           C  
ATOM     86  OG1 THR A1011      20.218 117.199   2.620  1.00 14.73           O  
ATOM     87  CG2 THR A1011      22.509 116.429   2.658  1.00 13.71           C  
ATOM     88  N   LEU A1012      18.669 114.470   3.799  1.00 11.88           N  
ATOM     89  CA  LEU A1012      17.226 114.341   4.015  1.00 13.85           C  
ATOM     90  C   LEU A1012      16.513 115.633   3.680  1.00 19.48           C  
ATOM     91  O   LEU A1012      15.319 115.556   3.424  1.00 28.31           O  
ATOM     92  CB  LEU A1012      16.895 114.026   5.468  1.00 14.17           C  
ATOM     93  CG  LEU A1012      17.570 112.811   6.046  1.00 11.37           C  
ATOM     94  CD1 LEU A1012      16.993 112.551   7.453  1.00 12.81           C  
ATOM     95  CD2 LEU A1012      17.428 111.592   5.190  1.00 13.44           C  
ATOM     96  N   SER A1013      17.155 116.793   3.716  1.00 20.39           N  
ATOM     97  CA  SER A1013      16.629 118.114   3.433  1.00 25.56           C  
ATOM     98  C   SER A1013      16.555 118.353   1.940  1.00 24.97           C  
ATOM     99  O   SER A1013      15.991 119.339   1.482  1.00 31.90           O  
ATOM    100  CB  SER A1013      17.505 119.217   4.020  1.00 29.96           C  
ATOM    101  OG  SER A1013      17.387 119.158   5.426  1.00 31.90           O  
ATOM    102  N   GLY A1014      17.203 117.494   1.169  1.00 20.38           N  
ATOM    103  CA  GLY A1014      17.223 117.611  -0.276  1.00 21.56           C  
ATOM    104  C   GLY A1014      18.463 118.245  -0.862  1.00 19.50           C  
ATOM    105  O   GLY A1014      18.470 118.587  -2.056  1.00 24.91           O  
ATOM    106  N   ALA A1015      19.499 118.468  -0.025  1.00 16.98           N  
ATOM    107  CA  ALA A1015      20.719 119.129  -0.485  1.00 16.39           C  
ATOM    108  C   ALA A1015      21.695 118.102  -1.039  1.00 17.19           C  
ATOM    109  O   ALA A1015      21.738 116.942  -0.584  1.00 16.06           O  
ATOM    110  CB  ALA A1015      21.335 119.892   0.669  1.00 21.41           C  
ATOM    111  N   PRO A1016      22.515 118.468  -2.009  1.00 17.48           N  
ATOM    112  CA  PRO A1016      23.587 117.546  -2.391  1.00 16.05           C  
ATOM    113  C   PRO A1016      24.644 117.448  -1.324  1.00 16.38           C  
ATOM    114  O   PRO A1016      24.861 118.375  -0.543  1.00 17.52           O  
ATOM    115  CD  PRO A1016      22.529 119.710  -2.840  1.00 26.98           C  
ATOM    116  N   PHE A1017      25.300 116.285  -1.297  1.00 14.21           N  
ATOM    117  CA  PHE A1017      26.428 116.104  -0.376  1.00 12.96           C  
ATOM    118  C   PHE A1017      27.483 115.295  -1.104  1.00 13.93           C  
ATOM    119  O   PHE A1017      27.156 114.294  -1.770  1.00 15.85           O  
ATOM    120  CB  PHE A1017      25.968 115.403   0.894  1.00 12.79           C  
ATOM    121  CG  PHE A1017      27.139 115.139   1.849  1.00 12.33           C  
ATOM    122  CD1 PHE A1017      27.581 116.198   2.642  1.00 13.44           C  
ATOM    123  CD2 PHE A1017      27.744 113.920   1.920  1.00 13.38           C  
ATOM    124  CE1 PHE A1017      28.647 115.976   3.514  1.00 15.30           C  
ATOM    125  CE2 PHE A1017      28.821 113.694   2.800  1.00 14.92           C  
ATOM    126  CZ  PHE A1017      29.275 114.735   3.583  1.00 15.75           C  
ATOM    127  N   ASP A1018      28.738 115.660  -0.969  1.00 14.89           N  
ATOM    128  CA  ASP A1018      29.852 114.958  -1.612  1.00 16.12           C  
ATOM    129  C   ASP A1018      30.710 114.322  -0.545  1.00 13.98           C  
ATOM    130  O   ASP A1018      31.318 115.043   0.255  1.00 15.04           O  
ATOM    131  CB  ASP A1018      30.675 115.952  -2.418  1.00 17.47           C  
ATOM    132  CG  ASP A1018      31.849 115.360  -3.152  1.00 21.47           C  
ATOM    133  OD1 ASP A1018      32.044 114.125  -3.058  1.00 23.48           O  
ATOM    134  OD2 ASP A1018      32.556 116.146  -3.814  1.00 28.70           O  
ATOM    135  N   GLY A1019      30.727 113.006  -0.502  1.00 13.92           N  
ATOM    136  CA  GLY A1019      31.520 112.243   0.424  1.00 14.77           C  
ATOM    137  C   GLY A1019      32.992 112.547   0.372  1.00 15.33           C  
ATOM    138  O   GLY A1019      33.721 112.381   1.365  1.00 15.76           O  
ATOM    139  N   ALA A1020      33.460 113.027  -0.779  1.00 16.65           N  
ATOM    140  CA  ALA A1020      34.891 113.305  -0.895  1.00 17.99           C  
ATOM    141  C   ALA A1020      35.247 114.419   0.092  1.00 16.94           C  
ATOM    142  O   ALA A1020      36.420 114.505   0.455  1.00 17.69           O  
ATOM    143  CB  ALA A1020      35.230 113.680  -2.322  1.00 26.32           C  
ATOM    144  N   SER A1021      34.267 115.235   0.483  1.00 16.09           N  
ATOM    145  CA  SER A1021      34.567 116.299   1.460  1.00 16.25           C  
ATOM    146  C   SER A1021      35.002 115.749   2.798  1.00 15.13           C  
ATOM    147  O   SER A1021      35.557 116.528   3.563  1.00 16.02           O  
ATOM    148  CB  SER A1021      33.326 117.201   1.624  1.00 17.52           C  
ATOM    149  OG  SER A1021      32.275 116.527   2.307  1.00 15.37           O  
ATOM    150  N   LEU A1022      34.783 114.454   3.059  1.00 14.09           N  
ATOM    151  CA  LEU A1022      35.162 113.863   4.317  1.00 14.27           C  
ATOM    152  C   LEU A1022      36.610 113.457   4.302  1.00 13.79           C  
ATOM    153  O   LEU A1022      37.189 113.159   5.362  1.00 14.73           O  
ATOM    154  CB  LEU A1022      34.274 112.634   4.611  1.00 14.36           C  
ATOM    155  CG  LEU A1022      32.783 112.992   4.827  1.00 12.64           C  
ATOM    156  CD1 LEU A1022      31.985 111.709   4.866  1.00 14.96           C  
ATOM    157  CD2 LEU A1022      32.569 113.827   6.075  1.00 12.63           C  
ATOM    158  N   GLN A1023      37.222 113.371   3.123  1.00 14.55           N  
ATOM    159  CA  GLN A1023      38.620 112.903   3.116  1.00 18.88           C  
ATOM    160  C   GLN A1023      39.520 113.869   3.869  1.00 16.74           C  
ATOM    161  O   GLN A1023      39.448 115.124   3.814  1.00 20.50           O  
ATOM    162  CB  GLN A1023      39.024 112.680   1.646  1.00 19.52           C  
ATOM    163  CG  GLN A1023      38.245 111.540   1.014  1.00 23.46           C  
ATOM    164  CD  GLN A1023      38.540 111.295  -0.449  1.00 34.61           C  
ATOM    165  OE1 GLN A1023      38.566 110.133  -0.905  1.00 39.66           O  
ATOM    166  NE2 GLN A1023      38.766 112.374  -1.204  1.00 35.90           N  
ATOM    167  N   GLY A1024      40.450 113.311   4.659  1.00 15.93           N  
ATOM    168  CA  GLY A1024      41.504 114.029   5.337  1.00 17.39           C  
ATOM    169  C   GLY A1024      41.068 114.668   6.638  1.00 16.53           C  
ATOM    170  O   GLY A1024      41.813 115.522   7.133  1.00 19.20           O  
ATOM    171  N   LYS A1025      39.911 114.261   7.164  1.00 15.30           N  
ATOM    172  CA  LYS A1025      39.546 114.805   8.479  1.00 14.72           C  
ATOM    173  C   LYS A1025      38.889 113.659   9.256  1.00 13.31           C  
ATOM    174  O   LYS A1025      38.430 112.634   8.732  1.00 14.53           O  
ATOM    175  CB  LYS A1025      38.711 116.069   8.312  1.00 22.31           C  
ATOM    176  CG  LYS A1025      37.441 115.778   7.583  1.00 30.13           C  
ATOM    177  CD  LYS A1025      36.428 116.904   7.586  1.00 30.01           C  
ATOM    178  CE  LYS A1025      36.466 117.757   6.347  1.00 29.75           C  
ATOM    179  NZ  LYS A1025      35.124 118.332   6.086  1.00 26.82           N  
ATOM    180  N   PRO A1026      38.889 113.756  10.577  1.00 11.40           N  
ATOM    181  CA  PRO A1026      38.233 112.742  11.404  1.00 11.18           C  
ATOM    182  C   PRO A1026      36.711 112.784  11.131  1.00 10.82           C  
ATOM    183  O   PRO A1026      36.108 113.849  11.009  1.00 12.33           O  
ATOM    184  CB  PRO A1026      38.513 113.191  12.834  1.00 12.08           C  
ATOM    185  CG  PRO A1026      39.038 114.585  12.772  1.00 20.47           C  
ATOM    186  CD  PRO A1026      39.462 114.876  11.379  1.00 13.97           C  
ATOM    187  N   ALA A1027      36.137 111.591  11.000  1.00 10.22           N  
ATOM    188  CA  ALA A1027      34.734 111.535  10.632  1.00  9.74           C  
ATOM    189  C   ALA A1027      34.109 110.258  11.183  1.00  9.56           C  
ATOM    190  O   ALA A1027      34.833 109.264  11.446  1.00 10.39           O  
ATOM    191  CB  ALA A1027      34.609 111.587   9.101  1.00 10.86           C  
ATOM    192  N   VAL A1028      32.805 110.273  11.285  1.00  9.15           N  
ATOM    193  CA  VAL A1028      32.057 109.083  11.707  1.00  8.58           C  
ATOM    194  C   VAL A1028      30.905 108.940  10.714  1.00  8.65           C  
ATOM    195  O   VAL A1028      30.103 109.855  10.547  1.00  9.46           O  
ATOM    196  CB  VAL A1028      31.530 109.221  13.143  1.00 10.03           C  
ATOM    197  CG1 VAL A1028      30.641 108.010  13.514  1.00 12.20           C  
ATOM    198  CG2 VAL A1028      32.634 109.387  14.185  1.00 11.39           C  
ATOM    199  N   LEU A1029      30.811 107.726  10.107  1.00  7.96           N  
ATOM    200  CA  LEU A1029      29.611 107.360   9.375  1.00  7.98           C  
ATOM    201  C   LEU A1029      28.742 106.490  10.270  1.00  8.33           C  
ATOM    202  O   LEU A1029      29.260 105.561  10.925  1.00  9.97           O  
ATOM    203  CB  LEU A1029      29.931 106.563   8.105  1.00  9.06           C  
ATOM    204  CG  LEU A1029      30.921 107.189   7.131  1.00 10.01           C  
ATOM    205  CD1 LEU A1029      31.099 106.289   5.918  1.00 11.76           C  
ATOM    206  CD2 LEU A1029      30.534 108.626   6.740  1.00 11.36           C  
ATOM    207  N   TRP A1030      27.443 106.758  10.293  1.00  7.95           N  
ATOM    208  CA  TRP A1030      26.521 105.979  11.087  1.00  7.86           C  
ATOM    209  C   TRP A1030      25.378 105.557  10.187  1.00  7.71           C  
ATOM    210  O   TRP A1030      24.608 106.387   9.700  1.00  8.56           O  
ATOM    211  CB  TRP A1030      26.003 106.793  12.270  1.00  9.25           C  
ATOM    212  CG  TRP A1030      25.087 106.064  13.208  1.00  8.24           C  
ATOM    213  CD1 TRP A1030      25.316 104.882  13.861  1.00  9.35           C  
ATOM    214  CD2 TRP A1030      23.790 106.490  13.667  1.00  8.52           C  
ATOM    215  NE1 TRP A1030      24.264 104.533  14.662  1.00 10.14           N  
ATOM    216  CE2 TRP A1030      23.322 105.507  14.558  1.00  9.20           C  
ATOM    217  CE3 TRP A1030      23.011 107.623  13.383  1.00  9.41           C  
ATOM    218  CZ2 TRP A1030      22.071 105.628  15.181  1.00 10.79           C  
ATOM    219  CZ3 TRP A1030      21.751 107.736  14.016  1.00 10.76           C  
ATOM    220  CH2 TRP A1030      21.330 106.735  14.888  1.00 11.03           C  
ATOM    221  N   PHE A1031      25.289 104.238   9.959  1.00  7.42           N  
ATOM    222  CA  PHE A1031      24.238 103.657   9.089  1.00  8.43           C  
ATOM    223  C   PHE A1031      23.079 103.258   9.932  1.00  7.52           C  
ATOM    224  O   PHE A1031      23.203 102.422  10.858  1.00  9.39           O  
ATOM    225  CB  PHE A1031      24.829 102.411   8.376  1.00  8.64           C  
ATOM    226  CG  PHE A1031      25.938 102.760   7.410  1.00  8.96           C  
ATOM    227  CD1 PHE A1031      27.265 102.929   7.829  1.00 10.32           C  
ATOM    228  CD2 PHE A1031      25.654 102.930   6.045  1.00 10.07           C  
ATOM    229  CE1 PHE A1031      28.248 103.243   6.917  1.00 11.52           C  
ATOM    230  CE2 PHE A1031      26.655 103.265   5.141  1.00 11.00           C  
ATOM    231  CZ  PHE A1031      27.968 103.444   5.562  1.00 11.91           C  
ATOM    232  N   TRP A1032      21.922 103.842   9.655  1.00  7.95           N  
ATOM    233  CA  TRP A1032      20.728 103.645  10.522  1.00  7.71           C  
ATOM    234  C   TRP A1032      19.480 103.490   9.680  1.00  7.17           C  
ATOM    235  O   TRP A1032      19.406 103.803   8.489  1.00  7.83           O  
ATOM    236  CB  TRP A1032      20.610 104.863  11.421  1.00  8.15           C  
ATOM    237  CG  TRP A1032      20.423 106.227  10.864  1.00  7.51           C  
ATOM    238  CD1 TRP A1032      21.420 107.091  10.529  1.00  7.75           C  
ATOM    239  CD2 TRP A1032      19.193 106.915  10.591  1.00  8.05           C  
ATOM    240  NE1 TRP A1032      20.922 108.285  10.061  1.00  7.99           N  
ATOM    241  CE2 TRP A1032      19.549 108.199  10.102  1.00  7.85           C  
ATOM    242  CE3 TRP A1032      17.847 106.581  10.721  1.00  9.38           C  
ATOM    243  CZ2 TRP A1032      18.595 109.162   9.743  1.00  8.12           C  
ATOM    244  CZ3 TRP A1032      16.906 107.531  10.363  1.00  9.43           C  
ATOM    245  CH2 TRP A1032      17.273 108.805   9.863  1.00  9.19           C  
ATOM    246  N   THR A1033      18.432 102.957  10.374  1.00  7.99           N  
ATOM    247  CA  THR A1033      17.090 103.016   9.840  1.00  8.39           C  
ATOM    248  C   THR A1033      16.173 103.481  10.964  1.00  7.99           C  
ATOM    249  O   THR A1033      16.453 103.200  12.126  1.00  8.94           O  
ATOM    250  CB  THR A1033      16.616 101.626   9.319  1.00  9.89           C  
ATOM    251  OG1 THR A1033      16.426 100.687  10.431  1.00 13.74           O  
ATOM    252  CG2 THR A1033      17.484 100.979   8.298  1.00 14.18           C  
ATOM    253  N   PRO A1034      15.074 104.219  10.673  1.00  8.50           N  
ATOM    254  CA  PRO A1034      14.364 104.881  11.766  1.00  8.86           C  
ATOM    255  C   PRO A1034      13.542 103.955  12.631  1.00  8.84           C  
ATOM    256  O   PRO A1034      13.137 104.348  13.738  1.00  9.57           O  
ATOM    257  CB  PRO A1034      13.496 105.912  11.023  1.00  9.74           C  
ATOM    258  CG  PRO A1034      13.339 105.358   9.616  1.00  9.42           C  
ATOM    259  CD  PRO A1034      14.694 104.691   9.364  1.00  9.70           C  
ATOM    260  N   TRP A1035      13.268 102.732  12.139  1.00  9.92           N  
ATOM    261  CA  TRP A1035      12.392 101.831  12.844  1.00 10.53           C  
ATOM    262  C   TRP A1035      13.166 100.783  13.587  1.00 10.21           C  
ATOM    263  O   TRP A1035      12.561  99.917  14.273  1.00 12.59           O  
ATOM    264  CB  TRP A1035      11.464 101.178  11.801  1.00 11.75           C  
ATOM    265  CG  TRP A1035      12.098 100.817  10.474  1.00 11.71           C  
ATOM    266  CD1 TRP A1035      11.962 101.554   9.316  1.00 11.58           C  
ATOM    267  CD2 TRP A1035      12.932  99.716  10.132  1.00 11.23           C  
ATOM    268  NE1 TRP A1035      12.667 100.946   8.266  1.00 12.34           N  
ATOM    269  CE2 TRP A1035      13.242  99.809   8.784  1.00 11.82           C  
ATOM    270  CE3 TRP A1035      13.390  98.620  10.898  1.00 11.92           C  
ATOM    271  CZ2 TRP A1035      14.046  98.877   8.107  1.00 12.45           C  
ATOM    272  CZ3 TRP A1035      14.163  97.680  10.257  1.00 13.74           C  
ATOM    273  CH2 TRP A1035      14.449  97.839   8.871  1.00 12.46           C  
ATOM    274  N   CYS A1036      14.492 100.858  13.595  1.00  9.75           N  
ATOM    275  CA  CYS A1036      15.298  99.894  14.315  1.00  9.77           C  
ATOM    276  C   CYS A1036      15.413 100.270  15.792  1.00  9.48           C  
ATOM    277  O   CYS A1036      15.812 101.428  16.093  1.00  9.89           O  
ATOM    278  CB  CYS A1036      16.700  99.807  13.694  1.00 10.40           C  
ATOM    279  SG  CYS A1036      17.885  98.916  14.721  1.00 10.20           S  
ATOM    280  N   PRO A1037      15.086  99.405  16.755  1.00 10.18           N  
ATOM    281  CA  PRO A1037      15.137  99.810  18.149  1.00 10.67           C  
ATOM    282  C   PRO A1037      16.572 100.076  18.600  1.00  9.99           C  
ATOM    283  O   PRO A1037      16.764 100.861  19.545  1.00 10.64           O  
ATOM    284  CB  PRO A1037      14.501  98.643  18.886  1.00 11.93           C  
ATOM    285  CG  PRO A1037      14.796  97.456  18.008  1.00 13.41           C  
ATOM    286  CD  PRO A1037      14.672  98.008  16.593  1.00 11.02           C  
ATOM    287  N   PHE A1038      17.549  99.428  18.011  1.00  9.72           N  
ATOM    288  CA  PHE A1038      18.939  99.657  18.384  1.00  9.77           C  
ATOM    289  C   PHE A1038      19.356 101.031  17.897  1.00  9.26           C  
ATOM    290  O   PHE A1038      20.015 101.774  18.628  1.00 10.11           O  
ATOM    291  CB  PHE A1038      19.839  98.555  17.841  1.00 11.05           C  
ATOM    292  CG  PHE A1038      19.451  97.185  18.353  1.00 11.46           C  
ATOM    293  CD1 PHE A1038      19.939  96.740  19.564  1.00 12.95           C  
ATOM    294  CD2 PHE A1038      18.582  96.350  17.591  1.00 12.36           C  
ATOM    295  CE1 PHE A1038      19.601  95.466  20.049  1.00 15.67           C  
ATOM    296  CE2 PHE A1038      18.246  95.104  18.088  1.00 15.22           C  
ATOM    297  CZ  PHE A1038      18.737  94.682  19.315  1.00 15.11           C  
ATOM    298  N   CYS A1039      18.957 101.419  16.682  1.00  9.15           N  
ATOM    299  CA  CYS A1039      19.239 102.739  16.180  1.00  9.18           C  
ATOM    300  C   CYS A1039      18.562 103.795  17.054  1.00  8.06           C  
ATOM    301  O   CYS A1039      19.162 104.840  17.351  1.00  8.66           O  
ATOM    302  CB  CYS A1039      18.789 102.882  14.736  1.00  8.88           C  
ATOM    303  SG  CYS A1039      19.727 101.889  13.543  1.00  9.68           S  
ATOM    304  N   ASN A1040      17.347 103.524  17.453  1.00  8.75           N  
ATOM    305  CA  ASN A1040      16.628 104.451  18.309  1.00  8.74           C  
ATOM    306  C   ASN A1040      17.334 104.587  19.648  1.00  8.44           C  
ATOM    307  O   ASN A1040      17.417 105.694  20.192  1.00  9.92           O  
ATOM    308  CB  ASN A1040      15.186 103.980  18.572  1.00  9.52           C  
ATOM    309  CG  ASN A1040      14.290 104.360  17.411  1.00  9.75           C  
ATOM    310  OD1 ASN A1040      14.232 103.644  16.350  1.00 12.37           O  
ATOM    311  ND2 ASN A1040      13.591 105.434  17.582  1.00  8.86           N  
ATOM    312  N   ALA A1041      17.873 103.492  20.223  1.00  9.74           N  
ATOM    313  CA  ALA A1041      18.616 103.549  21.488  1.00 10.25           C  
ATOM    314  C   ALA A1041      19.893 104.319  21.333  1.00  9.92           C  
ATOM    315  O   ALA A1041      20.301 105.033  22.257  1.00 13.26           O  
ATOM    316  CB  ALA A1041      18.861 102.149  21.990  1.00 11.61           C  
ATOM    317  N   GLU A1042      20.587 104.200  20.241  1.00  9.51           N  
ATOM    318  CA  GLU A1042      21.841 104.914  20.001  1.00  9.79           C  
ATOM    319  C   GLU A1042      21.664 106.368  19.642  1.00  8.96           C  
ATOM    320  O   GLU A1042      22.584 107.169  19.922  1.00 10.23           O  
ATOM    321  CB  GLU A1042      22.598 104.258  18.838  1.00 10.17           C  
ATOM    322  CG  GLU A1042      23.163 102.892  19.220  1.00 10.65           C  
ATOM    323  CD  GLU A1042      23.939 102.246  18.114  1.00 10.42           C  
ATOM    324  OE1 GLU A1042      23.941 102.733  16.983  1.00 13.54           O  
ATOM    325  OE2 GLU A1042      24.581 101.189  18.435  1.00 12.57           O  
ATOM    326  N   ALA A1043      20.550 106.774  19.061  1.00  8.55           N  
ATOM    327  CA  ALA A1043      20.396 108.105  18.505  1.00  8.60           C  
ATOM    328  C   ALA A1043      20.666 109.210  19.541  1.00  8.75           C  
ATOM    329  O   ALA A1043      21.358 110.179  19.169  1.00  9.11           O  
ATOM    330  CB  ALA A1043      19.031 108.300  17.903  1.00  8.97           C  
ATOM    331  N   PRO A1044      20.194 109.154  20.784  1.00  9.14           N  
ATOM    332  CA  PRO A1044      20.534 110.238  21.730  1.00  9.96           C  
ATOM    333  C   PRO A1044      22.037 110.380  21.954  1.00  9.58           C  
ATOM    334  O   PRO A1044      22.565 111.465  22.130  1.00 10.16           O  
ATOM    335  CB  PRO A1044      19.821 109.810  23.021  1.00 11.26           C  
ATOM    336  CG  PRO A1044      18.696 108.901  22.581  1.00 12.55           C  
ATOM    337  CD  PRO A1044      19.251 108.181  21.367  1.00 10.00           C  
ATOM    338  N   SER A1045      22.744 109.220  21.941  1.00 10.03           N  
ATOM    339  CA  SER A1045      24.187 109.243  22.089  1.00 10.28           C  
ATOM    340  C   SER A1045      24.861 109.857  20.899  1.00  9.44           C  
ATOM    341  O   SER A1045      25.827 110.622  21.044  1.00 10.89           O  
ATOM    342  CB  SER A1045      24.696 107.804  22.291  1.00 12.78           C  
ATOM    343  OG  SER A1045      24.158 107.348  23.543  1.00 13.41           O  
ATOM    344  N   LEU A1046      24.444 109.545  19.677  1.00  9.32           N  
ATOM    345  CA  LEU A1046      24.959 110.241  18.461  1.00  9.55           C  
ATOM    346  C   LEU A1046      24.745 111.724  18.608  1.00  8.51           C  
ATOM    347  O   LEU A1046      25.648 112.515  18.328  1.00  9.23           O  
ATOM    348  CB  LEU A1046      24.256 109.789  17.168  1.00 10.79           C  
ATOM    349  CG  LEU A1046      24.808 108.577  16.433  1.00 10.49           C  
ATOM    350  CD1 LEU A1046      26.218 108.841  15.852  1.00 12.14           C  
ATOM    351  CD2 LEU A1046      24.828 107.325  17.294  1.00 11.57           C  
ATOM    352  N   SER A1047      23.540 112.132  19.044  1.00  8.80           N  
ATOM    353  CA  SER A1047      23.267 113.575  19.104  1.00  8.97           C  
ATOM    354  C   SER A1047      24.217 114.285  20.054  1.00  8.61           C  
ATOM    355  O   SER A1047      24.815 115.319  19.729  1.00  9.09           O  
ATOM    356  CB  SER A1047      21.836 113.751  19.645  1.00  9.55           C  
ATOM    357  OG  SER A1047      21.578 115.145  19.746  1.00  9.76           O  
ATOM    358  N   GLN A1048      24.422 113.697  21.212  1.00  8.90           N  
ATOM    359  CA  GLN A1048      25.272 114.305  22.259  1.00  8.94           C  
ATOM    360  C   GLN A1048      26.735 114.242  21.876  1.00  8.88           C  
ATOM    361  O   GLN A1048      27.472 115.215  22.032  1.00 10.84           O  
ATOM    362  CB  GLN A1048      25.012 113.570  23.585  1.00 10.14           C  
ATOM    363  CG  GLN A1048      23.654 113.931  24.203  1.00  9.64           C  
ATOM    364  CD  GLN A1048      23.589 115.377  24.598  1.00 10.52           C  
ATOM    365  OE1 GLN A1048      22.717 116.163  24.104  1.00 12.31           O  
ATOM    366  NE2 GLN A1048      24.470 115.798  25.479  1.00  9.49           N  
ATOM    367  N   VAL A1049      27.219 113.098  21.416  1.00  9.40           N  
ATOM    368  CA  VAL A1049      28.638 112.963  21.081  1.00  9.46           C  
ATOM    369  C   VAL A1049      29.002 113.847  19.893  1.00  9.34           C  
ATOM    370  O   VAL A1049      30.056 114.491  19.902  1.00 10.39           O  
ATOM    371  CB  VAL A1049      29.048 111.509  20.934  1.00  9.86           C  
ATOM    372  CG1 VAL A1049      30.539 111.414  20.538  1.00 12.84           C  
ATOM    373  CG2 VAL A1049      28.812 110.730  22.222  1.00 11.17           C  
ATOM    374  N   ALA A1050      28.147 113.943  18.889  1.00  8.54           N  
ATOM    375  CA  ALA A1050      28.413 114.818  17.737  1.00  8.88           C  
ATOM    376  C   ALA A1050      28.501 116.252  18.254  1.00  9.10           C  
ATOM    377  O   ALA A1050      29.388 117.012  17.866  1.00 10.75           O  
ATOM    378  CB  ALA A1050      27.351 114.667  16.674  1.00  9.26           C  
ATOM    379  N   ALA A1051      27.572 116.659  19.130  1.00  9.23           N  
ATOM    380  CA  ALA A1051      27.529 118.048  19.603  1.00  9.67           C  
ATOM    381  C   ALA A1051      28.800 118.382  20.361  1.00  9.37           C  
ATOM    382  O   ALA A1051      29.322 119.495  20.266  1.00 11.59           O  
ATOM    383  CB  ALA A1051      26.314 118.310  20.461  1.00 11.17           C  
ATOM    384  N   ALA A1052      29.284 117.424  21.137  1.00  9.44           N  
ATOM    385  CA  ALA A1052      30.464 117.629  21.993  1.00 11.22           C  
ATOM    386  C   ALA A1052      31.761 117.541  21.240  1.00 11.19           C  
ATOM    387  O   ALA A1052      32.794 117.867  21.849  1.00 13.76           O  
ATOM    388  CB  ALA A1052      30.430 116.626  23.165  1.00 12.08           C  
ATOM    389  N   ASN A1053      31.775 117.116  19.993  1.00 10.61           N  
ATOM    390  CA  ASN A1053      33.004 116.858  19.258  1.00 12.05           C  
ATOM    391  C   ASN A1053      32.926 117.519  17.886  1.00 13.10           C  
ATOM    392  O   ASN A1053      32.969 116.817  16.880  1.00 12.85           O  
ATOM    393  CB  ASN A1053      33.268 115.352  19.109  1.00 13.19           C  
ATOM    394  CG  ASN A1053      33.511 114.718  20.489  1.00 13.39           C  
ATOM    395  OD1 ASN A1053      32.531 114.272  21.153  1.00 14.58           O  
ATOM    396  ND2 ASN A1053      34.733 114.666  20.918  1.00 18.19           N  
ATOM    397  N   PRO A1054      32.792 118.857  17.820  1.00 14.70           N  
ATOM    398  CA  PRO A1054      32.494 119.532  16.553  1.00 15.40           C  
ATOM    399  C   PRO A1054      33.580 119.420  15.501  1.00 16.30           C  
ATOM    400  O   PRO A1054      33.329 119.614  14.290  1.00 21.49           O  
ATOM    401  CB  PRO A1054      32.232 120.993  16.931  1.00 18.12           C  
ATOM    402  CG  PRO A1054      32.993 121.117  18.219  1.00 20.86           C  
ATOM    403  CD  PRO A1054      32.787 119.800  18.967  1.00 16.00           C  
ATOM    404  N   ALA A1055      34.826 119.111  15.919  1.00 17.34           N  
ATOM    405  CA  ALA A1055      35.851 118.979  14.889  1.00 17.11           C  
ATOM    406  C   ALA A1055      35.843 117.577  14.267  1.00 15.89           C  
ATOM    407  O   ALA A1055      36.683 117.342  13.362  1.00 18.61           O  
ATOM    408  CB  ALA A1055      37.157 119.389  15.507  1.00 22.00           C  
ATOM    409  N   VAL A1056      34.998 116.654  14.700  1.00 13.06           N  
ATOM    410  CA  VAL A1056      34.767 115.354  14.043  1.00 11.10           C  
ATOM    411  C   VAL A1056      33.467 115.533  13.249  1.00  9.70           C  
ATOM    412  O   VAL A1056      32.457 116.058  13.757  1.00 11.52           O  
ATOM    413  CB  VAL A1056      34.618 114.234  15.077  1.00 11.83           C  
ATOM    414  CG1 VAL A1056      34.292 112.896  14.462  1.00 11.85           C  
ATOM    415  CG2 VAL A1056      35.935 114.116  15.881  1.00 14.90           C  
ATOM    416  N   THR A1057      33.493 115.138  11.975  1.00  8.98           N  
ATOM    417  CA  THR A1057      32.323 115.316  11.125  1.00  9.82           C  
ATOM    418  C   THR A1057      31.489 114.019  11.080  1.00  8.51           C  
ATOM    419  O   THR A1057      31.994 112.984  10.694  1.00  9.75           O  
ATOM    420  CB  THR A1057      32.775 115.689   9.707  1.00 10.54           C  
ATOM    421  OG1 THR A1057      33.593 116.887   9.807  1.00 11.86           O  
ATOM    422  CG2 THR A1057      31.587 116.020   8.825  1.00 11.58           C  
ATOM    423  N   PHE A1058      30.273 114.134  11.552  1.00  8.49           N  
ATOM    424  CA  PHE A1058      29.371 112.983  11.614  1.00  8.72           C  
ATOM    425  C   PHE A1058      28.437 113.027  10.416  1.00  8.66           C  
ATOM    426  O   PHE A1058      27.867 114.069  10.089  1.00  9.54           O  
ATOM    427  CB  PHE A1058      28.495 113.043  12.893  1.00  9.07           C  
ATOM    428  CG  PHE A1058      29.257 112.687  14.160  1.00  9.84           C  
ATOM    429  CD1 PHE A1058      30.224 113.565  14.663  1.00 10.91           C  
ATOM    430  CD2 PHE A1058      28.994 111.496  14.820  1.00 12.20           C  
ATOM    431  CE1 PHE A1058      30.912 113.229  15.828  1.00 11.93           C  
ATOM    432  CE2 PHE A1058      29.666 111.152  15.996  1.00 15.54           C  
ATOM    433  CZ  PHE A1058      30.606 112.044  16.459  1.00 13.65           C  
ATOM    434  N   VAL A1059      28.241 111.853   9.787  1.00  8.62           N  
ATOM    435  CA  VAL A1059      27.299 111.712   8.696  1.00  8.17           C  
ATOM    436  C   VAL A1059      26.503 110.467   8.950  1.00  7.46           C  
ATOM    437  O   VAL A1059      27.020 109.363   9.004  1.00  8.85           O  
ATOM    438  CB  VAL A1059      28.011 111.638   7.346  1.00  8.80           C  
ATOM    439  CG1 VAL A1059      27.012 111.491   6.195  1.00 10.24           C  
ATOM    440  CG2 VAL A1059      28.899 112.869   7.148  1.00 10.77           C  
ATOM    441  N   GLY A1060      25.184 110.678   9.079  1.00  7.86           N  
ATOM    442  CA  GLY A1060      24.258 109.532   9.154  1.00  7.96           C  
ATOM    443  C   GLY A1060      23.849 109.132   7.742  1.00  7.81           C  
ATOM    444  O   GLY A1060      23.731 109.986   6.857  1.00  8.57           O  
ATOM    445  N   ILE A1061      23.598 107.847   7.536  1.00  7.87           N  
ATOM    446  CA  ILE A1061      23.255 107.337   6.220  1.00  7.91           C  
ATOM    447  C   ILE A1061      22.063 106.394   6.454  1.00  7.48           C  
ATOM    448  O   ILE A1061      22.211 105.325   7.066  1.00  8.89           O  
ATOM    449  CB  ILE A1061      24.432 106.625   5.525  1.00  9.89           C  
ATOM    450  CG1 ILE A1061      25.664 107.557   5.470  1.00 11.66           C  
ATOM    451  CG2 ILE A1061      23.998 106.159   4.156  1.00 13.42           C  
ATOM    452  CD1 ILE A1061      26.940 107.000   4.947  1.00 21.34           C  
ATOM    453  N   ALA A1062      20.888 106.826   6.003  1.00  7.78           N  
ATOM    454  CA  ALA A1062      19.654 106.076   6.299  1.00  8.28           C  
ATOM    455  C   ALA A1062      19.180 105.394   5.028  1.00  8.58           C  
ATOM    456  O   ALA A1062      19.354 105.877   3.897  1.00  8.93           O  
ATOM    457  CB  ALA A1062      18.563 107.054   6.768  1.00 10.04           C  
ATOM    458  N   THR A1063      18.510 104.248   5.208  1.00  9.43           N  
ATOM    459  CA  THR A1063      17.895 103.566   4.062  1.00  9.43           C  
ATOM    460  C   THR A1063      16.691 102.757   4.599  1.00  9.76           C  
ATOM    461  O   THR A1063      16.420 102.704   5.791  1.00 10.81           O  
ATOM    462  CB  THR A1063      18.903 102.693   3.339  1.00 11.54           C  
ATOM    463  OG1 THR A1063      18.334 102.278   2.043  1.00 12.82           O  
ATOM    464  CG2 THR A1063      19.297 101.446   4.103  1.00 14.32           C  
ATOM    465  N   ARG A1064      15.987 102.160   3.662  1.00 10.67           N  
ATOM    466  CA  ARG A1064      14.843 101.245   3.966  1.00 11.32           C  
ATOM    467  C   ARG A1064      13.734 101.986   4.682  1.00 10.32           C  
ATOM    468  O   ARG A1064      13.036 101.388   5.521  1.00 10.93           O  
ATOM    469  CB  ARG A1064      15.294 100.020   4.737  1.00 11.64           C  
ATOM    470  CG  ARG A1064      16.150  99.096   3.854  1.00 18.32           C  
ATOM    471  CD  ARG A1064      16.246  97.805   4.570  1.00 21.86           C  
ATOM    472  NE  ARG A1064      15.148  96.945   4.443  1.00 20.22           N  
ATOM    473  CZ  ARG A1064      15.019  95.819   5.153  1.00 21.52           C  
ATOM    474  NH1 ARG A1064      15.896  95.482   6.050  1.00 21.45           N  
ATOM    475  NH2 ARG A1064      14.012  95.037   5.000  1.00 21.90           N  
ATOM    476  N   ALA A1065      13.503 103.242   4.332  1.00 10.25           N  
ATOM    477  CA  ALA A1065      12.380 103.966   4.945  1.00 10.52           C  
ATOM    478  C   ALA A1065      12.018 105.144   4.061  1.00 10.73           C  
ATOM    479  O   ALA A1065      12.856 105.613   3.272  1.00 11.95           O  
ATOM    480  CB  ALA A1065      12.717 104.454   6.362  1.00 12.73           C  
ATOM    481  N   ASP A1066      10.800 105.666   4.240  1.00 12.35           N  
ATOM    482  CA  ASP A1066      10.464 106.876   3.510  1.00 13.97           C  
ATOM    483  C   ASP A1066      11.123 108.089   4.159  1.00 11.47           C  
ATOM    484  O   ASP A1066      11.523 108.094   5.338  1.00 11.36           O  
ATOM    485  CB  ASP A1066       8.954 107.096   3.452  1.00 19.81           C  
ATOM    486  CG  ASP A1066       8.378 107.094   4.841  1.00 25.12           C  
ATOM    487  OD1 ASP A1066       8.241 108.145   5.451  1.00 27.24           O  
ATOM    488  OD2 ASP A1066       8.105 105.997   5.381  1.00 38.81           O  
ATOM    489  N   VAL A1067      11.253 109.145   3.347  1.00 12.28           N  
ATOM    490  CA  VAL A1067      12.031 110.294   3.829  1.00 12.53           C  
ATOM    491  C   VAL A1067      11.359 110.943   5.010  1.00 12.51           C  
ATOM    492  O   VAL A1067      12.045 111.408   5.933  1.00 12.20           O  
ATOM    493  CB  VAL A1067      12.253 111.296   2.688  1.00 17.25           C  
ATOM    494  CG1 VAL A1067      13.177 112.434   3.187  1.00 32.81           C  
ATOM    495  CG2 VAL A1067      12.869 110.705   1.470  1.00 23.99           C  
ATOM    496  N   GLY A1068      10.043 111.024   5.063  1.00 13.67           N  
ATOM    497  CA  GLY A1068       9.396 111.598   6.216  1.00 15.41           C  
ATOM    498  C   GLY A1068       9.717 110.875   7.510  1.00 11.89           C  
ATOM    499  O   GLY A1068       9.868 111.497   8.570  1.00 12.47           O  
ATOM    500  N   ALA A1069       9.801 109.527   7.446  1.00 12.51           N  
ATOM    501  CA  ALA A1069      10.129 108.731   8.635  1.00 11.35           C  
ATOM    502  C   ALA A1069      11.570 109.000   9.041  1.00  9.62           C  
ATOM    503  O   ALA A1069      11.899 109.070  10.249  1.00 10.03           O  
ATOM    504  CB  ALA A1069       9.890 107.240   8.361  1.00 14.30           C  
ATOM    505  N   MET A1070      12.427 109.128   8.057  1.00  9.39           N  
ATOM    506  CA  MET A1070      13.836 109.497   8.353  1.00  8.37           C  
ATOM    507  C   MET A1070      13.898 110.823   9.038  1.00  8.28           C  
ATOM    508  O   MET A1070      14.596 111.013  10.038  1.00  8.42           O  
ATOM    509  CB  MET A1070      14.676 109.493   7.076  1.00  8.96           C  
ATOM    510  CG  MET A1070      14.797 108.127   6.408  1.00  9.52           C  
ATOM    511  SD  MET A1070      15.619 108.332   4.799  1.00  9.91           S  
ATOM    512  CE  MET A1070      15.826 106.637   4.313  1.00 10.32           C  
ATOM    513  N   GLN A1071      13.156 111.798   8.501  1.00  8.76           N  
ATOM    514  CA  GLN A1071      13.170 113.152   9.089  1.00  8.64           C  
ATOM    515  C   GLN A1071      12.595 113.152  10.500  1.00  8.69           C  
ATOM    516  O   GLN A1071      13.083 113.833  11.380  1.00  9.27           O  
ATOM    517  CB  GLN A1071      12.325 114.089   8.211  1.00 10.05           C  
ATOM    518  CG  GLN A1071      13.043 114.341   6.901  1.00  9.84           C  
ATOM    519  CD  GLN A1071      12.230 115.194   5.951  1.00  9.76           C  
ATOM    520  OE1 GLN A1071      11.004 115.386   6.104  1.00 11.33           O  
ATOM    521  NE2 GLN A1071      12.902 115.763   4.980  1.00 12.21           N  
ATOM    522  N   SER A1072      11.508 112.379  10.740  1.00  8.73           N  
ATOM    523  CA  SER A1072      10.973 112.349  12.107  1.00  9.43           C  
ATOM    524  C   SER A1072      11.993 111.863  13.088  1.00  8.77           C  
ATOM    525  O   SER A1072      12.005 112.324  14.244  1.00  9.38           O  
ATOM    526  CB  SER A1072       9.756 111.414  12.117  1.00 11.36           C  
ATOM    527  OG  SER A1072       8.676 112.015  11.464  1.00 14.46           O  
ATOM    528  N   PHE A1073      12.798 110.860  12.694  1.00  8.44           N  
ATOM    529  CA  PHE A1073      13.815 110.312  13.582  1.00  8.13           C  
ATOM    530  C   PHE A1073      14.907 111.343  13.903  1.00  7.64           C  
ATOM    531  O   PHE A1073      15.256 111.550  15.052  1.00  8.77           O  
ATOM    532  CB  PHE A1073      14.361 109.084  12.879  1.00  8.54           C  
ATOM    533  CG  PHE A1073      15.434 108.320  13.579  1.00  8.30           C  
ATOM    534  CD1 PHE A1073      16.784 108.665  13.456  1.00  9.50           C  
ATOM    535  CD2 PHE A1073      15.140 107.190  14.367  1.00  8.90           C  
ATOM    536  CE1 PHE A1073      17.761 107.870  14.048  1.00  9.82           C  
ATOM    537  CE2 PHE A1073      16.136 106.432  14.967  1.00  9.34           C  
ATOM    538  CZ  PHE A1073      17.479 106.763  14.802  1.00  9.79           C  
ATOM    539  N   VAL A1074      15.391 112.040  12.856  1.00  8.27           N  
ATOM    540  CA  VAL A1074      16.378 113.077  13.067  1.00  8.60           C  
ATOM    541  C   VAL A1074      15.831 114.153  13.984  1.00  8.96           C  
ATOM    542  O   VAL A1074      16.569 114.654  14.869  1.00  9.36           O  
ATOM    543  CB  VAL A1074      16.829 113.644  11.695  1.00  8.77           C  
ATOM    544  CG1 VAL A1074      17.549 114.973  11.843  1.00 10.10           C  
ATOM    545  CG2 VAL A1074      17.707 112.649  10.937  1.00 10.94           C  
ATOM    546  N   SER A1075      14.568 114.525  13.782  1.00  8.56           N  
ATOM    547  CA  SER A1075      13.962 115.590  14.615  1.00  9.25           C  
ATOM    548  C   SER A1075      13.805 115.135  16.047  1.00  9.36           C  
ATOM    549  O   SER A1075      14.110 115.868  16.976  1.00 10.99           O  
ATOM    550  CB  SER A1075      12.618 116.003  14.051  1.00 11.19           C  
ATOM    551  OG  SER A1075      12.793 116.655  12.806  1.00 11.99           O  
ATOM    552  N   LYS A1076      13.258 113.934  16.272  1.00  9.58           N  
ATOM    553  CA  LYS A1076      13.010 113.411  17.603  1.00 10.42           C  
ATOM    554  C   LYS A1076      14.269 113.342  18.452  1.00  8.90           C  
ATOM    555  O   LYS A1076      14.205 113.633  19.630  1.00 10.06           O  
ATOM    556  CB  LYS A1076      12.387 112.011  17.468  1.00 12.95           C  
ATOM    557  CG  LYS A1076      12.156 111.264  18.786  1.00 14.38           C  
ATOM    558  CD  LYS A1076      11.451 109.943  18.472  1.00 18.39           C  
ATOM    559  CE  LYS A1076      11.250 109.215  19.820  1.00 30.01           C  
ATOM    560  NZ  LYS A1076      10.596 107.927  19.529  1.00 48.54           N  
ATOM    561  N   TYR A1077      15.391 112.949  17.815  1.00  8.59           N  
ATOM    562  CA  TYR A1077      16.613 112.748  18.537  1.00  8.54           C  
ATOM    563  C   TYR A1077      17.602 113.878  18.360  1.00  8.49           C  
ATOM    564  O   TYR A1077      18.719 113.803  18.899  1.00  9.68           O  
ATOM    565  CB  TYR A1077      17.261 111.396  18.163  1.00  9.38           C  
ATOM    566  CG  TYR A1077      16.361 110.240  18.523  1.00  8.74           C  
ATOM    567  CD1 TYR A1077      16.098 109.956  19.855  1.00  9.59           C  
ATOM    568  CD2 TYR A1077      15.795 109.409  17.560  1.00  9.45           C  
ATOM    569  CE1 TYR A1077      15.292 108.889  20.252  1.00 11.47           C  
ATOM    570  CE2 TYR A1077      14.974 108.339  17.932  1.00 10.01           C  
ATOM    571  CZ  TYR A1077      14.744 108.085  19.255  1.00 10.14           C  
ATOM    572  OH  TYR A1077      13.921 107.056  19.660  1.00 11.60           O  
ATOM    573  N   ASN A1078      17.200 114.937  17.684  1.00  8.56           N  
ATOM    574  CA  ASN A1078      18.075 116.126  17.557  1.00  8.91           C  
ATOM    575  C   ASN A1078      19.425 115.752  16.982  1.00  8.28           C  
ATOM    576  O   ASN A1078      20.494 116.078  17.502  1.00  9.29           O  
ATOM    577  CB  ASN A1078      18.239 116.781  18.937  1.00 11.80           C  
ATOM    578  CG  ASN A1078      18.698 118.194  18.801  1.00 15.34           C  
ATOM    579  OD1 ASN A1078      18.890 118.708  17.689  1.00 22.61           O  
ATOM    580  ND2 ASN A1078      18.898 118.861  19.926  1.00 19.52           N  
ATOM    581  N   LEU A1079      19.409 115.065  15.831  1.00  8.98           N  
ATOM    582  CA  LEU A1079      20.667 114.667  15.157  1.00  9.16           C  
ATOM    583  C   LEU A1079      21.146 115.811  14.297  1.00  9.87           C  
ATOM    584  O   LEU A1079      20.811 115.932  13.128  1.00 10.66           O  
ATOM    585  CB  LEU A1079      20.467 113.390  14.331  1.00  9.54           C  
ATOM    586  CG  LEU A1079      19.932 112.206  15.125  1.00 10.15           C  
ATOM    587  CD1 LEU A1079      19.775 110.970  14.229  1.00 12.33           C  
ATOM    588  CD2 LEU A1079      20.870 111.829  16.240  1.00 14.31           C  
ATOM    589  N   ASN A1080      21.923 116.714  14.936  1.00 10.01           N  
ATOM    590  CA  ASN A1080      22.333 117.933  14.253  1.00  9.09           C  
ATOM    591  C   ASN A1080      23.619 117.743  13.472  1.00  9.70           C  
ATOM    592  O   ASN A1080      24.701 118.309  13.789  1.00 11.40           O  
ATOM    593  CB  ASN A1080      22.514 119.053  15.297  1.00 10.69           C  
ATOM    594  CG  ASN A1080      22.838 120.384  14.655  1.00 11.90           C  
ATOM    595  OD1 ASN A1080      22.430 120.648  13.528  1.00 15.71           O  
ATOM    596  ND2 ASN A1080      23.533 121.223  15.360  1.00 13.98           N  
ATOM    597  N   PHE A1081      23.524 116.962  12.425  1.00  9.04           N  
ATOM    598  CA  PHE A1081      24.604 116.679  11.522  1.00  9.46           C  
ATOM    599  C   PHE A1081      23.987 116.187  10.219  1.00  9.05           C  
ATOM    600  O   PHE A1081      22.787 115.890  10.166  1.00  9.57           O  
ATOM    601  CB  PHE A1081      25.629 115.682  12.092  1.00  9.46           C  
ATOM    602  CG  PHE A1081      25.038 114.428  12.686  1.00  9.49           C  
ATOM    603  CD1 PHE A1081      24.706 113.338  11.848  1.00  9.59           C  
ATOM    604  CD2 PHE A1081      24.839 114.279  14.043  1.00  9.72           C  
ATOM    605  CE1 PHE A1081      24.227 112.160  12.413  1.00 10.12           C  
ATOM    606  CE2 PHE A1081      24.381 113.102  14.611  1.00 10.75           C  
ATOM    607  CZ  PHE A1081      24.076 112.045  13.758  1.00 10.11           C  
ATOM    608  N   THR A1082      24.801 116.078   9.169  1.00  9.07           N  
ATOM    609  CA  THR A1082      24.271 115.653   7.870  1.00  9.52           C  
ATOM    610  C   THR A1082      23.707 114.236   7.980  1.00  7.62           C  
ATOM    611  O   THR A1082      24.354 113.347   8.510  1.00  8.62           O  
ATOM    612  CB  THR A1082      25.427 115.627   6.844  1.00 10.27           C  
ATOM    613  OG1 THR A1082      25.939 116.956   6.718  1.00 14.41           O  
ATOM    614  CG2 THR A1082      24.918 115.151   5.490  1.00 12.65           C  
ATOM    615  N   ASN A1083      22.519 114.040   7.425  1.00  8.45           N  
ATOM    616  CA  ASN A1083      21.951 112.690   7.248  1.00  8.36           C  
ATOM    617  C   ASN A1083      21.543 112.531   5.815  1.00  8.26           C  
ATOM    618  O   ASN A1083      20.907 113.386   5.202  1.00  9.53           O  
ATOM    619  CB  ASN A1083      20.745 112.472   8.196  1.00  9.69           C  
ATOM    620  CG  ASN A1083      21.233 112.243   9.602  1.00  8.50           C  
ATOM    621  OD1 ASN A1083      21.606 111.136   9.982  1.00  8.71           O  
ATOM    622  ND2 ASN A1083      21.280 113.334  10.338  1.00  9.93           N  
ATOM    623  N   LEU A1084      21.935 111.393   5.241  1.00  8.81           N  
ATOM    624  CA  LEU A1084      21.779 111.108   3.826  1.00  8.33           C  
ATOM    625  C   LEU A1084      20.596 110.163   3.605  1.00  8.09           C  
ATOM    626  O   LEU A1084      20.431 109.191   4.333  1.00  8.58           O  
ATOM    627  CB  LEU A1084      23.045 110.437   3.246  1.00  9.53           C  
ATOM    628  CG  LEU A1084      24.310 111.336   3.455  1.00  9.59           C  
ATOM    629  CD1 LEU A1084      25.523 110.656   2.847  1.00 10.96           C  
ATOM    630  CD2 LEU A1084      24.148 112.726   2.865  1.00 10.99           C  
ATOM    631  N   ASN A1085      19.800 110.478   2.593  1.00  8.90           N  
ATOM    632  CA  ASN A1085      18.711 109.581   2.201  1.00  9.84           C  
ATOM    633  C   ASN A1085      19.281 108.618   1.163  1.00  9.45           C  
ATOM    634  O   ASN A1085      19.302 108.962  -0.033  1.00 10.16           O  
ATOM    635  CB  ASN A1085      17.580 110.430   1.598  1.00 11.39           C  
ATOM    636  CG  ASN A1085      16.457 109.552   1.061  1.00 12.21           C  
ATOM    637  OD1 ASN A1085      16.407 108.367   1.288  1.00 12.14           O  
ATOM    638  ND2 ASN A1085      15.580 110.175   0.302  1.00 16.53           N  
ATOM    639  N   ASP A1086      19.799 107.486   1.592  1.00  9.95           N  
ATOM    640  CA  ASP A1086      20.417 106.541   0.663  1.00 10.44           C  
ATOM    641  C   ASP A1086      19.326 105.616   0.184  1.00 11.21           C  
ATOM    642  O   ASP A1086      19.243 104.435   0.530  1.00 11.32           O  
ATOM    643  CB  ASP A1086      21.510 105.757   1.381  1.00 11.49           C  
ATOM    644  CG  ASP A1086      22.295 104.832   0.462  1.00 11.54           C  
ATOM    645  OD1 ASP A1086      22.448 105.120  -0.719  1.00 14.71           O  
ATOM    646  OD2 ASP A1086      22.785 103.801   0.945  1.00 15.81           O  
ATOM    647  N   ALA A1087      18.435 106.182  -0.638  1.00 13.68           N  
ATOM    648  CA  ALA A1087      17.148 105.577  -0.878  1.00 14.81           C  
ATOM    649  C   ALA A1087      17.304 104.197  -1.496  1.00 14.16           C  
ATOM    650  O   ALA A1087      16.485 103.315  -1.249  1.00 19.80           O  
ATOM    651  CB  ALA A1087      16.329 106.480  -1.817  1.00 18.25           C  
ATOM    652  N   ASP A1088      18.288 104.010  -2.393  1.00 13.14           N  
ATOM    653  CA  ASP A1088      18.399 102.707  -3.039  1.00 15.50           C  
ATOM    654  C   ASP A1088      19.537 101.879  -2.458  1.00 13.00           C  
ATOM    655  O   ASP A1088      19.894 100.811  -2.990  1.00 15.46           O  
ATOM    656  CB  ASP A1088      18.588 102.881  -4.552  1.00 18.62           C  
ATOM    657  CG  ASP A1088      17.368 103.535  -5.185  1.00 20.65           C  
ATOM    658  OD1 ASP A1088      16.225 103.409  -4.722  1.00 22.77           O  
ATOM    659  OD2 ASP A1088      17.592 104.219  -6.205  1.00 25.35           O  
ATOM    660  N   GLY A1089      20.112 102.282  -1.335  1.00 11.47           N  
ATOM    661  CA  GLY A1089      21.125 101.491  -0.705  1.00 11.58           C  
ATOM    662  C   GLY A1089      22.452 101.455  -1.382  1.00 10.91           C  
ATOM    663  O   GLY A1089      23.273 100.583  -1.069  1.00 11.62           O  
ATOM    664  N   VAL A1090      22.728 102.370  -2.299  1.00 11.12           N  
ATOM    665  CA  VAL A1090      24.000 102.349  -3.007  1.00 11.11           C  
ATOM    666  C   VAL A1090      25.188 102.630  -2.094  1.00  9.82           C  
ATOM    667  O   VAL A1090      26.224 101.992  -2.212  1.00 10.78           O  
ATOM    668  CB  VAL A1090      23.914 103.324  -4.200  1.00 13.00           C  
ATOM    669  CG1 VAL A1090      25.271 103.608  -4.850  1.00 15.42           C  
ATOM    670  CG2 VAL A1090      22.938 102.794  -5.270  1.00 15.83           C  
ATOM    671  N   ILE A1091      25.036 103.610  -1.188  1.00 10.16           N  
ATOM    672  CA  ILE A1091      26.175 103.853  -0.272  1.00  9.82           C  
ATOM    673  C   ILE A1091      26.295 102.734   0.727  1.00  8.73           C  
ATOM    674  O   ILE A1091      27.414 102.277   1.052  1.00 10.13           O  
ATOM    675  CB  ILE A1091      26.018 105.237   0.441  1.00 11.33           C  
ATOM    676  CG1 ILE A1091      25.861 106.363  -0.607  1.00 13.75           C  
ATOM    677  CG2 ILE A1091      27.154 105.466   1.391  1.00 12.45           C  
ATOM    678  CD1 ILE A1091      25.362 107.633   0.101  1.00 18.17           C  
ATOM    679  N   TRP A1092      25.182 102.203   1.223  1.00  9.61           N  
ATOM    680  CA  TRP A1092      25.220 101.074   2.140  1.00 10.01           C  
ATOM    681  C   TRP A1092      26.004  99.936   1.689  1.00 11.39           C  
ATOM    682  O   TRP A1092      26.828  99.217   2.103  1.00 10.90           O  
ATOM    683  CB  TRP A1092      23.717 100.644   2.194  0.48 12.14           C  
ATOM    685  CG  TRP A1092      23.334  99.779   3.361  0.48  8.76           C  
ATOM    687  CD1 TRP A1092      23.939  99.726   4.576  0.48 10.46           C  
ATOM    689  CD2 TRP A1092      22.258  98.839   3.443  0.48  9.17           C  
ATOM    691  NE1 TRP A1092      23.332  98.820   5.411  0.48  8.52           N  
ATOM    693  CE2 TRP A1092      22.292  98.270   4.727  0.48  9.25           C  
ATOM    695  CE3 TRP A1092      21.276  98.437   2.534  0.48  8.77           C  
ATOM    697  CZ2 TRP A1092      21.352  97.320   5.093  0.48 10.15           C  
ATOM    699  CZ3 TRP A1092      20.348  97.484   2.932  0.48  9.50           C  
ATOM    701  CH2 TRP A1092      20.396  96.929   4.215  0.48 12.00           C  
ATOM    703  N   ALA A1093      25.842  99.845   0.288  1.00  9.97           N  
ATOM    704  CA  ALA A1093      26.503  98.456  -0.750  1.00 12.04           C  
ATOM    705  C   ALA A1093      27.942  98.850  -0.723  1.00 11.11           C  
ATOM    706  O   ALA A1093      28.751  97.950  -0.585  1.00 12.49           O  
ATOM    707  CB  ALA A1093      25.816  98.416  -1.995  1.00 14.03           C  
ATOM    708  N   ARG A1094      28.323 100.114  -0.891  1.00 12.57           N  
ATOM    709  CA  ARG A1094      29.719 100.507  -1.051  1.00 13.52           C  
ATOM    710  C   ARG A1094      30.472 100.136   0.207  1.00 14.57           C  
ATOM    711  O   ARG A1094      31.651  99.801   0.146  1.00 16.13           O  
ATOM    712  CB  ARG A1094      29.757 101.992  -1.462  1.00 16.74           C  
ATOM    713  CG  ARG A1094      31.161 102.553  -1.624  1.00 23.42           C  
ATOM    714  CD  ARG A1094      30.861 104.040  -1.908  1.00 33.78           C  
ATOM    715  NE  ARG A1094      30.807 104.172  -3.345  1.00 47.16           N  
ATOM    716  CZ  ARG A1094      31.757 104.426  -4.223  1.00 38.64           C  
ATOM    717  NH1 ARG A1094      33.025 104.634  -3.894  1.00 34.35           N  
ATOM    718  NH2 ARG A1094      31.398 104.478  -5.489  1.00 37.14           N  
ATOM    719  N   TYR A1095      29.786 100.229   1.358  1.00 13.98           N  
ATOM    720  CA  TYR A1095      30.392  99.984   2.616  1.00 18.08           C  
ATOM    721  C   TYR A1095      30.115  98.595   3.089  1.00 16.99           C  
ATOM    722  O   TYR A1095      30.508  98.397   4.245  1.00 27.85           O  
ATOM    723  CB  TYR A1095      29.879 101.013   3.696  1.00 19.64           C  
ATOM    724  CG  TYR A1095      30.741 102.253   3.516  1.00 19.28           C  
ATOM    725  CD1 TYR A1095      31.944 102.326   4.231  1.00 22.99           C  
ATOM    726  CD2 TYR A1095      30.381 103.258   2.635  1.00 19.44           C  
ATOM    727  CE1 TYR A1095      32.780 103.416   4.114  1.00 21.55           C  
ATOM    728  CE2 TYR A1095      31.225 104.364   2.483  1.00 19.80           C  
ATOM    729  CZ  TYR A1095      32.411 104.407   3.242  1.00 21.05           C  
ATOM    730  OH  TYR A1095      33.184 105.503   3.019  1.00 24.52           O  
ATOM    731  N   ASN A1096      29.600  97.777   2.165  0.55 14.02           N  
ATOM    733  CA  ASN A1096      29.437  96.391   2.561  0.55 14.69           C  
ATOM    735  C   ASN A1096      28.793  96.292   3.950  0.55 10.61           C  
ATOM    737  O   ASN A1096      29.238  95.549   4.819  0.55 13.08           O  
ATOM    739  CB  ASN A1096      30.809  95.722   2.645  0.55 14.11           C  
ATOM    741  CG  ASN A1096      30.660  94.228   2.681  0.55 16.30           C  
ATOM    743  OD1 ASN A1096      29.665  93.688   2.204  0.55 14.20           O  
ATOM    745  ND2 ASN A1096      31.637  93.509   3.197  0.55 16.30           N  
ATOM    747  N   VAL A1097      27.786  97.167   4.170  0.45  8.56           N  
ATOM    749  CA  VAL A1097      27.093  97.173   5.450  0.45  9.84           C  
ATOM    751  C   VAL A1097      25.870  96.268   5.274  0.45  8.97           C  
ATOM    753  O   VAL A1097      24.989  96.618   4.484  0.45 10.39           O  
ATOM    755  CB  VAL A1097      26.694  98.571   5.910  0.45 12.13           C  
ATOM    757  CG1 VAL A1097      25.855  98.548   7.184  0.45 10.42           C  
ATOM    759  CG2 VAL A1097      27.910  99.441   6.173  0.45 12.95           C  
ATOM    761  N   PRO A1098      25.860  95.140   5.958  0.53 10.87           N  
ATOM    763  CA  PRO A1098      24.730  94.204   5.874  0.53 13.27           C  
ATOM    765  C   PRO A1098      23.926  94.939   6.908  0.53 24.15           C  
ATOM    767  O   PRO A1098      23.113  95.628   6.294  0.53 36.35           O  
ATOM    769  CB  PRO A1098      25.361  92.870   6.248  0.53 14.67           C  
ATOM    771  CG  PRO A1098      26.190  93.312   7.413  0.53 16.06           C  
ATOM    773  CD  PRO A1098      26.817  94.587   6.923  0.53 12.49           C  
ATOM    775  N   TRP A1099      23.524  95.235   8.063  0.50 18.30           N  
ATOM    777  CA  TRP A1099      22.190  95.769   8.382  0.50 14.43           C  
ATOM    779  C   TRP A1099      22.605  96.851   9.350  0.50 11.49           C  
ATOM    781  O   TRP A1099      23.836  96.954   9.434  0.50  8.77           O  
ATOM    783  CB  TRP A1099      21.301  94.705   9.045  0.50 16.65           C  
ATOM    785  CG  TRP A1099      22.104  93.444   9.193  0.50 14.69           C  
ATOM    787  CD1 TRP A1099      22.112  92.291   8.643  0.50 15.31           C  
ATOM    789  CD2 TRP A1099      23.172  93.074  10.072  0.50 13.75           C  
ATOM    791  NE1 TRP A1099      22.786  91.226   8.722  0.50 12.54           N  
ATOM    793  CE2 TRP A1099      23.552  91.761   9.776  0.50 12.63           C  
ATOM    795  CE3 TRP A1099      23.798  93.787  11.083  0.50 14.48           C  
ATOM    797  CZ2 TRP A1099      24.570  91.095  10.444  0.50 15.19           C  
ATOM    799  CZ3 TRP A1099      24.826  93.146  11.768  0.50 18.04           C  
ATOM    801  CH2 TRP A1099      25.173  91.840  11.435  0.50 16.66           C  
ATOM    803  N   GLN A1100      21.873  97.514  10.212  1.00 15.00           N  
ATOM    804  CA  GLN A1100      21.936  98.674  11.042  1.00 12.15           C  
ATOM    805  C   GLN A1100      21.813  98.262  12.490  1.00 14.42           C  
ATOM    806  O   GLN A1100      21.207  97.222  12.747  1.00 17.95           O  
ATOM    807  CB  GLN A1100      20.694  99.494  10.694  0.54  8.06           C  
ATOM    809  CG  GLN A1100      19.409  99.165  11.483  0.54  8.35           C  
ATOM    811  CD  GLN A1100      18.752  97.861  11.038  0.54  9.87           C  
ATOM    813  OE1 GLN A1100      18.246  97.207  11.970  0.54  8.80           O  
ATOM    815  NE2 GLN A1100      18.797  97.475   9.784  0.54  8.23           N  
ATOM    817  N   PRO A1101      22.330  99.044  13.395  1.00 16.69           N  
ATOM    818  CA  PRO A1101      23.207 100.195  13.147  1.00 15.49           C  
ATOM    819  C   PRO A1101      24.647  99.748  12.905  1.00 18.04           C  
ATOM    820  O   PRO A1101      25.138  98.720  13.359  1.00 26.33           O  
ATOM    821  CB  PRO A1101      23.118 100.933  14.485  1.00 17.65           C  
ATOM    822  CG  PRO A1101      22.756  99.929  15.549  1.00 23.15           C  
ATOM    823  CD  PRO A1101      22.096  98.780  14.850  1.00 23.03           C  
ATOM    824  N   ALA A1102      25.372 100.594  12.155  1.00 14.03           N  
ATOM    825  CA  ALA A1102      26.793 100.326  11.926  1.00 13.52           C  
ATOM    826  C   ALA A1102      27.516 101.658  11.970  1.00 10.19           C  
ATOM    827  O   ALA A1102      26.982 102.657  11.534  1.00  9.17           O  
ATOM    828  CB  ALA A1102      27.075  99.664  10.591  1.00 19.24           C  
ATOM    829  N   PHE A1103      28.737 101.647  12.492  1.00 10.81           N  
ATOM    830  CA  PHE A1103      29.613 102.802  12.551  1.00  9.48           C  
ATOM    831  C   PHE A1103      30.892 102.561  11.757  1.00  9.85           C  
ATOM    832  O   PHE A1103      31.447 101.461  11.860  1.00 11.16           O  
ATOM    833  CB  PHE A1103      30.026 103.087  13.980  1.00 10.28           C  
ATOM    834  CG  PHE A1103      28.954 103.492  14.954  1.00 12.10           C  
ATOM    835  CD1 PHE A1103      28.180 102.493  15.567  1.00 17.11           C  
ATOM    836  CD2 PHE A1103      28.762 104.812  15.254  1.00 12.82           C  
ATOM    837  CE1 PHE A1103      27.229 102.863  16.491  1.00 20.14           C  
ATOM    838  CE2 PHE A1103      27.798 105.191  16.188  1.00 15.23           C  
ATOM    839  CZ  PHE A1103      27.062 104.199  16.778  1.00 17.88           C  
ATOM    840  N   VAL A1104      31.353 103.600  11.084  1.00  9.38           N  
ATOM    841  CA  VAL A1104      32.705 103.645  10.555  1.00 10.45           C  
ATOM    842  C   VAL A1104      33.367 104.856  11.158  1.00  9.30           C  
ATOM    843  O   VAL A1104      32.937 105.971  10.949  1.00 10.10           O  
ATOM    844  CB  VAL A1104      32.754 103.664   9.030  1.00 11.26           C  
ATOM    845  CG1 VAL A1104      34.187 103.624   8.548  1.00 14.23           C  
ATOM    846  CG2 VAL A1104      31.946 102.502   8.359  1.00 13.30           C  
ATOM    847  N   PHE A1105      34.488 104.611  11.871  1.00 10.18           N  
ATOM    848  CA  PHE A1105      35.234 105.651  12.567  1.00 10.74           C  
ATOM    849  C   PHE A1105      36.480 105.962  11.757  1.00 10.41           C  
ATOM    850  O   PHE A1105      37.400 105.101  11.703  1.00 12.45           O  
ATOM    851  CB  PHE A1105      35.594 105.139  13.959  1.00 11.31           C  
ATOM    852  CG  PHE A1105      34.414 104.987  14.878  1.00 11.08           C  
ATOM    853  CD1 PHE A1105      33.869 106.067  15.538  1.00 11.86           C  
ATOM    854  CD2 PHE A1105      33.844 103.715  15.036  1.00 11.36           C  
ATOM    855  CE1 PHE A1105      32.783 105.930  16.344  1.00 12.46           C  
ATOM    856  CE2 PHE A1105      32.742 103.550  15.864  1.00 12.83           C  
ATOM    857  CZ  PHE A1105      32.223 104.663  16.507  1.00 12.53           C  
ATOM    858  N   TYR A1106      36.553 107.118  11.115  1.00 11.14           N  
ATOM    859  CA  TYR A1106      37.689 107.491  10.267  1.00 11.30           C  
ATOM    860  C   TYR A1106      38.608 108.477  10.964  1.00 11.12           C  
ATOM    861  O   TYR A1106      38.194 109.484  11.525  1.00 10.48           O  
ATOM    862  CB  TYR A1106      37.184 108.246   9.081  1.00 11.67           C  
ATOM    863  CG  TYR A1106      36.694 107.420   7.890  1.00 13.14           C  
ATOM    864  CD1 TYR A1106      37.617 106.798   7.082  1.00 15.87           C  
ATOM    865  CD2 TYR A1106      35.364 107.279   7.631  1.00 15.52           C  
ATOM    866  CE1 TYR A1106      37.199 106.058   6.016  1.00 19.03           C  
ATOM    867  CE2 TYR A1106      34.929 106.535   6.523  1.00 16.64           C  
ATOM    868  CZ  TYR A1106      35.857 105.927   5.733  1.00 19.31           C  
ATOM    869  OH  TYR A1106      35.429 105.190   4.648  1.00 26.37           O  
ATOM    870  N   ARG A1107      39.892 108.137  10.907  1.00 12.71           N  
ATOM    871  CA  ARG A1107      40.934 109.091  11.217  1.00 14.45           C  
ATOM    872  C   ARG A1107      41.205 109.966   9.990  1.00 14.13           C  
ATOM    873  O   ARG A1107      40.869 109.608   8.862  1.00 16.20           O  
ATOM    874  CB  ARG A1107      42.245 108.395  11.610  1.00 15.48           C  
ATOM    875  CG  ARG A1107      42.084 107.597  12.920  1.00 20.96           C  
ATOM    876  CD  ARG A1107      43.482 107.056  13.267  1.00 26.89           C  
ATOM    877  NE  ARG A1107      44.416 108.111  13.626  1.00 32.24           N  
ATOM    878  CZ  ARG A1107      44.580 108.564  14.867  1.00 32.52           C  
ATOM    879  NH1 ARG A1107      43.860 108.037  15.858  1.00 44.51           N  
ATOM    880  NH2 ARG A1107      45.458 109.527  15.088  1.00 54.92           N  
ATOM    881  N   ALA A1108      41.859 111.130  10.230  1.00 16.11           N  
ATOM    882  CA  ALA A1108      42.203 112.034   9.133  1.00 16.60           C  
ATOM    883  C   ALA A1108      43.123 111.368   8.128  1.00 20.76           C  
ATOM    884  O   ALA A1108      43.116 111.719   6.960  1.00 25.32           O  
ATOM    885  CB  ALA A1108      42.879 113.294   9.718  1.00 17.63           C  
ATOM    886  N   ASP A1109      43.901 110.368   8.571  1.00 23.19           N  
ATOM    887  CA  ASP A1109      44.815 109.702   7.625  1.00 27.64           C  
ATOM    888  C   ASP A1109      44.138 108.649   6.760  1.00 27.56           C  
ATOM    889  O   ASP A1109      44.811 108.031   5.956  1.00 34.20           O  
ATOM    890  CB  ASP A1109      45.965 109.066   8.383  1.00 32.49           C  
ATOM    891  CG  ASP A1109      45.567 107.865   9.211  1.00 30.11           C  
ATOM    892  OD1 ASP A1109      44.425 107.420   9.247  1.00 25.45           O  
ATOM    893  OD2 ASP A1109      46.509 107.323   9.836  1.00 39.22           O  
ATOM    894  N   GLY A1110      42.832 108.494   6.905  1.00 26.03           N  
ATOM    895  CA  GLY A1110      42.139 107.612   5.990  1.00 26.62           C  
ATOM    896  C   GLY A1110      41.877 106.228   6.524  1.00 23.25           C  
ATOM    897  O   GLY A1110      41.057 105.531   5.922  1.00 25.33           O  
ATOM    898  N   THR A1111      42.572 105.870   7.590  1.00 23.33           N  
ATOM    899  CA  THR A1111      42.293 104.567   8.197  1.00 21.80           C  
ATOM    900  C   THR A1111      40.985 104.623   8.982  1.00 18.04           C  
ATOM    901  O   THR A1111      40.530 105.712   9.363  1.00 16.93           O  
ATOM    902  CB  THR A1111      43.459 104.095   9.080  1.00 23.33           C  
ATOM    903  OG1 THR A1111      43.541 104.985  10.202  1.00 24.36           O  
ATOM    904  CG2 THR A1111      44.822 104.092   8.373  1.00 28.59           C  
ATOM    905  N   SER A1112      40.382 103.463   9.152  1.00 19.02           N  
ATOM    906  CA  SER A1112      39.077 103.377   9.806  1.00 15.52           C  
ATOM    907  C   SER A1112      38.945 102.075  10.601  1.00 16.63           C  
ATOM    908  O   SER A1112      39.669 101.109  10.435  1.00 21.56           O  
ATOM    909  CB  SER A1112      37.969 103.533   8.772  1.00 17.53           C  
ATOM    910  OG  SER A1112      37.932 102.522   7.816  1.00 21.03           O  
ATOM    911  N   THR A1113      37.966 102.094  11.470  1.00 14.15           N  
ATOM    912  CA  THR A1113      37.496 100.961  12.224  1.00 15.35           C  
ATOM    913  C   THR A1113      35.994 100.937  12.163  1.00 12.72           C  
ATOM    914  O   THR A1113      35.351 101.971  12.189  1.00 17.54           O  
ATOM    915  CB  THR A1113      37.941 101.019  13.675  1.00 17.73           C  
ATOM    916  OG1 THR A1113      37.571 102.276  14.205  1.00 31.28           O  
ATOM    917  CG2 THR A1113      39.448 101.038  13.721  1.00 22.39           C  
ATOM    918  N   PHE A1114      35.429  99.763  12.076  1.00 10.54           N  
ATOM    919  CA  PHE A1114      33.990  99.602  12.035  1.00 11.27           C  
ATOM    920  C   PHE A1114      33.455  98.895  13.250  1.00 10.64           C  
ATOM    921  O   PHE A1114      34.141  98.047  13.870  1.00 11.25           O  
ATOM    922  CB  PHE A1114      33.513  99.217  10.649  0.45 12.98           C  
ATOM    924  CG  PHE A1114      33.499  97.758  10.331  0.45 12.98           C  
ATOM    926  CD1 PHE A1114      32.459  96.975  10.774  0.45 14.31           C  
ATOM    928  CD2 PHE A1114      34.492  97.208   9.559  0.45 11.93           C  
ATOM    930  CE1 PHE A1114      32.512  95.622  10.473  0.45 17.05           C  
ATOM    932  CE2 PHE A1114      34.600  95.836   9.226  0.45 10.07           C  
ATOM    934  CZ  PHE A1114      33.495  95.139   9.613  0.45 14.94           C  
ATOM    936  N   VAL A1115      32.193  99.214  13.607  1.00 11.53           N  
ATOM    937  CA  VAL A1115      31.461  98.495  14.604  1.00 14.55           C  
ATOM    938  C   VAL A1115      30.127  98.145  13.919  1.00 19.44           C  
ATOM    939  O   VAL A1115      29.443  99.049  13.442  1.00 26.54           O  
ATOM    940  CB  VAL A1115      31.288  99.296  15.904  1.00 18.45           C  
ATOM    941  CG1 VAL A1115      30.455  98.575  16.924  1.00 30.12           C  
ATOM    942  CG2 VAL A1115      32.697  99.638  16.437  1.00 18.39           C  
ATOM    943  N   ASN A1116      29.682  96.908  13.804  1.00 17.32           N  
ATOM    944  CA  ASN A1116      28.402  96.466  13.160  1.00 14.88           C  
ATOM    945  C   ASN A1116      27.879  95.307  13.970  1.00 16.23           C  
ATOM    946  O   ASN A1116      27.881  94.169  13.523  1.00 19.20           O  
ATOM    947  CB  ASN A1116      28.585  96.099  11.675  1.00 20.54           C  
ATOM    948  CG  ASN A1116      27.263  95.734  10.985  1.00 21.89           C  
ATOM    949  OD1 ASN A1116      26.182  96.194  11.382  1.00 26.42           O  
ATOM    950  ND2 ASN A1116      27.373  94.902   9.940  1.00 21.04           N  
ATOM    951  N   ASN A1117      27.428  95.596  15.178  1.00 21.59           N  
ATOM    952  CA  ASN A1117      26.927  94.625  16.125  1.00 17.22           C  
ATOM    953  C   ASN A1117      25.442  94.529  16.216  1.00 20.87           C  
ATOM    954  O   ASN A1117      24.793  95.493  16.644  1.00 21.66           O  
ATOM    955  CB  ASN A1117      27.511  95.241  17.414  1.00 20.84           C  
ATOM    956  CG  ASN A1117      27.055  94.347  18.532  1.00 20.47           C  
ATOM    957  OD1 ASN A1117      26.499  93.258  18.465  1.00 24.82           O  
ATOM    958  ND2 ASN A1117      27.392  94.756  19.748  1.00 24.72           N  
ATOM    959  N   PRO A1118      24.900  93.365  15.878  1.00 25.53           N  
ATOM    960  CA  PRO A1118      23.465  93.217  15.899  1.00 26.28           C  
ATOM    961  C   PRO A1118      22.870  92.980  17.286  1.00 27.08           C  
ATOM    962  O   PRO A1118      21.646  92.973  17.482  1.00 25.88           O  
ATOM    963  CB  PRO A1118      23.294  92.010  14.983  1.00 31.00           C  
ATOM    964  CG  PRO A1118      24.531  91.183  15.111  1.00 28.91           C  
ATOM    965  CD  PRO A1118      25.657  92.177  15.425  1.00 27.58           C  
ATOM    966  N   THR A1119      23.643  92.829  18.361  1.00 26.37           N  
ATOM    967  CA  THR A1119      23.020  92.348  19.587  1.00 26.29           C  
ATOM    968  C   THR A1119      22.702  93.442  20.590  1.00 24.30           C  
ATOM    969  O   THR A1119      21.943  93.206  21.526  1.00 22.60           O  
ATOM    970  CB  THR A1119      23.904  91.259  20.251  1.00 29.52           C  
ATOM    971  OG1 THR A1119      25.094  91.865  20.726  1.00 29.51           O  
ATOM    972  CG2 THR A1119      24.314  90.185  19.247  1.00 35.43           C  
ATOM    973  N   ALA A1120      23.272  94.633  20.424  1.00 22.29           N  
ATOM    974  CA  ALA A1120      23.164  95.642  21.436  1.00 19.98           C  
ATOM    975  C   ALA A1120      23.450  97.030  20.892  1.00 18.83           C  
ATOM    976  O   ALA A1120      24.174  97.147  19.928  1.00 31.92           O  
ATOM    977  CB  ALA A1120      24.125  95.357  22.591  1.00 24.27           C  
ATOM    978  N   ALA A1121      22.899  98.043  21.526  1.00 16.41           N  
ATOM    979  CA  ALA A1121      23.253  99.430  21.156  1.00 15.83           C  
ATOM    980  C   ALA A1121      24.580  99.806  21.785  1.00 14.00           C  
ATOM    981  O   ALA A1121      24.837  99.465  22.942  1.00 17.77           O  
ATOM    982  CB  ALA A1121      22.115 100.311  21.644  1.00 15.58           C  
ATOM    983  N   MET A1122      25.369 100.554  21.030  1.00 13.80           N  
ATOM    984  CA  MET A1122      26.582 101.126  21.612  1.00 13.96           C  
ATOM    985  C   MET A1122      26.226 102.166  22.663  1.00 14.37           C  
ATOM    986  O   MET A1122      25.375 103.012  22.426  1.00 15.07           O  
ATOM    987  CB  MET A1122      27.400 101.777  20.514  1.00 14.54           C  
ATOM    988  CG  MET A1122      28.795 102.204  21.023  1.00 13.73           C  
ATOM    989  SD  MET A1122      29.758 103.059  19.735  1.00 13.90           S  
ATOM    990  CE  MET A1122      30.066 101.717  18.642  1.00 15.05           C  
ATOM    991  N   SER A1123      26.931 102.128  23.811  1.00 14.68           N  
ATOM    992  CA  SER A1123      26.663 103.114  24.875  1.00 15.08           C  
ATOM    993  C   SER A1123      27.305 104.435  24.464  1.00 14.46           C  
ATOM    994  O   SER A1123      28.245 104.541  23.680  1.00 13.73           O  
ATOM    995  CB  SER A1123      27.274 102.675  26.200  1.00 16.76           C  
ATOM    996  OG  SER A1123      28.741 102.705  26.111  1.00 19.07           O  
ATOM    997  N   GLN A1124      26.813 105.493  25.154  1.00 14.72           N  
ATOM    998  CA  GLN A1124      27.446 106.802  24.949  1.00 13.79           C  
ATOM    999  C   GLN A1124      28.893 106.837  25.379  1.00 13.32           C  
ATOM   1000  O   GLN A1124      29.731 107.434  24.704  1.00 14.52           O  
ATOM   1001  CB  GLN A1124      26.646 107.899  25.683  1.00 14.58           C  
ATOM   1002  CG  GLN A1124      27.176 109.290  25.277  1.00 15.57           C  
ATOM   1003  CD  GLN A1124      26.461 110.422  25.949  1.00 18.49           C  
ATOM   1004  OE1 GLN A1124      26.919 111.575  25.989  1.00 20.11           O  
ATOM   1005  NE2 GLN A1124      25.309 110.167  26.524  1.00 25.80           N  
ATOM   1006  N   ASP A1125      29.187 106.215  26.522  1.00 15.39           N  
ATOM   1007  CA  ASP A1125      30.567 106.195  26.983  1.00 17.00           C  
ATOM   1008  C   ASP A1125      31.465 105.527  25.953  1.00 15.06           C  
ATOM   1009  O   ASP A1125      32.565 105.990  25.677  1.00 16.72           O  
ATOM   1010  CB  ASP A1125      30.670 105.460  28.322  1.00 23.75           C  
ATOM   1011  CG  ASP A1125      30.334 106.339  29.509  1.00 32.10           C  
ATOM   1012  OD1 ASP A1125      29.803 107.462  29.406  1.00 31.29           O  
ATOM   1013  OD2 ASP A1125      30.613 105.871  30.643  1.00 43.51           O  
ATOM   1014  N   GLU A1126      30.956 104.403  25.388  1.00 15.42           N  
ATOM   1015  CA  GLU A1126      31.812 103.754  24.404  1.00 15.08           C  
ATOM   1016  C   GLU A1126      32.015 104.630  23.165  1.00 13.34           C  
ATOM   1017  O   GLU A1126      33.096 104.771  22.644  1.00 15.61           O  
ATOM   1018  CB  GLU A1126      31.286 102.381  23.987  1.00 16.19           C  
ATOM   1019  CG  GLU A1126      32.139 101.729  22.905  1.00 16.75           C  
ATOM   1020  CD  GLU A1126      31.674 100.322  22.519  1.00 20.12           C  
ATOM   1021  OE1 GLU A1126      31.093  99.590  23.348  1.00 21.56           O  
ATOM   1022  OE2 GLU A1126      31.888  99.990  21.327  1.00 19.31           O  
ATOM   1023  N   LEU A1127      30.911 105.221  22.676  1.00 12.72           N  
ATOM   1024  CA  LEU A1127      30.978 106.093  21.498  1.00 12.46           C  
ATOM   1025  C   LEU A1127      31.884 107.297  21.729  1.00 11.80           C  
ATOM   1026  O   LEU A1127      32.708 107.608  20.856  1.00 12.72           O  
ATOM   1027  CB  LEU A1127      29.550 106.544  21.150  1.00 11.62           C  
ATOM   1028  CG  LEU A1127      29.459 107.497  19.946  1.00 10.42           C  
ATOM   1029  CD1 LEU A1127      30.006 106.885  18.682  1.00 11.61           C  
ATOM   1030  CD2 LEU A1127      28.007 107.946  19.752  1.00 13.25           C  
ATOM   1031  N   SER A1128      31.758 107.927  22.878  1.00 13.18           N  
ATOM   1032  CA  SER A1128      32.609 109.072  23.197  1.00 14.25           C  
ATOM   1033  C   SER A1128      34.080 108.682  23.140  1.00 16.60           C  
ATOM   1034  O   SER A1128      34.919 109.416  22.601  1.00 17.02           O  
ATOM   1035  CB  SER A1128      32.158 109.596  24.578  1.00 18.36           C  
ATOM   1036  OG  SER A1128      32.998 110.634  24.947  1.00 25.48           O  
ATOM   1037  N   GLY A1129      34.434 107.500  23.706  1.00 16.61           N  
ATOM   1038  CA  GLY A1129      35.831 107.092  23.681  1.00 18.26           C  
ATOM   1039  C   GLY A1129      36.292 106.773  22.251  1.00 18.40           C  
ATOM   1040  O   GLY A1129      37.422 107.148  21.922  1.00 18.27           O  
ATOM   1041  N   ARG A1130      35.452 106.133  21.449  1.00 15.36           N  
ATOM   1042  CA  ARG A1130      35.915 105.858  20.058  1.00 15.31           C  
ATOM   1043  C   ARG A1130      36.132 107.162  19.293  1.00 14.64           C  
ATOM   1044  O   ARG A1130      37.069 107.317  18.497  1.00 18.09           O  
ATOM   1045  CB  ARG A1130      34.923 104.940  19.341  1.00 15.24           C  
ATOM   1046  CG  ARG A1130      34.858 103.531  19.992  1.00 16.56           C  
ATOM   1047  CD  ARG A1130      33.788 102.725  19.274  1.00 16.24           C  
ATOM   1048  NE  ARG A1130      33.703 101.350  19.691  1.00 17.07           N  
ATOM   1049  CZ  ARG A1130      34.515 100.355  19.322  1.00 19.18           C  
ATOM   1050  NH1 ARG A1130      35.528 100.494  18.492  1.00 23.65           N  
ATOM   1051  NH2 ARG A1130      34.247  99.143  19.828  1.00 25.71           N  
ATOM   1052  N   VAL A1131      35.244 108.132  19.550  1.00 14.01           N  
ATOM   1053  CA  VAL A1131      35.392 109.427  18.833  1.00 13.94           C  
ATOM   1054  C   VAL A1131      36.627 110.185  19.321  1.00 15.35           C  
ATOM   1055  O   VAL A1131      37.381 110.727  18.482  1.00 16.84           O  
ATOM   1056  CB  VAL A1131      34.088 110.216  19.018  1.00 14.38           C  
ATOM   1057  CG1 VAL A1131      34.265 111.662  18.575  1.00 14.40           C  
ATOM   1058  CG2 VAL A1131      32.972 109.528  18.226  1.00 12.59           C  
ATOM   1059  N   ALA A1132      36.874 110.189  20.640  1.00 17.73           N  
ATOM   1060  CA  ALA A1132      38.098 110.825  21.139  1.00 19.73           C  
ATOM   1061  C   ALA A1132      39.326 110.195  20.518  1.00 18.66           C  
ATOM   1062  O   ALA A1132      40.354 110.885  20.316  1.00 22.16           O  
ATOM   1063  CB  ALA A1132      38.119 110.658  22.649  1.00 24.79           C  
ATOM   1064  N   ALA A1133      39.315 108.884  20.261  1.00 20.38           N  
ATOM   1065  CA  ALA A1133      40.528 108.214  19.770  1.00 22.45           C  
ATOM   1066  C   ALA A1133      40.890 108.699  18.374  1.00 21.36           C  
ATOM   1067  O   ALA A1133      42.028 108.572  17.968  1.00 28.55           O  
ATOM   1068  CB  ALA A1133      40.400 106.670  19.707  1.00 23.76           C  
ATOM   1069  N   LEU A1134      39.930 109.239  17.637  1.00 18.53           N  
ATOM   1070  CA  LEU A1134      40.272 109.775  16.296  1.00 20.43           C  
ATOM   1071  C   LEU A1134      41.253 110.963  16.554  1.00 23.72           C  
ATOM   1072  O   LEU A1134      41.743 110.792  15.150  1.00 22.37           O  
ATOM   1073  CB  LEU A1134      38.995 110.051  15.552  1.00 16.81           C  
ATOM   1074  CG  LEU A1134      37.909 108.983  15.463  1.00 15.86           C  
ATOM   1075  CD1 LEU A1134      36.638 109.494  14.788  1.00 17.16           C  
ATOM   1076  CD2 LEU A1134      38.451 107.776  14.690  1.00 17.48           C  
TER    1077      LEU A1134                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
