
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  144 ( 1077),  selected  144 , name 1kng_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 1kng_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E       1           -
LGA    -       -      N       2           -
LGA    -       -      L       3           -
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    -       -      Q       6           -
LGA    -       -      S       7           -
LGA    -       -      M       8           -
LGA    R    50_A      I       9           #
LGA    P    51_A      N      10          3.686
LGA    A    52_A      S      11          4.170
LGA    P    53_A      F      12          3.939
LGA    -       -      Y      13           -
LGA    Q    54_A      A      14          4.370
LGA    T    55_A      F      15          3.764
LGA    A    56_A      E      16          2.193
LGA    L    57_A      V      17          1.579
LGA    P    58_A      K      18          0.973
LGA    P    59_A      D      19          0.952
LGA    L    60_A      A      20          1.037
LGA    E    61_A      K      21          2.424
LGA    G    62_A      G      22           -
LGA    L    63_A      -       -           -
LGA    Q    64_A      -       -           -
LGA    A    65_A      -       -           -
LGA    D    66_A      -       -           -
LGA    N    67_A      -       -           -
LGA    V    68_A      -       -           -
LGA    Q    69_A      -       -           -
LGA    V    70_A      -       -           -
LGA    P    71_A      -       -           -
LGA    G    72_A      R      23           #
LGA    L    73_A      T      24           #
LGA    -       -      V      25           -
LGA    D    74_A      S      26          2.244
LGA    P    75_A      L      27          2.846
LGA    A    76_A      E      28          1.387
LGA    A    77_A      K      29          2.951
LGA    F    78_A      Y      30          3.512
LGA    K    79_A      K      31          1.945
LGA    G    80_A      G      32          0.864
LGA    K    81_A      K      33          0.978
LGA    V    82_A      V      34          1.049
LGA    S    83_A      S      35          1.202
LGA    L    84_A      L      36          1.151
LGA    V    85_A      V      37          1.080
LGA    N    86_A      V      38          1.445
LGA    V    87_A      N      39          1.089
LGA    W    88_A      V      40          0.491
LGA    A    89_A      A      41          1.329
LGA    S    90_A      S      42          1.271
LGA    W    91_A      D      43          2.285
LGA    C    92_A      C      44          2.682
LGA    V    93_A      Q      45          2.202
LGA    P    94_A      L      46          1.338
LGA    C    95_A      T      47          2.628
LGA    H    96_A      D      48          2.547
LGA    D    97_A      R      49          2.323
LGA    E    98_A      N      50          1.492
LGA    A    99_A      Y      51          1.196
LGA    P   100_A      L      52          0.962
LGA    L   101_A      G      53          1.324
LGA    L   102_A      L      54          1.276
LGA    T   103_A      K      55          1.453
LGA    E   104_A      E      56          1.614
LGA    L   105_A      L      57          1.609
LGA    G   106_A      H      58          1.869
LGA    K   107_A      K      59          1.113
LGA    D   108_A      E      60          1.984
LGA    -       -      F      61           -
LGA    K   109_A      G      62          2.545
LGA    -       -      P      63           -
LGA    -       -      S      64           -
LGA    R   110_A      H      65          3.927
LGA    F   111_A      F      66          1.483
LGA    Q   112_A      S      67          1.613
LGA    L   113_A      V      68          1.701
LGA    V   114_A      L      69          1.077
LGA    G   115_A      A      70          1.038
LGA    I   116_A      F      71          1.014
LGA    N   117_A      P      72          1.468
LGA    Y   118_A      C      73          1.402
LGA    K   119_A      N      74          2.909
LGA    -       -      Q      75           -
LGA    -       -      F      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    -       -      S      79           -
LGA    D   120_A      E      80          3.480
LGA    -       -      P      81           -
LGA    A   121_A      R      82          2.533
LGA    A   122_A      P      83          2.248
LGA    -       -      S      84           -
LGA    D   123_A      K      85          5.318
LGA    N   124_A      E      86          4.418
LGA    A   125_A      V      87          0.943
LGA    R   126_A      E      88          3.116
LGA    R   127_A      S      89          4.555
LGA    F   128_A      F      90          2.807
LGA    L   129_A      A      91          0.337
LGA    G   130_A      R      92          2.988
LGA    -       -      K      93           -
LGA    R   131_A      N      94          1.002
LGA    Y   132_A      Y      95          1.846
LGA    G   133_A      G      96          2.243
LGA    N   134_A      V      97          1.773
LGA    P   135_A      T      98          3.885
LGA    F   136_A      F      99          1.002
LGA    G   137_A      P     100          3.857
LGA    R   138_A      -       -           -
LGA    V   139_A      I     101          2.610
LGA    G   140_A      F     102          1.988
LGA    V   141_A      H     103          1.456
LGA    D   142_A      K     104          3.362
LGA    A   143_A      I     105          3.258
LGA    N   144_A      K     106          3.258
LGA    G   145_A      I     107          3.243
LGA    -       -      L     108           -
LGA    -       -      G     109           -
LGA    -       -      S     110           -
LGA    -       -      E     111           -
LGA    R   146_A      G     112          1.600
LGA    A   147_A      E     113          1.654
LGA    -       -      P     114           -
LGA    S   148_A      A     115           #
LGA    I   149_A      F     116           #
LGA    E   150_A      R     117          0.641
LGA    -       -      F     118           -
LGA    W   151_A      L     119          2.855
LGA    G   152_A      V     120          2.076
LGA    -       -      D     121           -
LGA    -       -      S     122           -
LGA    -       -      S     123           -
LGA    -       -      K     124           -
LGA    -       -      K     125           -
LGA    V   153_A      E     126          3.334
LGA    Y   154_A      P     127          1.937
LGA    G   155_A      R     128          3.144
LGA    V   156_A      W     129          3.457
LGA    -       -      N     130           -
LGA    P   157_A      F     131          1.088
LGA    E   158_A      W     132          0.854
LGA    T   159_A      K     133          0.858
LGA    F   160_A      Y     134          1.068
LGA    V   161_A      L     135          0.997
LGA    V   162_A      V     136          0.830
LGA    G   163_A      N     137          0.767
LGA    R   164_A      P     138          1.148
LGA    E   165_A      E     139          1.192
LGA    G   166_A      G     140          1.076
LGA    T   167_A      Q     141          0.528
LGA    I   168_A      V     142          0.720
LGA    V   169_A      V     143          1.093
LGA    Y   170_A      K     144          0.931
LGA    K   171_A      F     145          0.574
LGA    L   172_A      W     146          0.668
LGA    V   173_A      R     147          1.322
LGA    G   174_A      P     148          0.868
LGA    P   175_A      E     149          4.476
LGA    I   176_A      E     150          5.059
LGA    T   177_A      P     151          2.375
LGA    P   178_A      -       -           -
LGA    D   179_A      -       -           -
LGA    N   180_A      -       -           -
LGA    L   181_A      I     152          1.754
LGA    R   182_A      E     153          2.332
LGA    S   183_A      V     154          3.539
LGA    V   184_A      -       -           -
LGA    L   185_A      I     155          1.385
LGA    L   186_A      R     156          1.484
LGA    P   187_A      P     157          1.271
LGA    Q   188_A      D     158          0.880
LGA    M   189_A      I     159          1.375
LGA    E   190_A      A     160          2.158
LGA    K   191_A      A     161          2.098
LGA    A   192_A      L     162          1.709
LGA    L   193_A      V     163          2.941
LGA    -       -      R     164           -
LGA    -       -      Q     165           -
LGA    -       -      V     166           -
LGA    -       -      I     167           -
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  144  174    5.0    124    2.29    19.35     49.540     5.197

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.633205 * X  +  -0.748101 * Y  +   0.198484 * Z  +  33.185505
  Y_new =   0.136760 * X  +  -0.360553 * Y  +  -0.922658 * Z  + 117.897308
  Z_new =   0.761806 * X  +  -0.557087 * Y  +   0.330614 * Z  +  -0.228595 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.035193    2.106400  [ DEG:   -59.3122    120.6878 ]
  Theta =  -0.866096   -2.275496  [ DEG:   -49.6237   -130.3763 ]
  Phi   =   2.928880   -0.212713  [ DEG:   167.8125    -12.1875 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1kng_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1kng_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  144  174   5.0  124   2.29   19.35  49.540
REMARK  ---------------------------------------------------------- 
MOLECULE 1kng_A
HEADER    OXIDOREDUCTASE                          18-DEC-01   1KNG              
TITLE     CRYSTAL STRUCTURE OF CCMG REDUCING OXIDOREDUCTASE AT 1.14 A           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOL:DISULFIDE INTERCHANGE PROTEIN CYCY;                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: THIOREDOXIN-LIKE PROTEIN CCMG;                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BRADYRHIZOBIUM JAPONICUM;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: CYCY;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PRJ2766                                   
KEYWDS    THIOREDOXIN FOLD, CYTOCHROME C MATURATION, ATOMIC RESOLUTION          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.A.EDELING,L.W.GUDDAT,R.A.FABIANEK,L.THONY-MEYER,J.L.MARTIN          
REVDAT   2   01-APR-03 1KNG    1       JRNL                                     
REVDAT   1   17-JUL-02 1KNG    0                                                
JRNL        AUTH   M.A.EDELING,L.W.GUDDAT,R.A.FABIANEK,L.THONY-MEYER,           
JRNL        AUTH 2 J.L.MARTIN                                                   
JRNL        TITL   STRUCTURE OF CCMG/DSBE AT 1.14 A RESOLUTION:                 
JRNL        TITL 2 HIGH-FIDELITY REDUCING ACTIVITY IN AN                        
JRNL        TITL 3 INDISCRIMINATELY OXIDIZING ENVIRONMENT                       
JRNL        REF    STRUCTURE                     V.  10   973 2002              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 1.14 ANGSTROMS.                                          
DBREF  1KNG A   39   194  UNP    P30960   CYCY_BRAJA      39    194             
SEQRES   1 A  156  ASP PRO SER ARG ILE PRO SER ALA LEU ILE GLY ARG PRO          
SEQRES   2 A  156  ALA PRO GLN THR ALA LEU PRO PRO LEU GLU GLY LEU GLN          
SEQRES   3 A  156  ALA ASP ASN VAL GLN VAL PRO GLY LEU ASP PRO ALA ALA          
SEQRES   4 A  156  PHE LYS GLY LYS VAL SER LEU VAL ASN VAL TRP ALA SER          
SEQRES   5 A  156  TRP CYS VAL PRO CYS HIS ASP GLU ALA PRO LEU LEU THR          
SEQRES   6 A  156  GLU LEU GLY LYS ASP LYS ARG PHE GLN LEU VAL GLY ILE          
SEQRES   7 A  156  ASN TYR LYS ASP ALA ALA ASP ASN ALA ARG ARG PHE LEU          
SEQRES   8 A  156  GLY ARG TYR GLY ASN PRO PHE GLY ARG VAL GLY VAL ASP          
SEQRES   9 A  156  ALA ASN GLY ARG ALA SER ILE GLU TRP GLY VAL TYR GLY          
SEQRES  10 A  156  VAL PRO GLU THR PHE VAL VAL GLY ARG GLU GLY THR ILE          
SEQRES  11 A  156  VAL TYR LYS LEU VAL GLY PRO ILE THR PRO ASP ASN LEU          
SEQRES  12 A  156  ARG SER VAL LEU LEU PRO GLN MET GLU LYS ALA LEU LYS          
FORMUL   2  HOH   *154(H2 O)                                                    
CRYST1   35.100   48.200   90.200  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   ARG A  50      40.688 100.171   5.235  1.00 34.41           N  
ATOM      2  CA  ARG A  50      40.418 100.466   3.801  1.00 37.45           C  
ATOM      3  C   ARG A  50      39.880 101.878   3.592  1.00 31.06           C  
ATOM      4  O   ARG A  50      39.246 102.462   4.466  1.00 25.67           O  
ATOM      5  CB  ARG A  50      39.498  99.391   3.259  1.00 50.99           C  
ATOM      6  N   PRO A  51      40.092 102.467   2.387  1.00 30.78           N  
ATOM      7  CA  PRO A  51      39.438 103.740   2.033  1.00 28.40           C  
ATOM      8  C   PRO A  51      37.949 103.598   2.184  1.00 23.53           C  
ATOM      9  O   PRO A  51      37.319 102.607   1.844  1.00 30.48           O  
ATOM     10  CB  PRO A  51      39.847 103.946   0.572  1.00 34.24           C  
ATOM     11  CG  PRO A  51      41.172 103.244   0.491  1.00 51.05           C  
ATOM     12  CD  PRO A  51      40.970 101.977   1.288  1.00 39.46           C  
ATOM     13  N   ALA A  52      37.371 104.659   2.727  1.00 22.82           N  
ATOM     14  CA  ALA A  52      35.924 104.759   2.771  1.00 21.74           C  
ATOM     15  C   ALA A  52      35.379 104.660   1.371  1.00 19.92           C  
ATOM     16  O   ALA A  52      35.951 105.191   0.443  1.00 21.59           O  
ATOM     17  CB  ALA A  52      35.461 106.057   3.372  1.00 28.18           C  
ATOM     18  N   PRO A  53      34.262 103.983   1.191  1.00 19.84           N  
ATOM     19  CA  PRO A  53      33.653 103.942  -0.125  1.00 20.20           C  
ATOM     20  C   PRO A  53      33.356 105.361  -0.628  1.00 17.45           C  
ATOM     21  O   PRO A  53      33.009 106.243   0.110  1.00 20.19           O  
ATOM     22  CB  PRO A  53      32.356 103.207   0.108  1.00 23.58           C  
ATOM     23  CG  PRO A  53      32.597 102.395   1.352  1.00 26.53           C  
ATOM     24  CD  PRO A  53      33.556 103.164   2.203  1.00 23.94           C  
ATOM     25  N   GLN A  54      33.493 105.491  -1.952  1.00 16.05           N  
ATOM     26  CA  GLN A  54      33.332 106.779  -2.641  1.00 14.96           C  
ATOM     27  C   GLN A  54      31.912 107.025  -3.079  1.00 17.00           C  
ATOM     28  O   GLN A  54      31.652 107.661  -4.080  1.00 22.49           O  
ATOM     29  CB  GLN A  54      34.338 106.894  -3.802  1.00 17.88           C  
ATOM     30  CG  GLN A  54      35.784 106.813  -3.320  1.00 25.93           C  
ATOM     31  CD  GLN A  54      36.144 107.755  -2.211  1.00 33.39           C  
ATOM     32  OE1 GLN A  54      36.325 107.415  -1.035  1.00 38.74           O  
ATOM     33  NE2 GLN A  54      36.201 108.995  -2.613  1.00 32.10           N  
ATOM     34  N   THR A  55      30.957 106.615  -2.225  1.00 17.27           N  
ATOM     35  CA  THR A  55      29.529 106.736  -2.438  1.00 17.69           C  
ATOM     36  C   THR A  55      29.071 108.150  -2.202  1.00 14.75           C  
ATOM     37  O   THR A  55      29.373 108.690  -1.153  1.00 21.23           O  
ATOM     38  CB  THR A  55      28.795 105.853  -1.411  0.83 17.05           C  
ATOM     39  OG1 THR A  55      29.151 106.131  -0.014  0.85 21.03           O  
ATOM     40  CG2 THR A  55      29.149 104.379  -1.559  0.73 17.67           C  
ATOM     41  N   ALA A  56      28.373 108.756  -3.157  1.00 11.65           N  
ATOM     42  CA  ALA A  56      27.724 110.043  -2.963  1.00 11.14           C  
ATOM     43  C   ALA A  56      26.224 109.805  -2.854  1.00 11.82           C  
ATOM     44  O   ALA A  56      25.670 108.973  -3.555  1.00 14.42           O  
ATOM     45  CB  ALA A  56      28.044 110.984  -4.100  1.00 13.94           C  
ATOM     46  N   LEU A  57      25.578 110.521  -1.933  1.00 10.99           N  
ATOM     47  CA  LEU A  57      24.167 110.358  -1.651  1.00 11.31           C  
ATOM     48  C   LEU A  57      23.471 111.693  -1.544  1.00 10.33           C  
ATOM     49  O   LEU A  57      24.047 112.659  -1.031  1.00 10.96           O  
ATOM     50  CB  LEU A  57      23.941 109.620  -0.322  1.00 12.28           C  
ATOM     51  CG  LEU A  57      24.433 108.191  -0.260  1.00 14.36           C  
ATOM     52  CD1 LEU A  57      24.330 107.691   1.159  1.00 18.69           C  
ATOM     53  CD2 LEU A  57      23.634 107.295  -1.209  1.00 17.94           C  
ATOM     54  N   PRO A  58      22.255 111.796  -2.036  1.00 10.74           N  
ATOM     55  CA  PRO A  58      21.499 113.057  -1.920  1.00 10.70           C  
ATOM     56  C   PRO A  58      21.058 113.300  -0.503  1.00  9.98           C  
ATOM     57  O   PRO A  58      21.044 112.390   0.332  1.00 11.08           O  
ATOM     58  CB  PRO A  58      20.286 112.812  -2.835  1.00 13.05           C  
ATOM     59  CG  PRO A  58      20.089 111.320  -2.727  1.00 14.54           C  
ATOM     60  CD  PRO A  58      21.466 110.719  -2.652  1.00 12.48           C  
ATOM     61  N   PRO A  59      20.716 114.543  -0.195  1.00 10.76           N  
ATOM     62  CA  PRO A  59      20.242 114.904   1.154  1.00 10.21           C  
ATOM     63  C   PRO A  59      18.815 114.506   1.447  1.00 10.74           C  
ATOM     64  O   PRO A  59      18.056 114.056   0.589  1.00 12.13           O  
ATOM     65  CB  PRO A  59      20.351 116.440   1.161  1.00 11.41           C  
ATOM     66  CG  PRO A  59      20.072 116.786  -0.281  1.00 12.17           C  
ATOM     67  CD  PRO A  59      20.725 115.723  -1.097  1.00 12.04           C  
ATOM     68  N   LEU A  60      18.459 114.643   2.730  1.00 11.17           N  
ATOM     69  CA  LEU A  60      17.082 114.493   3.217  1.00 11.09           C  
ATOM     70  C   LEU A  60      16.422 115.850   3.126  1.00 10.66           C  
ATOM     71  O   LEU A  60      16.743 116.779   3.896  1.00 11.85           O  
ATOM     72  CB  LEU A  60      17.071 113.990   4.638  1.00 11.26           C  
ATOM     73  CG  LEU A  60      15.657 113.803   5.261  1.00 11.66           C  
ATOM     74  CD1 LEU A  60      14.787 112.855   4.462  1.00 15.23           C  
ATOM     75  CD2 LEU A  60      15.818 113.344   6.697  1.00 14.74           C  
ATOM     76  N   GLU A  61      15.628 116.078   2.099  1.00 11.13           N  
ATOM     77  CA  GLU A  61      15.019 117.378   1.852  1.00 11.43           C  
ATOM     78  C   GLU A  61      14.240 117.853   3.065  1.00 11.02           C  
ATOM     79  O   GLU A  61      13.426 117.117   3.603  1.00 13.02           O  
ATOM     80  CB  GLU A  61      14.108 117.335   0.618  1.00 12.81           C  
ATOM     81  CG  GLU A  61      13.551 118.677   0.215  1.00 14.00           C  
ATOM     82  CD  GLU A  61      14.526 119.742  -0.153  1.00 12.87           C  
ATOM     83  OE1 GLU A  61      15.610 119.413  -0.712  1.00 14.49           O  
ATOM     84  OE2 GLU A  61      14.217 120.949   0.036  1.00 14.86           O  
ATOM     85  N   GLY A  62      14.487 119.105   3.443  1.00 12.51           N  
ATOM     86  CA  GLY A  62      13.758 119.703   4.557  1.00 14.02           C  
ATOM     87  C   GLY A  62      14.380 119.548   5.878  1.00 14.63           C  
ATOM     88  O   GLY A  62      13.915 120.148   6.847  1.00 20.59           O  
ATOM     89  N   LEU A  63      15.476 118.816   5.999  1.00 13.31           N  
ATOM     90  CA  LEU A  63      16.221 118.767   7.227  1.00 12.45           C  
ATOM     91  C   LEU A  63      17.116 120.003   7.322  1.00 12.83           C  
ATOM     92  O   LEU A  63      17.939 120.193   6.442  1.00 14.30           O  
ATOM     93  CB  LEU A  63      17.023 117.488   7.267  1.00 13.02           C  
ATOM     94  CG  LEU A  63      17.918 117.309   8.485  1.00 13.98           C  
ATOM     95  CD1 LEU A  63      17.108 117.172   9.755  1.00 17.48           C  
ATOM     96  CD2 LEU A  63      18.831 116.093   8.321  1.00 14.70           C  
ATOM     97  N   GLN A  64      16.948 120.802   8.376  0.85 13.21           N  
ATOM     98  CA  GLN A  64      17.699 122.042   8.499  0.85 14.07           C  
ATOM     99  C   GLN A  64      18.517 122.040   9.784  0.85 15.41           C  
ATOM    100  O   GLN A  64      18.164 121.443  10.765  0.85 18.89           O  
ATOM    101  CB  GLN A  64      16.787 123.262   8.516  0.85 19.28           C  
ATOM    103  CG  GLN A  64      16.078 123.409   7.179  0.85 23.02           C  
ATOM    105  CD  GLN A  64      15.357 124.712   7.021  0.85 28.15           C  
ATOM    107  OE1 GLN A  64      15.326 125.524   7.928  0.85 28.65           O  
ATOM    109  NE2 GLN A  64      14.781 124.870   5.849  0.85 43.60           N  
ATOM    111  N   ALA A  65      19.611 122.778   9.739  1.00 16.82           N  
ATOM    112  CA  ALA A  65      20.469 123.045  10.908  1.00 19.47           C  
ATOM    113  C   ALA A  65      20.896 124.496  10.716  1.00 21.49           C  
ATOM    114  O   ALA A  65      21.297 124.895   9.648  1.00 22.98           O  
ATOM    115  CB  ALA A  65      21.650 122.108  10.980  1.00 27.68           C  
ATOM    116  N   ASP A  66      20.733 125.251  11.806  0.50 18.95           N  
ATOM    117  CA  ASP A  66      21.062 126.683  11.784  0.50 23.82           C  
ATOM    118  C   ASP A  66      20.350 127.348  10.600  0.97 23.66           C  
ATOM    119  O   ASP A  66      20.880 128.224   9.926  0.96 24.16           O  
ATOM    120  CB  ASP A  66      22.570 126.914  11.739  0.50 25.43           C  
ATOM    121  CG  ASP A  66      23.346 126.584  12.988  0.50 50.57           C  
ATOM    122  OD1 ASP A  66      22.852 126.794  14.108  0.50 50.60           O  
ATOM    123  OD2 ASP A  66      24.492 126.113  12.831  0.50 73.97           O  
ATOM    124  N   ASN A  67      19.130 126.944  10.319  0.78 19.71           N  
ATOM    125  CA  ASN A  67      18.224 127.516   9.356  0.78 20.55           C  
ATOM    126  C   ASN A  67      18.623 127.288   7.912  0.78 20.65           C  
ATOM    127  O   ASN A  67      18.119 127.977   7.044  0.78 24.32           O  
ATOM    128  CB  ASN A  67      18.020 129.006   9.670  0.78 26.56           C  
ATOM    130  CG  ASN A  67      17.412 129.201  11.024  0.78 31.11           C  
ATOM    132  OD1 ASN A  67      16.488 128.536  11.490  0.78 27.13           O  
ATOM    134  ND2 ASN A  67      17.973 130.190  11.702  0.78 41.31           N  
ATOM    136  N   VAL A  68      19.505 126.306   7.639  1.00 20.74           N  
ATOM    137  CA  VAL A  68      19.848 125.970   6.258  1.00 19.93           C  
ATOM    138  C   VAL A  68      19.801 124.465   6.104  1.00 16.58           C  
ATOM    139  O   VAL A  68      19.987 123.644   7.012  1.00 17.91           O  
ATOM    140  CB  VAL A  68      21.213 126.489   5.823  1.00 27.55           C  
ATOM    141  CG1 VAL A  68      21.224 128.012   6.018  1.00 38.33           C  
ATOM    142  CG2 VAL A  68      22.312 125.891   6.618  1.00 49.44           C  
ATOM    143  N   GLN A  69      19.529 124.042   4.877  1.00 15.19           N  
ATOM    144  CA  GLN A  69      19.469 122.643   4.512  1.00 13.37           C  
ATOM    145  C   GLN A  69      20.757 121.921   4.880  1.00 14.02           C  
ATOM    146  O   GLN A  69      21.846 122.366   4.526  1.00 16.78           O  
ATOM    147  CB  GLN A  69      19.178 122.559   3.015  1.00 15.37           C  
ATOM    148  CG  GLN A  69      19.176 121.157   2.463  1.00 13.78           C  
ATOM    149  CD  GLN A  69      18.075 120.230   2.910  1.00 12.36           C  
ATOM    150  OE1 GLN A  69      16.899 120.581   2.889  1.00 14.16           O  
ATOM    151  NE2 GLN A  69      18.487 119.034   3.332  1.00 12.77           N  
ATOM    152  N   VAL A  70      20.605 120.772   5.516  1.00 12.90           N  
ATOM    153  CA  VAL A  70      21.717 119.866   5.797  1.00 12.39           C  
ATOM    154  C   VAL A  70      22.152 119.172   4.513  1.00 12.16           C  
ATOM    155  O   VAL A  70      21.305 118.544   3.839  1.00 12.42           O  
ATOM    156  CB  VAL A  70      21.333 118.869   6.883  1.00 12.36           C  
ATOM    157  CG1 VAL A  70      22.378 117.808   7.105  1.00 15.22           C  
ATOM    158  CG2 VAL A  70      21.039 119.622   8.197  1.00 15.23           C  
ATOM    159  N   PRO A  71      23.413 119.237   4.128  1.00 11.56           N  
ATOM    160  CA  PRO A  71      23.828 118.582   2.887  1.00 12.36           C  
ATOM    161  C   PRO A  71      23.786 117.072   2.990  1.00 11.08           C  
ATOM    162  O   PRO A  71      23.726 116.476   4.056  1.00 11.55           O  
ATOM    163  CB  PRO A  71      25.238 119.124   2.671  0.63 16.63           C  
ATOM    165  CG  PRO A  71      25.700 119.668   3.958  0.63 18.41           C  
ATOM    167  CD  PRO A  71      24.502 119.938   4.835  0.63 13.81           C  
ATOM    169  N   GLY A  72      23.883 116.460   1.813  1.00 12.11           N  
ATOM    170  CA  GLY A  72      24.056 115.048   1.650  1.00 11.91           C  
ATOM    171  C   GLY A  72      25.462 114.574   1.857  1.00 11.03           C  
ATOM    172  O   GLY A  72      26.241 115.220   2.537  1.00 13.95           O  
ATOM    173  N   LEU A  73      25.760 113.397   1.321  1.00 12.54           N  
ATOM    174  CA  LEU A  73      27.050 112.808   1.522  1.00 12.48           C  
ATOM    175  C   LEU A  73      27.898 112.965   0.264  1.00 12.73           C  
ATOM    176  O   LEU A  73      27.561 112.410  -0.779  1.00 14.01           O  
ATOM    177  CB  LEU A  73      26.941 111.329   1.904  1.00 15.91           C  
ATOM    178  CG  LEU A  73      28.267 110.598   2.067  1.00 19.61           C  
ATOM    179  CD1 LEU A  73      29.101 111.267   3.125  1.00 23.42           C  
ATOM    180  CD2 LEU A  73      27.965 109.127   2.383  1.00 26.92           C  
ATOM    181  N   ASP A  74      28.997 113.687   0.360  1.00 14.22           N  
ATOM    182  CA  ASP A  74      30.031 113.771  -0.685  1.00 15.19           C  
ATOM    183  C   ASP A  74      31.251 113.121  -0.047  1.00 13.62           C  
ATOM    184  O   ASP A  74      31.645 113.563   1.027  1.00 14.85           O  
ATOM    185  CB  ASP A  74      30.300 115.195  -1.084  1.00 16.57           C  
ATOM    186  CG  ASP A  74      31.171 115.234  -2.325  1.00 26.76           C  
ATOM    187  OD1 ASP A  74      32.307 114.726  -2.196  1.00 19.53           O  
ATOM    188  OD2 ASP A  74      30.709 115.719  -3.372  1.00 32.51           O  
ATOM    189  N   PRO A  75      31.868 112.094  -0.601  1.00 16.04           N  
ATOM    190  CA  PRO A  75      33.001 111.428   0.055  1.00 17.18           C  
ATOM    191  C   PRO A  75      34.190 112.353   0.275  1.00 16.27           C  
ATOM    192  O   PRO A  75      35.024 112.009   1.148  1.00 19.76           O  
ATOM    193  CB  PRO A  75      33.355 110.236  -0.827  1.00 26.40           C  
ATOM    194  CG  PRO A  75      32.754 110.607  -2.147  1.00 29.83           C  
ATOM    195  CD  PRO A  75      31.528 111.437  -1.877  1.00 19.36           C  
ATOM    196  N   ALA A  76      34.294 113.483  -0.371  1.00 17.05           N  
ATOM    197  CA  ALA A  76      35.396 114.401  -0.112  1.00 19.93           C  
ATOM    198  C   ALA A  76      35.354 114.961   1.293  1.00 19.94           C  
ATOM    199  O   ALA A  76      36.388 115.464   1.828  1.00 26.01           O  
ATOM    200  CB  ALA A  76      35.349 115.505  -1.154  0.50 18.48           C  
ATOM    201  N   ALA A  77      34.186 114.908   1.932  1.00 16.37           N  
ATOM    202  CA  ALA A  77      33.999 115.453   3.245  1.00 17.57           C  
ATOM    203  C   ALA A  77      34.752 114.716   4.322  1.00 16.84           C  
ATOM    204  O   ALA A  77      34.909 115.213   5.427  1.00 20.78           O  
ATOM    205  CB  ALA A  77      32.526 115.463   3.624  1.00 26.58           C  
ATOM    206  N   PHE A  78      35.225 113.497   4.061  1.00 17.68           N  
ATOM    207  CA  PHE A  78      35.942 112.767   5.081  1.00 17.13           C  
ATOM    208  C   PHE A  78      37.386 113.246   5.282  1.00 20.44           C  
ATOM    209  O   PHE A  78      37.947 113.100   6.365  1.00 23.00           O  
ATOM    210  CB  PHE A  78      35.972 111.285   4.728  1.00 18.50           C  
ATOM    211  CG  PHE A  78      34.620 110.643   4.835  1.00 16.95           C  
ATOM    212  CD1 PHE A  78      33.873 110.699   5.973  1.00 19.45           C  
ATOM    213  CD2 PHE A  78      34.103 109.957   3.768  1.00 19.98           C  
ATOM    214  CE1 PHE A  78      32.637 110.084   6.040  1.00 19.96           C  
ATOM    215  CE2 PHE A  78      32.856 109.352   3.815  1.00 20.52           C  
ATOM    216  CZ  PHE A  78      32.105 109.440   4.949  1.00 18.31           C  
ATOM    217  N   LYS A  79      38.016 113.782   4.243  1.00 22.66           N  
ATOM    218  CA  LYS A  79      39.434 114.155   4.331  0.80 22.78           C  
ATOM    219  C   LYS A  79      39.667 115.252   5.336  1.00 23.29           C  
ATOM    220  O   LYS A  79      39.040 116.301   5.400  1.00 24.10           O  
ATOM    221  CB  LYS A  79      39.895 114.526   2.904  0.80 26.01           C  
ATOM    222  CG  LYS A  79      39.847 113.263   2.030  0.80 33.29           C  
ATOM    223  CD  LYS A  79      40.938 112.286   2.455  0.40 70.21           C  
ATOM    224  CE  LYS A  79      41.735 111.775   1.230  0.40 86.35           C  
ATOM    225  NZ  LYS A  79      43.000 111.067   1.679  0.40 65.90           N  
ATOM    226  N   GLY A  80      40.655 114.993   6.202  1.00 22.94           N  
ATOM    227  CA  GLY A  80      41.053 116.007   7.150  1.00 24.25           C  
ATOM    228  C   GLY A  80      40.330 115.977   8.480  1.00 22.77           C  
ATOM    229  O   GLY A  80      40.671 116.758   9.377  1.00 30.92           O  
ATOM    230  N   LYS A  81      39.321 115.154   8.640  1.00 19.44           N  
ATOM    231  CA  LYS A  81      38.427 115.110   9.765  1.00 19.86           C  
ATOM    232  C   LYS A  81      38.426 113.733  10.380  1.00 18.47           C  
ATOM    233  O   LYS A  81      38.838 112.760   9.757  1.00 20.15           O  
ATOM    234  CB  LYS A  81      36.985 115.456   9.328  1.00 22.38           C  
ATOM    235  CG  LYS A  81      36.935 116.913   8.774  1.00 37.69           C  
ATOM    236  CD  LYS A  81      35.572 117.332   8.293  0.80 49.12           C  
ATOM    237  CE  LYS A  81      35.744 118.614   7.514  0.80 70.75           C  
ATOM    238  NZ  LYS A  81      36.909 119.414   7.992  0.00 51.00           N  
ATOM    239  N   VAL A  82      37.984 113.667  11.627  1.00 17.96           N  
ATOM    240  CA  VAL A  82      37.584 112.397  12.241  1.00 16.20           C  
ATOM    241  C   VAL A  82      36.046 112.368  12.244  1.00 14.47           C  
ATOM    242  O   VAL A  82      35.438 113.256  12.810  1.00 16.64           O  
ATOM    243  CB  VAL A  82      38.120 112.205  13.650  1.00 17.65           C  
ATOM    244  CG1 VAL A  82      37.616 110.886  14.251  1.00 18.87           C  
ATOM    245  CG2 VAL A  82      39.635 112.281  13.617  1.00 22.27           C  
ATOM    246  N   SER A  83      35.522 111.368  11.552  1.00 15.06           N  
ATOM    247  CA  SER A  83      34.088 111.286  11.341  1.00 13.89           C  
ATOM    248  C   SER A  83      33.505 109.978  11.910  1.00 13.96           C  
ATOM    249  O   SER A  83      34.113 108.945  11.913  1.00 18.65           O  
ATOM    250  CB  SER A  83      33.765 111.293   9.836  1.00 15.75           C  
ATOM    251  OG  SER A  83      34.308 112.431   9.212  1.00 17.43           O  
ATOM    252  N   LEU A  84      32.294 110.102  12.424  0.83 12.44           N  
ATOM    253  CA  LEU A  84      31.483 108.962  12.789  0.83 12.85           C  
ATOM    254  C   LEU A  84      30.410 108.863  11.729  0.83 11.66           C  
ATOM    255  O   LEU A  84      29.717 109.827  11.490  0.83 14.90           O  
ATOM    256  CB  LEU A  84      30.861 109.190  14.153  0.83 17.40           C  
ATOM    258  CG  LEU A  84      30.040 108.010  14.651  0.83 20.97           C  
ATOM    260  CD1 LEU A  84      30.313 107.814  16.131  0.83 38.80           C  
ATOM    262  CD2 LEU A  84      28.552 108.239  14.377  0.83 24.02           C  
ATOM    264  N   VAL A  85      30.223 107.657  11.165  1.00 12.75           N  
ATOM    265  CA  VAL A  85      29.208 107.429  10.136  1.00 12.79           C  
ATOM    266  C   VAL A  85      28.236 106.435  10.738  1.00 11.88           C  
ATOM    267  O   VAL A  85      28.645 105.306  11.086  1.00 15.42           O  
ATOM    268  CB  VAL A  85      29.823 106.852   8.858  1.00 14.05           C  
ATOM    269  CG1 VAL A  85      28.704 106.552   7.848  1.00 15.66           C  
ATOM    270  CG2 VAL A  85      30.822 107.820   8.258  1.00 16.51           C  
ATOM    271  N   ASN A  86      27.014 106.827  10.910  1.00 11.91           N  
ATOM    272  CA  ASN A  86      25.982 105.965  11.485  1.00 11.66           C  
ATOM    273  C   ASN A  86      24.936 105.647  10.421  1.00 10.74           C  
ATOM    274  O   ASN A  86      24.424 106.567   9.782  1.00 11.54           O  
ATOM    275  CB  ASN A  86      25.325 106.636  12.670  1.00 11.89           C  
ATOM    276  CG  ASN A  86      24.148 105.920  13.295  1.00 12.27           C  
ATOM    277  OD1 ASN A  86      23.020 106.332  13.197  1.00 15.02           O  
ATOM    278  ND2 ASN A  86      24.491 104.816  13.982  1.00 14.21           N  
ATOM    279  N   VAL A  87      24.559 104.377  10.258  1.00 10.52           N  
ATOM    280  CA  VAL A  87      23.582 103.900   9.283  1.00 10.80           C  
ATOM    281  C   VAL A  87      22.354 103.498  10.061  1.00 10.56           C  
ATOM    282  O   VAL A  87      22.436 102.665  10.945  1.00 11.59           O  
ATOM    283  CB  VAL A  87      24.159 102.744   8.436  1.00 12.17           C  
ATOM    284  CG1 VAL A  87      23.222 102.494   7.311  1.00 14.35           C  
ATOM    285  CG2 VAL A  87      25.559 103.063   7.937  1.00 14.72           C  
ATOM    286  N   TRP A  88      21.251 104.162   9.751  1.00 10.20           N  
ATOM    287  CA  TRP A  88      20.062 104.103  10.621  1.00 10.99           C  
ATOM    288  C   TRP A  88      18.808 104.192   9.787  1.00 10.45           C  
ATOM    289  O   TRP A  88      18.801 104.635   8.639  1.00 11.00           O  
ATOM    290  CB  TRP A  88      20.072 105.250  11.623  1.00 11.62           C  
ATOM    291  CG  TRP A  88      20.012 106.607  10.960  1.00 11.63           C  
ATOM    292  CD1 TRP A  88      21.069 107.311  10.469  1.00 12.66           C  
ATOM    293  CD2 TRP A  88      18.869 107.392  10.692  1.00 11.45           C  
ATOM    294  NE1 TRP A  88      20.646 108.484   9.906  1.00 14.19           N  
ATOM    295  CE2 TRP A  88      19.283 108.572  10.060  1.00 12.63           C  
ATOM    296  CE3 TRP A  88      17.485 107.261  10.970  1.00 12.71           C  
ATOM    297  CZ2 TRP A  88      18.383 109.570   9.679  1.00 15.36           C  
ATOM    298  CZ3 TRP A  88      16.599 108.251  10.594  1.00 14.23           C  
ATOM    299  CH2 TRP A  88      17.051 109.408   9.955  1.00 15.57           C  
ATOM    300  N   ALA A  89      17.674 103.777  10.390  1.00 10.61           N  
ATOM    301  CA  ALA A  89      16.361 103.939   9.794  1.00 10.71           C  
ATOM    302  C   ALA A  89      15.348 104.140  10.909  1.00 10.68           C  
ATOM    303  O   ALA A  89      15.512 103.637  12.028  1.00 11.28           O  
ATOM    304  CB  ALA A  89      15.930 102.739   8.994  1.00 12.36           C  
ATOM    305  N   SER A  90      14.291 104.852  10.591  1.00 10.33           N  
ATOM    306  CA  SER A  90      13.252 105.133  11.582  1.00 10.91           C  
ATOM    307  C   SER A  90      12.472 103.932  12.063  1.00 10.89           C  
ATOM    308  O   SER A  90      11.881 103.957  13.153  1.00 13.42           O  
ATOM    309  CB  SER A  90      12.218 106.133  11.008  1.00 12.33           C  
ATOM    310  OG  SER A  90      11.406 105.595  10.030  1.00 13.62           O  
ATOM    311  N   TRP A  91      12.432 102.855  11.278  1.00 10.93           N  
ATOM    312  CA  TRP A  91      11.708 101.628  11.613  1.00 11.32           C  
ATOM    313  C   TRP A  91      12.573 100.676  12.415  1.00 12.01           C  
ATOM    314  O   TRP A  91      12.066  99.622  12.794  1.00 14.69           O  
ATOM    315  CB  TRP A  91      11.172 100.973  10.340  1.00 13.30           C  
ATOM    316  CG  TRP A  91      12.173 100.855   9.209  1.00 12.00           C  
ATOM    317  CD1 TRP A  91      12.225 101.673   8.118  1.00 13.73           C  
ATOM    318  CD2 TRP A  91      13.239  99.923   9.067  1.00 12.22           C  
ATOM    319  NE1 TRP A  91      13.250 101.294   7.308  1.00 13.95           N  
ATOM    320  CE2 TRP A  91      13.891 100.242   7.836  1.00 12.77           C  
ATOM    321  CE3 TRP A  91      13.722  98.852   9.811  1.00 14.49           C  
ATOM    322  CZ2 TRP A  91      14.980  99.531   7.380  1.00 14.51           C  
ATOM    323  CZ3 TRP A  91      14.816  98.172   9.304  1.00 15.88           C  
ATOM    324  CH2 TRP A  91      15.440  98.486   8.115  1.00 16.67           C  
ATOM    325  N   CYS A  92      13.840 100.976  12.620  1.00 12.19           N  
ATOM    326  CA  CYS A  92      14.801 100.118  13.281  1.00 12.17           C  
ATOM    327  C   CYS A  92      14.764 100.344  14.812  1.00 11.58           C  
ATOM    328  O   CYS A  92      14.975 101.446  15.268  1.00 12.07           O  
ATOM    329  CB  CYS A  92      16.152 100.467  12.666  1.00 13.60           C  
ATOM    330  SG  CYS A  92      17.618 100.166  13.638  1.00 13.02           S  
ATOM    331  N   VAL A  93      14.521  99.268  15.545  1.00 12.48           N  
ATOM    332  CA  VAL A  93      14.291  99.368  16.988  1.00 13.48           C  
ATOM    333  C   VAL A  93      15.558  99.805  17.702  1.00 12.56           C  
ATOM    334  O   VAL A  93      15.502 100.779  18.466  1.00 13.33           O  
ATOM    335  CB  VAL A  93      13.657  98.036  17.496  1.00 14.60           C  
ATOM    336  CG1 VAL A  93      13.697  97.982  19.013  1.00 19.42           C  
ATOM    337  CG2 VAL A  93      12.250  97.916  16.948  1.00 17.90           C  
ATOM    338  N   PRO A  94      16.708  99.196  17.516  1.00 12.77           N  
ATOM    339  CA  PRO A  94      17.919  99.676  18.195  1.00 13.74           C  
ATOM    340  C   PRO A  94      18.365 101.090  17.812  1.00 12.05           C  
ATOM    341  O   PRO A  94      19.056 101.753  18.540  1.00 13.97           O  
ATOM    342  CB  PRO A  94      19.009  98.637  17.872  1.00 14.70           C  
ATOM    343  CG  PRO A  94      18.282  97.448  17.376  1.00 19.74           C  
ATOM    344  CD  PRO A  94      16.964  97.932  16.845  1.00 13.48           C  
ATOM    345  N   CYS A  95      17.882 101.509  16.631  1.00 10.43           N  
ATOM    346  CA  CYS A  95      18.161 102.861  16.163  1.00 11.38           C  
ATOM    347  C   CYS A  95      17.507 103.874  17.076  1.00 11.44           C  
ATOM    348  O   CYS A  95      18.071 104.950  17.348  1.00 12.23           O  
ATOM    349  CB  CYS A  95      17.716 103.043  14.718  1.00 12.55           C  
ATOM    350  SG  CYS A  95      18.587 101.962  13.550  1.00 13.49           S  
ATOM    351  N   HIS A  96      16.307 103.585  17.583  1.00 12.75           N  
ATOM    352  CA  HIS A  96      15.647 104.475  18.572  1.00 13.18           C  
ATOM    353  C   HIS A  96      16.446 104.487  19.877  1.00 13.78           C  
ATOM    354  O   HIS A  96      16.612 105.524  20.471  1.00 15.74           O  
ATOM    355  CB  HIS A  96      14.201 104.010  18.841  1.00 13.53           C  
ATOM    356  CG  HIS A  96      13.302 104.388  17.713  1.00 14.06           C  
ATOM    357  ND1 HIS A  96      12.429 105.437  17.797  1.00 14.54           N  
ATOM    358  CD2 HIS A  96      13.168 103.807  16.471  1.00 16.52           C  
ATOM    359  CE1 HIS A  96      11.812 105.525  16.654  1.00 16.38           C  
ATOM    360  NE2 HIS A  96      12.215 104.558  15.826  1.00 15.93           N  
ATOM    361  N   ASP A  97      16.900 103.306  20.285  1.00 15.03           N  
ATOM    362  CA  ASP A  97      17.592 103.194  21.559  1.00 16.69           C  
ATOM    363  C   ASP A  97      18.827 104.054  21.566  1.00 15.38           C  
ATOM    364  O   ASP A  97      19.182 104.672  22.564  1.00 21.05           O  
ATOM    365  CB  ASP A  97      17.969 101.752  21.861  1.00 18.91           C  
ATOM    366  CG  ASP A  97      16.753 100.876  22.126  1.00 21.73           C  
ATOM    367  OD1 ASP A  97      16.921  99.658  21.999  1.00 29.68           O  
ATOM    368  OD2 ASP A  97      15.687 101.419  22.476  1.00 34.60           O  
ATOM    369  N   GLU A  98      19.589 104.072  20.462  1.00 13.05           N  
ATOM    370  CA  GLU A  98      20.841 104.762  20.396  1.00 14.55           C  
ATOM    371  C   GLU A  98      20.733 106.243  20.073  1.00 14.39           C  
ATOM    372  O   GLU A  98      21.687 107.023  20.263  1.00 14.09           O  
ATOM    373  CB  GLU A  98      21.810 104.115  19.442  1.00 13.89           C  
ATOM    374  CG  GLU A  98      21.481 104.305  18.040  1.00 14.19           C  
ATOM    375  CD  GLU A  98      22.416 103.710  16.983  1.00 14.34           C  
ATOM    376  OE1 GLU A  98      23.396 103.060  17.354  1.00 16.27           O  
ATOM    377  OE2 GLU A  98      22.171 103.937  15.807  1.00 14.51           O  
ATOM    378  N   ALA A  99      19.611 106.703  19.562  1.00 12.97           N  
ATOM    379  CA  ALA A  99      19.475 108.058  19.066  1.00 13.06           C  
ATOM    380  C   ALA A  99      19.809 109.126  20.114  1.00 13.18           C  
ATOM    381  O   ALA A  99      20.542 110.076  19.834  1.00 14.56           O  
ATOM    382  CB  ALA A  99      18.084 108.287  18.474  1.00 16.39           C  
ATOM    383  N   PRO A 100      19.319 109.037  21.354  0.90 13.97           N  
ATOM    384  CA  PRO A 100      19.652 110.089  22.324  0.90 16.16           C  
ATOM    385  C   PRO A 100      21.144 110.173  22.641  0.90 15.83           C  
ATOM    386  O   PRO A 100      21.631 111.262  22.927  0.90 17.94           O  
ATOM    387  CB  PRO A 100      18.879 109.696  23.570  0.90 21.08           C  
ATOM    388  CG  PRO A 100      17.745 108.901  23.043  0.90 23.47           C  
ATOM    389  CD  PRO A 100      18.277 108.151  21.904  0.90 15.31           C  
ATOM    390  N   LEU A 101      21.854 109.051  22.532  1.00 16.12           N  
ATOM    391  CA  LEU A 101      23.295 109.037  22.743  1.00 16.79           C  
ATOM    392  C   LEU A 101      24.028 109.766  21.641  1.00 16.98           C  
ATOM    393  O   LEU A 101      24.978 110.515  21.827  1.00 20.58           O  
ATOM    394  CB  LEU A 101      23.804 107.597  22.870  1.00 19.26           C  
ATOM    395  CG  LEU A 101      23.193 106.786  24.018  1.00 23.00           C  
ATOM    396  CD1 LEU A 101      23.702 105.377  23.939  1.00 27.52           C  
ATOM    397  CD2 LEU A 101      23.647 107.367  25.343  1.00 45.80           C  
ATOM    398  N   LEU A 102      23.617 109.619  20.375  1.00 15.18           N  
ATOM    399  CA  LEU A 102      24.195 110.344  19.249  1.00 15.60           C  
ATOM    400  C   LEU A 102      23.867 111.823  19.361  1.00 16.72           C  
ATOM    401  O   LEU A 102      24.736 112.629  19.053  1.00 16.36           O  
ATOM    402  CB  LEU A 102      23.673 109.799  17.916  1.00 16.99           C  
ATOM    403  CG  LEU A 102      24.219 108.454  17.459  1.00 17.76           C  
ATOM    404  CD1 LEU A 102      23.369 107.850  16.346  1.00 25.89           C  
ATOM    405  CD2 LEU A 102      25.654 108.560  16.984  1.00 26.77           C  
ATOM    406  N   THR A 103      22.674 112.193  19.795  1.00 16.06           N  
ATOM    407  CA  THR A 103      22.385 113.623  20.000  1.00 17.66           C  
ATOM    408  C   THR A 103      23.388 114.226  20.964  1.00 17.56           C  
ATOM    409  O   THR A 103      23.967 115.313  20.761  1.00 22.03           O  
ATOM    410  CB  THR A 103      20.920 113.799  20.450  1.00 21.11           C  
ATOM    411  OG1 THR A 103      20.140 113.387  19.275  1.00 21.96           O  
ATOM    412  CG2 THR A 103      20.567 115.246  20.678  1.00 26.54           C  
ATOM    413  N   GLU A 104      23.700 113.564  22.082  1.00 20.84           N  
ATOM    414  CA  GLU A 104      24.720 114.119  22.987  1.00 22.74           C  
ATOM    415  C   GLU A 104      26.097 114.215  22.352  1.00 24.57           C  
ATOM    416  O   GLU A 104      26.841 115.166  22.488  1.00 26.06           O  
ATOM    417  CB  GLU A 104      24.760 113.244  24.241  0.80 33.55           C  
ATOM    418  CG  GLU A 104      23.426 113.277  24.971  0.40 27.60           C  
ATOM    419  CD  GLU A 104      23.234 114.465  25.887  0.40 70.55           C  
ATOM    420  OE1 GLU A 104      23.916 115.499  25.737  0.40 32.24           O  
ATOM    421  OE2 GLU A 104      22.382 114.385  26.804  0.40 86.46           O  
ATOM    422  N   LEU A 105      26.488 113.164  21.615  1.00 21.60           N  
ATOM    423  CA  LEU A 105      27.835 113.092  21.008  1.00 23.42           C  
ATOM    424  C   LEU A 105      27.942 114.255  20.028  1.00 23.15           C  
ATOM    425  O   LEU A 105      28.999 114.830  19.879  1.00 26.81           O  
ATOM    426  CB  LEU A 105      28.088 111.770  20.321  1.00 24.23           C  
ATOM    427  CG  LEU A 105      29.459 111.517  19.724  1.00 23.37           C  
ATOM    428  CD1 LEU A 105      30.562 111.632  20.742  1.00 30.37           C  
ATOM    429  CD2 LEU A 105      29.506 110.131  19.093  1.00 30.86           C  
ATOM    430  N   GLY A 106      26.870 114.587  19.308  1.00 21.26           N  
ATOM    431  CA  GLY A 106      26.878 115.678  18.377  1.00 22.45           C  
ATOM    432  C   GLY A 106      27.215 117.037  18.927  1.00 24.65           C  
ATOM    433  O   GLY A 106      27.538 117.984  18.199  1.00 28.96           O  
ATOM    434  N   LYS A 107      27.173 117.209  20.248  0.80 23.95           N  
ATOM    435  CA  LYS A 107      27.594 118.421  20.918  0.80 27.51           C  
ATOM    436  C   LYS A 107      29.119 118.581  20.893  0.80 23.84           C  
ATOM    437  O   LYS A 107      29.630 119.694  21.090  0.80 29.98           O  
ATOM    438  CB  LYS A 107      27.098 118.466  22.348  0.80 39.48           C  
ATOM    439  N   ASP A 108      29.870 117.525  20.651  1.00 26.92           N  
ATOM    440  CA  ASP A 108      31.325 117.551  20.626  1.00 24.14           C  
ATOM    441  C   ASP A 108      31.849 117.950  19.252  1.00 25.31           C  
ATOM    442  O   ASP A 108      31.893 117.179  18.283  1.00 28.28           O  
ATOM    443  CB  ASP A 108      31.799 116.164  21.086  1.00 25.27           C  
ATOM    444  CG  ASP A 108      33.282 116.115  21.290  1.00 23.16           C  
ATOM    445  OD1 ASP A 108      34.050 116.957  20.763  1.00 26.72           O  
ATOM    446  OD2 ASP A 108      33.737 115.187  22.000  1.00 30.83           O  
ATOM    447  N   LYS A 109      32.286 119.186  19.134  1.00 27.30           N  
ATOM    448  CA  LYS A 109      32.686 119.832  17.912  1.00 33.60           C  
ATOM    449  C   LYS A 109      34.021 119.348  17.379  1.00 25.53           C  
ATOM    450  O   LYS A 109      34.469 119.768  16.317  1.00 29.23           O  
ATOM    451  CB  LYS A 109      32.735 121.339  18.201  1.00 43.56           C  
ATOM    452  N   ARG A 110      34.711 118.433  18.054  1.00 22.53           N  
ATOM    453  CA  ARG A 110      35.936 117.878  17.484  1.00 22.32           C  
ATOM    454  C   ARG A 110      35.711 116.915  16.314  1.00 19.90           C  
ATOM    455  O   ARG A 110      36.620 116.621  15.535  1.00 22.51           O  
ATOM    456  CB  ARG A 110      36.686 117.090  18.570  1.00 23.71           C  
ATOM    457  CG  ARG A 110      37.069 117.994  19.737  1.00 27.51           C  
ATOM    458  CD  ARG A 110      37.720 117.237  20.889  1.00 33.33           C  
ATOM    459  NE  ARG A 110      36.821 116.248  21.454  1.00 29.48           N  
ATOM    460  CZ  ARG A 110      37.187 115.265  22.260  1.00 30.06           C  
ATOM    461  NH1 ARG A 110      38.467 115.150  22.612  1.00 37.83           N  
ATOM    462  NH2 ARG A 110      36.297 114.418  22.719  1.00 33.97           N  
ATOM    463  N   PHE A 111      34.474 116.406  16.214  1.00 18.11           N  
ATOM    464  CA  PHE A 111      34.144 115.340  15.274  1.00 16.92           C  
ATOM    465  C   PHE A 111      33.055 115.747  14.290  1.00 16.44           C  
ATOM    466  O   PHE A 111      32.247 116.605  14.596  1.00 21.62           O  
ATOM    467  CB  PHE A 111      33.682 114.074  16.015  1.00 17.64           C  
ATOM    468  CG  PHE A 111      34.601 113.657  17.147  1.00 17.51           C  
ATOM    469  CD1 PHE A 111      34.229 113.728  18.444  1.00 19.47           C  
ATOM    470  CD2 PHE A 111      35.866 113.225  16.821  1.00 18.40           C  
ATOM    471  CE1 PHE A 111      35.096 113.354  19.455  1.00 26.28           C  
ATOM    472  CE2 PHE A 111      36.750 112.825  17.810  1.00 22.09           C  
ATOM    473  CZ  PHE A 111      36.351 112.879  19.108  1.00 22.81           C  
ATOM    474  N   GLN A 112      33.114 115.090  13.128  1.00 15.25           N  
ATOM    475  CA  GLN A 112      32.069 115.220  12.130  1.00 15.35           C  
ATOM    476  C   GLN A 112      31.158 114.007  12.232  1.00 14.29           C  
ATOM    477  O   GLN A 112      31.631 112.914  12.183  1.00 19.31           O  
ATOM    478  CB  GLN A 112      32.696 115.340  10.762  1.00 17.56           C  
ATOM    479  CG  GLN A 112      31.658 115.307   9.642  1.00 19.49           C  
ATOM    480  CD  GLN A 112      32.266 115.575   8.284  1.00 22.78           C  
ATOM    481  OE1 GLN A 112      31.888 116.547   7.607  1.00 28.57           O  
ATOM    482  NE2 GLN A 112      33.153 114.741   7.820  1.00 21.74           N  
ATOM    483  N   LEU A 113      29.869 114.228  12.365  1.00 13.58           N  
ATOM    484  CA  LEU A 113      28.917 113.112  12.404  1.00 12.81           C  
ATOM    485  C   LEU A 113      28.138 113.077  11.104  1.00 12.79           C  
ATOM    486  O   LEU A 113      27.574 114.078  10.657  1.00 13.76           O  
ATOM    487  CB  LEU A 113      27.967 113.233  13.610  1.00 14.78           C  
ATOM    488  CG  LEU A 113      28.427 112.590  14.888  1.00 21.43           C  
ATOM    489  CD1 LEU A 113      29.692 113.180  15.488  1.00 30.01           C  
ATOM    490  CD2 LEU A 113      27.351 112.629  15.951  1.00 22.44           C  
ATOM    491  N   VAL A 114      28.128 111.909  10.500  1.00 12.07           N  
ATOM    492  CA  VAL A 114      27.487 111.697   9.180  1.00 12.02           C  
ATOM    493  C   VAL A 114      26.474 110.602   9.342  1.00 10.82           C  
ATOM    494  O   VAL A 114      26.788 109.563   9.899  1.00 13.58           O  
ATOM    495  CB  VAL A 114      28.555 111.308   8.162  1.00 13.41           C  
ATOM    496  CG1 VAL A 114      27.956 110.994   6.793  1.00 16.40           C  
ATOM    497  CG2 VAL A 114      29.606 112.407   8.028  1.00 17.44           C  
ATOM    498  N   GLY A 115      25.273 110.848   8.876  1.00 10.45           N  
ATOM    499  CA  GLY A 115      24.240 109.836   8.843  1.00 11.24           C  
ATOM    500  C   GLY A 115      23.885 109.294   7.477  1.00 10.24           C  
ATOM    501  O   GLY A 115      23.875 110.083   6.545  1.00 13.79           O  
ATOM    502  N   ILE A 116      23.695 108.015   7.400  1.00  9.92           N  
ATOM    503  CA  ILE A 116      23.192 107.340   6.173  1.00 10.47           C  
ATOM    504  C   ILE A 116      21.827 106.808   6.531  1.00  9.91           C  
ATOM    505  O   ILE A 116      21.706 105.905   7.369  1.00 11.77           O  
ATOM    506  CB  ILE A 116      24.132 106.279   5.614  1.00 12.28           C  
ATOM    507  CG1 ILE A 116      25.482 106.904   5.233  1.00 13.33           C  
ATOM    508  CG2 ILE A 116      23.495 105.595   4.449  1.00 13.99           C  
ATOM    509  CD1 ILE A 116      26.577 105.954   4.736  1.00 17.43           C  
ATOM    510  N   ASN A 117      20.799 107.359   5.925  1.00 10.11           N  
ATOM    511  CA  ASN A 117      19.430 106.950   6.177  1.00  9.80           C  
ATOM    512  C   ASN A 117      19.050 105.848   5.204  1.00  9.91           C  
ATOM    513  O   ASN A 117      19.009 106.049   4.011  1.00 11.63           O  
ATOM    514  CB  ASN A 117      18.506 108.179   6.009  1.00 11.21           C  
ATOM    515  CG  ASN A 117      17.021 107.857   6.241  1.00 11.16           C  
ATOM    516  OD1 ASN A 117      16.224 108.125   5.357  1.00 13.81           O  
ATOM    517  ND2 ASN A 117      16.719 107.294   7.376  1.00 11.74           N  
ATOM    518  N   TYR A 118      18.792 104.662   5.743  1.00  9.97           N  
ATOM    519  CA  TYR A 118      18.680 103.414   5.015  1.00 10.44           C  
ATOM    520  C   TYR A 118      17.261 102.957   4.789  1.00  9.97           C  
ATOM    521  O   TYR A 118      16.537 102.739   5.776  1.00 11.77           O  
ATOM    522  CB  TYR A 118      19.467 102.389   5.817  1.00 12.35           C  
ATOM    523  CG  TYR A 118      19.440 100.960   5.422  1.00 12.19           C  
ATOM    524  CD1 TYR A 118      20.349 100.406   4.553  1.00 15.03           C  
ATOM    525  CD2 TYR A 118      18.549 100.076   5.998  1.00 13.55           C  
ATOM    526  CE1 TYR A 118      20.305  99.073   4.257  1.00 17.50           C  
ATOM    527  CE2 TYR A 118      18.512  98.722   5.710  1.00 13.80           C  
ATOM    528  CZ  TYR A 118      19.421  98.218   4.817  1.00 15.79           C  
ATOM    529  OH  TYR A 118      19.415  96.880   4.506  1.00 19.48           O  
ATOM    530  N   LYS A 119      16.858 102.850   3.543  1.00 10.84           N  
ATOM    531  CA  LYS A 119      15.570 102.227   3.175  1.00 11.49           C  
ATOM    532  C   LYS A 119      14.405 102.815   3.973  1.00 11.52           C  
ATOM    533  O   LYS A 119      13.611 102.046   4.543  1.00 12.23           O  
ATOM    534  CB  LYS A 119      15.619 100.702   3.314  1.00 13.90           C  
ATOM    535  CG  LYS A 119      16.636 100.033   2.418  1.00 14.32           C  
ATOM    536  CD  LYS A 119      16.495  98.491   2.531  1.00 18.74           C  
ATOM    537  CE  LYS A 119      17.601  97.739   1.831  1.00 18.94           C  
ATOM    538  NZ  LYS A 119      17.379  96.264   1.943  1.00 21.37           N  
ATOM    539  N   ASP A 120      14.264 104.133   3.982  1.00 11.97           N  
ATOM    540  CA  ASP A 120      13.345 104.833   4.875  1.00 11.81           C  
ATOM    541  C   ASP A 120      12.607 105.896   4.126  1.00 13.12           C  
ATOM    542  O   ASP A 120      13.195 106.695   3.389  1.00 16.14           O  
ATOM    543  CB  ASP A 120      14.156 105.472   6.001  1.00 11.70           C  
ATOM    544  CG  ASP A 120      13.453 105.679   7.338  1.00 11.73           C  
ATOM    545  OD1 ASP A 120      12.317 105.227   7.528  1.00 13.48           O  
ATOM    546  OD2 ASP A 120      14.117 106.283   8.179  1.00 11.90           O  
ATOM    547  N   ALA A 121      11.335 106.026   4.355  1.00 12.57           N  
ATOM    548  CA  ALA A 121      10.509 107.076   3.758  1.00 13.41           C  
ATOM    549  C   ALA A 121      10.848 108.426   4.338  1.00 11.54           C  
ATOM    550  O   ALA A 121      11.100 108.520   5.541  1.00 12.77           O  
ATOM    551  CB  ALA A 121       9.029 106.806   4.000  1.00 18.07           C  
ATOM    552  N   ALA A 122      10.893 109.458   3.544  1.00 12.37           N  
ATOM    553  CA  ALA A 122      11.349 110.764   3.954  1.00 12.15           C  
ATOM    554  C   ALA A 122      10.557 111.335   5.139  1.00 11.24           C  
ATOM    555  O   ALA A 122      11.123 111.908   6.051  1.00 11.47           O  
ATOM    556  CB  ALA A 122      11.342 111.757   2.774  1.00 13.90           C  
ATOM    557  N   ASP A 123       9.235 111.194   5.122  1.00 11.42           N  
ATOM    558  CA  ASP A 123       8.437 111.714   6.215  1.00 10.89           C  
ATOM    559  C   ASP A 123       8.856 111.067   7.521  1.00 10.93           C  
ATOM    560  O   ASP A 123       8.882 111.721   8.567  1.00 11.66           O  
ATOM    561  CB  ASP A 123       6.940 111.509   5.989  1.00 11.59           C  
ATOM    562  CG  ASP A 123       6.234 112.565   5.185  1.00 12.42           C  
ATOM    563  OD1 ASP A 123       6.685 113.716   5.162  1.00 15.22           O  
ATOM    564  OD2 ASP A 123       5.167 112.249   4.624  1.00 17.57           O  
ATOM    565  N   ASN A 124       9.109 109.760   7.482  1.00 11.32           N  
ATOM    566  CA  ASN A 124       9.449 109.024   8.693  1.00 10.85           C  
ATOM    567  C   ASN A 124      10.840 109.374   9.181  1.00 10.46           C  
ATOM    568  O   ASN A 124      11.101 109.472  10.375  1.00 11.31           O  
ATOM    569  CB  ASN A 124       9.305 107.518   8.494  1.00 13.07           C  
ATOM    570  CG  ASN A 124       7.852 107.173   8.290  1.00 17.65           C  
ATOM    571  OD1 ASN A 124       6.919 107.860   8.703  1.00 22.86           O  
ATOM    572  ND2 ASN A 124       7.650 106.024   7.652  1.00 24.82           N  
ATOM    573  N   ALA A 125      11.775 109.565   8.265  1.00 10.52           N  
ATOM    574  CA  ALA A 125      13.139 109.983   8.598  1.00 10.86           C  
ATOM    575  C   ALA A 125      13.127 111.392   9.206  1.00  9.58           C  
ATOM    576  O   ALA A 125      13.797 111.625  10.220  1.00 10.83           O  
ATOM    577  CB  ALA A 125      14.045 109.939   7.390  1.00 11.52           C  
ATOM    578  N   ARG A 126      12.336 112.300   8.649  1.00 10.60           N  
ATOM    579  CA  ARG A 126      12.217 113.643   9.219  1.00 10.82           C  
ATOM    580  C   ARG A 126      11.552 113.586  10.617  1.00 10.21           C  
ATOM    581  O   ARG A 126      12.016 114.330  11.506  1.00 12.20           O  
ATOM    582  CB  ARG A 126      11.416 114.563   8.281  1.00 10.57           C  
ATOM    583  CG  ARG A 126      12.194 115.008   7.065  1.00 10.86           C  
ATOM    584  CD  ARG A 126      11.414 116.059   6.259  1.00 12.30           C  
ATOM    585  NE  ARG A 126      10.316 115.470   5.523  1.00 12.92           N  
ATOM    586  CZ  ARG A 126      10.272 115.084   4.273  1.00 11.85           C  
ATOM    587  NH1 ARG A 126      11.285 115.223   3.488  1.00 12.54           N  
ATOM    588  NH2 ARG A 126       9.169 114.514   3.782  1.00 13.70           N  
ATOM    589  N   ARG A 127      10.540 112.746  10.770  1.00  9.94           N  
ATOM    590  CA  ARG A 127       9.941 112.611  12.119  1.00 10.90           C  
ATOM    591  C   ARG A 127      10.992 112.156  13.111  1.00 10.19           C  
ATOM    592  O   ARG A 127      11.046 112.690  14.228  1.00 11.69           O  
ATOM    593  CB  ARG A 127       8.753 111.647  12.050  1.00 11.43           C  
ATOM    594  CG  ARG A 127       7.930 111.606  13.306  1.00 12.72           C  
ATOM    595  CD  ARG A 127       8.342 110.689  14.343  1.00 15.34           C  
ATOM    596  NE  ARG A 127       7.509 110.662  15.533  1.00 14.83           N  
ATOM    597  CZ  ARG A 127       6.636 109.731  15.890  1.00 13.33           C  
ATOM    598  NH1 ARG A 127       6.291 108.723  15.115  1.00 18.12           N  
ATOM    599  NH2 ARG A 127       6.059 109.827  17.076  1.00 15.23           N  
ATOM    600  N   PHE A 128      11.765 111.146  12.771  1.00 10.08           N  
ATOM    601  CA  PHE A 128      12.743 110.563  13.659  1.00 10.41           C  
ATOM    602  C   PHE A 128      13.707 111.620  14.136  1.00  9.94           C  
ATOM    603  O   PHE A 128      14.003 111.735  15.324  1.00 11.41           O  
ATOM    604  CB  PHE A 128      13.444 109.418  12.943  1.00 10.84           C  
ATOM    605  CG  PHE A 128      14.457 108.651  13.765  1.00 11.12           C  
ATOM    606  CD1 PHE A 128      15.776 109.097  13.841  1.00 12.58           C  
ATOM    607  CD2 PHE A 128      14.107 107.503  14.439  1.00 12.78           C  
ATOM    608  CE1 PHE A 128      16.707 108.353  14.544  1.00 15.08           C  
ATOM    609  CE2 PHE A 128      15.030 106.760  15.131  1.00 14.23           C  
ATOM    610  CZ  PHE A 128      16.338 107.215  15.199  1.00 15.05           C  
ATOM    611  N   LEU A 129      14.315 112.379  13.203  1.00 10.50           N  
ATOM    612  CA  LEU A 129      15.284 113.389  13.609  1.00 11.04           C  
ATOM    613  C   LEU A 129      14.630 114.555  14.341  1.00 11.80           C  
ATOM    614  O   LEU A 129      15.264 115.145  15.208  1.00 13.37           O  
ATOM    615  CB  LEU A 129      16.099 113.845  12.401  0.90 11.16           C  
ATOM    616  CG  LEU A 129      16.955 112.792  11.726  0.90 11.00           C  
ATOM    617  CD1 LEU A 129      17.492 113.292  10.387  0.90 18.08           C  
ATOM    618  CD2 LEU A 129      18.075 112.366  12.632  0.90 15.34           C  
ATOM    619  N   GLY A 130      13.347 114.849  14.057  1.00 11.57           N  
ATOM    620  CA  GLY A 130      12.668 115.866  14.841  1.00 12.93           C  
ATOM    621  C   GLY A 130      12.365 115.384  16.247  1.00 12.94           C  
ATOM    622  O   GLY A 130      12.277 116.230  17.114  1.00 16.94           O  
ATOM    623  N   ARG A 131      12.213 114.108  16.474  1.00 12.53           N  
ATOM    624  CA  ARG A 131      11.885 113.547  17.771  1.00 12.62           C  
ATOM    625  C   ARG A 131      13.066 113.498  18.717  1.00 12.71           C  
ATOM    626  O   ARG A 131      12.985 113.864  19.889  1.00 15.34           O  
ATOM    627  CB  ARG A 131      11.279 112.165  17.581  1.00 12.24           C  
ATOM    628  CG  ARG A 131      10.765 111.539  18.856  1.00 13.95           C  
ATOM    629  CD  ARG A 131      10.040 110.243  18.625  1.00 16.19           C  
ATOM    630  NE  ARG A 131       8.902 110.077  19.621  1.00 19.89           N  
ATOM    631  CZ  ARG A 131       8.843 109.195  20.550  0.50 11.98           C  
ATOM    632  NH1 ARG A 131       9.668 108.226  20.933  0.50 15.43           N  
ATOM    633  NH2 ARG A 131       7.729 109.234  21.311  0.50 20.40           N  
ATOM    634  N   TYR A 132      14.188 113.071  18.163  1.00 11.94           N  
ATOM    635  CA  TYR A 132      15.383 112.857  18.965  1.00 12.95           C  
ATOM    636  C   TYR A 132      16.415 113.955  18.837  1.00 13.37           C  
ATOM    637  O   TYR A 132      17.369 113.986  19.626  1.00 17.16           O  
ATOM    638  CB  TYR A 132      16.043 111.505  18.567  1.00 14.63           C  
ATOM    639  CG  TYR A 132      15.132 110.353  18.892  1.00 13.10           C  
ATOM    640  CD1 TYR A 132      14.801 110.007  20.200  1.00 16.40           C  
ATOM    641  CD2 TYR A 132      14.559 109.622  17.875  1.00 13.19           C  
ATOM    642  CE1 TYR A 132      13.966 108.952  20.453  1.00 17.31           C  
ATOM    643  CE2 TYR A 132      13.693 108.569  18.131  1.00 14.38           C  
ATOM    644  CZ  TYR A 132      13.402 108.234  19.427  1.00 15.64           C  
ATOM    645  OH  TYR A 132      12.530 107.242  19.735  1.00 17.54           O  
ATOM    646  N   GLY A 133      16.273 114.840  17.866  1.00 13.99           N  
ATOM    647  CA  GLY A 133      17.253 115.791  17.511  1.00 15.60           C  
ATOM    648  C   GLY A 133      18.133 115.256  16.391  1.00 12.69           C  
ATOM    649  O   GLY A 133      18.292 114.052  16.227  1.00 15.37           O  
ATOM    650  N   ASN A 134      18.719 116.165  15.658  1.00 14.00           N  
ATOM    651  CA  ASN A 134      19.644 115.847  14.573  1.00 12.83           C  
ATOM    652  C   ASN A 134      21.091 116.128  14.976  1.00 13.69           C  
ATOM    653  O   ASN A 134      21.500 117.285  15.042  1.00 17.16           O  
ATOM    654  CB  ASN A 134      19.348 116.677  13.353  1.00 14.33           C  
ATOM    655  CG  ASN A 134      20.418 116.414  12.291  1.00 13.17           C  
ATOM    656  OD1 ASN A 134      20.845 115.278  12.132  1.00 14.37           O  
ATOM    657  ND2 ASN A 134      20.829 117.469  11.577  1.00 17.26           N  
ATOM    658  N   PRO A 135      21.867 115.093  15.206  1.00 14.47           N  
ATOM    659  CA  PRO A 135      23.277 115.278  15.566  1.00 17.74           C  
ATOM    660  C   PRO A 135      24.191 115.380  14.360  1.00 13.97           C  
ATOM    661  O   PRO A 135      25.384 115.599  14.530  1.00 17.52           O  
ATOM    662  CB  PRO A 135      23.610 113.984  16.316  1.00 23.14           C  
ATOM    663  CG  PRO A 135      22.751 112.981  15.660  1.00 22.39           C  
ATOM    664  CD  PRO A 135      21.478 113.696  15.244  1.00 17.44           C  
ATOM    665  N   PHE A 136      23.684 115.171  13.166  1.00 12.68           N  
ATOM    666  CA  PHE A 136      24.509 114.989  11.980  1.00 12.51           C  
ATOM    667  C   PHE A 136      24.779 116.289  11.229  1.00 13.13           C  
ATOM    668  O   PHE A 136      23.833 117.063  10.984  1.00 14.85           O  
ATOM    669  CB  PHE A 136      23.834 114.029  11.048  1.00 12.21           C  
ATOM    670  CG  PHE A 136      23.535 112.668  11.591  1.00 11.53           C  
ATOM    671  CD1 PHE A 136      24.571 111.840  11.979  1.00 14.07           C  
ATOM    672  CD2 PHE A 136      22.252 112.195  11.748  1.00 13.58           C  
ATOM    673  CE1 PHE A 136      24.322 110.583  12.464  1.00 13.86           C  
ATOM    674  CE2 PHE A 136      22.027 110.911  12.200  1.00 14.33           C  
ATOM    675  CZ  PHE A 136      23.052 110.105  12.609  1.00 15.37           C  
ATOM    676  N   GLY A 137      26.001 116.541  10.818  1.00 12.28           N  
ATOM    677  CA  GLY A 137      26.301 117.581   9.923  1.00 13.49           C  
ATOM    678  C   GLY A 137      26.008 117.351   8.467  1.00 12.01           C  
ATOM    679  O   GLY A 137      25.868 118.275   7.700  1.00 14.07           O  
ATOM    680  N   ARG A 138      25.931 116.074   8.085  1.00 12.03           N  
ATOM    681  CA  ARG A 138      25.579 115.620   6.757  1.00 11.59           C  
ATOM    682  C   ARG A 138      24.680 114.383   6.918  1.00 10.42           C  
ATOM    683  O   ARG A 138      24.974 113.530   7.763  1.00 11.52           O  
ATOM    684  CB  ARG A 138      26.794 115.180   5.954  1.00 13.07           C  
ATOM    685  CG  ARG A 138      27.625 116.375   5.492  1.00 14.42           C  
ATOM    686  CD  ARG A 138      28.883 115.908   4.747  1.00 15.82           C  
ATOM    687  NE  ARG A 138      29.547 116.957   4.026  1.00 19.86           N  
ATOM    688  CZ  ARG A 138      29.357 117.332   2.779  1.00 17.75           C  
ATOM    689  NH1 ARG A 138      28.499 116.698   1.987  1.00 16.65           N  
ATOM    690  NH2 ARG A 138      30.105 118.332   2.359  1.00 22.91           N  
ATOM    691  N   VAL A 139      23.629 114.313   6.105  1.00 10.79           N  
ATOM    692  CA  VAL A 139      22.752 113.146   6.098  1.00 10.95           C  
ATOM    693  C   VAL A 139      22.562 112.784   4.646  1.00 10.51           C  
ATOM    694  O   VAL A 139      22.031 113.563   3.843  1.00 11.78           O  
ATOM    695  CB  VAL A 139      21.403 113.354   6.798  1.00 11.76           C  
ATOM    696  CG1 VAL A 139      20.483 112.142   6.573  1.00 14.66           C  
ATOM    697  CG2 VAL A 139      21.607 113.622   8.278  1.00 12.96           C  
ATOM    698  N   GLY A 140      22.955 111.577   4.274  1.00 10.55           N  
ATOM    699  CA  GLY A 140      22.709 111.060   2.963  1.00 11.09           C  
ATOM    700  C   GLY A 140      21.587 110.019   2.960  1.00 10.67           C  
ATOM    701  O   GLY A 140      21.546 109.195   3.866  1.00 13.32           O  
ATOM    702  N   VAL A 141      20.773 110.051   1.948  1.00 11.41           N  
ATOM    703  CA  VAL A 141      19.679 109.117   1.851  1.00 10.82           C  
ATOM    704  C   VAL A 141      20.042 107.979   0.917  1.00 11.57           C  
ATOM    705  O   VAL A 141      20.440 108.197  -0.238  1.00 13.25           O  
ATOM    706  CB  VAL A 141      18.429 109.848   1.343  1.00 12.53           C  
ATOM    707  CG1 VAL A 141      17.332 108.866   1.084  1.00 16.35           C  
ATOM    708  CG2 VAL A 141      18.012 110.912   2.345  1.00 15.01           C  
ATOM    709  N   ASP A 142      19.960 106.752   1.447  1.00 11.28           N  
ATOM    710  CA  ASP A 142      20.258 105.528   0.733  1.00 11.64           C  
ATOM    711  C   ASP A 142      18.952 104.753   0.580  1.00 11.94           C  
ATOM    712  O   ASP A 142      18.699 103.805   1.332  1.00 12.25           O  
ATOM    713  CB  ASP A 142      21.294 104.725   1.468  1.00 13.00           C  
ATOM    714  CG  ASP A 142      21.784 103.495   0.763  1.00 13.73           C  
ATOM    715  OD1 ASP A 142      21.613 103.377  -0.464  1.00 16.80           O  
ATOM    716  OD2 ASP A 142      22.323 102.615   1.492  1.00 15.03           O  
ATOM    717  N   ALA A 143      18.105 105.192  -0.341  1.00 14.05           N  
ATOM    718  CA  ALA A 143      16.751 104.701  -0.386  1.00 15.88           C  
ATOM    719  C   ALA A 143      16.656 103.208  -0.729  1.00 15.63           C  
ATOM    720  O   ALA A 143      15.699 102.564  -0.283  1.00 18.48           O  
ATOM    721  CB  ALA A 143      15.945 105.511  -1.394  1.00 20.87           C  
ATOM    722  N   ASN A 144      17.575 102.724  -1.528  1.00 14.52           N  
ATOM    723  CA  ASN A 144      17.547 101.339  -2.020  1.00 16.81           C  
ATOM    724  C   ASN A 144      18.585 100.477  -1.296  1.00 16.69           C  
ATOM    725  O   ASN A 144      18.657  99.288  -1.576  1.00 21.40           O  
ATOM    726  CB  ASN A 144      17.711 101.257  -3.526  1.00 18.13           C  
ATOM    727  CG  ASN A 144      18.960 101.934  -4.061  1.00 18.65           C  
ATOM    728  OD1 ASN A 144      19.890 102.145  -3.307  1.00 19.87           O  
ATOM    729  ND2 ASN A 144      18.937 102.312  -5.336  1.00 24.76           N  
ATOM    730  N   GLY A 145      19.371 101.020  -0.372  1.00 15.89           N  
ATOM    731  CA  GLY A 145      20.368 100.234   0.336  1.00 16.47           C  
ATOM    732  C   GLY A 145      21.607  99.981  -0.438  1.00 16.25           C  
ATOM    733  O   GLY A 145      22.519  99.314   0.126  1.00 18.14           O  
ATOM    734  N   ARG A 146      21.731 100.458  -1.656  1.00 16.80           N  
ATOM    735  CA  ARG A 146      22.917 100.110  -2.454  1.00 18.08           C  
ATOM    736  C   ARG A 146      24.201 100.721  -1.931  1.00 18.50           C  
ATOM    737  O   ARG A 146      25.292 100.075  -1.982  1.00 19.94           O  
ATOM    738  CB  ARG A 146      22.654 100.523  -3.916  1.00 21.59           C  
ATOM    739  CG  ARG A 146      21.744  99.496  -4.590  1.00 25.97           C  
ATOM    740  CD  ARG A 146      21.678  99.703  -6.101  1.00 33.32           C  
ATOM    741  NE  ARG A 146      22.969  99.268  -6.660  1.00 42.33           N  
ATOM    742  CZ  ARG A 146      23.561  99.708  -7.746  1.00 32.44           C  
ATOM    743  NH1 ARG A 146      23.036 100.643  -8.505  1.00 37.39           N  
ATOM    744  NH2 ARG A 146      24.727  99.231  -8.135  1.00 42.93           N  
ATOM    745  N   ALA A 147      24.151 101.925  -1.372  1.00 16.15           N  
ATOM    746  CA  ALA A 147      25.361 102.490  -0.784  1.00 17.20           C  
ATOM    747  C   ALA A 147      25.782 101.712   0.425  1.00 16.80           C  
ATOM    748  O   ALA A 147      26.961 101.454   0.623  1.00 18.60           O  
ATOM    749  CB  ALA A 147      25.158 103.954  -0.411  1.00 20.81           C  
ATOM    750  N   SER A 148      24.831 101.308   1.249  1.00 16.02           N  
ATOM    751  CA  SER A 148      25.143 100.574   2.474  1.00 17.28           C  
ATOM    752  C   SER A 148      25.788  99.231   2.125  1.00 17.18           C  
ATOM    753  O   SER A 148      26.663  98.790   2.880  1.00 20.10           O  
ATOM    754  CB  SER A 148      23.853 100.439   3.288  1.00 17.97           C  
ATOM    755  OG  SER A 148      23.452 101.715   3.775  1.00 18.94           O  
ATOM    756  N   ILE A 149      25.466  98.599   0.986  1.00 18.51           N  
ATOM    757  CA  ILE A 149      26.168  97.397   0.643  1.00 19.96           C  
ATOM    758  C   ILE A 149      27.649  97.663   0.373  1.00 18.29           C  
ATOM    759  O   ILE A 149      28.521  96.885   0.754  1.00 20.68           O  
ATOM    760  CB  ILE A 149      25.565  96.410  -0.368  1.00 27.20           C  
ATOM    761  CG1 ILE A 149      26.389  95.743  -1.515  1.00 28.66           C  
ATOM    762  CG2 ILE A 149      24.038  96.472  -0.657  1.00 36.37           C  
ATOM    763  CD1 ILE A 149      27.878  96.174  -1.495  0.00 53.63           C  
ATOM    764  N   GLU A 150      27.972  98.797  -0.255  0.75 16.42           N  
ATOM    765  CA  GLU A 150      29.356  99.120  -0.476  0.75 16.64           C  
ATOM    766  C   GLU A 150      30.104  99.321   0.827  0.75 15.87           C  
ATOM    767  O   GLU A 150      31.269  99.038   0.896  0.75 18.32           O  
ATOM    768  CB  GLU A 150      29.604 100.353  -1.400  0.75 20.20           C  
ATOM    770  CG  GLU A 150      29.049 100.188  -2.791  0.75 25.68           C  
ATOM    772  CD  GLU A 150      29.434 101.385  -3.659  0.75 33.77           C  
ATOM    774  OE1 GLU A 150      30.609 101.789  -3.558  0.75 33.32           O  
ATOM    776  OE2 GLU A 150      28.552 101.847  -4.412  0.75 46.42           O  
ATOM    778  N   TRP A 151      29.464  99.835   1.861  1.00 16.34           N  
ATOM    779  CA  TRP A 151      30.037  99.982   3.191  1.00 17.35           C  
ATOM    780  C   TRP A 151      30.118  98.687   3.960  1.00 17.06           C  
ATOM    781  O   TRP A 151      30.671  98.644   5.054  1.00 20.52           O  
ATOM    782  CB  TRP A 151      29.236 101.021   3.969  1.00 15.93           C  
ATOM    783  CG  TRP A 151      29.508 102.442   3.568  1.00 16.05           C  
ATOM    784  CD1 TRP A 151      29.001 103.131   2.492  1.00 18.36           C  
ATOM    785  CD2 TRP A 151      30.367 103.374   4.237  1.00 15.11           C  
ATOM    786  NE1 TRP A 151      29.501 104.420   2.463  1.00 17.97           N  
ATOM    787  CE2 TRP A 151      30.323 104.588   3.517  1.00 16.45           C  
ATOM    788  CE3 TRP A 151      31.157 103.302   5.371  1.00 16.13           C  
ATOM    789  CZ2 TRP A 151      31.029 105.706   3.891  1.00 16.48           C  
ATOM    790  CZ3 TRP A 151      31.883 104.433   5.747  1.00 17.77           C  
ATOM    791  CH2 TRP A 151      31.820 105.624   5.013  1.00 17.00           C  
ATOM    792  N   GLY A 152      29.525  97.600   3.434  1.00 18.68           N  
ATOM    793  CA  GLY A 152      29.565  96.317   4.118  1.00 18.82           C  
ATOM    794  C   GLY A 152      28.531  96.205   5.204  1.00 19.04           C  
ATOM    795  O   GLY A 152      28.772  95.413   6.132  1.00 23.83           O  
ATOM    796  N   VAL A 153      27.444  96.951   5.140  1.00 19.09           N  
ATOM    797  CA  VAL A 153      26.447  96.919   6.209  1.00 21.97           C  
ATOM    798  C   VAL A 153      25.570  95.675   6.184  1.00 24.17           C  
ATOM    799  O   VAL A 153      24.877  95.385   5.222  1.00 30.99           O  
ATOM    800  CB  VAL A 153      25.654  98.228   6.126  1.00 20.81           C  
ATOM    801  CG1 VAL A 153      24.491  98.143   7.090  1.00 22.33           C  
ATOM    802  CG2 VAL A 153      26.604  99.379   6.390  1.00 24.20           C  
ATOM    803  N   TYR A 154      25.567  94.898   7.269  0.50 17.21           N  
ATOM    804  CA  TYR A 154      24.732  93.714   7.385  0.50 20.45           C  
ATOM    805  C   TYR A 154      23.263  94.020   7.656  0.50 18.13           C  
ATOM    806  O   TYR A 154      22.340  93.394   7.208  0.50 22.93           O  
ATOM    807  CB  TYR A 154      25.269  92.799   8.474  0.50 19.63           C  
ATOM    808  N   GLY A 155      23.023  95.078   8.359  0.80 27.31           N  
ATOM    809  CA  GLY A 155      21.681  95.485   8.792  0.80 32.54           C  
ATOM    810  C   GLY A 155      21.921  96.718   9.632  0.80 21.94           C  
ATOM    811  O   GLY A 155      23.057  97.058   9.933  0.80 27.43           O  
ATOM    812  N   VAL A 156      20.886  97.414   9.986  1.00 14.67           N  
ATOM    813  CA  VAL A 156      21.052  98.603  10.804  1.00 12.74           C  
ATOM    814  C   VAL A 156      20.753  98.334  12.259  1.00 11.42           C  
ATOM    815  O   VAL A 156      19.933  97.461  12.594  1.00 13.26           O  
ATOM    816  CB  VAL A 156      20.186  99.756  10.233  1.00 13.68           C  
ATOM    817  CG1 VAL A 156      20.790 100.209   8.900  1.00 17.84           C  
ATOM    818  CG2 VAL A 156      18.717  99.378  10.080  1.00 14.61           C  
ATOM    819  N   PRO A 157      21.384  99.073  13.146  1.00 12.22           N  
ATOM    820  CA  PRO A 157      22.402 100.102  12.879  1.00 11.82           C  
ATOM    821  C   PRO A 157      23.812  99.536  12.851  1.00 11.93           C  
ATOM    822  O   PRO A 157      24.085  98.517  13.491  1.00 13.15           O  
ATOM    823  CB  PRO A 157      22.219 101.016  14.091  1.00 13.57           C  
ATOM    824  CG  PRO A 157      21.835 100.077  15.195  1.00 15.05           C  
ATOM    825  CD  PRO A 157      21.048  98.966  14.605  1.00 14.39           C  
ATOM    826  N   GLU A 158      24.655 100.242  12.131  1.00 12.87           N  
ATOM    827  CA  GLU A 158      26.091 100.033  12.184  1.00 12.96           C  
ATOM    828  C   GLU A 158      26.733 101.405  12.187  1.00 12.61           C  
ATOM    829  O   GLU A 158      26.197 102.356  11.647  1.00 13.20           O  
ATOM    830  CB  GLU A 158      26.567  99.178  11.032  1.00 14.86           C  
ATOM    831  CG  GLU A 158      26.111  97.767  11.085  1.00 17.11           C  
ATOM    832  CD  GLU A 158      26.714  96.822  10.053  1.00 19.76           C  
ATOM    833  OE1 GLU A 158      27.639  97.235   9.347  1.00 24.62           O  
ATOM    834  OE2 GLU A 158      26.200  95.665  10.004  1.00 23.29           O  
ATOM    835  N   THR A 159      27.895 101.471  12.841  1.00 12.38           N  
ATOM    836  CA  THR A 159      28.638 102.710  12.984  1.00 12.58           C  
ATOM    837  C   THR A 159      30.081 102.515  12.568  1.00 12.43           C  
ATOM    838  O   THR A 159      30.721 101.527  12.952  1.00 16.59           O  
ATOM    839  CB  THR A 159      28.521 103.222  14.434  1.00 14.49           C  
ATOM    840  OG1 THR A 159      27.144 103.555  14.639  1.00 15.27           O  
ATOM    841  CG2 THR A 159      29.359 104.433  14.678  1.00 18.44           C  
ATOM    842  N   PHE A 160      30.647 103.477  11.860  1.00 12.83           N  
ATOM    843  CA  PHE A 160      32.027 103.473  11.408  1.00 12.74           C  
ATOM    844  C   PHE A 160      32.727 104.726  11.913  1.00 13.29           C  
ATOM    845  O   PHE A 160      32.154 105.783  12.035  1.00 15.50           O  
ATOM    846  CB  PHE A 160      32.164 103.524   9.877  1.00 14.42           C  
ATOM    847  CG  PHE A 160      31.438 102.395   9.171  1.00 14.63           C  
ATOM    848  CD1 PHE A 160      30.089 102.436   8.940  1.00 16.20           C  
ATOM    849  CD2 PHE A 160      32.143 101.280   8.704  1.00 18.70           C  
ATOM    850  CE1 PHE A 160      29.409 101.403   8.294  1.00 18.04           C  
ATOM    851  CE2 PHE A 160      31.495 100.231   8.062  1.00 19.51           C  
ATOM    852  CZ  PHE A 160      30.125 100.321   7.867  1.00 19.45           C  
ATOM    853  N   VAL A 161      34.017 104.569  12.205  1.00 13.70           N  
ATOM    854  CA  VAL A 161      34.900 105.704  12.436  1.00 13.91           C  
ATOM    855  C   VAL A 161      35.811 105.834  11.228  1.00 14.47           C  
ATOM    856  O   VAL A 161      36.467 104.850  10.867  1.00 15.42           O  
ATOM    857  CB  VAL A 161      35.710 105.520  13.711  1.00 14.61           C  
ATOM    858  CG1 VAL A 161      36.618 106.729  13.898  1.00 18.41           C  
ATOM    859  CG2 VAL A 161      34.807 105.285  14.913  1.00 18.20           C  
ATOM    860  N   VAL A 162      35.877 107.030  10.666  1.00 15.70           N  
ATOM    861  CA  VAL A 162      36.716 107.356   9.503  1.00 15.51           C  
ATOM    862  C   VAL A 162      37.696 108.407   9.930  1.00 15.90           C  
ATOM    863  O   VAL A 162      37.346 109.465  10.466  1.00 17.94           O  
ATOM    864  CB  VAL A 162      35.864 107.823   8.326  1.00 17.18           C  
ATOM    865  CG1 VAL A 162      36.738 108.113   7.084  1.00 20.27           C  
ATOM    866  CG2 VAL A 162      34.819 106.794   7.940  1.00 18.94           C  
ATOM    867  N   GLY A 163      38.972 108.092   9.704  1.00 18.63           N  
ATOM    868  CA  GLY A 163      40.084 108.971  10.093  1.00 22.22           C  
ATOM    869  C   GLY A 163      40.418 110.038   9.109  1.00 18.99           C  
ATOM    870  O   GLY A 163      39.725 110.174   8.098  1.00 20.65           O  
ATOM    871  N   ARG A 164      41.456 110.800   9.428  1.00 22.37           N  
ATOM    872  CA  ARG A 164      41.745 111.997   8.657  1.00 24.20           C  
ATOM    873  C   ARG A 164      42.185 111.697   7.235  1.00 24.22           C  
ATOM    874  O   ARG A 164      42.080 112.583   6.375  1.00 26.38           O  
ATOM    875  CB  ARG A 164      42.806 112.816   9.419  1.00 27.44           C  
ATOM    876  CG  ARG A 164      42.252 113.498  10.646  1.00 27.89           C  
ATOM    877  CD  ARG A 164      43.226 114.364  11.453  1.00 40.08           C  
ATOM    878  NE  ARG A 164      42.510 115.288  12.330  0.00 51.40           N  
ATOM    879  CZ  ARG A 164      42.173 116.531  12.001  0.00 46.23           C  
ATOM    880  NH1 ARG A 164      42.491 117.010  10.805  0.00 32.61           N  
ATOM    881  NH2 ARG A 164      41.522 117.295  12.868  0.00 65.33           N  
ATOM    882  N   GLU A 165      42.684 110.498   6.991  0.77 25.88           N  
ATOM    883  CA  GLU A 165      43.120 110.029   5.671  0.77 30.51           C  
ATOM    884  C   GLU A 165      41.949 109.466   4.896  0.77 29.61           C  
ATOM    885  O   GLU A 165      42.114 109.053   3.749  0.77 29.69           O  
ATOM    886  CB  GLU A 165      44.264 109.001   5.781  0.23 47.25           C  
ATOM    887  CG  GLU A 165      45.352 109.449   6.740  0.23 37.45           C  
ATOM    888  CD  GLU A 165      45.580 108.487   7.887  0.12 80.12           C  
ATOM    889  OE1 GLU A 165      45.250 107.294   7.711  0.12 95.46           O  
ATOM    890  OE2 GLU A 165      46.084 108.930   8.940  0.12 33.79           O  
ATOM    891  N   GLY A 166      40.752 109.492   5.502  1.00 27.08           N  
ATOM    892  CA  GLY A 166      39.601 108.979   4.780  1.00 24.35           C  
ATOM    893  C   GLY A 166      39.485 107.474   4.731  1.00 22.80           C  
ATOM    894  O   GLY A 166      38.816 106.854   3.865  1.00 24.47           O  
ATOM    895  N   THR A 167      40.154 106.846   5.687  1.00 21.10           N  
ATOM    896  CA  THR A 167      40.117 105.389   5.798  1.00 21.62           C  
ATOM    897  C   THR A 167      39.304 105.013   7.063  1.00 20.55           C  
ATOM    898  O   THR A 167      39.177 105.745   8.032  1.00 21.16           O  
ATOM    899  CB  THR A 167      41.498 104.714   5.877  1.00 23.33           C  
ATOM    900  OG1 THR A 167      42.155 105.202   7.045  1.00 32.14           O  
ATOM    901  CG2 THR A 167      42.342 105.040   4.653  1.00 25.53           C  
ATOM    902  N   ILE A 168      38.738 103.809   7.022  1.00 21.27           N  
ATOM    903  CA  ILE A 168      37.909 103.239   8.071  1.00 18.68           C  
ATOM    904  C   ILE A 168      38.853 102.675   9.109  1.00 21.29           C  
ATOM    905  O   ILE A 168      39.597 101.727   8.829  1.00 29.59           O  
ATOM    906  CB  ILE A 168      36.906 102.198   7.533  1.00 19.49           C  
ATOM    907  CG1 ILE A 168      35.891 102.865   6.586  1.00 23.78           C  
ATOM    908  CG2 ILE A 168      36.160 101.495   8.621  1.00 24.15           C  
ATOM    909  CD1 ILE A 168      34.981 101.925   5.860  1.00 25.26           C  
ATOM    910  N   VAL A 169      38.793 103.238  10.286  1.00 18.46           N  
ATOM    911  CA  VAL A 169      39.693 102.776  11.329  1.00 20.71           C  
ATOM    912  C   VAL A 169      38.993 101.929  12.373  1.00 20.29           C  
ATOM    913  O   VAL A 169      39.689 101.232  13.098  1.00 25.18           O  
ATOM    914  CB  VAL A 169      40.457 103.958  11.938  1.00 25.77           C  
ATOM    915  CG1 VAL A 169      41.252 104.746  10.902  1.00 34.39           C  
ATOM    916  CG2 VAL A 169      39.505 104.842  12.695  1.00 27.92           C  
ATOM    917  N   TYR A 170      37.661 101.904  12.436  1.00 19.38           N  
ATOM    918  CA  TYR A 170      36.938 101.101  13.394  1.00 17.95           C  
ATOM    919  C   TYR A 170      35.498 100.937  12.895  1.00 17.19           C  
ATOM    920  O   TYR A 170      34.964 101.834  12.287  1.00 17.09           O  
ATOM    921  CB  TYR A 170      36.951 101.762  14.776  1.00 21.98           C  
ATOM    922  CG  TYR A 170      36.344 100.828  15.822  1.00 25.66           C  
ATOM    923  CD1 TYR A 170      37.040  99.694  16.188  1.00 36.03           C  
ATOM    924  CD2 TYR A 170      35.095 101.105  16.353  1.00 28.68           C  
ATOM    925  CE1 TYR A 170      36.508  98.825  17.130  1.00 36.75           C  
ATOM    926  CE2 TYR A 170      34.560 100.230  17.295  1.00 33.32           C  
ATOM    927  CZ  TYR A 170      35.278  99.117  17.655  1.00 40.53           C  
ATOM    928  OH  TYR A 170      34.796  98.218  18.560  1.00 51.60           O  
ATOM    929  N   LYS A 171      34.901  99.801  13.230  1.00 19.07           N  
ATOM    930  CA  LYS A 171      33.498  99.559  12.979  1.00 19.05           C  
ATOM    931  C   LYS A 171      32.821  98.955  14.208  1.00 18.67           C  
ATOM    932  O   LYS A 171      33.412  98.020  14.800  1.00 21.92           O  
ATOM    933  CB  LYS A 171      33.328  98.592  11.794  1.00 23.92           C  
ATOM    934  CG  LYS A 171      31.887  98.350  11.425  1.00 24.45           C  
ATOM    935  CD  LYS A 171      31.805  97.294  10.365  1.00 31.70           C  
ATOM    936  CE  LYS A 171      30.379  97.276   9.866  1.00 34.89           C  
ATOM    937  NZ  LYS A 171      30.098  96.233   8.848  1.00 26.42           N  
ATOM    938  N   LEU A 172      31.656  99.423  14.515  1.00 19.31           N  
ATOM    939  CA  LEU A 172      30.749  98.894  15.538  1.00 21.00           C  
ATOM    940  C   LEU A 172      29.474  98.343  14.905  1.00 21.32           C  
ATOM    941  O   LEU A 172      28.706  99.012  14.218  1.00 20.88           O  
ATOM    942  CB  LEU A 172      30.468 100.042  16.506  1.00 21.84           C  
ATOM    943  CG  LEU A 172      29.973  99.867  17.950  1.00 39.45           C  
ATOM    944  CD1 LEU A 172      28.742 100.747  18.167  1.00 40.01           C  
ATOM    945  CD2 LEU A 172      29.755  98.443  18.374  1.00 50.58           C  
ATOM    946  N   VAL A 173      29.184  97.063  15.109  1.00 22.69           N  
ATOM    947  CA  VAL A 173      27.943  96.461  14.650  1.00 25.85           C  
ATOM    948  C   VAL A 173      26.963  96.478  15.794  1.00 23.35           C  
ATOM    949  O   VAL A 173      27.244  95.999  16.887  1.00 38.16           O  
ATOM    950  CB  VAL A 173      28.186  95.008  14.194  1.00 31.59           C  
ATOM    951  CG1 VAL A 173      26.872  94.314  13.921  1.00 40.82           C  
ATOM    952  CG2 VAL A 173      29.127  95.042  13.012  1.00 30.74           C  
ATOM    953  N   GLY A 174      25.774  96.984  15.575  1.00 21.33           N  
ATOM    954  CA  GLY A 174      24.809  97.056  16.650  1.00 23.59           C  
ATOM    955  C   GLY A 174      24.748  98.441  17.213  1.00 17.34           C  
ATOM    956  O   GLY A 174      25.475  99.347  16.749  1.00 19.93           O  
ATOM    957  N   PRO A 175      23.843  98.669  18.175  1.00 17.92           N  
ATOM    958  CA  PRO A 175      23.639 100.008  18.634  1.00 17.76           C  
ATOM    959  C   PRO A 175      24.832 100.468  19.467  1.00 17.95           C  
ATOM    960  O   PRO A 175      25.565  99.711  20.143  1.00 17.46           O  
ATOM    961  CB  PRO A 175      22.455  99.858  19.625  1.00 19.67           C  
ATOM    962  CG  PRO A 175      22.482  98.428  20.030  1.00 24.10           C  
ATOM    963  CD  PRO A 175      22.937  97.688  18.799  1.00 19.49           C  
ATOM    964  N   ILE A 176      24.979 101.769  19.520  1.00 16.67           N  
ATOM    965  CA  ILE A 176      25.802 102.476  20.494  1.00 15.13           C  
ATOM    966  C   ILE A 176      25.042 102.388  21.808  1.00 15.47           C  
ATOM    967  O   ILE A 176      23.825 102.565  21.831  1.00 17.07           O  
ATOM    968  CB  ILE A 176      26.002 103.907  20.038  1.00 15.26           C  
ATOM    969  CG1 ILE A 176      26.697 103.949  18.643  1.00 17.00           C  
ATOM    970  CG2 ILE A 176      26.768 104.686  21.066  1.00 17.90           C  
ATOM    971  CD1 ILE A 176      26.654 105.311  17.995  1.00 23.03           C  
ATOM    972  N   THR A 177      25.785 102.077  22.854  1.00 14.85           N  
ATOM    973  CA  THR A 177      25.295 101.992  24.204  1.00 16.20           C  
ATOM    974  C   THR A 177      26.131 102.914  25.074  1.00 15.13           C  
ATOM    975  O   THR A 177      27.200 103.289  24.652  1.00 14.82           O  
ATOM    976  CB  THR A 177      25.361 100.563  24.770  1.00 16.83           C  
ATOM    977  OG1 THR A 177      26.747 100.218  24.921  1.00 16.88           O  
ATOM    978  CG2 THR A 177      24.742  99.543  23.845  1.00 19.50           C  
ATOM    979  N   PRO A 178      25.688 103.224  26.297  1.00 16.04           N  
ATOM    980  CA  PRO A 178      26.559 104.073  27.129  1.00 17.33           C  
ATOM    981  C   PRO A 178      27.939 103.473  27.318  1.00 15.88           C  
ATOM    982  O   PRO A 178      28.969 104.150  27.257  1.00 16.10           O  
ATOM    983  CB  PRO A 178      25.755 104.239  28.416  1.00 19.76           C  
ATOM    984  CG  PRO A 178      24.327 104.108  27.966  1.00 21.72           C  
ATOM    985  CD  PRO A 178      24.402 103.025  26.898  1.00 17.93           C  
ATOM    986  N   ASP A 179      27.995 102.156  27.536  1.00 15.05           N  
ATOM    987  CA  ASP A 179      29.261 101.507  27.824  1.00 14.54           C  
ATOM    988  C   ASP A 179      30.150 101.500  26.577  1.00 14.21           C  
ATOM    989  O   ASP A 179      31.351 101.768  26.706  1.00 16.21           O  
ATOM    990  CB  ASP A 179      29.094 100.097  28.345  1.00 16.42           C  
ATOM    991  CG  ASP A 179      28.691 100.020  29.828  1.00 16.97           C  
ATOM    992  OD1 ASP A 179      29.320 100.727  30.635  1.00 19.31           O  
ATOM    993  OD2 ASP A 179      27.757  99.220  30.049  1.00 22.05           O  
ATOM    994  N   ASN A 180      29.626 101.137  25.390  1.00 14.17           N  
ATOM    995  CA  ASN A 180      30.540 101.114  24.245  1.00 14.23           C  
ATOM    996  C   ASN A 180      30.837 102.525  23.758  1.00 14.04           C  
ATOM    997  O   ASN A 180      31.917 102.721  23.177  1.00 16.58           O  
ATOM    998  CB  ASN A 180      30.083 100.110  23.190  1.00 15.47           C  
ATOM    999  CG  ASN A 180      28.856 100.500  22.404  1.00 14.87           C  
ATOM   1000  OD1 ASN A 180      28.565 101.685  22.201  1.00 16.47           O  
ATOM   1001  ND2 ASN A 180      28.162  99.467  21.909  1.00 18.40           N  
ATOM   1002  N   LEU A 181      30.028 103.517  24.019  1.00 14.69           N  
ATOM   1003  CA  LEU A 181      30.384 104.890  23.663  1.00 15.04           C  
ATOM   1004  C   LEU A 181      31.592 105.354  24.485  1.00 14.99           C  
ATOM   1005  O   LEU A 181      32.596 105.826  23.970  1.00 16.25           O  
ATOM   1006  CB  LEU A 181      29.173 105.792  23.849  1.00 15.71           C  
ATOM   1007  CG  LEU A 181      29.377 107.248  23.457  1.00 22.24           C  
ATOM   1008  CD1 LEU A 181      29.920 107.420  22.048  1.00 25.96           C  
ATOM   1009  CD2 LEU A 181      28.061 107.958  23.488  1.00 32.71           C  
ATOM   1010  N   ARG A 182      31.432 105.177  25.823  1.00 14.69           N  
ATOM   1011  CA  ARG A 182      32.439 105.714  26.725  1.00 16.06           C  
ATOM   1012  C   ARG A 182      33.773 105.012  26.642  1.00 14.01           C  
ATOM   1013  O   ARG A 182      34.831 105.596  26.772  1.00 17.68           O  
ATOM   1014  CB  ARG A 182      31.877 105.692  28.155  1.00 19.51           C  
ATOM   1015  N   SER A 183      33.693 103.680  26.451  1.00 13.95           N  
ATOM   1016  CA  SER A 183      34.874 102.880  26.682  1.00 15.25           C  
ATOM   1017  C   SER A 183      35.432 102.205  25.424  1.00 14.68           C  
ATOM   1018  O   SER A 183      36.454 101.510  25.494  1.00 16.49           O  
ATOM   1019  CB  SER A 183      34.576 101.760  27.728  1.00 16.98           C  
ATOM   1020  OG  SER A 183      34.069 102.375  28.910  1.00 19.11           O  
ATOM   1021  N   VAL A 184      34.761 102.365  24.285  1.00 14.47           N  
ATOM   1022  CA  VAL A 184      35.218 101.775  23.022  1.00 15.48           C  
ATOM   1023  C   VAL A 184      35.231 102.833  21.947  1.00 14.82           C  
ATOM   1024  O   VAL A 184      36.294 103.134  21.378  1.00 16.28           O  
ATOM   1025  CB  VAL A 184      34.371 100.558  22.597  1.00 15.83           C  
ATOM   1026  CG1 VAL A 184      34.912  99.986  21.274  1.00 20.96           C  
ATOM   1027  CG2 VAL A 184      34.341  99.519  23.695  1.00 17.87           C  
ATOM   1028  N   LEU A 185      34.098 103.432  21.625  0.80 11.83           N  
ATOM   1029  CA  LEU A 185      34.046 104.350  20.457  0.80 13.75           C  
ATOM   1030  C   LEU A 185      34.761 105.668  20.690  0.80 12.66           C  
ATOM   1031  O   LEU A 185      35.594 106.056  19.882  0.80 14.82           O  
ATOM   1032  CB  LEU A 185      32.604 104.642  20.083  0.80 17.92           C  
ATOM   1034  CG  LEU A 185      31.913 103.796  19.069  0.80 33.23           C  
ATOM   1036  CD1 LEU A 185      30.527 104.413  18.911  0.80 33.97           C  
ATOM   1038  CD2 LEU A 185      32.568 103.804  17.697  0.80 29.33           C  
ATOM   1040  N   LEU A 186      34.443 106.367  21.771  0.77 12.57           N  
ATOM   1041  CA  LEU A 186      35.101 107.649  22.003  0.77 13.88           C  
ATOM   1042  C   LEU A 186      36.605 107.495  22.151  0.77 14.60           C  
ATOM   1043  O   LEU A 186      37.332 108.285  21.538  0.77 16.32           O  
ATOM   1044  CB  LEU A 186      34.533 108.346  23.232  0.77 18.56           C  
ATOM   1046  CG  LEU A 186      33.451 109.368  22.942  0.77 41.37           C  
ATOM   1048  CD1 LEU A 186      32.891 109.909  24.242  0.77 36.66           C  
ATOM   1050  CD2 LEU A 186      33.922 110.538  22.059  0.77 25.46           C  
ATOM   1052  N   PRO A 187      37.124 106.535  22.889  1.00 15.69           N  
ATOM   1053  CA  PRO A 187      38.609 106.358  22.856  1.00 17.01           C  
ATOM   1054  C   PRO A 187      39.185 106.192  21.449  1.00 17.85           C  
ATOM   1055  O   PRO A 187      40.274 106.706  21.188  1.00 20.74           O  
ATOM   1056  CB  PRO A 187      38.813 105.148  23.753  1.00 20.76           C  
ATOM   1057  CG  PRO A 187      37.622 105.242  24.690  1.00 18.43           C  
ATOM   1058  CD  PRO A 187      36.445 105.713  23.902  1.00 16.71           C  
ATOM   1059  N   GLN A 188      38.520 105.420  20.584  1.00 18.27           N  
ATOM   1060  CA  GLN A 188      39.055 105.206  19.237  1.00 20.12           C  
ATOM   1061  C   GLN A 188      39.008 106.515  18.454  1.00 20.48           C  
ATOM   1062  O   GLN A 188      39.934 106.802  17.678  1.00 24.17           O  
ATOM   1063  CB  GLN A 188      38.332 104.084  18.528  1.00 24.21           C  
ATOM   1064  CG  GLN A 188      38.546 102.679  19.133  1.00 27.28           C  
ATOM   1065  CD  GLN A 188      39.912 102.096  19.038  1.00 63.00           C  
ATOM   1066  OE1 GLN A 188      40.895 102.765  18.754  1.00 71.42           O  
ATOM   1067  NE2 GLN A 188      39.950 100.782  19.302  1.00 45.04           N  
ATOM   1068  N   MET A 189      37.933 107.271  18.609  1.00 16.96           N  
ATOM   1069  CA  MET A 189      37.831 108.562  17.953  1.00 17.86           C  
ATOM   1070  C   MET A 189      38.905 109.537  18.421  1.00 19.05           C  
ATOM   1071  O   MET A 189      39.503 110.250  17.607  1.00 19.36           O  
ATOM   1072  CB  MET A 189      36.446 109.154  18.195  1.00 16.90           C  
ATOM   1073  CG  MET A 189      35.402 108.312  17.492  1.00 17.82           C  
ATOM   1074  SD  MET A 189      33.698 108.697  17.939  1.00 22.42           S  
ATOM   1075  CE  MET A 189      33.532 110.341  17.290  1.00 34.71           C  
ATOM   1076  N   GLU A 190      39.158 109.576  19.702  1.00 19.41           N  
ATOM   1077  CA  GLU A 190      40.215 110.465  20.213  1.00 20.80           C  
ATOM   1078  C   GLU A 190      41.615 110.074  19.739  1.00 22.59           C  
ATOM   1079  O   GLU A 190      42.425 110.953  19.439  1.00 27.58           O  
ATOM   1080  CB  GLU A 190      40.138 110.476  21.746  1.00 23.68           C  
ATOM   1081  CG  GLU A 190      38.840 111.122  22.211  1.00 22.81           C  
ATOM   1082  CD  GLU A 190      38.769 111.389  23.692  0.50 28.42           C  
ATOM   1083  OE1 GLU A 190      39.282 110.536  24.441  0.50 25.85           O  
ATOM   1084  OE2 GLU A 190      38.214 112.436  24.075  0.50 27.73           O  
ATOM   1085  N   LYS A 191      41.840 108.778  19.648  0.80 20.52           N  
ATOM   1086  CA  LYS A 191      43.132 108.324  19.160  0.80 21.65           C  
ATOM   1087  C   LYS A 191      43.322 108.805  17.725  0.80 20.47           C  
ATOM   1088  O   LYS A 191      44.442 109.081  17.358  0.80 28.03           O  
ATOM   1089  CB  LYS A 191      43.281 106.807  19.274  0.80 26.37           C  
ATOM   1090  CG  LYS A 191      43.445 106.303  20.703  0.80 30.66           C  
ATOM   1091  CD  LYS A 191      43.425 104.797  20.830  0.80 42.64           C  
ATOM   1092  CE  LYS A 191      43.581 104.381  22.271  0.80 40.85           C  
ATOM   1093  NZ  LYS A 191      44.836 103.716  22.621  0.80 45.99           N  
ATOM   1094  N   ALA A 192      42.262 108.867  16.921  1.00 22.58           N  
ATOM   1095  CA  ALA A 192      42.346 109.218  15.503  1.00 21.29           C  
ATOM   1096  C   ALA A 192      42.565 110.715  15.266  1.00 23.14           C  
ATOM   1097  O   ALA A 192      42.972 111.179  14.192  1.00 26.16           O  
ATOM   1098  CB  ALA A 192      41.063 108.786  14.818  1.00 22.36           C  
ATOM   1099  N   LEU A 193      42.366 111.516  16.309  1.00 23.41           N  
ATOM   1100  CA  LEU A 193      42.682 112.919  16.258  1.00 29.52           C  
ATOM   1101  C   LEU A 193      44.242 113.102  16.380  1.00 36.73           C  
ATOM   1102  O   LEU A 193      44.532 114.199  15.876  1.00 39.39           O  
ATOM   1103  CB  LEU A 193      42.038 113.770  17.351  1.00 28.32           C  
ATOM   1104  CG  LEU A 193      40.534 113.839  17.399  1.00 25.33           C  
ATOM   1105  CD1 LEU A 193      40.087 114.263  18.789  1.00 29.94           C  
ATOM   1106  CD2 LEU A 193      39.999 114.775  16.328  1.00 28.73           C  
TER    1107      LEU A 193                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
