
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  155 ( 1230),  selected  155 , name 2p31_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2p31_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E       1           -
LGA    -       -      N       2           -
LGA    -       -      L       3           -
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    -       -      Q       6           -
LGA    -       -      S       7           -
LGA    -       -      M       8           -
LGA    Q    23_A      I       9          1.755
LGA    D    24_A      N      10          2.848
LGA    -       -      S      11           -
LGA    F    25_A      F      12          0.517
LGA    Y    26_A      Y      13          0.686
LGA    D    27_A      A      14          0.661
LGA    F    28_A      F      15          0.624
LGA    K    29_A      E      16          0.690
LGA    A    30_A      V      17          0.380
LGA    V    31_A      K      18          0.415
LGA    N    32_A      D      19          0.686
LGA    I    33_A      A      20          0.854
LGA    R    34_A      K      21          2.045
LGA    G    35_A      G      22          1.870
LGA    K    36_A      R      23          1.764
LGA    L    37_A      T      24          0.898
LGA    V    38_A      V      25          0.487
LGA    S    39_A      S      26          0.471
LGA    L    40_A      L      27          0.582
LGA    E    41_A      E      28          0.740
LGA    K    42_A      K      29          0.793
LGA    Y    43_A      Y      30          0.564
LGA    R    44_A      K      31          0.615
LGA    G    45_A      G      32          0.512
LGA    S    46_A      K      33          0.557
LGA    V    47_A      V      34          0.532
LGA    S    48_A      S      35          0.437
LGA    L    49_A      L      36          0.398
LGA    V    50_A      V      37          0.403
LGA    V    51_A      V      38          0.311
LGA    N    52_A      N      39          0.286
LGA    V    53_A      V      40          0.203
LGA    A    54_A      A      41          0.276
LGA    S    55_A      S      42          0.317
LGA    E    56_A      D      43          0.593
LGA    C    57_A      C      44          0.478
LGA    G    58_A      Q      45          0.367
LGA    F    59_A      L      46          0.379
LGA    T    60_A      T      47          0.285
LGA    D    61_A      D      48          0.364
LGA    Q    62_A      R      49          0.628
LGA    H    63_A      N      50          0.422
LGA    Y    64_A      Y      51          0.231
LGA    R    65_A      L      52          0.522
LGA    A    66_A      G      53          0.587
LGA    L    67_A      L      54          0.451
LGA    Q    68_A      K      55          0.710
LGA    Q    69_A      E      56          0.859
LGA    L    70_A      L      57          0.739
LGA    Q    71_A      H      58          0.649
LGA    R    72_A      K      59          0.353
LGA    D    73_A      E      60          0.275
LGA    L    74_A      F      61          0.632
LGA    G    75_A      G      62          0.340
LGA    P    76_A      P      63          4.119
LGA    H    77_A      S      64          4.877
LGA    H    78_A      H      65          0.860
LGA    F    79_A      F      66          0.406
LGA    N    80_A      S      67          0.326
LGA    V    81_A      V      68          0.268
LGA    L    82_A      L      69          0.217
LGA    A    83_A      A      70          0.162
LGA    F    84_A      F      71          0.342
LGA    P    85_A      P      72          0.315
LGA    C    86_A      C      73          0.109
LGA    N    87_A      N      74          0.061
LGA    Q    88_A      Q      75          0.168
LGA    F    89_A      F      76          0.179
LGA    G    90_A      G      77          0.148
LGA    Q    91_A      E      78          0.238
LGA    Q    92_A      S      79          0.406
LGA    E    93_A      E      80          0.195
LGA    P    94_A      P      81          0.296
LGA    D    95_A      R      82          0.285
LGA    S    96_A      P      83          0.550
LGA    N    97_A      S      84          0.970
LGA    K    98_A      K      85          1.641
LGA    E    99_A      E      86          1.172
LGA    I   100_A      V      87          0.649
LGA    E   101_A      E      88          0.994
LGA    S   102_A      S      89          1.114
LGA    F   103_A      F      90          0.599
LGA    A   104_A      A      91          0.305
LGA    R   105_A      R      92          0.276
LGA    R   106_A      K      93          0.447
LGA    T   107_A      N      94          0.153
LGA    Y   108_A      Y      95          0.257
LGA    S   109_A      G      96          0.191
LGA    V   110_A      V      97          0.993
LGA    S   111_A      T      98          0.307
LGA    F   112_A      F      99          0.142
LGA    P   113_A      P     100          0.791
LGA    M   114_A      I     101          0.959
LGA    F   115_A      F     102          0.388
LGA    S   116_A      H     103          0.313
LGA    K   117_A      K     104          0.216
LGA    I   118_A      I     105          0.242
LGA    A   119_A      K     106          0.883
LGA    V   120_A      I     107          1.533
LGA    T   121_A      L     108          2.005
LGA    G   122_A      G     109          1.896
LGA    T   123_A      S     110          1.460
LGA    G   124_A      E     111          1.021
LGA    A   125_A      G     112          0.828
LGA    H   126_A      E     113          0.485
LGA    P   127_A      P     114          0.438
LGA    A   128_A      A     115          0.966
LGA    F   129_A      F     116          1.284
LGA    K   130_A      R     117          1.233
LGA    Y   131_A      F     118          0.920
LGA    L   132_A      L     119          0.782
LGA    A   133_A      V     120          0.826
LGA    Q   134_A      D     121          0.850
LGA    T   135_A      S     122          1.138
LGA    S   136_A      S     123          0.768
LGA    G   137_A      K     124          0.914
LGA    K   138_A      K     125          0.627
LGA    E   139_A      E     126          0.915
LGA    P   140_A      P     127          0.651
LGA    T   141_A      R     128          0.697
LGA    W   142_A      W     129          0.469
LGA    N   143_A      N     130          0.102
LGA    F   144_A      F     131          0.273
LGA    W   145_A      W     132          0.437
LGA    K   146_A      K     133          0.315
LGA    Y   147_A      Y     134          0.266
LGA    L   148_A      L     135          0.228
LGA    V   149_A      V     136          0.132
LGA    A   150_A      N     137          0.195
LGA    P   151_A      P     138          0.305
LGA    D   152_A      E     139          0.311
LGA    G   153_A      G     140          0.316
LGA    K   154_A      Q     141          0.266
LGA    V   155_A      V     142          0.157
LGA    V   156_A      V     143          0.336
LGA    G   157_A      K     144          0.568
LGA    A   158_A      F     145          0.656
LGA    W   159_A      W     146          0.826
LGA    D   160_A      R     147          1.062
LGA    P   161_A      P     148          0.649
LGA    T   162_A      E     149          0.337
LGA    V   163_A      E     150          0.445
LGA    S   164_A      P     151          0.699
LGA    V   165_A      I     152          1.362
LGA    E   166_A      E     153          1.500
LGA    E   167_A      V     154          0.881
LGA    V   168_A      I     155          0.688
LGA    R   169_A      R     156          1.171
LGA    P   170_A      P     157          0.905
LGA    Q   171_A      D     158          0.728
LGA    I   172_A      I     159          0.876
LGA    T   173_A      A     160          0.932
LGA    A   174_A      A     161          0.941
LGA    L   175_A      L     162          0.582
LGA    V   176_A      V     163          0.751
LGA    R   177_A      R     164          2.738
LGA    -       -      Q     165           -
LGA    -       -      V     166           -
LGA    -       -      I     167           -
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  155  174    5.0    155    0.96    56.13     87.356    14.681

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.408425 * X  +   0.242893 * Y  +  -0.879882 * Z  +  -8.158902
  Y_new =   0.024072 * X  +   0.960744 * Y  +   0.276389 * Z  + 120.914696
  Z_new =   0.912474 * X  +  -0.134065 * Y  +   0.386545 * Z  +  33.144432 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.333847    2.807746  [ DEG:   -19.1280    160.8720 ]
  Theta =  -1.149291   -1.992301  [ DEG:   -65.8495   -114.1505 ]
  Phi   =   0.058871   -3.082722  [ DEG:     3.3731   -176.6269 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p31_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p31_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  155  174   5.0  155   0.96   56.13  87.356
REMARK  ---------------------------------------------------------- 
MOLECULE 2p31_A
HEADER    OXIDOREDUCTASE                          08-MAR-07   2P31              
TITLE     CRYSTAL STRUCTURE OF HUMAN GLUTATHIONE PEROXIDASE 7                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLUTATHIONE PEROXIDASE 7;                                  
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: CL683;                                                      
COMPND   5 EC: 1.11.1.9;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: GPX7, GPX6;                                                    
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC-BSA4                                 
KEYWDS    THIOREDOXIN FOLD, NPGPX, PHOSPHOLIPID HYDROPEROXIDASE,                
KEYWDS   2 STRUCTURAL GENOMICS, STRUCTURAL GENOMICS CONSORTIUM, SGC             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.L.KAVANAGH,C.JOHANSSON,E.PAPAGRIGORIOU,G.KOCHAN,C.UMEANO,           
AUTHOR   2 O.GILEADI,F.VON DELFT,J.WEIGELT,C.H.ARROWSMITH,M.SUNDSTROM,          
AUTHOR   3 A.EDWARDS,U.OPPERMANN,STRUCTURAL GENOMICS CONSORTIUM (SGC)           
REVDAT   1   20-MAR-07 2P31    0                                                
JRNL        AUTH   K.L.KAVANAGH,U.OPPERMANN                                     
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN GLUTATHIONE PEROXIDASE 7          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2P31 A   20   177  UNP    Q96SL4   GPX7_HUMAN      20    177             
DBREF  2P31 B   20   177  UNP    Q96SL4   GPX7_HUMAN      20    177             
SEQRES   1 A  181  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  181  GLY THR GLU ASN LEU TYR PHE GLN SER MET GLN GLN GLU          
SEQRES   3 A  181  GLN ASP PHE TYR ASP PHE LYS ALA VAL ASN ILE ARG GLY          
SEQRES   4 A  181  LYS LEU VAL SER LEU GLU LYS TYR ARG GLY SER VAL SER          
SEQRES   5 A  181  LEU VAL VAL ASN VAL ALA SER GLU CYS GLY PHE THR ASP          
SEQRES   6 A  181  GLN HIS TYR ARG ALA LEU GLN GLN LEU GLN ARG ASP LEU          
SEQRES   7 A  181  GLY PRO HIS HIS PHE ASN VAL LEU ALA PHE PRO CYS ASN          
SEQRES   8 A  181  GLN PHE GLY GLN GLN GLU PRO ASP SER ASN LYS GLU ILE          
SEQRES   9 A  181  GLU SER PHE ALA ARG ARG THR TYR SER VAL SER PHE PRO          
SEQRES  10 A  181  MET PHE SER LYS ILE ALA VAL THR GLY THR GLY ALA HIS          
SEQRES  11 A  181  PRO ALA PHE LYS TYR LEU ALA GLN THR SER GLY LYS GLU          
SEQRES  12 A  181  PRO THR TRP ASN PHE TRP LYS TYR LEU VAL ALA PRO ASP          
SEQRES  13 A  181  GLY LYS VAL VAL GLY ALA TRP ASP PRO THR VAL SER VAL          
SEQRES  14 A  181  GLU GLU VAL ARG PRO GLN ILE THR ALA LEU VAL ARG              
SEQRES   1 B  181  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 B  181  GLY THR GLU ASN LEU TYR PHE GLN SER MET GLN GLN GLU          
SEQRES   3 B  181  GLN ASP PHE TYR ASP PHE LYS ALA VAL ASN ILE ARG GLY          
SEQRES   4 B  181  LYS LEU VAL SER LEU GLU LYS TYR ARG GLY SER VAL SER          
SEQRES   5 B  181  LEU VAL VAL ASN VAL ALA SER GLU CYS GLY PHE THR ASP          
SEQRES   6 B  181  GLN HIS TYR ARG ALA LEU GLN GLN LEU GLN ARG ASP LEU          
SEQRES   7 B  181  GLY PRO HIS HIS PHE ASN VAL LEU ALA PHE PRO CYS ASN          
SEQRES   8 B  181  GLN PHE GLY GLN GLN GLU PRO ASP SER ASN LYS GLU ILE          
SEQRES   9 B  181  GLU SER PHE ALA ARG ARG THR TYR SER VAL SER PHE PRO          
SEQRES  10 B  181  MET PHE SER LYS ILE ALA VAL THR GLY THR GLY ALA HIS          
SEQRES  11 B  181  PRO ALA PHE LYS TYR LEU ALA GLN THR SER GLY LYS GLU          
SEQRES  12 B  181  PRO THR TRP ASN PHE TRP LYS TYR LEU VAL ALA PRO ASP          
SEQRES  13 B  181  GLY LYS VAL VAL GLY ALA TRP ASP PRO THR VAL SER VAL          
SEQRES  14 B  181  GLU GLU VAL ARG PRO GLN ILE THR ALA LEU VAL ARG              
HET     CL    201       1                                                       
HET     CL    202       1                                                       
HETNAM      CL CHLORIDE ION                                                     
FORMUL   3   CL    2(CL 1-)                                                     
FORMUL   5  HOH   *144(H2 O)                                                    
CRYST1   32.046   56.224   94.593  90.00  91.27  90.00 P 1 21 1      4          
ATOM      1  N   GLN A  23      41.177 104.881  -4.098  1.00 34.48           N  
ATOM      2  CA  GLN A  23      39.761 105.049  -3.593  1.00 37.29           C  
ATOM      3  C   GLN A  23      39.633 104.963  -2.067  1.00 32.75           C  
ATOM      4  O   GLN A  23      40.222 104.090  -1.413  1.00 27.83           O  
ATOM      5  CB  GLN A  23      38.794 104.020  -4.211  1.00 39.91           C  
ATOM      6  CG  GLN A  23      38.370 104.327  -5.637  1.00 51.79           C  
ATOM      7  CD  GLN A  23      37.222 105.311  -5.730  1.00 60.72           C  
ATOM      8  OE1 GLN A  23      36.184 105.128  -5.103  1.00 65.03           O  
ATOM      9  NE2 GLN A  23      37.395 106.352  -6.540  1.00 56.44           N  
ATOM     10  N   ASP A  24      38.832 105.877  -1.513  1.00 25.12           N  
ATOM     11  CA  ASP A  24      38.522 105.878  -0.105  1.00 20.32           C  
ATOM     12  C   ASP A  24      37.086 106.405   0.059  1.00 18.18           C  
ATOM     13  O   ASP A  24      36.434 106.769  -0.914  1.00 13.59           O  
ATOM     14  CB  ASP A  24      39.564 106.678   0.694  1.00 15.70           C  
ATOM     15  CG  ASP A  24      39.623 108.160   0.294  1.00 17.93           C  
ATOM     16  OD1 ASP A  24      38.658 108.922   0.522  1.00 20.59           O  
ATOM     17  OD2 ASP A  24      40.651 108.571  -0.245  1.00 18.33           O  
ATOM     18  N   PHE A  25      36.606 106.404   1.281  1.00 15.16           N  
ATOM     19  CA  PHE A  25      35.200 106.737   1.546  1.00 16.19           C  
ATOM     20  C   PHE A  25      34.832 108.170   1.105  1.00 17.50           C  
ATOM     21  O   PHE A  25      33.694 108.442   0.726  1.00 14.08           O  
ATOM     22  CB  PHE A  25      34.909 106.613   3.051  1.00 11.60           C  
ATOM     23  CG  PHE A  25      33.466 106.877   3.393  1.00 14.55           C  
ATOM     24  CD1 PHE A  25      32.503 105.912   3.163  1.00 13.63           C  
ATOM     25  CD2 PHE A  25      33.072 108.104   3.894  1.00 12.97           C  
ATOM     26  CE1 PHE A  25      31.153 106.166   3.443  1.00 16.28           C  
ATOM     27  CE2 PHE A  25      31.713 108.374   4.189  1.00 11.60           C  
ATOM     28  CZ  PHE A  25      30.767 107.386   3.966  1.00 16.15           C  
ATOM     29  N   TYR A  26      35.795 109.087   1.186  1.00 15.56           N  
ATOM     30  CA  TYR A  26      35.530 110.469   0.893  1.00 12.61           C  
ATOM     31  C   TYR A  26      35.628 110.766  -0.608  1.00 11.05           C  
ATOM     32  O   TYR A  26      35.617 111.912  -1.001  1.00 16.24           O  
ATOM     33  CB  TYR A  26      36.448 111.365   1.693  1.00 10.35           C  
ATOM     34  CG  TYR A  26      36.274 111.301   3.203  1.00  8.68           C  
ATOM     35  CD1 TYR A  26      35.014 111.257   3.780  1.00 12.27           C  
ATOM     36  CD2 TYR A  26      37.367 111.332   4.044  1.00 12.12           C  
ATOM     37  CE1 TYR A  26      34.840 111.232   5.134  1.00  6.75           C  
ATOM     38  CE2 TYR A  26      37.201 111.325   5.446  1.00  7.75           C  
ATOM     39  CZ  TYR A  26      35.925 111.302   5.979  1.00 10.80           C  
ATOM     40  OH  TYR A  26      35.738 111.263   7.357  1.00 10.13           O  
ATOM     41  N   ASP A  27      35.652 109.737  -1.440  1.00 11.42           N  
ATOM     42  CA  ASP A  27      35.642 109.914  -2.886  1.00 16.34           C  
ATOM     43  C   ASP A  27      34.211 109.753  -3.397  1.00 17.64           C  
ATOM     44  O   ASP A  27      33.940 109.987  -4.574  1.00 15.03           O  
ATOM     45  CB  ASP A  27      36.540 108.866  -3.561  1.00 22.60           C  
ATOM     46  CG  ASP A  27      38.026 109.166  -3.425  1.00 21.76           C  
ATOM     47  OD1 ASP A  27      38.436 110.342  -3.370  1.00 23.03           O  
ATOM     48  OD2 ASP A  27      38.791 108.201  -3.431  1.00 24.12           O  
ATOM     49  N   PHE A  28      33.295 109.297  -2.531  1.00 18.23           N  
ATOM     50  CA  PHE A  28      31.954 108.965  -2.982  1.00 17.79           C  
ATOM     51  C   PHE A  28      31.020 110.197  -2.882  1.00 18.64           C  
ATOM     52  O   PHE A  28      31.353 111.206  -2.235  1.00 13.89           O  
ATOM     53  CB  PHE A  28      31.418 107.728  -2.250  1.00 14.03           C  
ATOM     54  CG  PHE A  28      32.193 106.481  -2.552  1.00 11.89           C  
ATOM     55  CD1 PHE A  28      31.989 105.802  -3.745  1.00 15.25           C  
ATOM     56  CD2 PHE A  28      33.133 106.001  -1.664  1.00 16.40           C  
ATOM     57  CE1 PHE A  28      32.730 104.672  -4.051  1.00 13.12           C  
ATOM     58  CE2 PHE A  28      33.879 104.877  -1.940  1.00 10.85           C  
ATOM     59  CZ  PHE A  28      33.677 104.207  -3.153  1.00 13.76           C  
ATOM     60  N   LYS A  29      29.875 110.106  -3.555  1.00 19.38           N  
ATOM     61  CA  LYS A  29      28.842 111.150  -3.508  1.00 16.31           C  
ATOM     62  C   LYS A  29      27.522 110.553  -3.056  1.00 16.41           C  
ATOM     63  O   LYS A  29      27.269 109.374  -3.289  1.00 16.42           O  
ATOM     64  CB  LYS A  29      28.662 111.750  -4.907  1.00 14.22           C  
ATOM     65  CG  LYS A  29      29.910 112.382  -5.468  1.00 18.34           C  
ATOM     66  CD  LYS A  29      29.560 113.459  -6.468  1.00 23.62           C  
ATOM     67  CE  LYS A  29      28.955 112.922  -7.746  1.00 21.56           C  
ATOM     68  NZ  LYS A  29      29.897 112.140  -8.561  1.00 22.88           N  
ATOM     69  N   ALA A  30      26.683 111.370  -2.415  1.00 15.63           N  
ATOM     70  CA  ALA A  30      25.418 110.894  -1.871  1.00 13.61           C  
ATOM     71  C   ALA A  30      24.436 112.029  -1.913  1.00 14.04           C  
ATOM     72  O   ALA A  30      24.824 113.189  -1.692  1.00 16.11           O  
ATOM     73  CB  ALA A  30      25.607 110.387  -0.403  1.00 17.00           C  
ATOM     74  N   VAL A  31      23.169 111.712  -2.181  1.00 12.14           N  
ATOM     75  CA  VAL A  31      22.117 112.701  -2.079  1.00 13.42           C  
ATOM     76  C   VAL A  31      21.792 112.860  -0.588  1.00 14.67           C  
ATOM     77  O   VAL A  31      21.511 111.892   0.089  1.00 16.58           O  
ATOM     78  CB  VAL A  31      20.895 112.323  -2.930  1.00 14.67           C  
ATOM     79  CG1 VAL A  31      19.753 113.311  -2.751  1.00  8.26           C  
ATOM     80  CG2 VAL A  31      21.292 112.217  -4.431  1.00  9.91           C  
ATOM     81  N   ASN A  32      21.846 114.101  -0.099  1.00 14.51           N  
ATOM     82  CA  ASN A  32      21.488 114.391   1.258  1.00 15.31           C  
ATOM     83  C   ASN A  32      19.957 114.230   1.454  1.00  9.57           C  
ATOM     84  O   ASN A  32      19.217 114.015   0.490  1.00 10.66           O  
ATOM     85  CB  ASN A  32      22.124 115.728   1.763  1.00 15.24           C  
ATOM     86  CG  ASN A  32      21.345 116.992   1.395  1.00 16.18           C  
ATOM     87  OD1 ASN A  32      20.258 116.948   0.827  1.00 23.03           O  
ATOM     88  ND2 ASN A  32      21.937 118.152   1.718  1.00 14.64           N  
ATOM     89  N   ILE A  33      19.510 114.254   2.704  1.00  9.59           N  
ATOM     90  CA  ILE A  33      18.092 114.003   3.025  1.00 13.58           C  
ATOM     91  C   ILE A  33      17.107 115.037   2.505  1.00 14.24           C  
ATOM     92  O   ILE A  33      15.907 114.760   2.393  1.00 12.78           O  
ATOM     93  CB  ILE A  33      17.864 113.825   4.565  1.00 15.34           C  
ATOM     94  CG1 ILE A  33      16.614 112.948   4.821  1.00 13.98           C  
ATOM     95  CG2 ILE A  33      17.786 115.204   5.260  1.00  8.07           C  
ATOM     96  CD1 ILE A  33      16.659 112.140   6.146  1.00  8.32           C  
ATOM     97  N   ARG A  34      17.585 116.236   2.213  1.00 14.75           N  
ATOM     98  CA  ARG A  34      16.748 117.261   1.587  1.00 13.57           C  
ATOM     99  C   ARG A  34      16.805 117.202   0.048  1.00 14.76           C  
ATOM    100  O   ARG A  34      16.259 118.045  -0.605  1.00 15.11           O  
ATOM    101  CB  ARG A  34      17.169 118.636   2.045  1.00 12.82           C  
ATOM    102  CG  ARG A  34      17.155 118.773   3.546  1.00 18.74           C  
ATOM    103  CD  ARG A  34      17.431 120.194   3.956  1.00 27.13           C  
ATOM    104  NE  ARG A  34      17.541 120.310   5.410  1.00 38.45           N  
ATOM    105  CZ  ARG A  34      17.751 121.452   6.063  1.00 46.42           C  
ATOM    106  NH1 ARG A  34      17.888 122.603   5.411  1.00 52.01           N  
ATOM    107  NH2 ARG A  34      17.834 121.438   7.390  1.00 51.52           N  
ATOM    108  N   GLY A  35      17.495 116.220  -0.525  1.00 16.58           N  
ATOM    109  CA  GLY A  35      17.473 116.034  -1.971  1.00 13.69           C  
ATOM    110  C   GLY A  35      18.596 116.721  -2.701  1.00 12.85           C  
ATOM    111  O   GLY A  35      18.574 116.796  -3.946  1.00 13.86           O  
ATOM    112  N   LYS A  36      19.582 117.209  -1.963  1.00 12.31           N  
ATOM    113  CA  LYS A  36      20.711 117.881  -2.585  1.00 15.16           C  
ATOM    114  C   LYS A  36      21.867 116.895  -2.677  1.00 14.20           C  
ATOM    115  O   LYS A  36      22.296 116.318  -1.661  1.00 14.45           O  
ATOM    116  CB  LYS A  36      21.156 119.116  -1.792  1.00 10.66           C  
ATOM    117  CG  LYS A  36      22.395 119.806  -2.383  1.00 15.95           C  
ATOM    118  CD  LYS A  36      22.748 121.097  -1.663  1.00 18.74           C  
ATOM    119  CE  LYS A  36      23.179 120.806  -0.251  1.00 17.41           C  
ATOM    120  NZ  LYS A  36      23.957 121.944   0.310  1.00 28.06           N  
ATOM    121  N   LEU A  37      22.371 116.704  -3.889  1.00 14.11           N  
ATOM    122  CA  LEU A  37      23.572 115.876  -4.105  1.00 17.07           C  
ATOM    123  C   LEU A  37      24.798 116.542  -3.496  1.00 16.68           C  
ATOM    124  O   LEU A  37      25.030 117.731  -3.696  1.00 16.61           O  
ATOM    125  CB  LEU A  37      23.829 115.630  -5.607  1.00 17.70           C  
ATOM    126  CG  LEU A  37      25.056 114.741  -5.956  1.00 16.10           C  
ATOM    127  CD1 LEU A  37      24.952 113.317  -5.428  1.00 13.60           C  
ATOM    128  CD2 LEU A  37      25.222 114.712  -7.429  1.00 13.77           C  
ATOM    129  N   VAL A  38      25.592 115.752  -2.780  1.00 15.47           N  
ATOM    130  CA  VAL A  38      26.812 116.244  -2.159  1.00 14.86           C  
ATOM    131  C   VAL A  38      27.967 115.280  -2.419  1.00 17.91           C  
ATOM    132  O   VAL A  38      27.736 114.067  -2.624  1.00 15.04           O  
ATOM    133  CB  VAL A  38      26.644 116.537  -0.638  1.00 15.06           C  
ATOM    134  CG1 VAL A  38      25.429 117.478  -0.389  1.00 12.10           C  
ATOM    135  CG2 VAL A  38      26.553 115.283   0.211  1.00 15.11           C  
ATOM    136  N   SER A  39      29.182 115.852  -2.430  1.00 14.46           N  
ATOM    137  CA  SER A  39      30.413 115.106  -2.463  1.00 10.96           C  
ATOM    138  C   SER A  39      30.898 114.840  -1.051  1.00 17.90           C  
ATOM    139  O   SER A  39      31.008 115.746  -0.241  1.00 14.40           O  
ATOM    140  CB  SER A  39      31.495 115.856  -3.202  1.00 11.78           C  
ATOM    141  OG  SER A  39      32.618 115.009  -3.344  1.00 12.11           O  
ATOM    142  N   LEU A  40      31.203 113.590  -0.753  1.00 15.58           N  
ATOM    143  CA  LEU A  40      31.752 113.267   0.575  1.00 15.96           C  
ATOM    144  C   LEU A  40      33.151 113.785   0.744  1.00 14.74           C  
ATOM    145  O   LEU A  40      33.647 113.807   1.867  1.00 17.77           O  
ATOM    146  CB  LEU A  40      31.666 111.773   0.865  1.00 14.25           C  
ATOM    147  CG  LEU A  40      30.249 111.198   0.885  1.00 21.36           C  
ATOM    148  CD1 LEU A  40      30.321 109.719   1.259  1.00 24.15           C  
ATOM    149  CD2 LEU A  40      29.358 111.983   1.829  1.00 23.68           C  
ATOM    150  N   GLU A  41      33.754 114.273  -0.351  1.00 13.88           N  
ATOM    151  CA  GLU A  41      34.990 115.050  -0.296  1.00 17.44           C  
ATOM    152  C   GLU A  41      34.899 116.201   0.688  1.00 15.00           C  
ATOM    153  O   GLU A  41      35.908 116.601   1.208  1.00 13.23           O  
ATOM    154  CB  GLU A  41      35.377 115.649  -1.651  1.00 18.04           C  
ATOM    155  CG  GLU A  41      35.790 114.648  -2.710  1.00 16.21           C  
ATOM    156  CD  GLU A  41      37.281 114.276  -2.721  1.00 19.76           C  
ATOM    157  OE1 GLU A  41      37.957 114.363  -1.683  1.00 24.78           O  
ATOM    158  OE2 GLU A  41      37.771 113.897  -3.801  1.00 29.00           O  
ATOM    159  N   LYS A  42      33.704 116.748   0.938  1.00 14.80           N  
ATOM    160  CA  LYS A  42      33.580 117.878   1.845  1.00 12.75           C  
ATOM    161  C   LYS A  42      34.000 117.482   3.296  1.00 16.55           C  
ATOM    162  O   LYS A  42      34.231 118.364   4.113  1.00 12.14           O  
ATOM    163  CB  LYS A  42      32.142 118.373   1.868  1.00 13.11           C  
ATOM    164  CG  LYS A  42      31.133 117.376   2.469  1.00 12.68           C  
ATOM    165  CD  LYS A  42      29.696 117.640   2.053  1.00 14.52           C  
ATOM    166  CE  LYS A  42      29.196 118.949   2.583  1.00 20.58           C  
ATOM    167  NZ  LYS A  42      27.801 119.130   2.138  1.00 12.20           N  
ATOM    168  N   TYR A  43      34.023 116.172   3.592  1.00 15.37           N  
ATOM    169  CA  TYR A  43      34.400 115.618   4.902  1.00 15.78           C  
ATOM    170  C   TYR A  43      35.866 115.117   4.976  1.00 14.39           C  
ATOM    171  O   TYR A  43      36.309 114.669   6.016  1.00 15.36           O  
ATOM    172  CB  TYR A  43      33.436 114.477   5.279  1.00 15.12           C  
ATOM    173  CG  TYR A  43      31.981 114.947   5.324  1.00 17.59           C  
ATOM    174  CD1 TYR A  43      31.569 115.903   6.238  1.00 19.82           C  
ATOM    175  CD2 TYR A  43      31.044 114.468   4.428  1.00 11.20           C  
ATOM    176  CE1 TYR A  43      30.263 116.370   6.249  1.00 15.22           C  
ATOM    177  CE2 TYR A  43      29.727 114.905   4.464  1.00 16.41           C  
ATOM    178  CZ  TYR A  43      29.348 115.875   5.353  1.00 17.53           C  
ATOM    179  OH  TYR A  43      28.028 116.348   5.368  1.00 20.41           O  
ATOM    180  N   ARG A  44      36.626 115.204   3.902  1.00 16.64           N  
ATOM    181  CA  ARG A  44      38.028 114.787   3.968  1.00 15.47           C  
ATOM    182  C   ARG A  44      38.821 115.651   4.961  1.00 18.81           C  
ATOM    183  O   ARG A  44      38.653 116.863   5.019  1.00 13.55           O  
ATOM    184  CB  ARG A  44      38.645 114.846   2.597  1.00 18.73           C  
ATOM    185  CG  ARG A  44      40.061 114.320   2.515  1.00 14.83           C  
ATOM    186  CD  ARG A  44      40.583 114.329   1.102  1.00 17.33           C  
ATOM    187  NE  ARG A  44      39.800 113.481   0.200  1.00 16.55           N  
ATOM    188  CZ  ARG A  44      39.847 112.147   0.155  1.00 17.29           C  
ATOM    189  NH1 ARG A  44      40.630 111.442   0.972  1.00 16.36           N  
ATOM    190  NH2 ARG A  44      39.090 111.501  -0.719  1.00 20.36           N  
ATOM    191  N   GLY A  45      39.687 115.017   5.751  1.00 21.10           N  
ATOM    192  CA  GLY A  45      40.404 115.692   6.823  1.00 19.64           C  
ATOM    193  C   GLY A  45      39.677 115.604   8.143  1.00 21.92           C  
ATOM    194  O   GLY A  45      40.228 115.964   9.187  1.00 16.31           O  
ATOM    195  N   SER A  46      38.426 115.149   8.072  1.00 17.85           N  
ATOM    196  CA  SER A  46      37.589 114.973   9.213  1.00 20.77           C  
ATOM    197  C   SER A  46      37.364 113.472   9.541  1.00 17.97           C  
ATOM    198  O   SER A  46      37.503 112.590   8.688  1.00 16.68           O  
ATOM    199  CB  SER A  46      36.264 115.700   8.974  1.00 15.80           C  
ATOM    200  OG  SER A  46      35.273 114.818   8.547  1.00 24.24           O  
ATOM    201  N   VAL A  47      37.031 113.209  10.795  1.00 12.20           N  
ATOM    202  CA  VAL A  47      36.646 111.884  11.236  1.00 11.39           C  
ATOM    203  C   VAL A  47      35.124 111.753  11.094  1.00 12.65           C  
ATOM    204  O   VAL A  47      34.382 112.679  11.434  1.00 14.08           O  
ATOM    205  CB  VAL A  47      37.031 111.682  12.738  1.00  9.57           C  
ATOM    206  CG1 VAL A  47      36.625 110.271  13.190  1.00 10.11           C  
ATOM    207  CG2 VAL A  47      38.500 111.914  12.939  1.00 15.04           C  
ATOM    208  N   SER A  48      34.664 110.608  10.622  1.00 16.00           N  
ATOM    209  CA  SER A  48      33.266 110.386  10.397  1.00 15.73           C  
ATOM    210  C   SER A  48      32.821 109.088  11.041  1.00 12.07           C  
ATOM    211  O   SER A  48      33.509 108.076  10.940  1.00 16.42           O  
ATOM    212  CB  SER A  48      32.945 110.341   8.870  1.00 19.52           C  
ATOM    213  OG  SER A  48      33.261 111.562   8.251  1.00 15.56           O  
ATOM    214  N   LEU A  49      31.662 109.117  11.694  1.00 13.10           N  
ATOM    215  CA  LEU A  49      30.987 107.885  12.138  1.00 11.89           C  
ATOM    216  C   LEU A  49      29.781 107.680  11.221  1.00 12.19           C  
ATOM    217  O   LEU A  49      28.773 108.363  11.367  1.00 13.01           O  
ATOM    218  CB  LEU A  49      30.542 107.945  13.615  1.00 13.43           C  
ATOM    219  CG  LEU A  49      30.136 106.582  14.212  1.00 15.68           C  
ATOM    220  CD1 LEU A  49      31.345 105.663  14.361  1.00 17.12           C  
ATOM    221  CD2 LEU A  49      29.431 106.709  15.532  1.00 15.48           C  
ATOM    222  N   VAL A  50      29.911 106.707  10.320  1.00 13.87           N  
ATOM    223  CA  VAL A  50      28.909 106.414   9.301  1.00 17.29           C  
ATOM    224  C   VAL A  50      27.963 105.357   9.863  1.00 15.11           C  
ATOM    225  O   VAL A  50      28.379 104.259  10.215  1.00 13.62           O  
ATOM    226  CB  VAL A  50      29.593 105.975   7.986  1.00 17.49           C  
ATOM    227  CG1 VAL A  50      28.580 105.824   6.855  1.00 12.34           C  
ATOM    228  CG2 VAL A  50      30.694 107.012   7.597  1.00 13.19           C  
ATOM    229  N   VAL A  51      26.707 105.742  10.000  1.00 15.07           N  
ATOM    230  CA  VAL A  51      25.688 104.959  10.653  1.00 17.91           C  
ATOM    231  C   VAL A  51      24.480 104.800   9.730  1.00 13.80           C  
ATOM    232  O   VAL A  51      24.056 105.767   9.140  1.00 15.07           O  
ATOM    233  CB  VAL A  51      25.252 105.635  11.953  1.00 16.20           C  
ATOM    234  CG1 VAL A  51      24.293 104.736  12.723  1.00  7.38           C  
ATOM    235  CG2 VAL A  51      26.483 106.018  12.754  1.00 14.15           C  
ATOM    236  N   ASN A  52      23.981 103.568   9.585  1.00 17.43           N  
ATOM    237  CA  ASN A  52      22.694 103.297   8.922  1.00 16.15           C  
ATOM    238  C   ASN A  52      21.605 103.370   9.966  1.00 12.32           C  
ATOM    239  O   ASN A  52      21.683 102.722  11.021  1.00 10.81           O  
ATOM    240  CB  ASN A  52      22.652 101.973   8.117  1.00 18.49           C  
ATOM    241  CG  ASN A  52      22.926 100.717   8.965  1.00 15.92           C  
ATOM    242  OD1 ASN A  52      23.999 100.589   9.548  1.00 13.78           O  
ATOM    243  ND2 ASN A  52      21.960  99.781   9.014  1.00 13.26           N  
ATOM    244  N   VAL A  53      20.617 104.219   9.713  1.00 15.41           N  
ATOM    245  CA  VAL A  53      19.597 104.529  10.701  1.00 14.09           C  
ATOM    246  C   VAL A  53      18.228 104.005  10.315  1.00 14.27           C  
ATOM    247  O   VAL A  53      17.948 103.737   9.144  1.00 12.06           O  
ATOM    248  CB  VAL A  53      19.528 106.064  11.022  1.00 15.31           C  
ATOM    249  CG1 VAL A  53      20.840 106.550  11.613  1.00 13.08           C  
ATOM    250  CG2 VAL A  53      19.132 106.859   9.749  1.00 15.77           C  
ATOM    251  N   ALA A  54      17.381 103.856  11.336  1.00 15.78           N  
ATOM    252  CA  ALA A  54      15.970 103.495  11.168  1.00 15.29           C  
ATOM    253  C   ALA A  54      15.150 104.206  12.229  1.00 17.32           C  
ATOM    254  O   ALA A  54      15.654 104.559  13.310  1.00 20.88           O  
ATOM    255  CB  ALA A  54      15.787 101.977  11.243  1.00 10.23           C  
ATOM    256  N   SER A  55      13.878 104.405  11.939  1.00 21.58           N  
ATOM    257  CA  SER A  55      12.988 105.196  12.803  1.00 23.76           C  
ATOM    258  C   SER A  55      12.106 104.381  13.737  1.00 26.38           C  
ATOM    259  O   SER A  55      11.651 104.895  14.754  1.00 27.24           O  
ATOM    260  CB  SER A  55      12.111 106.109  11.943  1.00 23.19           C  
ATOM    261  OG  SER A  55      12.895 107.161  11.381  1.00 26.17           O  
ATOM    262  N   GLU A  56      11.870 103.115  13.406  1.00 28.78           N  
ATOM    263  CA  GLU A  56      10.877 102.309  14.128  1.00 33.67           C  
ATOM    264  C   GLU A  56      11.512 101.186  14.934  1.00 34.37           C  
ATOM    265  O   GLU A  56      10.824 100.350  15.494  1.00 34.26           O  
ATOM    266  CB  GLU A  56       9.870 101.720  13.139  1.00 32.90           C  
ATOM    267  CG  GLU A  56       9.293 102.746  12.196  1.00 38.58           C  
ATOM    268  CD  GLU A  56       7.950 102.346  11.625  1.00 42.42           C  
ATOM    269  OE1 GLU A  56       7.651 101.125  11.530  1.00 51.57           O  
ATOM    270  OE2 GLU A  56       7.194 103.272  11.260  1.00 45.54           O  
ATOM    271  N   CYS A  57      12.837 101.203  15.000  1.00 37.76           N  
ATOM    272  CA  CYS A  57      13.629 100.160  15.630  1.00 39.39           C  
ATOM    273  C   CYS A  57      13.538 100.287  17.160  1.00 39.08           C  
ATOM    274  O   CYS A  57      13.370 101.397  17.692  1.00 34.04           O  
ATOM    275  CB  CYS A  57      15.089 100.320  15.146  1.00 38.08           C  
ATOM    276  SG  CYS A  57      16.217  99.008  15.502  1.00 41.77           S  
ATOM    277  N   GLY A  58      13.652  99.159  17.860  1.00 38.04           N  
ATOM    278  CA  GLY A  58      13.897  99.183  19.304  1.00 40.25           C  
ATOM    279  C   GLY A  58      15.144  99.981  19.684  1.00 40.74           C  
ATOM    280  O   GLY A  58      15.156 100.650  20.697  1.00 43.15           O  
ATOM    281  N   PHE A  59      16.193  99.920  18.856  1.00 43.62           N  
ATOM    282  CA  PHE A  59      17.433 100.693  19.093  1.00 41.48           C  
ATOM    283  C   PHE A  59      17.284 102.225  18.834  1.00 41.52           C  
ATOM    284  O   PHE A  59      18.235 102.967  19.087  1.00 41.62           O  
ATOM    285  CB  PHE A  59      18.618 100.154  18.221  1.00 43.14           C  
ATOM    286  CG  PHE A  59      19.091  98.734  18.581  1.00 44.64           C  
ATOM    287  CD1 PHE A  59      19.884  98.500  19.717  1.00 38.42           C  
ATOM    288  CD2 PHE A  59      18.766  97.654  17.772  1.00 40.11           C  
ATOM    289  CE1 PHE A  59      20.306  97.230  20.044  1.00 36.07           C  
ATOM    290  CE2 PHE A  59      19.185  96.363  18.100  1.00 39.25           C  
ATOM    291  CZ  PHE A  59      19.955  96.153  19.233  1.00 35.39           C  
ATOM    292  N   THR A  60      16.122 102.690  18.348  1.00 35.67           N  
ATOM    293  CA  THR A  60      16.029 104.007  17.663  1.00 34.63           C  
ATOM    294  C   THR A  60      16.256 105.190  18.599  1.00 31.16           C  
ATOM    295  O   THR A  60      17.020 106.105  18.294  1.00 28.01           O  
ATOM    296  CB  THR A  60      14.657 104.188  16.918  1.00 32.60           C  
ATOM    297  OG1 THR A  60      14.625 103.304  15.789  1.00 24.38           O  
ATOM    298  CG2 THR A  60      14.419 105.656  16.453  1.00 26.97           C  
ATOM    299  N   ASP A  61      15.582 105.145  19.737  1.00 27.54           N  
ATOM    300  CA  ASP A  61      15.583 106.226  20.696  1.00 27.29           C  
ATOM    301  C   ASP A  61      16.940 106.363  21.393  1.00 25.13           C  
ATOM    302  O   ASP A  61      17.526 107.442  21.429  1.00 23.77           O  
ATOM    303  CB  ASP A  61      14.484 105.966  21.709  1.00 31.26           C  
ATOM    304  CG  ASP A  61      14.244 107.137  22.602  1.00 35.30           C  
ATOM    305  OD1 ASP A  61      13.631 108.116  22.127  1.00 43.79           O  
ATOM    306  OD2 ASP A  61      14.677 107.063  23.771  1.00 34.99           O  
ATOM    307  N   GLN A  62      17.449 105.254  21.915  1.00 23.34           N  
ATOM    308  CA  GLN A  62      18.742 105.254  22.590  1.00 23.81           C  
ATOM    309  C   GLN A  62      19.837 105.640  21.600  1.00 20.41           C  
ATOM    310  O   GLN A  62      20.719 106.434  21.918  1.00 16.13           O  
ATOM    311  CB  GLN A  62      19.024 103.905  23.259  1.00 23.21           C  
ATOM    312  N   HIS A  63      19.759 105.117  20.382  1.00 20.41           N  
ATOM    313  CA  HIS A  63      20.782 105.401  19.385  1.00 19.39           C  
ATOM    314  C   HIS A  63      20.806 106.822  18.904  1.00 16.62           C  
ATOM    315  O   HIS A  63      21.890 107.396  18.783  1.00 14.75           O  
ATOM    316  CB  HIS A  63      20.699 104.443  18.191  1.00 24.70           C  
ATOM    317  CG  HIS A  63      21.609 103.270  18.336  1.00 33.94           C  
ATOM    318  ND1 HIS A  63      21.187 102.062  18.841  1.00 39.54           N  
ATOM    319  CD2 HIS A  63      22.940 103.145  18.103  1.00 44.13           C  
ATOM    320  CE1 HIS A  63      22.213 101.229  18.881  1.00 50.65           C  
ATOM    321  NE2 HIS A  63      23.288 101.862  18.444  1.00 45.49           N  
ATOM    322  N   TYR A  64      19.634 107.390  18.606  1.00 17.31           N  
ATOM    323  CA  TYR A  64      19.571 108.769  18.144  1.00 12.98           C  
ATOM    324  C   TYR A  64      19.997 109.716  19.246  1.00 12.71           C  
ATOM    325  O   TYR A  64      20.663 110.713  18.970  1.00 13.42           O  
ATOM    326  CB  TYR A  64      18.199 109.137  17.648  1.00 15.62           C  
ATOM    327  CG  TYR A  64      18.027 109.042  16.131  1.00 17.21           C  
ATOM    328  CD1 TYR A  64      17.252 108.043  15.552  1.00 21.60           C  
ATOM    329  CD2 TYR A  64      18.553 110.009  15.294  1.00 21.49           C  
ATOM    330  CE1 TYR A  64      17.057 107.985  14.146  1.00 18.89           C  
ATOM    331  CE2 TYR A  64      18.379 109.952  13.903  1.00 14.27           C  
ATOM    332  CZ  TYR A  64      17.633 108.946  13.337  1.00 16.97           C  
ATOM    333  OH  TYR A  64      17.443 108.950  11.955  1.00 18.64           O  
ATOM    334  N   ARG A  65      19.650 109.411  20.488  1.00 14.51           N  
ATOM    335  CA  ARG A  65      20.103 110.232  21.611  1.00 19.78           C  
ATOM    336  C   ARG A  65      21.624 110.204  21.768  1.00 15.13           C  
ATOM    337  O   ARG A  65      22.237 111.227  22.021  1.00 17.24           O  
ATOM    338  CB  ARG A  65      19.452 109.802  22.912  1.00 19.25           C  
ATOM    339  CG  ARG A  65      17.991 110.152  23.059  1.00 23.89           C  
ATOM    340  CD  ARG A  65      17.469 109.640  24.413  1.00 34.79           C  
ATOM    341  NE  ARG A  65      16.005 109.686  24.556  1.00 45.96           N  
ATOM    342  CZ  ARG A  65      15.289 110.782  24.831  1.00 55.68           C  
ATOM    343  NH1 ARG A  65      15.862 111.973  25.007  1.00 57.97           N  
ATOM    344  NH2 ARG A  65      13.967 110.685  24.937  1.00 60.35           N  
ATOM    345  N   ALA A  66      22.216 109.026  21.648  1.00 19.06           N  
ATOM    346  CA  ALA A  66      23.654 108.864  21.778  1.00 19.13           C  
ATOM    347  C   ALA A  66      24.402 109.469  20.597  1.00 18.23           C  
ATOM    348  O   ALA A  66      25.463 110.063  20.772  1.00 20.60           O  
ATOM    349  CB  ALA A  66      24.038 107.352  21.994  1.00 15.73           C  
ATOM    350  N   LEU A  67      23.861 109.340  19.396  1.00 15.57           N  
ATOM    351  CA  LEU A  67      24.508 109.899  18.240  1.00 15.73           C  
ATOM    352  C   LEU A  67      24.522 111.398  18.242  1.00 15.60           C  
ATOM    353  O   LEU A  67      25.509 111.991  17.785  1.00 15.34           O  
ATOM    354  CB  LEU A  67      23.897 109.393  16.926  1.00 14.44           C  
ATOM    355  CG  LEU A  67      24.086 107.910  16.538  1.00 18.23           C  
ATOM    356  CD1 LEU A  67      23.057 107.541  15.456  1.00 21.36           C  
ATOM    357  CD2 LEU A  67      25.507 107.571  16.068  1.00 11.38           C  
ATOM    358  N   GLN A  68      23.434 112.021  18.707  1.00 13.93           N  
ATOM    359  CA  GLN A  68      23.401 113.450  18.820  1.00 14.63           C  
ATOM    360  C   GLN A  68      24.342 113.930  19.926  1.00 16.98           C  
ATOM    361  O   GLN A  68      25.042 114.919  19.738  1.00 19.57           O  
ATOM    362  CB  GLN A  68      21.971 113.971  19.064  1.00 18.84           C  
ATOM    363  CG  GLN A  68      21.877 115.521  19.113  1.00 15.37           C  
ATOM    364  CD  GLN A  68      22.564 116.221  17.957  1.00 11.70           C  
ATOM    365  OE1 GLN A  68      22.582 115.728  16.846  1.00 16.72           O  
ATOM    366  NE2 GLN A  68      23.096 117.389  18.211  1.00  9.64           N  
ATOM    367  N   GLN A  69      24.398 113.230  21.054  1.00 17.21           N  
ATOM    368  CA  GLN A  69      25.342 113.618  22.093  1.00 19.75           C  
ATOM    369  C   GLN A  69      26.794 113.486  21.584  1.00 21.15           C  
ATOM    370  O   GLN A  69      27.644 114.330  21.889  1.00 20.26           O  
ATOM    371  CB  GLN A  69      25.099 112.812  23.372  1.00 21.80           C  
ATOM    372  CG  GLN A  69      25.741 113.402  24.672  1.00 29.09           C  
ATOM    373  CD  GLN A  69      25.347 114.865  25.022  1.00 49.73           C  
ATOM    374  OE1 GLN A  69      24.245 115.342  24.701  1.00 52.72           O  
ATOM    375  NE2 GLN A  69      26.267 115.573  25.697  1.00 47.74           N  
ATOM    376  N   LEU A  70      27.051 112.473  20.761  1.00 20.22           N  
ATOM    377  CA  LEU A  70      28.367 112.285  20.150  1.00 23.89           C  
ATOM    378  C   LEU A  70      28.720 113.496  19.275  1.00 24.46           C  
ATOM    379  O   LEU A  70      29.829 114.011  19.329  1.00 22.30           O  
ATOM    380  CB  LEU A  70      28.367 111.007  19.325  1.00 21.88           C  
ATOM    381  CG  LEU A  70      29.658 110.334  18.943  1.00 27.09           C  
ATOM    382  CD1 LEU A  70      30.359 109.791  20.194  1.00 24.18           C  
ATOM    383  CD2 LEU A  70      29.281 109.197  18.001  1.00 29.88           C  
ATOM    384  N   GLN A  71      27.751 113.960  18.492  1.00 22.74           N  
ATOM    385  CA  GLN A  71      27.920 115.115  17.627  1.00 22.71           C  
ATOM    386  C   GLN A  71      28.165 116.378  18.444  1.00 21.21           C  
ATOM    387  O   GLN A  71      29.050 117.160  18.145  1.00 19.95           O  
ATOM    388  CB  GLN A  71      26.692 115.281  16.725  1.00 19.99           C  
ATOM    389  CG  GLN A  71      26.807 116.373  15.710  1.00 21.13           C  
ATOM    390  CD  GLN A  71      27.680 116.018  14.519  1.00 16.98           C  
ATOM    391  OE1 GLN A  71      28.038 114.876  14.301  1.00 13.04           O  
ATOM    392  NE2 GLN A  71      28.021 117.020  13.743  1.00 17.18           N  
ATOM    393  N   ARG A  72      27.383 116.550  19.487  1.00 20.90           N  
ATOM    394  CA  ARG A  72      27.556 117.664  20.427  1.00 25.55           C  
ATOM    395  C   ARG A  72      28.998 117.705  21.001  1.00 22.32           C  
ATOM    396  O   ARG A  72      29.670 118.735  20.953  1.00 22.50           O  
ATOM    397  CB  ARG A  72      26.495 117.512  21.529  1.00 22.01           C  
ATOM    398  CG  ARG A  72      26.016 118.715  22.255  1.00 33.87           C  
ATOM    399  CD  ARG A  72      25.073 118.268  23.397  1.00 28.02           C  
ATOM    400  N   ASP A  73      29.466 116.570  21.498  1.00 24.30           N  
ATOM    401  CA  ASP A  73      30.747 116.466  22.223  1.00 22.96           C  
ATOM    402  C   ASP A  73      31.990 116.453  21.322  1.00 22.32           C  
ATOM    403  O   ASP A  73      33.002 117.094  21.637  1.00 16.43           O  
ATOM    404  CB  ASP A  73      30.771 115.171  23.043  1.00 24.58           C  
ATOM    405  CG  ASP A  73      29.674 115.119  24.139  1.00 28.25           C  
ATOM    406  OD1 ASP A  73      29.047 116.163  24.461  1.00 29.79           O  
ATOM    407  OD2 ASP A  73      29.457 113.992  24.666  1.00 25.90           O  
ATOM    408  N   LEU A  74      31.908 115.742  20.192  1.00 20.03           N  
ATOM    409  CA  LEU A  74      33.056 115.610  19.283  1.00 20.64           C  
ATOM    410  C   LEU A  74      32.958 116.379  17.958  1.00 18.43           C  
ATOM    411  O   LEU A  74      33.973 116.501  17.280  1.00 13.11           O  
ATOM    412  CB  LEU A  74      33.365 114.130  18.961  1.00 20.49           C  
ATOM    413  CG  LEU A  74      33.748 113.199  20.113  1.00 25.42           C  
ATOM    414  CD1 LEU A  74      34.155 111.849  19.537  1.00 20.83           C  
ATOM    415  CD2 LEU A  74      34.865 113.749  20.961  1.00 25.66           C  
ATOM    416  N   GLY A  75      31.775 116.875  17.597  1.00 15.07           N  
ATOM    417  CA  GLY A  75      31.599 117.714  16.415  1.00 15.99           C  
ATOM    418  C   GLY A  75      32.583 118.885  16.288  1.00 16.92           C  
ATOM    419  O   GLY A  75      33.107 119.157  15.182  1.00 15.35           O  
ATOM    420  N   PRO A  76      32.846 119.590  17.407  1.00 16.70           N  
ATOM    421  CA  PRO A  76      33.808 120.708  17.418  1.00 15.34           C  
ATOM    422  C   PRO A  76      35.262 120.292  17.176  1.00 15.18           C  
ATOM    423  O   PRO A  76      36.132 121.151  16.995  1.00 15.31           O  
ATOM    424  CB  PRO A  76      33.641 121.293  18.814  1.00 17.30           C  
ATOM    425  CG  PRO A  76      32.291 120.794  19.292  1.00 19.11           C  
ATOM    426  CD  PRO A  76      32.182 119.438  18.712  1.00 12.47           C  
ATOM    427  N   HIS A  77      35.515 118.988  17.142  1.00 15.13           N  
ATOM    428  CA  HIS A  77      36.852 118.458  16.899  1.00 13.80           C  
ATOM    429  C   HIS A  77      36.936 117.804  15.521  1.00 11.92           C  
ATOM    430  O   HIS A  77      37.667 116.828  15.324  1.00 13.98           O  
ATOM    431  CB  HIS A  77      37.194 117.473  17.995  1.00 14.38           C  
ATOM    432  CG  HIS A  77      37.248 118.106  19.346  1.00 15.23           C  
ATOM    433  ND1 HIS A  77      38.431 118.434  19.955  1.00 17.85           N  
ATOM    434  CD2 HIS A  77      36.266 118.547  20.166  1.00 16.62           C  
ATOM    435  CE1 HIS A  77      38.183 119.034  21.107  1.00 13.54           C  
ATOM    436  NE2 HIS A  77      36.876 119.111  21.261  1.00 17.36           N  
ATOM    437  N   HIS A  78      36.155 118.323  14.581  1.00 15.41           N  
ATOM    438  CA  HIS A  78      36.256 117.940  13.145  1.00 13.97           C  
ATOM    439  C   HIS A  78      35.805 116.495  12.913  1.00 14.07           C  
ATOM    440  O   HIS A  78      36.511 115.631  12.334  1.00 14.57           O  
ATOM    441  CB  HIS A  78      37.687 118.221  12.640  1.00 17.34           C  
ATOM    442  CG  HIS A  78      37.772 118.599  11.198  1.00 18.39           C  
ATOM    443  ND1 HIS A  78      38.950 118.510  10.488  1.00 25.26           N  
ATOM    444  CD2 HIS A  78      36.854 119.114  10.346  1.00 20.41           C  
ATOM    445  CE1 HIS A  78      38.752 118.950   9.256  1.00 14.12           C  
ATOM    446  NE2 HIS A  78      37.492 119.326   9.146  1.00 21.22           N  
ATOM    447  N   PHE A  79      34.592 116.263  13.402  1.00 16.15           N  
ATOM    448  CA  PHE A  79      33.970 114.971  13.468  1.00 14.69           C  
ATOM    449  C   PHE A  79      32.496 115.157  13.124  1.00 16.47           C  
ATOM    450  O   PHE A  79      31.880 116.150  13.536  1.00 13.66           O  
ATOM    451  CB  PHE A  79      34.019 114.385  14.871  1.00 13.26           C  
ATOM    452  CG  PHE A  79      33.065 113.243  15.058  1.00  9.81           C  
ATOM    453  CD1 PHE A  79      33.401 111.952  14.627  1.00 11.20           C  
ATOM    454  CD2 PHE A  79      31.803 113.449  15.613  1.00 16.06           C  
ATOM    455  CE1 PHE A  79      32.529 110.930  14.756  1.00 12.32           C  
ATOM    456  CE2 PHE A  79      30.921 112.408  15.773  1.00 14.24           C  
ATOM    457  CZ  PHE A  79      31.261 111.154  15.349  1.00  8.67           C  
ATOM    458  N   ASN A  80      31.936 114.190  12.395  1.00 13.68           N  
ATOM    459  CA  ASN A  80      30.498 114.128  12.201  1.00 10.90           C  
ATOM    460  C   ASN A  80      30.007 112.707  12.201  1.00 14.46           C  
ATOM    461  O   ASN A  80      30.684 111.802  11.686  1.00 16.52           O  
ATOM    462  CB  ASN A  80      30.122 114.713  10.831  1.00 12.89           C  
ATOM    463  CG  ASN A  80      30.394 116.203  10.717  1.00 17.80           C  
ATOM    464  OD1 ASN A  80      29.603 117.033  11.174  1.00 22.19           O  
ATOM    465  ND2 ASN A  80      31.495 116.542  10.072  1.00 14.16           N  
ATOM    466  N   VAL A  81      28.806 112.534  12.753  1.00 15.86           N  
ATOM    467  CA  VAL A  81      27.977 111.404  12.461  1.00 12.56           C  
ATOM    468  C   VAL A  81      27.431 111.644  11.018  1.00 15.11           C  
ATOM    469  O   VAL A  81      26.930 112.719  10.716  1.00 14.31           O  
ATOM    470  CB  VAL A  81      26.809 111.292  13.445  1.00 11.20           C  
ATOM    471  CG1 VAL A  81      25.837 110.185  13.041  1.00 11.13           C  
ATOM    472  CG2 VAL A  81      27.302 111.068  14.903  1.00 15.54           C  
ATOM    473  N   LEU A  82      27.534 110.646  10.145  1.00 12.49           N  
ATOM    474  CA  LEU A  82      26.920 110.700   8.803  1.00 12.69           C  
ATOM    475  C   LEU A  82      25.856 109.601   8.735  1.00 11.84           C  
ATOM    476  O   LEU A  82      26.173 108.415   8.666  1.00 13.61           O  
ATOM    477  CB  LEU A  82      27.984 110.553   7.718  1.00 16.33           C  
ATOM    478  CG  LEU A  82      29.136 111.566   7.691  1.00 14.57           C  
ATOM    479  CD1 LEU A  82      30.050 111.200   6.534  1.00 15.83           C  
ATOM    480  CD2 LEU A  82      28.678 113.029   7.564  1.00 16.36           C  
ATOM    481  N   ALA A  83      24.587 110.000   8.868  1.00 15.71           N  
ATOM    482  CA  ALA A  83      23.459 109.071   9.099  1.00 13.64           C  
ATOM    483  C   ALA A  83      22.748 108.814   7.769  1.00 15.10           C  
ATOM    484  O   ALA A  83      22.259 109.741   7.134  1.00 15.78           O  
ATOM    485  CB  ALA A  83      22.454 109.653  10.094  1.00  6.73           C  
ATOM    486  N   PHE A  84      22.656 107.548   7.393  1.00 14.97           N  
ATOM    487  CA  PHE A  84      21.992 107.125   6.172  1.00 15.56           C  
ATOM    488  C   PHE A  84      20.799 106.247   6.511  1.00 17.53           C  
ATOM    489  O   PHE A  84      20.979 105.132   7.011  1.00 15.22           O  
ATOM    490  CB  PHE A  84      22.947 106.331   5.300  1.00 15.34           C  
ATOM    491  CG  PHE A  84      24.059 107.136   4.729  1.00 17.32           C  
ATOM    492  CD1 PHE A  84      24.036 107.554   3.370  1.00 16.05           C  
ATOM    493  CD2 PHE A  84      25.166 107.458   5.514  1.00 14.65           C  
ATOM    494  CE1 PHE A  84      25.113 108.279   2.827  1.00  9.38           C  
ATOM    495  CE2 PHE A  84      26.246 108.203   4.960  1.00 16.01           C  
ATOM    496  CZ  PHE A  84      26.189 108.611   3.636  1.00 13.55           C  
ATOM    497  N   PRO A  85      19.566 106.744   6.258  1.00 19.19           N  
ATOM    498  CA  PRO A  85      18.409 105.894   6.530  1.00 15.11           C  
ATOM    499  C   PRO A  85      18.377 104.671   5.615  1.00 15.13           C  
ATOM    500  O   PRO A  85      18.794 104.745   4.461  1.00 11.63           O  
ATOM    501  CB  PRO A  85      17.200 106.811   6.243  1.00 15.91           C  
ATOM    502  CG  PRO A  85      17.728 108.201   6.172  1.00 16.11           C  
ATOM    503  CD  PRO A  85      19.168 108.071   5.743  1.00 16.36           C  
ATOM    504  N   CYS A  86      17.905 103.555   6.154  1.00 13.66           N  
ATOM    505  CA  CYS A  86      17.841 102.332   5.406  1.00 12.85           C  
ATOM    506  C   CYS A  86      16.653 101.517   5.882  1.00 10.53           C  
ATOM    507  O   CYS A  86      16.476 101.376   7.086  1.00 12.48           O  
ATOM    508  CB  CYS A  86      19.167 101.583   5.572  1.00 14.15           C  
ATOM    509  SG  CYS A  86      19.267 100.016   4.730  1.00 15.54           S  
ATOM    510  N   ASN A  87      15.821 101.063   4.923  1.00 12.13           N  
ATOM    511  CA  ASN A  87      14.630 100.242   5.161  1.00 13.60           C  
ATOM    512  C   ASN A  87      14.820  98.711   4.976  1.00 11.92           C  
ATOM    513  O   ASN A  87      13.865  97.960   4.871  1.00 13.61           O  
ATOM    514  CB  ASN A  87      13.487 100.711   4.253  1.00 13.67           C  
ATOM    515  CG  ASN A  87      12.101 100.262   4.746  1.00 14.78           C  
ATOM    516  OD1 ASN A  87      11.832 100.231   5.942  1.00 17.66           O  
ATOM    517  ND2 ASN A  87      11.227  99.914   3.811  1.00 10.25           N  
ATOM    518  N   GLN A  88      16.055  98.250   4.962  1.00  9.13           N  
ATOM    519  CA  GLN A  88      16.333  96.851   4.684  1.00  9.98           C  
ATOM    520  C   GLN A  88      16.150  95.895   5.859  1.00 11.80           C  
ATOM    521  O   GLN A  88      15.917  94.726   5.657  1.00 14.10           O  
ATOM    522  CB  GLN A  88      17.773  96.725   4.144  1.00 11.36           C  
ATOM    523  CG  GLN A  88      17.907  97.168   2.683  1.00 10.82           C  
ATOM    524  CD  GLN A  88      19.294  96.951   2.170  1.00 11.84           C  
ATOM    525  OE1 GLN A  88      20.220  97.553   2.664  1.00 18.27           O  
ATOM    526  NE2 GLN A  88      19.450  96.076   1.196  1.00 12.80           N  
ATOM    527  N   PHE A  89      16.312  96.384   7.081  1.00 11.42           N  
ATOM    528  CA  PHE A  89      16.420  95.524   8.235  1.00 15.23           C  
ATOM    529  C   PHE A  89      15.147  95.614   9.076  1.00 14.96           C  
ATOM    530  O   PHE A  89      14.995  96.524   9.897  1.00 16.05           O  
ATOM    531  CB  PHE A  89      17.616  95.937   9.026  1.00 14.83           C  
ATOM    532  CG  PHE A  89      18.917  95.855   8.250  1.00  9.81           C  
ATOM    533  CD1 PHE A  89      19.425  94.641   7.873  1.00 11.27           C  
ATOM    534  CD2 PHE A  89      19.602  97.001   7.896  1.00 13.45           C  
ATOM    535  CE1 PHE A  89      20.597  94.556   7.157  1.00 12.97           C  
ATOM    536  CE2 PHE A  89      20.782  96.931   7.199  1.00 15.34           C  
ATOM    537  CZ  PHE A  89      21.283  95.700   6.816  1.00 13.48           C  
ATOM    538  N   GLY A  90      14.231  94.682   8.825  1.00 13.16           N  
ATOM    539  CA  GLY A  90      12.897  94.635   9.501  1.00 15.39           C  
ATOM    540  C   GLY A  90      11.889  95.636   8.913  1.00 18.98           C  
ATOM    541  O   GLY A  90      10.767  95.788   9.432  1.00 18.69           O  
ATOM    542  N   GLN A  91      12.298  96.293   7.819  1.00 15.47           N  
ATOM    543  CA  GLN A  91      11.618  97.454   7.233  1.00 16.43           C  
ATOM    544  C   GLN A  91      11.236  98.499   8.286  1.00 16.90           C  
ATOM    545  O   GLN A  91      10.075  98.841   8.420  1.00 13.55           O  
ATOM    546  CB  GLN A  91      10.411  97.041   6.402  1.00 18.39           C  
ATOM    547  CG  GLN A  91      10.785  96.369   5.109  1.00 20.39           C  
ATOM    548  CD  GLN A  91      11.449  95.035   5.340  1.00 26.37           C  
ATOM    549  OE1 GLN A  91      10.827  94.107   5.890  1.00 25.56           O  
ATOM    550  NE2 GLN A  91      12.737  94.927   4.956  1.00 22.02           N  
ATOM    551  N   GLN A  92      12.238  99.006   9.003  1.00 13.99           N  
ATOM    552  CA  GLN A  92      12.022  99.930  10.129  1.00 20.03           C  
ATOM    553  C   GLN A  92      12.309 101.395   9.763  1.00 17.85           C  
ATOM    554  O   GLN A  92      12.366 102.290  10.628  1.00 13.58           O  
ATOM    555  CB  GLN A  92      12.857  99.455  11.325  1.00 19.14           C  
ATOM    556  CG  GLN A  92      12.348  98.091  11.829  1.00 23.27           C  
ATOM    557  CD  GLN A  92      13.085  97.607  13.027  1.00 28.34           C  
ATOM    558  OE1 GLN A  92      14.196  98.059  13.308  1.00 54.54           O  
ATOM    559  NE2 GLN A  92      12.488  96.675  13.751  1.00 45.09           N  
ATOM    560  N   GLU A  93      12.403 101.638   8.457  1.00 16.90           N  
ATOM    561  CA  GLU A  93      12.467 102.997   7.923  1.00 17.66           C  
ATOM    562  C   GLU A  93      11.569 103.151   6.658  1.00 16.36           C  
ATOM    563  O   GLU A  93      12.068 103.416   5.570  1.00 14.07           O  
ATOM    564  CB  GLU A  93      13.920 103.316   7.597  1.00 11.23           C  
ATOM    565  CG  GLU A  93      14.207 104.775   7.340  1.00 18.87           C  
ATOM    566  CD  GLU A  93      14.256 105.571   8.584  1.00 26.47           C  
ATOM    567  OE1 GLU A  93      13.177 105.727   9.233  1.00 28.43           O  
ATOM    568  OE2 GLU A  93      15.364 106.050   8.914  1.00 24.89           O  
ATOM    569  N   PRO A  94      10.242 102.974   6.813  1.00 19.35           N  
ATOM    570  CA  PRO A  94       9.335 102.955   5.650  1.00 17.55           C  
ATOM    571  C   PRO A  94       8.993 104.345   5.108  1.00 18.18           C  
ATOM    572  O   PRO A  94       8.485 104.450   4.016  1.00 18.26           O  
ATOM    573  CB  PRO A  94       8.060 102.305   6.226  1.00 20.74           C  
ATOM    574  CG  PRO A  94       8.041 102.742   7.661  1.00 14.25           C  
ATOM    575  CD  PRO A  94       9.509 102.739   8.084  1.00 20.54           C  
ATOM    576  N   ASP A  95       9.261 105.400   5.871  1.00 17.73           N  
ATOM    577  CA  ASP A  95       8.742 106.713   5.516  1.00 22.33           C  
ATOM    578  C   ASP A  95       9.623 107.463   4.538  1.00 19.00           C  
ATOM    579  O   ASP A  95      10.714 107.008   4.183  1.00 18.46           O  
ATOM    580  CB  ASP A  95       8.519 107.557   6.775  1.00 24.38           C  
ATOM    581  CG  ASP A  95       7.422 106.995   7.672  1.00 35.01           C  
ATOM    582  OD1 ASP A  95       6.562 106.212   7.194  1.00 33.33           O  
ATOM    583  OD2 ASP A  95       7.444 107.336   8.874  1.00 47.15           O  
ATOM    584  N   SER A  96       9.115 108.614   4.096  1.00 16.92           N  
ATOM    585  CA  SER A  96       9.828 109.485   3.178  1.00 18.12           C  
ATOM    586  C   SER A  96      11.024 110.153   3.839  1.00 17.13           C  
ATOM    587  O   SER A  96      11.134 110.270   5.079  1.00 17.52           O  
ATOM    588  CB  SER A  96       8.906 110.550   2.569  1.00 16.67           C  
ATOM    589  OG  SER A  96       8.485 111.481   3.554  1.00 20.73           O  
ATOM    590  N   ASN A  97      11.923 110.604   2.980  1.00 15.82           N  
ATOM    591  CA  ASN A  97      13.066 111.365   3.388  1.00 14.38           C  
ATOM    592  C   ASN A  97      12.634 112.589   4.205  1.00 16.83           C  
ATOM    593  O   ASN A  97      13.177 112.835   5.300  1.00 16.98           O  
ATOM    594  CB  ASN A  97      13.909 111.724   2.162  1.00 15.08           C  
ATOM    595  CG  ASN A  97      14.652 110.531   1.612  1.00 16.69           C  
ATOM    596  OD1 ASN A  97      15.281 109.810   2.361  1.00 16.92           O  
ATOM    597  ND2 ASN A  97      14.535 110.285   0.310  1.00 17.32           N  
ATOM    598  N   LYS A  98      11.612 113.288   3.712  1.00 14.80           N  
ATOM    599  CA  LYS A  98      10.994 114.423   4.438  1.00 22.96           C  
ATOM    600  C   LYS A  98      10.538 114.054   5.879  1.00 21.39           C  
ATOM    601  O   LYS A  98      10.817 114.774   6.864  1.00 19.34           O  
ATOM    602  CB  LYS A  98       9.784 114.938   3.642  1.00 21.68           C  
ATOM    603  CG  LYS A  98       9.388 116.390   3.921  1.00 34.69           C  
ATOM    604  CD  LYS A  98       7.977 116.746   3.372  1.00 28.91           C  
ATOM    605  N   GLU A  99       9.827 112.938   5.986  1.00 20.38           N  
ATOM    606  CA  GLU A  99       9.306 112.484   7.266  1.00 17.42           C  
ATOM    607  C   GLU A  99      10.384 112.100   8.227  1.00 13.86           C  
ATOM    608  O   GLU A  99      10.294 112.431   9.412  1.00 11.08           O  
ATOM    609  CB  GLU A  99       8.358 111.285   7.078  1.00 19.53           C  
ATOM    610  CG  GLU A  99       6.902 111.671   6.896  1.00 31.00           C  
ATOM    611  CD  GLU A  99       6.218 110.965   5.714  1.00 43.99           C  
ATOM    612  OE1 GLU A  99       6.439 109.742   5.457  1.00 39.34           O  
ATOM    613  OE2 GLU A  99       5.430 111.663   5.045  1.00 50.09           O  
ATOM    614  N   ILE A 100      11.409 111.389   7.711  1.00 16.40           N  
ATOM    615  CA  ILE A 100      12.529 110.933   8.508  1.00 14.63           C  
ATOM    616  C   ILE A 100      13.311 112.131   9.076  1.00 16.10           C  
ATOM    617  O   ILE A 100      13.616 112.187  10.273  1.00 15.10           O  
ATOM    618  CB  ILE A 100      13.454 109.996   7.690  1.00 18.15           C  
ATOM    619  CG1 ILE A 100      12.695 108.712   7.281  1.00 14.96           C  
ATOM    620  CG2 ILE A 100      14.781 109.698   8.468  1.00 13.25           C  
ATOM    621  CD1 ILE A 100      13.234 108.026   5.988  1.00 12.85           C  
ATOM    622  N   GLU A 101      13.643 113.084   8.219  1.00 16.75           N  
ATOM    623  CA  GLU A 101      14.307 114.287   8.691  1.00 17.75           C  
ATOM    624  C   GLU A 101      13.494 115.022   9.774  1.00 16.46           C  
ATOM    625  O   GLU A 101      14.021 115.370  10.843  1.00 15.17           O  
ATOM    626  CB  GLU A 101      14.558 115.242   7.538  1.00 17.00           C  
ATOM    627  CG  GLU A 101      15.614 116.247   7.872  1.00 23.76           C  
ATOM    628  CD  GLU A 101      15.595 117.486   7.002  1.00 26.25           C  
ATOM    629  OE1 GLU A 101      14.771 117.580   6.061  1.00 32.10           O  
ATOM    630  OE2 GLU A 101      16.437 118.371   7.284  1.00 31.70           O  
ATOM    631  N   SER A 102      12.215 115.260   9.488  1.00 18.61           N  
ATOM    632  CA  SER A 102      11.320 115.904  10.447  1.00 15.03           C  
ATOM    633  C   SER A 102      11.350 115.142  11.779  1.00 17.10           C  
ATOM    634  O   SER A 102      11.484 115.756  12.838  1.00 12.16           O  
ATOM    635  CB  SER A 102       9.913 115.984   9.864  1.00 11.53           C  
ATOM    636  OG  SER A 102       9.015 116.532  10.806  1.00 23.30           O  
ATOM    637  N   PHE A 103      11.299 113.806  11.718  1.00 19.84           N  
ATOM    638  CA  PHE A 103      11.302 112.971  12.921  1.00 16.83           C  
ATOM    639  C   PHE A 103      12.589 113.144  13.720  1.00 18.91           C  
ATOM    640  O   PHE A 103      12.528 113.379  14.945  1.00 17.04           O  
ATOM    641  CB  PHE A 103      11.075 111.496  12.558  1.00 18.98           C  
ATOM    642  CG  PHE A 103      11.419 110.518  13.672  1.00 18.02           C  
ATOM    643  CD1 PHE A 103      10.578 110.369  14.764  1.00 17.99           C  
ATOM    644  CD2 PHE A 103      12.582 109.751  13.610  1.00 24.78           C  
ATOM    645  CE1 PHE A 103      10.883 109.500  15.785  1.00 21.68           C  
ATOM    646  CE2 PHE A 103      12.901 108.870  14.632  1.00 16.42           C  
ATOM    647  CZ  PHE A 103      12.050 108.732  15.714  1.00 20.34           C  
ATOM    648  N   ALA A 104      13.743 112.997  13.040  1.00 22.91           N  
ATOM    649  CA  ALA A 104      15.062 113.134  13.677  1.00 18.31           C  
ATOM    650  C   ALA A 104      15.244 114.543  14.290  1.00 14.99           C  
ATOM    651  O   ALA A 104      15.580 114.669  15.476  1.00 16.86           O  
ATOM    652  CB  ALA A 104      16.170 112.807  12.694  1.00 13.10           C  
ATOM    653  N   ARG A 105      14.929 115.580  13.512  1.00 15.02           N  
ATOM    654  CA  ARG A 105      15.127 116.971  13.952  1.00 21.10           C  
ATOM    655  C   ARG A 105      14.209 117.343  15.117  1.00 17.18           C  
ATOM    656  O   ARG A 105      14.671 117.927  16.082  1.00 20.73           O  
ATOM    657  CB  ARG A 105      14.988 117.995  12.811  1.00 23.24           C  
ATOM    658  CG  ARG A 105      15.881 117.782  11.526  1.00 39.09           C  
ATOM    659  CD  ARG A 105      17.461 117.886  11.639  1.00 44.26           C  
ATOM    660  NE  ARG A 105      18.114 117.491  10.366  1.00 44.57           N  
ATOM    661  CZ  ARG A 105      19.430 117.418  10.117  1.00 36.18           C  
ATOM    662  NH1 ARG A 105      20.336 117.752  11.023  1.00 37.23           N  
ATOM    663  NH2 ARG A 105      19.843 117.034   8.918  1.00 37.90           N  
ATOM    664  N   ARG A 106      12.938 116.960  15.057  1.00 18.71           N  
ATOM    665  CA  ARG A 106      11.989 117.297  16.133  1.00 23.51           C  
ATOM    666  C   ARG A 106      12.084 116.441  17.389  1.00 22.39           C  
ATOM    667  O   ARG A 106      11.805 116.926  18.505  1.00 21.00           O  
ATOM    668  CB  ARG A 106      10.555 117.257  15.616  1.00 21.04           C  
ATOM    669  CG  ARG A 106      10.241 118.401  14.666  1.00 33.23           C  
ATOM    670  CD  ARG A 106       8.944 118.154  13.928  1.00 35.79           C  
ATOM    671  NE  ARG A 106       8.256 119.393  13.556  1.00 44.06           N  
ATOM    672  CZ  ARG A 106       7.024 119.443  13.056  1.00 43.69           C  
ATOM    673  NH1 ARG A 106       6.492 120.625  12.759  1.00 51.74           N  
ATOM    674  NH2 ARG A 106       6.316 118.326  12.855  1.00 38.98           N  
ATOM    675  N   THR A 107      12.441 115.166  17.225  1.00 17.64           N  
ATOM    676  CA  THR A 107      12.432 114.263  18.360  1.00 16.40           C  
ATOM    677  C   THR A 107      13.751 114.350  19.115  1.00 19.14           C  
ATOM    678  O   THR A 107      13.749 114.351  20.355  1.00 17.53           O  
ATOM    679  CB  THR A 107      12.120 112.797  17.975  1.00 13.71           C  
ATOM    680  OG1 THR A 107      10.979 112.752  17.116  1.00  9.29           O  
ATOM    681  CG2 THR A 107      11.845 111.960  19.239  1.00  9.71           C  
ATOM    682  N   TYR A 108      14.863 114.429  18.375  1.00 19.62           N  
ATOM    683  CA  TYR A 108      16.209 114.331  18.964  1.00 21.30           C  
ATOM    684  C   TYR A 108      17.119 115.541  18.737  1.00 22.20           C  
ATOM    685  O   TYR A 108      18.287 115.504  19.131  1.00 23.56           O  
ATOM    686  CB  TYR A 108      16.903 113.043  18.476  1.00 18.45           C  
ATOM    687  CG  TYR A 108      16.043 111.813  18.680  1.00 22.10           C  
ATOM    688  CD1 TYR A 108      15.817 111.315  19.967  1.00 17.48           C  
ATOM    689  CD2 TYR A 108      15.435 111.165  17.597  1.00 13.60           C  
ATOM    690  CE1 TYR A 108      15.023 110.211  20.174  1.00 20.25           C  
ATOM    691  CE2 TYR A 108      14.622 110.057  17.805  1.00 19.01           C  
ATOM    692  CZ  TYR A 108      14.424 109.583  19.093  1.00 20.67           C  
ATOM    693  OH  TYR A 108      13.619 108.478  19.316  1.00 26.38           O  
ATOM    694  N   SER A 109      16.582 116.599  18.130  1.00 20.93           N  
ATOM    695  CA  SER A 109      17.323 117.826  17.849  1.00 19.90           C  
ATOM    696  C   SER A 109      18.605 117.538  17.088  1.00 18.87           C  
ATOM    697  O   SER A 109      19.639 118.162  17.319  1.00 16.92           O  
ATOM    698  CB  SER A 109      17.592 118.594  19.141  1.00 24.59           C  
ATOM    699  OG  SER A 109      16.364 118.944  19.746  1.00 24.72           O  
ATOM    700  N   VAL A 110      18.508 116.601  16.151  1.00 18.34           N  
ATOM    701  CA  VAL A 110      19.648 116.091  15.415  1.00 19.81           C  
ATOM    702  C   VAL A 110      20.294 117.261  14.704  1.00 20.95           C  
ATOM    703  O   VAL A 110      19.594 118.075  14.168  1.00 21.41           O  
ATOM    704  CB  VAL A 110      19.205 115.025  14.396  1.00 14.94           C  
ATOM    705  CG1 VAL A 110      20.222 114.864  13.302  1.00 15.17           C  
ATOM    706  CG2 VAL A 110      18.912 113.688  15.116  1.00 18.49           C  
ATOM    707  N   SER A 111      21.620 117.343  14.740  1.00 19.15           N  
ATOM    708  CA  SER A 111      22.381 118.408  14.077  1.00 21.40           C  
ATOM    709  C   SER A 111      23.510 117.823  13.188  1.00 20.55           C  
ATOM    710  O   SER A 111      24.347 118.544  12.662  1.00 25.33           O  
ATOM    711  CB  SER A 111      22.987 119.305  15.145  1.00 19.53           C  
ATOM    712  OG  SER A 111      24.108 118.640  15.680  1.00 22.61           O  
ATOM    713  N   PHE A 112      23.547 116.503  13.053  1.00 15.35           N  
ATOM    714  CA  PHE A 112      24.508 115.855  12.225  1.00 15.72           C  
ATOM    715  C   PHE A 112      23.921 115.699  10.820  1.00 14.58           C  
ATOM    716  O   PHE A 112      22.715 115.744  10.650  1.00 15.09           O  
ATOM    717  CB  PHE A 112      24.981 114.513  12.822  1.00 15.69           C  
ATOM    718  CG  PHE A 112      23.885 113.578  13.260  1.00 16.19           C  
ATOM    719  CD1 PHE A 112      23.174 112.846  12.335  1.00  7.47           C  
ATOM    720  CD2 PHE A 112      23.650 113.347  14.639  1.00 12.83           C  
ATOM    721  CE1 PHE A 112      22.178 111.956  12.744  1.00 14.60           C  
ATOM    722  CE2 PHE A 112      22.677 112.446  15.047  1.00 17.54           C  
ATOM    723  CZ  PHE A 112      21.956 111.740  14.099  1.00 20.67           C  
ATOM    724  N   PRO A 113      24.785 115.558   9.818  1.00 18.37           N  
ATOM    725  CA  PRO A 113      24.343 115.326   8.437  1.00 18.25           C  
ATOM    726  C   PRO A 113      23.522 114.060   8.291  1.00 16.75           C  
ATOM    727  O   PRO A 113      23.899 112.991   8.778  1.00 13.51           O  
ATOM    728  CB  PRO A 113      25.668 115.191   7.658  1.00 17.81           C  
ATOM    729  CG  PRO A 113      26.674 115.799   8.471  1.00 15.85           C  
ATOM    730  CD  PRO A 113      26.259 115.662   9.901  1.00 19.00           C  
ATOM    731  N   MET A 114      22.402 114.198   7.606  1.00 16.28           N  
ATOM    732  CA  MET A 114      21.556 113.074   7.282  1.00 16.18           C  
ATOM    733  C   MET A 114      21.416 113.015   5.794  1.00 15.15           C  
ATOM    734  O   MET A 114      21.407 114.047   5.162  1.00 14.86           O  
ATOM    735  CB  MET A 114      20.189 113.270   7.912  1.00 14.42           C  
ATOM    736  CG  MET A 114      20.238 113.134   9.464  1.00 17.28           C  
ATOM    737  SD  MET A 114      18.580 113.113  10.096  1.00 19.70           S  
ATOM    738  CE  MET A 114      18.225 111.400   9.710  1.00 11.04           C  
ATOM    739  N   PHE A 115      21.282 111.804   5.259  1.00 13.82           N  
ATOM    740  CA  PHE A 115      21.264 111.543   3.819  1.00 11.78           C  
ATOM    741  C   PHE A 115      19.971 110.891   3.385  1.00 14.05           C  
ATOM    742  O   PHE A 115      19.206 110.422   4.217  1.00 15.09           O  
ATOM    743  CB  PHE A 115      22.472 110.673   3.455  1.00 16.06           C  
ATOM    744  CG  PHE A 115      23.767 111.392   3.639  1.00 16.75           C  
ATOM    745  CD1 PHE A 115      24.339 112.098   2.592  1.00 15.39           C  
ATOM    746  CD2 PHE A 115      24.361 111.468   4.917  1.00 17.37           C  
ATOM    747  CE1 PHE A 115      25.512 112.802   2.785  1.00 18.11           C  
ATOM    748  CE2 PHE A 115      25.515 112.196   5.122  1.00 11.09           C  
ATOM    749  CZ  PHE A 115      26.105 112.862   4.067  1.00 13.84           C  
ATOM    750  N   SER A 116      19.703 110.880   2.083  1.00 15.84           N  
ATOM    751  CA  SER A 116      18.521 110.215   1.555  1.00  8.96           C  
ATOM    752  C   SER A 116      18.649 108.730   1.791  1.00 13.47           C  
ATOM    753  O   SER A 116      19.753 108.184   1.753  1.00 12.63           O  
ATOM    754  CB  SER A 116      18.317 110.500   0.047  1.00  9.95           C  
ATOM    755  OG  SER A 116      17.858 111.830  -0.154  1.00 17.29           O  
ATOM    756  N   LYS A 117      17.507 108.090   2.045  1.00  8.55           N  
ATOM    757  CA  LYS A 117      17.408 106.651   2.225  1.00 14.08           C  
ATOM    758  C   LYS A 117      18.096 105.860   1.109  1.00 18.34           C  
ATOM    759  O   LYS A 117      17.912 106.153  -0.092  1.00 18.08           O  
ATOM    760  CB  LYS A 117      15.941 106.239   2.263  1.00 19.29           C  
ATOM    761  CG  LYS A 117      15.728 104.872   2.881  1.00 25.30           C  
ATOM    762  CD  LYS A 117      14.310 104.368   2.733  1.00 18.79           C  
ATOM    763  CE  LYS A 117      13.305 105.426   2.993  1.00 22.00           C  
ATOM    764  NZ  LYS A 117      12.041 104.779   3.279  1.00 19.18           N  
ATOM    765  N   ILE A 118      18.844 104.842   1.518  1.00 17.10           N  
ATOM    766  CA  ILE A 118      19.640 103.994   0.607  1.00 18.08           C  
ATOM    767  C   ILE A 118      19.563 102.518   1.056  1.00 19.78           C  
ATOM    768  O   ILE A 118      19.063 102.224   2.146  1.00 19.05           O  
ATOM    769  CB  ILE A 118      21.126 104.391   0.574  1.00 15.54           C  
ATOM    770  CG1 ILE A 118      21.700 104.511   1.997  1.00 15.83           C  
ATOM    771  CG2 ILE A 118      21.349 105.735  -0.143  1.00 17.26           C  
ATOM    772  CD1 ILE A 118      23.275 104.427   2.032  1.00 19.66           C  
ATOM    773  N   ALA A 119      20.059 101.614   0.205  1.00 19.07           N  
ATOM    774  CA  ALA A 119      20.509 100.261   0.625  1.00 17.09           C  
ATOM    775  C   ALA A 119      21.969 100.311   1.099  1.00 18.79           C  
ATOM    776  O   ALA A 119      22.812 101.032   0.541  1.00 15.04           O  
ATOM    777  CB  ALA A 119      20.365  99.283  -0.514  1.00 15.52           C  
ATOM    778  N   VAL A 120      22.266  99.563   2.147  1.00 17.47           N  
ATOM    779  CA  VAL A 120      23.639  99.449   2.646  1.00 18.01           C  
ATOM    780  C   VAL A 120      24.273  98.053   2.358  1.00 17.48           C  
ATOM    781  O   VAL A 120      25.495  97.864   2.476  1.00 17.39           O  
ATOM    782  CB  VAL A 120      23.710  99.855   4.147  1.00 19.76           C  
ATOM    783  CG1 VAL A 120      23.231 101.301   4.307  1.00 13.94           C  
ATOM    784  CG2 VAL A 120      22.937  98.869   5.062  1.00 10.90           C  
ATOM    785  N   THR A 121      23.425  97.099   1.950  1.00 19.39           N  
ATOM    786  CA  THR A 121      23.838  95.752   1.691  1.00 17.97           C  
ATOM    787  C   THR A 121      23.182  95.217   0.398  1.00 16.65           C  
ATOM    788  O   THR A 121      22.129  95.660  -0.019  1.00 11.90           O  
ATOM    789  CB  THR A 121      23.566  94.851   2.928  1.00 18.26           C  
ATOM    790  OG1 THR A 121      24.207  93.601   2.742  1.00 25.99           O  
ATOM    791  CG2 THR A 121      22.123  94.624   3.140  1.00 10.96           C  
ATOM    792  N   GLY A 122      23.858  94.296  -0.251  1.00 20.06           N  
ATOM    793  CA  GLY A 122      23.312  93.647  -1.430  1.00 18.50           C  
ATOM    794  C   GLY A 122      23.853  94.342  -2.652  1.00 22.78           C  
ATOM    795  O   GLY A 122      24.694  95.234  -2.554  1.00 26.07           O  
ATOM    796  N   THR A 123      23.343  93.931  -3.804  1.00 24.69           N  
ATOM    797  CA  THR A 123      23.819  94.396  -5.111  1.00 24.46           C  
ATOM    798  C   THR A 123      23.557  95.899  -5.336  1.00 24.51           C  
ATOM    799  O   THR A 123      24.375  96.618  -5.930  1.00 29.98           O  
ATOM    800  CB  THR A 123      23.160  93.547  -6.238  1.00 23.18           C  
ATOM    801  OG1 THR A 123      23.544  94.059  -7.522  1.00 32.42           O  
ATOM    802  CG2 THR A 123      21.613  93.558  -6.124  1.00 23.13           C  
ATOM    803  N   GLY A 124      22.402  96.360  -4.874  1.00 21.83           N  
ATOM    804  CA  GLY A 124      22.020  97.750  -4.967  1.00 19.95           C  
ATOM    805  C   GLY A 124      22.518  98.632  -3.841  1.00 15.82           C  
ATOM    806  O   GLY A 124      22.046  99.754  -3.714  1.00 17.05           O  
ATOM    807  N   ALA A 125      23.471  98.167  -3.025  1.00 16.33           N  
ATOM    808  CA  ALA A 125      23.998  99.027  -1.932  1.00 15.74           C  
ATOM    809  C   ALA A 125      24.665 100.285  -2.508  1.00 17.61           C  
ATOM    810  O   ALA A 125      25.259 100.275  -3.594  1.00 16.54           O  
ATOM    811  CB  ALA A 125      24.968  98.284  -1.033  1.00 15.37           C  
ATOM    812  N   HIS A 126      24.590 101.376  -1.771  1.00 16.65           N  
ATOM    813  CA  HIS A 126      25.323 102.559  -2.139  1.00 14.11           C  
ATOM    814  C   HIS A 126      26.829 102.190  -2.258  1.00 16.35           C  
ATOM    815  O   HIS A 126      27.377 101.513  -1.370  1.00 13.54           O  
ATOM    816  CB  HIS A 126      25.061 103.672  -1.122  1.00 14.18           C  
ATOM    817  CG  HIS A 126      25.564 105.009  -1.557  1.00 15.42           C  
ATOM    818  ND1 HIS A 126      26.901 105.262  -1.773  1.00 18.15           N  
ATOM    819  CD2 HIS A 126      24.913 106.161  -1.826  1.00 17.60           C  
ATOM    820  CE1 HIS A 126      27.054 106.518  -2.152  1.00 21.75           C  
ATOM    821  NE2 HIS A 126      25.861 107.086  -2.189  1.00 16.29           N  
ATOM    822  N   PRO A 127      27.502 102.620  -3.357  1.00 18.12           N  
ATOM    823  CA  PRO A 127      28.931 102.317  -3.543  1.00 19.03           C  
ATOM    824  C   PRO A 127      29.795 102.661  -2.321  1.00 15.83           C  
ATOM    825  O   PRO A 127      30.777 101.984  -2.065  1.00 17.97           O  
ATOM    826  CB  PRO A 127      29.329 103.184  -4.762  1.00 18.01           C  
ATOM    827  CG  PRO A 127      28.121 103.409  -5.494  1.00 25.35           C  
ATOM    828  CD  PRO A 127      26.974 103.404  -4.492  1.00 18.34           C  
ATOM    829  N   ALA A 128      29.454 103.717  -1.594  1.00 16.81           N  
ATOM    830  CA  ALA A 128      30.201 104.087  -0.383  1.00 16.93           C  
ATOM    831  C   ALA A 128      30.098 102.998   0.665  1.00 15.90           C  
ATOM    832  O   ALA A 128      31.058 102.733   1.378  1.00 20.27           O  
ATOM    833  CB  ALA A 128      29.706 105.455   0.196  1.00 19.08           C  
ATOM    834  N   PHE A 129      28.923 102.379   0.768  1.00 16.30           N  
ATOM    835  CA  PHE A 129      28.738 101.262   1.645  1.00 15.28           C  
ATOM    836  C   PHE A 129      29.369  99.970   1.141  1.00 14.52           C  
ATOM    837  O   PHE A 129      29.850  99.214   1.972  1.00 13.21           O  
ATOM    838  CB  PHE A 129      27.262 101.081   2.030  1.00 18.74           C  
ATOM    839  CG  PHE A 129      26.844 101.992   3.162  1.00 19.55           C  
ATOM    840  CD1 PHE A 129      26.882 101.561   4.483  1.00 19.82           C  
ATOM    841  CD2 PHE A 129      26.457 103.309   2.901  1.00 18.22           C  
ATOM    842  CE1 PHE A 129      26.560 102.445   5.517  1.00 18.50           C  
ATOM    843  CE2 PHE A 129      26.108 104.178   3.921  1.00 18.97           C  
ATOM    844  CZ  PHE A 129      26.145 103.753   5.219  1.00 14.49           C  
ATOM    845  N   LYS A 130      29.407  99.717  -0.182  1.00 14.20           N  
ATOM    846  CA  LYS A 130      30.238  98.637  -0.740  1.00 16.96           C  
ATOM    847  C   LYS A 130      31.706  98.802  -0.314  1.00 19.03           C  
ATOM    848  O   LYS A 130      32.340  97.840   0.095  1.00 20.97           O  
ATOM    849  CB  LYS A 130      30.143  98.569  -2.279  1.00 15.82           C  
ATOM    850  CG  LYS A 130      28.774  98.086  -2.732  1.00 22.29           C  
ATOM    851  CD  LYS A 130      28.574  98.019  -4.262  1.00 28.34           C  
ATOM    852  CE  LYS A 130      27.121  97.588  -4.592  1.00 31.04           C  
ATOM    853  NZ  LYS A 130      26.969  97.065  -5.987  1.00 35.26           N  
ATOM    854  N   TYR A 131      32.225 100.026  -0.423  1.00 16.05           N  
ATOM    855  CA  TYR A 131      33.571 100.345  -0.034  1.00 16.83           C  
ATOM    856  C   TYR A 131      33.821  99.999   1.468  1.00 16.45           C  
ATOM    857  O   TYR A 131      34.814  99.350   1.803  1.00 17.26           O  
ATOM    858  CB  TYR A 131      33.884 101.842  -0.292  1.00 17.94           C  
ATOM    859  CG  TYR A 131      35.186 102.234   0.346  1.00 13.00           C  
ATOM    860  CD1 TYR A 131      36.391 101.963  -0.322  1.00 27.25           C  
ATOM    861  CD2 TYR A 131      35.233 102.779   1.630  1.00 16.93           C  
ATOM    862  CE1 TYR A 131      37.606 102.255   0.252  1.00 25.01           C  
ATOM    863  CE2 TYR A 131      36.462 103.057   2.229  1.00 23.17           C  
ATOM    864  CZ  TYR A 131      37.634 102.795   1.521  1.00 16.22           C  
ATOM    865  OH  TYR A 131      38.860 103.066   2.043  1.00 26.27           O  
ATOM    866  N   LEU A 132      32.923 100.424   2.344  1.00 12.14           N  
ATOM    867  CA  LEU A 132      33.100 100.220   3.804  1.00 15.29           C  
ATOM    868  C   LEU A 132      33.096  98.710   4.154  1.00 18.05           C  
ATOM    869  O   LEU A 132      33.869  98.268   4.999  1.00 18.66           O  
ATOM    870  CB  LEU A 132      31.984 100.910   4.558  1.00 14.01           C  
ATOM    871  CG  LEU A 132      31.921 102.425   4.629  1.00 15.56           C  
ATOM    872  CD1 LEU A 132      30.681 102.904   5.406  1.00 12.19           C  
ATOM    873  CD2 LEU A 132      33.176 102.972   5.254  1.00 15.09           C  
ATOM    874  N   ALA A 133      32.253  97.931   3.460  1.00 16.79           N  
ATOM    875  CA  ALA A 133      32.103  96.487   3.694  1.00 17.22           C  
ATOM    876  C   ALA A 133      33.293  95.724   3.114  1.00 20.29           C  
ATOM    877  O   ALA A 133      33.869  94.864   3.770  1.00 16.71           O  
ATOM    878  CB  ALA A 133      30.804  95.971   3.096  1.00 14.11           C  
ATOM    879  N   GLN A 134      33.665  96.055   1.881  1.00 21.82           N  
ATOM    880  CA  GLN A 134      34.815  95.424   1.236  1.00 23.89           C  
ATOM    881  C   GLN A 134      36.125  95.670   1.992  1.00 20.23           C  
ATOM    882  O   GLN A 134      36.910  94.744   2.190  1.00 21.28           O  
ATOM    883  CB  GLN A 134      34.941  95.875  -0.220  1.00 20.41           C  
ATOM    884  CG  GLN A 134      33.838  95.307  -1.131  1.00 34.77           C  
ATOM    885  CD  GLN A 134      33.855  95.899  -2.569  1.00 39.14           C  
ATOM    886  OE1 GLN A 134      34.753  96.674  -2.930  1.00 59.74           O  
ATOM    887  NE2 GLN A 134      32.845  95.541  -3.377  1.00 49.02           N  
ATOM    888  N   THR A 135      36.378  96.892   2.425  1.00 18.26           N  
ATOM    889  CA  THR A 135      37.665  97.193   3.093  1.00 17.06           C  
ATOM    890  C   THR A 135      37.653  96.823   4.598  1.00 16.41           C  
ATOM    891  O   THR A 135      38.690  96.513   5.179  1.00 17.84           O  
ATOM    892  CB  THR A 135      38.098  98.690   2.901  1.00 15.25           C  
ATOM    893  OG1 THR A 135      37.208  99.530   3.624  1.00 23.86           O  
ATOM    894  CG2 THR A 135      38.091  99.100   1.401  1.00 14.86           C  
ATOM    895  N   SER A 136      36.498  96.823   5.241  1.00 16.85           N  
ATOM    896  CA  SER A 136      36.466  96.449   6.668  1.00 14.54           C  
ATOM    897  C   SER A 136      36.290  94.941   6.829  1.00 15.91           C  
ATOM    898  O   SER A 136      36.720  94.366   7.832  1.00 13.29           O  
ATOM    899  CB  SER A 136      35.365  97.182   7.413  1.00 15.07           C  
ATOM    900  OG  SER A 136      34.109  96.672   7.099  1.00 20.72           O  
ATOM    901  N   GLY A 137      35.680  94.291   5.841  1.00 13.54           N  
ATOM    902  CA  GLY A 137      35.336  92.869   5.932  1.00 14.17           C  
ATOM    903  C   GLY A 137      33.997  92.595   6.628  1.00 17.26           C  
ATOM    904  O   GLY A 137      33.591  91.431   6.771  1.00 19.24           O  
ATOM    905  N   LYS A 138      33.308  93.645   7.065  1.00 16.48           N  
ATOM    906  CA  LYS A 138      32.006  93.504   7.715  1.00 17.70           C  
ATOM    907  C   LYS A 138      31.005  94.337   6.960  1.00 20.31           C  
ATOM    908  O   LYS A 138      31.264  95.513   6.654  1.00 18.14           O  
ATOM    909  CB  LYS A 138      32.009  93.991   9.178  1.00 18.62           C  
ATOM    910  CG  LYS A 138      33.053  93.366  10.090  1.00 20.45           C  
ATOM    911  CD  LYS A 138      34.185  94.354  10.286  1.00 34.57           C  
ATOM    912  CE  LYS A 138      35.504  93.718  10.672  1.00 36.04           C  
ATOM    913  NZ  LYS A 138      36.547  94.770  10.710  1.00 34.53           N  
ATOM    914  N   GLU A 139      29.848  93.746   6.677  1.00 20.34           N  
ATOM    915  CA  GLU A 139      28.735  94.494   6.122  1.00 19.84           C  
ATOM    916  C   GLU A 139      27.615  94.573   7.168  1.00 16.64           C  
ATOM    917  O   GLU A 139      27.504  93.712   8.054  1.00 20.96           O  
ATOM    918  CB  GLU A 139      28.257  93.881   4.764  1.00 20.28           C  
ATOM    919  CG  GLU A 139      27.493  92.591   4.830  1.00 22.40           C  
ATOM    920  CD  GLU A 139      26.926  92.130   3.449  1.00 23.78           C  
ATOM    921  OE1 GLU A 139      27.602  92.287   2.417  1.00 30.52           O  
ATOM    922  OE2 GLU A 139      25.783  91.602   3.405  1.00 21.27           O  
ATOM    923  N   PRO A 140      26.764  95.583   7.058  1.00 16.37           N  
ATOM    924  CA  PRO A 140      25.692  95.672   8.029  1.00 15.38           C  
ATOM    925  C   PRO A 140      24.686  94.532   7.953  1.00 11.98           C  
ATOM    926  O   PRO A 140      24.217  94.133   6.848  1.00 10.29           O  
ATOM    927  CB  PRO A 140      25.023  97.015   7.713  1.00 16.45           C  
ATOM    928  CG  PRO A 140      25.955  97.723   6.826  1.00 20.67           C  
ATOM    929  CD  PRO A 140      26.673  96.664   6.060  1.00 17.78           C  
ATOM    930  N   THR A 141      24.358  94.037   9.137  1.00 11.06           N  
ATOM    931  CA  THR A 141      23.416  92.947   9.339  1.00 13.89           C  
ATOM    932  C   THR A 141      22.205  93.381  10.178  1.00 15.68           C  
ATOM    933  O   THR A 141      21.381  92.540  10.531  1.00 14.61           O  
ATOM    934  CB  THR A 141      24.110  91.713  10.000  1.00 13.29           C  
ATOM    935  OG1 THR A 141      24.833  92.129  11.151  1.00 18.96           O  
ATOM    936  CG2 THR A 141      25.075  91.053   9.028  1.00 12.29           C  
ATOM    937  N   TRP A 142      22.112  94.679  10.475  1.00 12.75           N  
ATOM    938  CA  TRP A 142      20.953  95.290  11.113  1.00 11.75           C  
ATOM    939  C   TRP A 142      21.049  96.820  11.066  1.00 12.53           C  
ATOM    940  O   TRP A 142      22.024  97.401  10.600  1.00 12.01           O  
ATOM    941  CB  TRP A 142      20.816  94.860  12.595  1.00 12.37           C  
ATOM    942  CG  TRP A 142      19.399  94.994  13.139  1.00 15.08           C  
ATOM    943  CD1 TRP A 142      18.995  95.756  14.227  1.00 16.20           C  
ATOM    944  CD2 TRP A 142      18.205  94.373  12.625  1.00 16.90           C  
ATOM    945  NE1 TRP A 142      17.636  95.655  14.389  1.00 19.06           N  
ATOM    946  CE2 TRP A 142      17.125  94.818  13.427  1.00 16.89           C  
ATOM    947  CE3 TRP A 142      17.944  93.487  11.561  1.00 17.92           C  
ATOM    948  CZ2 TRP A 142      15.812  94.390  13.214  1.00 21.67           C  
ATOM    949  CZ3 TRP A 142      16.652  93.059  11.359  1.00 19.20           C  
ATOM    950  CH2 TRP A 142      15.593  93.514  12.178  1.00 19.24           C  
ATOM    951  N   ASN A 143      20.015  97.459  11.605  1.00 12.71           N  
ATOM    952  CA  ASN A 143      19.997  98.887  11.767  1.00 13.41           C  
ATOM    953  C   ASN A 143      21.060  99.305  12.769  1.00 14.19           C  
ATOM    954  O   ASN A 143      21.398  98.555  13.680  1.00 12.95           O  
ATOM    955  CB  ASN A 143      18.626  99.349  12.264  1.00 14.55           C  
ATOM    956  CG  ASN A 143      17.531  98.857  11.402  1.00  9.56           C  
ATOM    957  OD1 ASN A 143      17.511  99.137  10.202  1.00 13.49           O  
ATOM    958  ND2 ASN A 143      16.620  98.047  11.987  1.00 12.64           N  
ATOM    959  N   PHE A 144      21.613 100.493  12.543  1.00 13.96           N  
ATOM    960  CA  PHE A 144      22.499 101.149  13.484  1.00 12.83           C  
ATOM    961  C   PHE A 144      23.885 100.515  13.622  1.00 13.70           C  
ATOM    962  O   PHE A 144      24.533 100.570  14.694  1.00 13.54           O  
ATOM    963  CB  PHE A 144      21.796 101.342  14.813  1.00 12.54           C  
ATOM    964  CG  PHE A 144      20.691 102.358  14.760  1.00 13.77           C  
ATOM    965  CD1 PHE A 144      21.009 103.720  14.675  1.00 15.36           C  
ATOM    966  CD2 PHE A 144      19.346 101.974  14.844  1.00 13.60           C  
ATOM    967  CE1 PHE A 144      20.038 104.658  14.654  1.00 11.56           C  
ATOM    968  CE2 PHE A 144      18.354 102.910  14.801  1.00 13.95           C  
ATOM    969  CZ  PHE A 144      18.695 104.275  14.705  1.00 17.05           C  
ATOM    970  N   TRP A 145      24.318  99.921  12.521  1.00 11.34           N  
ATOM    971  CA  TRP A 145      25.732  99.611  12.309  1.00 14.38           C  
ATOM    972  C   TRP A 145      26.493 100.896  12.150  1.00 14.66           C  
ATOM    973  O   TRP A 145      25.928 101.898  11.707  1.00 12.19           O  
ATOM    974  CB  TRP A 145      25.916  98.707  11.084  1.00 18.13           C  
ATOM    975  CG  TRP A 145      26.026  97.308  11.461  1.00 17.39           C  
ATOM    976  CD1 TRP A 145      25.013  96.476  11.799  1.00 14.24           C  
ATOM    977  CD2 TRP A 145      27.238  96.560  11.609  1.00 15.58           C  
ATOM    978  NE1 TRP A 145      25.509  95.248  12.137  1.00 16.77           N  
ATOM    979  CE2 TRP A 145      26.871  95.264  12.024  1.00 18.20           C  
ATOM    980  CE3 TRP A 145      28.600  96.859  11.431  1.00 11.80           C  
ATOM    981  CZ2 TRP A 145      27.813  94.255  12.266  1.00 16.94           C  
ATOM    982  CZ3 TRP A 145      29.529  95.858  11.675  1.00 15.92           C  
ATOM    983  CH2 TRP A 145      29.134  94.580  12.106  1.00 14.16           C  
ATOM    984  N   LYS A 146      27.770 100.867  12.555  1.00 15.96           N  
ATOM    985  CA  LYS A 146      28.588 102.069  12.686  1.00 16.24           C  
ATOM    986  C   LYS A 146      29.977 101.786  12.146  1.00 15.01           C  
ATOM    987  O   LYS A 146      30.568 100.783  12.488  1.00 18.06           O  
ATOM    988  CB  LYS A 146      28.643 102.499  14.161  1.00 17.87           C  
ATOM    989  CG  LYS A 146      27.275 102.792  14.675  1.00 21.66           C  
ATOM    990  CD  LYS A 146      27.303 103.216  16.099  1.00 20.75           C  
ATOM    991  CE  LYS A 146      25.907 103.263  16.662  1.00 32.25           C  
ATOM    992  NZ  LYS A 146      25.393 101.875  16.858  1.00 29.21           N  
ATOM    993  N   TYR A 147      30.449 102.638  11.238  1.00 18.42           N  
ATOM    994  CA  TYR A 147      31.807 102.580  10.723  1.00 16.45           C  
ATOM    995  C   TYR A 147      32.507 103.862  11.082  1.00 18.69           C  
ATOM    996  O   TYR A 147      31.976 104.948  10.814  1.00 15.84           O  
ATOM    997  CB  TYR A 147      31.788 102.462   9.201  1.00 18.29           C  
ATOM    998  CG  TYR A 147      31.218 101.172   8.715  1.00 16.77           C  
ATOM    999  CD1 TYR A 147      32.027 100.080   8.496  1.00 12.56           C  
ATOM   1000  CD2 TYR A 147      29.864 101.047   8.466  1.00 23.78           C  
ATOM   1001  CE1 TYR A 147      31.503  98.863   8.041  1.00 14.37           C  
ATOM   1002  CE2 TYR A 147      29.328  99.849   8.014  1.00 17.63           C  
ATOM   1003  CZ  TYR A 147      30.158  98.763   7.792  1.00 18.70           C  
ATOM   1004  OH  TYR A 147      29.625  97.586   7.343  1.00 22.27           O  
ATOM   1005  N   LEU A 148      33.719 103.717  11.627  1.00 15.53           N  
ATOM   1006  CA  LEU A 148      34.594 104.816  11.889  1.00 16.63           C  
ATOM   1007  C   LEU A 148      35.522 105.065  10.708  1.00 15.64           C  
ATOM   1008  O   LEU A 148      36.306 104.200  10.340  1.00 14.16           O  
ATOM   1009  CB  LEU A 148      35.400 104.552  13.177  1.00 13.68           C  
ATOM   1010  CG  LEU A 148      36.374 105.642  13.596  1.00 14.98           C  
ATOM   1011  CD1 LEU A 148      35.674 107.019  13.619  1.00 16.54           C  
ATOM   1012  CD2 LEU A 148      37.001 105.244  14.955  1.00 11.30           C  
ATOM   1013  N   VAL A 149      35.418 106.258  10.127  1.00 16.18           N  
ATOM   1014  CA  VAL A 149      36.276 106.651   9.036  1.00 14.05           C  
ATOM   1015  C   VAL A 149      37.270 107.734   9.453  1.00 11.82           C  
ATOM   1016  O   VAL A 149      36.876 108.768   9.953  1.00 12.20           O  
ATOM   1017  CB  VAL A 149      35.440 107.125   7.816  1.00 16.32           C  
ATOM   1018  CG1 VAL A 149      36.372 107.528   6.655  1.00 11.04           C  
ATOM   1019  CG2 VAL A 149      34.443 106.051   7.407  1.00 14.07           C  
ATOM   1020  N   ALA A 150      38.563 107.474   9.203  1.00 10.73           N  
ATOM   1021  CA  ALA A 150      39.663 108.375   9.519  1.00 12.29           C  
ATOM   1022  C   ALA A 150      39.716 109.525   8.540  1.00 14.15           C  
ATOM   1023  O   ALA A 150      39.146 109.433   7.427  1.00 16.64           O  
ATOM   1024  CB  ALA A 150      41.025 107.582   9.491  1.00  9.15           C  
ATOM   1025  N   PRO A 151      40.448 110.606   8.903  1.00 14.01           N  
ATOM   1026  CA  PRO A 151      40.596 111.776   8.043  1.00 14.72           C  
ATOM   1027  C   PRO A 151      40.936 111.484   6.568  1.00 17.07           C  
ATOM   1028  O   PRO A 151      40.512 112.233   5.681  1.00 15.42           O  
ATOM   1029  CB  PRO A 151      41.679 112.571   8.751  1.00 16.33           C  
ATOM   1030  CG  PRO A 151      41.493 112.266  10.152  1.00 14.03           C  
ATOM   1031  CD  PRO A 151      41.151 110.800  10.177  1.00 15.03           C  
ATOM   1032  N   ASP A 152      41.680 110.401   6.315  1.00 17.67           N  
ATOM   1033  CA  ASP A 152      42.037 109.991   4.945  1.00 19.18           C  
ATOM   1034  C   ASP A 152      40.989 109.139   4.221  1.00 19.06           C  
ATOM   1035  O   ASP A 152      41.236 108.653   3.116  1.00 19.72           O  
ATOM   1036  CB  ASP A 152      43.441 109.327   4.891  1.00 16.45           C  
ATOM   1037  CG  ASP A 152      43.517 107.984   5.638  1.00 19.54           C  
ATOM   1038  OD1 ASP A 152      42.562 107.553   6.277  1.00 22.34           O  
ATOM   1039  OD2 ASP A 152      44.577 107.346   5.603  1.00 28.97           O  
ATOM   1040  N   GLY A 153      39.820 108.986   4.836  1.00 21.21           N  
ATOM   1041  CA  GLY A 153      38.718 108.264   4.252  1.00 18.97           C  
ATOM   1042  C   GLY A 153      38.803 106.749   4.378  1.00 19.52           C  
ATOM   1043  O   GLY A 153      38.080 106.036   3.672  1.00 13.94           O  
ATOM   1044  N   LYS A 154      39.673 106.237   5.249  1.00 18.54           N  
ATOM   1045  CA  LYS A 154      39.800 104.791   5.410  1.00 21.01           C  
ATOM   1046  C   LYS A 154      39.115 104.318   6.669  1.00 16.32           C  
ATOM   1047  O   LYS A 154      39.186 104.956   7.706  1.00 19.01           O  
ATOM   1048  CB  LYS A 154      41.278 104.348   5.368  1.00 21.41           C  
ATOM   1049  CG  LYS A 154      41.920 104.821   4.085  1.00 25.62           C  
ATOM   1050  CD  LYS A 154      43.116 104.030   3.637  1.00 41.29           C  
ATOM   1051  CE  LYS A 154      43.548 104.474   2.208  1.00 41.44           C  
ATOM   1052  NZ  LYS A 154      42.433 104.309   1.200  1.00 37.33           N  
ATOM   1053  N   VAL A 155      38.495 103.147   6.554  1.00 18.63           N  
ATOM   1054  CA  VAL A 155      37.733 102.571   7.650  0.50 16.75           C  
ATOM   1056  C   VAL A 155      38.703 101.985   8.669  1.00 18.30           C  
ATOM   1057  O   VAL A 155      39.616 101.228   8.338  1.00 23.64           O  
ATOM   1058  CB  VAL A 155      36.684 101.509   7.193  0.50 18.55           C  
ATOM   1060  CG1 VAL A 155      35.565 101.419   8.199  0.50 17.29           C  
ATOM   1062  CG2 VAL A 155      36.092 101.871   5.846  0.50 15.50           C  
ATOM   1064  N   VAL A 156      38.541 102.403   9.911  1.00 16.80           N  
ATOM   1065  CA  VAL A 156      39.399 101.937  10.987  1.00 17.22           C  
ATOM   1066  C   VAL A 156      38.609 101.161  12.033  1.00 18.39           C  
ATOM   1067  O   VAL A 156      39.208 100.496  12.880  1.00 20.84           O  
ATOM   1068  CB  VAL A 156      40.212 103.095  11.643  1.00 18.83           C  
ATOM   1069  CG1 VAL A 156      41.174 103.711  10.635  1.00 22.89           C  
ATOM   1070  CG2 VAL A 156      39.327 104.153  12.169  1.00 19.98           C  
ATOM   1071  N   GLY A 157      37.277 101.203  11.973  1.00 19.25           N  
ATOM   1072  CA  GLY A 157      36.446 100.392  12.887  1.00 17.47           C  
ATOM   1073  C   GLY A 157      35.037 100.218  12.411  1.00 14.96           C  
ATOM   1074  O   GLY A 157      34.554 101.025  11.662  1.00 12.55           O  
ATOM   1075  N   ALA A 158      34.391  99.145  12.856  1.00 13.52           N  
ATOM   1076  CA  ALA A 158      33.005  98.862  12.540  1.00 14.45           C  
ATOM   1077  C   ALA A 158      32.343  98.185  13.739  1.00 15.19           C  
ATOM   1078  O   ALA A 158      32.899  97.248  14.292  1.00 15.57           O  
ATOM   1079  CB  ALA A 158      32.922  97.954  11.295  1.00 12.38           C  
ATOM   1080  N   TRP A 159      31.144  98.626  14.130  1.00 16.51           N  
ATOM   1081  CA  TRP A 159      30.438  97.980  15.237  1.00 17.56           C  
ATOM   1082  C   TRP A 159      28.995  97.738  14.895  1.00 15.90           C  
ATOM   1083  O   TRP A 159      28.402  98.515  14.180  1.00 13.07           O  
ATOM   1084  CB  TRP A 159      30.484  98.840  16.503  1.00 19.68           C  
ATOM   1085  CG  TRP A 159      31.865  99.210  16.935  1.00 22.48           C  
ATOM   1086  CD1 TRP A 159      32.631  98.561  17.849  1.00 24.72           C  
ATOM   1087  CD2 TRP A 159      32.659 100.309  16.453  1.00 19.49           C  
ATOM   1088  NE1 TRP A 159      33.841  99.183  17.978  1.00 27.13           N  
ATOM   1089  CE2 TRP A 159      33.889 100.261  17.134  1.00 25.99           C  
ATOM   1090  CE3 TRP A 159      32.454 101.312  15.506  1.00 21.50           C  
ATOM   1091  CZ2 TRP A 159      34.908 101.194  16.914  1.00 25.90           C  
ATOM   1092  CZ3 TRP A 159      33.467 102.253  15.292  1.00 24.80           C  
ATOM   1093  CH2 TRP A 159      34.668 102.189  16.004  1.00 18.91           C  
ATOM   1094  N   ASP A 160      28.422  96.678  15.453  1.00 14.86           N  
ATOM   1095  CA  ASP A 160      26.996  96.429  15.317  1.00 13.57           C  
ATOM   1096  C   ASP A 160      26.223  97.261  16.345  1.00 15.04           C  
ATOM   1097  O   ASP A 160      26.816  97.754  17.308  1.00 17.00           O  
ATOM   1098  CB  ASP A 160      26.725  94.920  15.432  1.00 14.92           C  
ATOM   1099  CG  ASP A 160      26.728  94.423  16.874  1.00 18.60           C  
ATOM   1100  OD1 ASP A 160      27.816  94.174  17.411  1.00 30.89           O  
ATOM   1101  OD2 ASP A 160      25.641  94.291  17.475  1.00 19.72           O  
ATOM   1102  N   PRO A 161      24.881  97.351  16.201  1.00 15.29           N  
ATOM   1103  CA  PRO A 161      24.123  98.232  17.082  1.00 15.47           C  
ATOM   1104  C   PRO A 161      24.181  97.849  18.556  1.00 15.45           C  
ATOM   1105  O   PRO A 161      23.916  98.700  19.387  1.00 13.87           O  
ATOM   1106  CB  PRO A 161      22.681  98.098  16.571  1.00 15.60           C  
ATOM   1107  CG  PRO A 161      22.659  96.697  15.917  1.00 17.70           C  
ATOM   1108  CD  PRO A 161      23.992  96.632  15.254  1.00 17.08           C  
ATOM   1109  N   THR A 162      24.527  96.607  18.890  1.00 13.11           N  
ATOM   1110  CA  THR A 162      24.586  96.217  20.310  1.00 15.23           C  
ATOM   1111  C   THR A 162      25.795  96.763  21.043  1.00 11.90           C  
ATOM   1112  O   THR A 162      25.878  96.583  22.240  1.00 14.76           O  
ATOM   1113  CB  THR A 162      24.516  94.671  20.553  1.00 12.21           C  
ATOM   1114  OG1 THR A 162      25.692  94.042  20.039  1.00 15.41           O  
ATOM   1115  CG2 THR A 162      23.276  94.072  19.930  1.00  8.74           C  
ATOM   1116  N   VAL A 163      26.752  97.384  20.336  1.00 15.09           N  
ATOM   1117  CA  VAL A 163      27.872  97.996  21.009  1.00 14.48           C  
ATOM   1118  C   VAL A 163      27.472  99.434  21.367  1.00 16.53           C  
ATOM   1119  O   VAL A 163      27.096 100.215  20.472  1.00 15.33           O  
ATOM   1120  CB  VAL A 163      29.179  97.970  20.152  1.00 15.19           C  
ATOM   1121  CG1 VAL A 163      30.303  98.654  20.913  1.00 12.22           C  
ATOM   1122  CG2 VAL A 163      29.561  96.517  19.800  1.00 14.75           C  
ATOM   1123  N   SER A 164      27.551  99.759  22.658  1.00 14.46           N  
ATOM   1124  CA  SER A 164      27.182 101.077  23.164  1.00 22.76           C  
ATOM   1125  C   SER A 164      28.040 102.202  22.621  1.00 27.31           C  
ATOM   1126  O   SER A 164      29.218 102.016  22.275  1.00 26.45           O  
ATOM   1127  CB  SER A 164      27.201 101.128  24.699  1.00 24.08           C  
ATOM   1128  OG  SER A 164      28.453 100.747  25.224  1.00 29.68           O  
ATOM   1129  N   VAL A 165      27.450 103.391  22.566  1.00 32.59           N  
ATOM   1130  CA  VAL A 165      28.193 104.562  22.107  1.00 31.62           C  
ATOM   1131  C   VAL A 165      29.263 104.925  23.149  1.00 30.60           C  
ATOM   1132  O   VAL A 165      30.297 105.449  22.766  1.00 35.08           O  
ATOM   1133  CB  VAL A 165      27.257 105.718  21.657  1.00 33.63           C  
ATOM   1134  CG1 VAL A 165      28.020 107.005  21.400  1.00 29.32           C  
ATOM   1135  CG2 VAL A 165      26.519 105.303  20.381  1.00 35.59           C  
ATOM   1136  N   GLU A 166      29.075 104.584  24.426  1.00 28.23           N  
ATOM   1137  CA  GLU A 166      30.188 104.641  25.431  1.00 30.54           C  
ATOM   1138  C   GLU A 166      31.453 103.857  25.033  1.00 27.75           C  
ATOM   1139  O   GLU A 166      32.562 104.201  25.461  1.00 26.47           O  
ATOM   1140  CB  GLU A 166      29.783 104.047  26.792  1.00 28.95           C  
ATOM   1141  CG  GLU A 166      28.878 104.878  27.667  1.00 38.36           C  
ATOM   1142  CD  GLU A 166      27.422 104.517  27.495  1.00 52.38           C  
ATOM   1143  OE1 GLU A 166      27.027 104.143  26.367  1.00 60.17           O  
ATOM   1144  OE2 GLU A 166      26.668 104.609  28.487  1.00 59.56           O  
ATOM   1145  N   GLU A 167      31.258 102.740  24.321  1.00 21.38           N  
ATOM   1146  CA  GLU A 167      32.365 101.888  23.886  1.00 20.41           C  
ATOM   1147  C   GLU A 167      32.940 102.328  22.561  1.00 14.63           C  
ATOM   1148  O   GLU A 167      34.145 102.170  22.320  1.00 19.14           O  
ATOM   1149  CB  GLU A 167      31.907 100.430  23.813  1.00 20.46           C  
ATOM   1150  CG  GLU A 167      31.528  99.892  25.170  1.00 20.87           C  
ATOM   1151  CD  GLU A 167      31.232  98.383  25.197  1.00 30.00           C  
ATOM   1152  OE1 GLU A 167      31.379  97.698  24.145  1.00 34.72           O  
ATOM   1153  OE2 GLU A 167      30.858  97.899  26.296  1.00 39.34           O  
ATOM   1154  N   VAL A 168      32.083 102.863  21.692  1.00 14.78           N  
ATOM   1155  CA  VAL A 168      32.517 103.399  20.404  1.00 16.97           C  
ATOM   1156  C   VAL A 168      33.247 104.762  20.534  1.00 16.24           C  
ATOM   1157  O   VAL A 168      34.299 104.996  19.914  1.00 17.09           O  
ATOM   1158  CB  VAL A 168      31.324 103.514  19.427  1.00 15.75           C  
ATOM   1159  CG1 VAL A 168      31.735 104.225  18.135  1.00 16.39           C  
ATOM   1160  CG2 VAL A 168      30.781 102.113  19.150  1.00 16.12           C  
ATOM   1161  N   ARG A 169      32.700 105.637  21.360  1.00 16.51           N  
ATOM   1162  CA  ARG A 169      33.195 107.003  21.478  1.00 15.95           C  
ATOM   1163  C   ARG A 169      34.702 107.113  21.695  1.00 15.84           C  
ATOM   1164  O   ARG A 169      35.341 107.924  21.026  1.00 16.24           O  
ATOM   1165  CB  ARG A 169      32.424 107.778  22.549  1.00 12.35           C  
ATOM   1166  CG  ARG A 169      32.877 109.236  22.694  1.00 16.23           C  
ATOM   1167  CD  ARG A 169      32.202 109.900  23.847  1.00 18.51           C  
ATOM   1168  NE  ARG A 169      32.760 109.430  25.107  1.00 20.86           N  
ATOM   1169  CZ  ARG A 169      32.077 108.966  26.150  1.00 14.70           C  
ATOM   1170  NH1 ARG A 169      30.754 108.867  26.137  1.00 21.51           N  
ATOM   1171  NH2 ARG A 169      32.751 108.576  27.207  1.00 22.96           N  
ATOM   1172  N   PRO A 170      35.268 106.397  22.680  1.00 17.64           N  
ATOM   1173  CA  PRO A 170      36.716 106.553  22.915  1.00 18.75           C  
ATOM   1174  C   PRO A 170      37.616 106.264  21.711  1.00 18.33           C  
ATOM   1175  O   PRO A 170      38.728 106.826  21.610  1.00 16.30           O  
ATOM   1176  CB  PRO A 170      36.990 105.596  24.072  1.00 16.98           C  
ATOM   1177  CG  PRO A 170      35.671 105.548  24.813  1.00 16.76           C  
ATOM   1178  CD  PRO A 170      34.651 105.535  23.710  1.00 19.85           C  
ATOM   1179  N   GLN A 171      37.133 105.406  20.820  1.00 16.64           N  
ATOM   1180  CA  GLN A 171      37.837 105.072  19.598  1.00 17.64           C  
ATOM   1181  C   GLN A 171      37.843 106.238  18.629  1.00 17.06           C  
ATOM   1182  O   GLN A 171      38.793 106.411  17.874  1.00 20.46           O  
ATOM   1183  CB  GLN A 171      37.209 103.848  18.921  1.00 20.62           C  
ATOM   1184  CG  GLN A 171      37.222 102.569  19.764  1.00 23.72           C  
ATOM   1185  CD  GLN A 171      38.617 102.222  20.253  1.00 31.12           C  
ATOM   1186  OE1 GLN A 171      39.564 102.206  19.472  1.00 26.20           O  
ATOM   1187  NE2 GLN A 171      38.755 101.979  21.557  1.00 20.04           N  
ATOM   1188  N   ILE A 172      36.775 107.026  18.672  1.00 18.58           N  
ATOM   1189  CA  ILE A 172      36.642 108.254  17.883  1.00 19.53           C  
ATOM   1190  C   ILE A 172      37.538 109.363  18.451  1.00 18.65           C  
ATOM   1191  O   ILE A 172      38.206 110.057  17.704  1.00 18.60           O  
ATOM   1192  CB  ILE A 172      35.155 108.799  17.819  1.00 19.94           C  
ATOM   1193  CG1 ILE A 172      34.143 107.701  17.400  1.00 19.24           C  
ATOM   1194  CG2 ILE A 172      35.119 109.996  16.894  1.00 18.73           C  
ATOM   1195  CD1 ILE A 172      32.654 108.055  17.656  1.00 14.31           C  
ATOM   1196  N   THR A 173      37.527 109.522  19.774  1.00 16.71           N  
ATOM   1197  CA  THR A 173      38.350 110.554  20.404  0.50 17.77           C  
ATOM   1199  C   THR A 173      39.835 110.299  20.174  1.00 17.01           C  
ATOM   1200  O   THR A 173      40.590 111.257  19.985  1.00 20.57           O  
ATOM   1201  CB  THR A 173      38.054 110.741  21.902  0.50 15.90           C  
ATOM   1203  OG1 THR A 173      38.484 109.594  22.635  0.50 18.62           O  
ATOM   1205  CG2 THR A 173      36.563 110.988  22.122  0.50 16.17           C  
ATOM   1207  N   ALA A 174      40.243 109.041  20.135  1.00 15.12           N  
ATOM   1208  CA  ALA A 174      41.603 108.674  19.739  1.00 16.85           C  
ATOM   1209  C   ALA A 174      42.025 109.235  18.389  1.00 16.57           C  
ATOM   1210  O   ALA A 174      43.212 109.482  18.193  1.00 20.36           O  
ATOM   1211  CB  ALA A 174      41.812 107.085  19.752  1.00 12.55           C  
ATOM   1212  N   LEU A 175      41.091 109.402  17.448  1.00 15.58           N  
ATOM   1213  CA  LEU A 175      41.438 109.855  16.092  1.00 16.47           C  
ATOM   1214  C   LEU A 175      41.388 111.388  15.921  1.00 19.47           C  
ATOM   1215  O   LEU A 175      42.073 111.952  15.058  1.00 21.37           O  
ATOM   1216  CB  LEU A 175      40.516 109.225  15.043  1.00 17.63           C  
ATOM   1217  CG  LEU A 175      40.598 107.752  14.630  1.00 26.09           C  
ATOM   1218  CD1 LEU A 175      39.717 107.539  13.391  1.00 24.48           C  
ATOM   1219  CD2 LEU A 175      42.026 107.357  14.344  1.00 29.16           C  
ATOM   1220  N   VAL A 176      40.546 112.059  16.701  1.00 16.10           N  
ATOM   1221  CA  VAL A 176      40.387 113.491  16.540  1.00 13.92           C  
ATOM   1222  C   VAL A 176      41.535 114.227  17.218  1.00 12.70           C  
ATOM   1223  O   VAL A 176      42.230 113.681  18.072  1.00 16.33           O  
ATOM   1224  CB  VAL A 176      39.001 114.020  17.056  1.00 15.72           C  
ATOM   1225  CG1 VAL A 176      37.804 113.390  16.271  1.00 10.14           C  
ATOM   1226  CG2 VAL A 176      38.876 113.864  18.561  1.00  9.82           C  
ATOM   1227  N   ARG A 177      41.721 115.490  16.841  1.00 16.71           N  
ATOM   1228  CA  ARG A 177      42.613 116.376  17.572  1.00 20.28           C  
ATOM   1229  C   ARG A 177      41.832 117.465  18.373  1.00 20.90           C  
ATOM   1230  O   ARG A 177      40.599 117.551  18.478  1.00 17.91           O  
ATOM   1231  CB  ARG A 177      43.622 117.038  16.614  1.00 21.17           C  
ATOM   1232  CG  ARG A 177      44.435 116.085  15.741  1.00 29.09           C  
ATOM   1233  CD  ARG A 177      45.444 115.243  16.497  1.00 30.87           C  
ATOM   1234  NE  ARG A 177      46.410 114.691  15.549  1.00 43.44           N  
ATOM   1235  CZ  ARG A 177      47.622 114.222  15.857  1.00 53.80           C  
ATOM   1236  NH1 ARG A 177      48.051 114.180  17.122  1.00 51.28           N  
ATOM   1237  NH2 ARG A 177      48.417 113.782  14.882  1.00 54.21           N  
ATOM   1238  OXT ARG A 177      42.471 118.341  18.947  1.00 16.55           O  
TER    1239      ARG A 177                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
